/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.emulator.actions;

import com.android.annotations.concurrency.Slow;
import com.android.emulator.control.Image;
import com.android.emulator.control.ImageFormat;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.emulator.EmptyStreamObserver;
import com.android.tools.idea.emulator.EmulatorController;
import com.android.tools.idea.emulator.RuntimeConfigurationOverrider;
import com.android.tools.idea.emulator.actions.AbstractEmulatorAction;
import com.android.tools.idea.emulator.actions.AbstractEmulatorActionKt;
import com.android.tools.idea.protobuf.ByteString;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/emulator/actions/EmulatorScreenshotAction;", "Lcom/android/tools/idea/emulator/actions/AbstractEmulatorAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "ScreenshotReceiver", "intellij.android.emulator"})
public final class EmulatorScreenshotAction
extends AbstractEmulatorAction {
    private static final SimpleDateFormat TIMESTAMP_FORMAT;
    @NotNull
    public static final Companion Companion;

    public void actionPerformed(@NotNull AnActionEvent event) {
        ImageFormat imageFormat;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event.getRequiredData(CommonDataKeys.PROJECT)");
        Project project = (Project)object;
        EmulatorController emulatorController = AbstractEmulatorActionKt.getEmulatorController(event);
        if (emulatorController == null) {
            return;
        }
        EmulatorController emulatorController2 = emulatorController;
        ImageFormat imageFormat2 = imageFormat = ImageFormat.newBuilder().setFormat(ImageFormat.ImgFormat.PNG).build();
        Intrinsics.checkNotNullExpressionValue((Object)imageFormat2, (String)"imageFormat");
        emulatorController2.getScreenshot(imageFormat2, (StreamObserver<Image>)((StreamObserver)new ScreenshotReceiver(project)));
    }

    static {
        Companion = new Companion(null);
        TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.US);
    }

    @Slow
    @JvmStatic
    private static final void createAndOpenScreenshotFile(ByteString imageContents, Date timestamp, Project project) {
        EmulatorScreenshotAction.Companion.createAndOpenScreenshotFile(imageContents, timestamp, project);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/emulator/actions/EmulatorScreenshotAction$ScreenshotReceiver;", "Lcom/android/tools/idea/emulator/EmptyStreamObserver;", "Lcom/android/emulator/control/Image;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "onNext", "", "response", "intellij.android.emulator"})
    private static final class ScreenshotReceiver
    extends EmptyStreamObserver<Image> {
        @NotNull
        private final Project project;

        @Override
        public void onNext(@NotNull Image response) {
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Date timestamp = new Date();
            FutureUtils.executeOnPooledThread((Function0)((Function0)new Function0<Unit>(this, response, timestamp){
                final /* synthetic */ ScreenshotReceiver this$0;
                final /* synthetic */ Image $response;
                final /* synthetic */ Date $timestamp;

                public final void invoke() {
                    ByteString byteString = this.$response.getImage();
                    Intrinsics.checkNotNullExpressionValue((Object)byteString, (String)"response.image");
                    com.android.tools.idea.emulator.actions.EmulatorScreenshotAction$Companion.access$createAndOpenScreenshotFile(EmulatorScreenshotAction.Companion, byteString, this.$timestamp, this.this$0.getProject());
                }
                {
                    this.this$0 = screenshotReceiver;
                    this.$response = image;
                    this.$timestamp = date;
                    super(0);
                }
            }));
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public ScreenshotReceiver(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0003R\u0016\u0010\u0003\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/idea/emulator/actions/EmulatorScreenshotAction$Companion;", "", "()V", "TIMESTAMP_FORMAT", "Ljava/text/SimpleDateFormat;", "getTIMESTAMP_FORMAT$annotations", "createAndOpenScreenshotFile", "", "imageContents", "Lcom/android/tools/idea/protobuf/ByteString;", "timestamp", "Ljava/util/Date;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.emulator"})
    public static final class Companion {
        @JvmStatic
        private static /* synthetic */ void getTIMESTAMP_FORMAT$annotations() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Slow
        @JvmStatic
        private final void createAndOpenScreenshotFile(ByteString imageContents, Date timestamp, Project project) {
            String timestampSuffix = TIMESTAMP_FORMAT.format(timestamp);
            Path dir = RuntimeConfigurationOverrider.getRuntimeConfiguration().getDesktopOrUserHomeDirectory();
            int n = 0;
            int n2 = 100;
            while (n <= n2) {
                void attempt;
                String uniquenessSuffix = attempt == false ? "" : "" + '_' + (int)attempt;
                String filename = "Screenshot_" + timestampSuffix + uniquenessSuffix + ".png";
                Path file2 = dir.resolve(filename);
                try {
                    Closeable closeable = Files.newOutputStream(file2, StandardOpenOption.CREATE_NEW);
                    boolean bl = false;
                    boolean bl2 = false;
                    Throwable throwable = null;
                    try {
                        OutputStream it = (OutputStream)closeable;
                        boolean bl3 = false;
                        imageContents.writeTo(it);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2.toFile());
                    if (virtualFile == null) {
                        return;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"LocalFileSystem.getInsta\u2026(file.toFile()) ?: return");
                    VirtualFile virtualFile2 = virtualFile;
                    boolean $i$f$invokeLater = false;
                    ApplicationManager.getApplication().invokeLater(new Runnable(project, virtualFile2){
                        final /* synthetic */ Project $project$inlined;
                        final /* synthetic */ VirtualFile $virtualFile$inlined;
                        {
                            this.$project$inlined = project;
                            this.$virtualFile$inlined = virtualFile;
                        }

                        public final void run() {
                            boolean bl = false;
                            FileEditorManager.getInstance((Project)this.$project$inlined).openFile(this.$virtualFile$inlined, true);
                        }
                    });
                    return;
                }
                catch (FileAlreadyExistsException e) {
                }
                catch (IOException e) {
                    Companion $this$logger$iv = this;
                    boolean $i$f$getLogger = false;
                    Logger logger2 = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
                    logger2.error("Unable to create screenshot file " + file2, (Throwable)e);
                    return;
                }
                ++attempt;
            }
            Companion $this$logger$iv = this;
            boolean $i$f$getLogger = false;
            Logger logger3 = Logger.getInstance(Companion.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"Logger.getInstance(T::class.java)");
            logger3.error("Unable to create screenshot file - no suitable name");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

