/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.emulator.actions;

import com.android.annotations.concurrency.UiThread;
import com.android.emulator.control.ParameterValue;
import com.android.emulator.control.PhysicalModelValue;
import com.android.emulator.control.Rotation;
import com.android.tools.idea.emulator.EmptyStreamObserver;
import com.android.tools.idea.emulator.EmulatorController;
import com.android.tools.idea.emulator.EmulatorView;
import com.android.tools.idea.emulator.actions.AbstractEmulatorAction;
import com.android.tools.idea.emulator.actions.AbstractEmulatorActionKt;
import com.android.tools.idea.protobuf.Empty;
import com.intellij.openapi.actionSystem.AnActionEvent;
import io.grpc.stub.StreamObserver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0004H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/emulator/actions/EmulatorRotateAction;", "Lcom/android/tools/idea/emulator/actions/AbstractEmulatorAction;", "()V", "canonicalizeRotationAngle", "", "angleDegrees", "rotate", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "degrees", "intellij.android.emulator"})
public abstract class EmulatorRotateAction
extends AbstractEmulatorAction {
    @UiThread
    public final void rotate(@NotNull AnActionEvent event, float degrees) {
        PhysicalModelValue rotationModel;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        EmulatorController emulatorController = AbstractEmulatorActionKt.getEmulatorController(event);
        if (emulatorController == null) {
            return;
        }
        EmulatorController emulatorController2 = emulatorController;
        EmulatorView emulatorView = AbstractEmulatorActionKt.getEmulatorView(event);
        EmulatorView emulatorView2 = emulatorView;
        if (emulatorView2 == null || (emulatorView2 = emulatorView2.getDisplayRotation()) == null) {
            return;
        }
        EmulatorView rotation = emulatorView2;
        float angle = this.canonicalizeRotationAngle((float)rotation.ordinal() * 90.0f + degrees);
        ParameterValue.Builder parameters2 = ParameterValue.newBuilder().addData(0.0f).addData(0.0f).addData(angle);
        PhysicalModelValue physicalModelValue = rotationModel = PhysicalModelValue.newBuilder().setTarget(PhysicalModelValue.PhysicalType.ROTATION).setValue(parameters2).build();
        Intrinsics.checkNotNullExpressionValue((Object)physicalModelValue, (String)"rotationModel");
        emulatorController2.setPhysicalModel(physicalModelValue, (StreamObserver<Empty>)new EmptyStreamObserver<Empty>(emulatorView, angle){
            final /* synthetic */ EmulatorView $emulatorView;
            final /* synthetic */ float $angle;

            public void onNext(@NotNull Empty response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Rotation.SkinRotation skinRotation = Rotation.SkinRotation.forNumber((int)(((int)(this.$angle / (float)90) + 4) % 4));
                Intrinsics.checkNotNullExpressionValue((Object)skinRotation, (String)"SkinRotation.forNumber((\u2026e / 90).toInt() + 4) % 4)");
                this.$emulatorView.setDisplayRotation(skinRotation);
            }
            {
                this.$emulatorView = $captured_local_variable$0;
                this.$angle = $captured_local_variable$1;
            }
        });
    }

    private final float canonicalizeRotationAngle(float angleDegrees) {
        float angle = (float)MathKt.roundToInt((float)(angleDegrees / (float)90)) * 90.0f;
        return angle < -180.0f ? angle + (float)360 : (angle >= 180.0f ? angle - (float)360 : angle);
    }
}

