/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.emulator.actions;

import com.android.emulator.control.SnapshotPackage;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.emulator.EmptyStreamObserver;
import com.android.tools.idea.emulator.EmulatorConstants;
import com.android.tools.idea.emulator.EmulatorController;
import com.android.tools.idea.emulator.EmulatorId;
import com.android.tools.idea.emulator.EmulatorUtilsKt;
import com.android.tools.idea.emulator.EmulatorView;
import com.android.tools.idea.emulator.actions.AbstractEmulatorAction;
import com.android.tools.idea.emulator.actions.AbstractEmulatorActionKt;
import com.android.tools.idea.emulator.actions.EmulatorCreateSnapshotActionKt;
import com.android.tools.idea.emulator.actions.dialogs.BootMode;
import com.android.tools.idea.emulator.actions.dialogs.BootType;
import com.android.tools.idea.emulator.actions.dialogs.CreateSnapshotDialog;
import com.android.tools.idea.emulator.actions.dialogs.SnapshotManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import io.grpc.stub.StreamObserver;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/emulator/actions/EmulatorCreateSnapshotAction;", "Lcom/android/tools/idea/emulator/actions/AbstractEmulatorAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isEnabled", "", "CompletionTracker", "intellij.android.emulator"})
public final class EmulatorCreateSnapshotAction
extends AbstractEmulatorAction {
    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getRequiredData(CommonDataKeys.PROJECT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"event.getRequiredData(CommonDataKeys.PROJECT)");
        Project project = (Project)object;
        EmulatorController emulatorController = AbstractEmulatorActionKt.getEmulatorController(event);
        if (emulatorController == null) {
            return;
        }
        EmulatorController emulatorController2 = emulatorController;
        EmulatorView emulatorView = AbstractEmulatorActionKt.getEmulatorView(event);
        if (emulatorView == null) {
            return;
        }
        EmulatorView emulatorView2 = emulatorView;
        CreateSnapshotDialog dialog2 = new CreateSnapshotDialog();
        if (!dialog2.createWrapper(project).showAndGet()) {
            return;
        }
        EmulatorId emulatorId = emulatorController2.getEmulatorId();
        String string = dialog2.getSnapshotName();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String snapshotName = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        Function0 bootSnapshotUpdater2 = (Function0)new Function0<Unit>(dialog2, emulatorController2, snapshotName){
            final /* synthetic */ CreateSnapshotDialog $dialog;
            final /* synthetic */ EmulatorController $emulatorController;
            final /* synthetic */ String $snapshotName;

            public final void invoke() {
                if (this.$dialog.getUseToBoot()) {
                    new SnapshotManager(this.$emulatorController).saveBootMode(new BootMode(BootType.SNAPSHOT, this.$snapshotName));
                }
            }
            {
                this.$dialog = createSnapshotDialog;
                this.$emulatorController = emulatorController;
                this.$snapshotName = string;
                super(0);
            }
        };
        emulatorController2.saveSnapshot(snapshotName, (StreamObserver<SnapshotPackage>)((StreamObserver)new CompletionTracker(emulatorId, emulatorView2, (Function0<Unit>)bootSnapshotUpdater2)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isEnabled(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!super.isEnabled(event)) return false;
        EmulatorController emulatorController = AbstractEmulatorActionKt.getEmulatorController(event);
        if (CollectionsKt.contains((Iterable)EmulatorCreateSnapshotActionKt.access$getInProgress$p(), (Object)(emulatorController != null ? emulatorController.getEmulatorId() : null))) return false;
        return true;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0003\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\tH\u0002J\b\u0010\u0012\u001a\u00020\tH\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/emulator/actions/EmulatorCreateSnapshotAction$CompletionTracker;", "Lcom/android/tools/idea/emulator/EmptyStreamObserver;", "Lcom/android/emulator/control/SnapshotPackage;", "emulatorId", "Lcom/android/tools/idea/emulator/EmulatorId;", "emulatorView", "Lcom/android/tools/idea/emulator/EmulatorView;", "bootSnapshotUpdater", "Lkotlin/Function0;", "", "(Lcom/android/tools/idea/emulator/EmulatorId;Lcom/android/tools/idea/emulator/EmulatorView;Lkotlin/jvm/functions/Function0;)V", "getBootSnapshotUpdater", "()Lkotlin/jvm/functions/Function0;", "getEmulatorId", "()Lcom/android/tools/idea/emulator/EmulatorId;", "getEmulatorView", "()Lcom/android/tools/idea/emulator/EmulatorView;", "finished", "onCompleted", "onError", "t", "", "intellij.android.emulator"})
    private static final class CompletionTracker
    extends EmptyStreamObserver<SnapshotPackage> {
        @NotNull
        private final EmulatorId emulatorId;
        @NotNull
        private final EmulatorView emulatorView;
        @NotNull
        private final Function0<Unit> bootSnapshotUpdater;

        @Override
        public void onCompleted() {
            FutureUtils.executeOnPooledThread((Function0)((Function0)new Function0<Unit>(this){
                final /* synthetic */ CompletionTracker this$0;

                public final void invoke() {
                    this.this$0.getBootSnapshotUpdater().invoke();
                    CompletionTracker.access$finished(this.this$0);
                }
                {
                    this.this$0 = completionTracker2;
                    super(0);
                }
            }));
        }

        @Override
        public void onError(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            Notification notification = EmulatorConstants.EMULATOR_TOOL_WINDOW_NOTIFICATION_GROUP.createNotification("Unable to create a snapshot", NotificationType.ERROR);
            Notifications.Bus.notify((Notification)notification);
            this.finished();
        }

        private final void finished() {
            EmulatorUtilsKt.invokeLaterInAnyModalityState((Function0<Unit>)((Function0)new Function0<Unit>(this){
                final /* synthetic */ CompletionTracker this$0;

                public final void invoke() {
                    this.this$0.getEmulatorView().hideLongRunningOperationIndicator();
                    EmulatorCreateSnapshotActionKt.access$getInProgress$p().remove(this.this$0.getEmulatorId());
                }
                {
                    this.this$0 = completionTracker2;
                    super(0);
                }
            }));
        }

        @NotNull
        public final EmulatorId getEmulatorId() {
            return this.emulatorId;
        }

        @NotNull
        public final EmulatorView getEmulatorView() {
            return this.emulatorView;
        }

        @NotNull
        public final Function0<Unit> getBootSnapshotUpdater() {
            return this.bootSnapshotUpdater;
        }

        public CompletionTracker(@NotNull EmulatorId emulatorId, @NotNull EmulatorView emulatorView, @NotNull Function0<Unit> bootSnapshotUpdater2) {
            Intrinsics.checkNotNullParameter((Object)emulatorId, (String)"emulatorId");
            Intrinsics.checkNotNullParameter((Object)emulatorView, (String)"emulatorView");
            Intrinsics.checkNotNullParameter(bootSnapshotUpdater2, (String)"bootSnapshotUpdater");
            this.emulatorId = emulatorId;
            this.emulatorView = emulatorView;
            this.bootSnapshotUpdater = bootSnapshotUpdater2;
            EmulatorCreateSnapshotActionKt.access$getInProgress$p().add(this.emulatorId);
            this.emulatorView.showLongRunningOperationIndicator("Saving state...");
        }

        public static final /* synthetic */ void access$finished(CompletionTracker $this) {
            $this.finished();
        }
    }
}

