/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.emulator;

import com.android.annotations.concurrency.Slow;
import com.android.emulator.control.Rotation;
import com.android.ide.common.util.PathString;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.avdmanager.SkinLayoutDefinition;
import com.android.tools.idea.emulator.AnchorPoint;
import com.android.tools.idea.emulator.AnchoredImage;
import com.android.tools.idea.emulator.EmulatorUtilsKt;
import com.android.tools.idea.emulator.SkinDefinition$Companion$WhenMappings;
import com.android.tools.idea.emulator.SkinLayout;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u000f\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/emulator/SkinDefinition;", "", "layout", "Lcom/android/tools/idea/emulator/SkinLayout;", "(Lcom/android/tools/idea/emulator/SkinLayout;)V", "getLayout", "()Lcom/android/tools/idea/emulator/SkinLayout;", "createScaledLayout", "displayWidth", "", "displayHeight", "displayRotation", "Lcom/android/emulator/control/Rotation$SkinRotation;", "getRotatedFrameSize", "Ljava/awt/Dimension;", "displaySize", "Companion", "Part", "intellij.android.emulator"})
public final class SkinDefinition {
    @NotNull
    private final SkinLayout layout;
    private static final int ALPHA_MASK = -16777216;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SkinLayout createScaledLayout(int displayWidth, int displayHeight, @NotNull Rotation.SkinRotation displayRotation) {
        void $this$mapNotNullTo$iv$iv;
        boolean bl;
        void $this$mapNotNullTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)displayRotation, (String)"displayRotation");
        if (displayRotation == Rotation.SkinRotation.LANDSCAPE && displayWidth == this.layout.getDisplaySize().width && displayHeight == this.layout.getDisplaySize().height) {
            return this.layout;
        }
        Rectangle rotatedFrameRect = SkinDefinition.Companion.rotated(this.layout.getFrameRectangle(), displayRotation, this.layout.getDisplaySize());
        Dimension rotatedDisplaySize = EmulatorUtilsKt.rotated(this.layout.getDisplaySize(), displayRotation);
        double scaleX = (double)displayWidth / (double)rotatedDisplaySize.width;
        double scaleY = (double)displayHeight / (double)rotatedDisplaySize.height;
        int frameX = EmulatorUtilsKt.scaled(rotatedFrameRect.x, scaleX);
        int frameY = EmulatorUtilsKt.scaled(rotatedFrameRect.y, scaleY);
        int frameWidth = -frameX + displayWidth + EmulatorUtilsKt.scaled(SkinDefinition.Companion.getRight(rotatedFrameRect) - rotatedDisplaySize.width, scaleX);
        int frameHeight = -frameY + displayHeight + EmulatorUtilsKt.scaled(SkinDefinition.Companion.getBottom(rotatedFrameRect) - rotatedDisplaySize.height, scaleY);
        Rectangle frameRect = new Rectangle(frameX, frameY, frameWidth, frameHeight);
        Iterable $this$mapNotNull$iv = this.layout.getFrameImages();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<AnchoredImage> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AnchoredImage anchoredImage;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            AnchoredImage it = (AnchoredImage)element$iv$iv;
            boolean bl3 = false;
            if (it.rotatedAndScaled(displayRotation, scaleX, scaleY) == null) continue;
            boolean bl4 = false;
            bl = false;
            AnchoredImage it$iv$iv = anchoredImage;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List frameImages = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        Iterable $this$mapNotNull$iv2 = this.layout.getMaskImages();
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            AnchoredImage anchoredImage;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl6 = false;
            AnchoredImage it = (AnchoredImage)element$iv$iv;
            boolean bl7 = false;
            if (it.rotatedAndScaled(displayRotation, scaleX, scaleY) == null) continue;
            bl = false;
            boolean bl8 = false;
            AnchoredImage it$iv$iv = anchoredImage;
            boolean bl9 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        List maskImages = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        return new SkinLayout(new Dimension(displayWidth, displayHeight), frameRect, frameImages, maskImages);
    }

    @NotNull
    public final Dimension getRotatedFrameSize(@NotNull Rotation.SkinRotation displayRotation, @NotNull Dimension displaySize) {
        Dimension size;
        Intrinsics.checkNotNullParameter((Object)displayRotation, (String)"displayRotation");
        Intrinsics.checkNotNullParameter((Object)displaySize, (String)"displaySize");
        double scaleX = displaySize.getWidth() / this.layout.getDisplaySize().getWidth();
        double scaleY = displaySize.getHeight() / this.layout.getDisplaySize().getHeight();
        Rectangle frameRect = this.layout.getFrameRectangle();
        Dimension dimension2 = size = scaleX == 1.0 && scaleY == 1.0 ? frameRect.getSize() : new Dimension(-EmulatorUtilsKt.scaled(frameRect.x, scaleX) + displaySize.width + EmulatorUtilsKt.scaled(SkinDefinition.Companion.getRight(frameRect) - this.layout.getDisplaySize().width, scaleX), -EmulatorUtilsKt.scaled(frameRect.y, scaleY) + displaySize.height + EmulatorUtilsKt.scaled(SkinDefinition.Companion.getBottom(frameRect) - this.layout.getDisplaySize().height, scaleY));
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"size");
        return EmulatorUtilsKt.rotated(dimension2, displayRotation);
    }

    public static /* synthetic */ Dimension getRotatedFrameSize$default(SkinDefinition skinDefinition, Rotation.SkinRotation skinRotation, Dimension dimension2, int n, Object object) {
        if ((n & 2) != 0) {
            dimension2 = skinDefinition.layout.getDisplaySize();
        }
        return skinDefinition.getRotatedFrameSize(skinRotation, dimension2);
    }

    @NotNull
    public final SkinLayout getLayout() {
        return this.layout;
    }

    private SkinDefinition(SkinLayout layout2) {
        this.layout = layout2;
    }

    public /* synthetic */ SkinDefinition(SkinLayout layout2, DefaultConstructorMarker $constructor_marker) {
        this(layout2);
    }

    @Slow
    @JvmStatic
    @Nullable
    public static final SkinDefinition create(@NotNull Path skinFolder) {
        return Companion.create(skinFolder);
    }

    @JvmStatic
    private static final Rectangle rotated(Rectangle $this$rotated, Rotation.SkinRotation rotation, Dimension displaySize) {
        return SkinDefinition.Companion.rotated($this$rotated, rotation, displaySize);
    }

    @JvmStatic
    private static final Part createPart(SkinLayoutDefinition partNode, Path skinFolder) {
        return SkinDefinition.Companion.createPart(partNode, skinFolder);
    }

    @JvmStatic
    private static final URL getReferencedFile(SkinLayoutDefinition node2, String propertyName, Path skinFolder) {
        return SkinDefinition.Companion.getReferencedFile(node2, propertyName, skinFolder);
    }

    @JvmStatic
    private static final SkinLayout createLayout(Dimension displaySize, Rectangle frameRectangle, Part part) {
        return SkinDefinition.Companion.createLayout(displaySize, frameRectangle, part);
    }

    @JvmStatic
    private static final boolean isCombinedMaskAndBackground(String filename) {
        return SkinDefinition.Companion.isCombinedMaskAndBackground(filename);
    }

    @JvmStatic
    private static final List<AnchoredImage> disassembleFrame(BufferedImage background, Rectangle frameRectangle, Dimension displaySize) {
        return SkinDefinition.Companion.disassembleFrame(background, frameRectangle, displaySize);
    }

    @JvmStatic
    private static final List<AnchoredImage> disassembleMask(BufferedImage mask, Dimension displaySize) {
        return SkinDefinition.Companion.disassembleMask(mask, displaySize);
    }

    @JvmStatic
    private static final Sequence<Rectangle> cutHorizontally(BufferedImage image, Rectangle cropBounds) {
        return SkinDefinition.Companion.cutHorizontally(image, cropBounds);
    }

    @JvmStatic
    private static final Sequence<Rectangle> cutVertically(BufferedImage image, Rectangle cropBounds) {
        return SkinDefinition.Companion.cutVertically(image, cropBounds);
    }

    @JvmStatic
    private static final boolean isTransparentHorizontalLine(BufferedImage image, int startX, int endX, int y) {
        return SkinDefinition.Companion.isTransparentHorizontalLine(image, startX, endX, y);
    }

    @JvmStatic
    private static final boolean isTransparentVerticalLine(BufferedImage image, int x, int startY, int endY) {
        return SkinDefinition.Companion.isTransparentVerticalLine(image, x, startY, endY);
    }

    @JvmStatic
    private static final boolean isTransparentPixel(BufferedImage image, int x, int y) {
        return SkinDefinition.Companion.isTransparentPixel(image, x, y);
    }

    @JvmStatic
    private static final AnchoredImage createAnchoredImage(BufferedImage mask, Rectangle cropBounds, Dimension displaySize) {
        return SkinDefinition.Companion.createAnchoredImage(mask, cropBounds, displaySize);
    }

    @JvmStatic
    private static final Rectangle computeAdjustedFrameRectangle(Iterable<AnchoredImage> backgroundImages, Dimension displaySize) {
        return SkinDefinition.Companion.computeAdjustedFrameRectangle(backgroundImages, displaySize);
    }

    @JvmStatic
    private static final BufferedImage cropped(BufferedImage $this$cropped, Rectangle cropBounds) {
        return SkinDefinition.Companion.cropped($this$cropped, cropBounds);
    }

    @JvmStatic
    private static final Rectangle getCropBounds(BufferedImage image, Rectangle initialCrop) {
        return SkinDefinition.Companion.getCropBounds(image, initialCrop);
    }

    private static final int getRight(Rectangle $this$right) {
        return SkinDefinition.Companion.getRight($this$right);
    }

    private static final int getBottom(Rectangle $this$bottom) {
        return SkinDefinition.Companion.getBottom($this$bottom);
    }

    @JvmStatic
    private static final BufferedImage readImage(URL url) {
        return SkinDefinition.Companion.readImage(url);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\u000b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/emulator/SkinDefinition$Part;", "", "backgroundFile", "Ljava/net/URL;", "maskFile", "(Ljava/net/URL;Ljava/net/URL;)V", "getBackgroundFile", "()Ljava/net/URL;", "getMaskFile", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.android.emulator"})
    private static final class Part {
        @Nullable
        private final URL backgroundFile;
        @Nullable
        private final URL maskFile;

        @Nullable
        public final URL getBackgroundFile() {
            return this.backgroundFile;
        }

        @Nullable
        public final URL getMaskFile() {
            return this.maskFile;
        }

        public Part(@Nullable URL backgroundFile, @Nullable URL maskFile) {
            this.backgroundFile = backgroundFile;
            this.maskFile = maskFile;
        }

        @Nullable
        public final URL component1() {
            return this.backgroundFile;
        }

        @Nullable
        public final URL component2() {
            return this.maskFile;
        }

        @NotNull
        public final Part copy(@Nullable URL backgroundFile, @Nullable URL maskFile) {
            return new Part(backgroundFile, maskFile);
        }

        public static /* synthetic */ Part copy$default(Part part, URL uRL, URL uRL2, int n, Object object) {
            if ((n & 1) != 0) {
                uRL = part.backgroundFile;
            }
            if ((n & 2) != 0) {
                uRL2 = part.maskFile;
            }
            return part.copy(uRL, uRL2);
        }

        @NotNull
        public String toString() {
            return "Part(backgroundFile=" + this.backgroundFile + ", maskFile=" + this.maskFile + ")";
        }

        public int hashCode() {
            URL uRL = this.backgroundFile;
            URL uRL2 = this.maskFile;
            return (uRL != null ? ((Object)uRL).hashCode() : 0) * 31 + (uRL2 != null ? ((Object)uRL2).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Part)) break block3;
                    Part part = (Part)object;
                    if (!Intrinsics.areEqual((Object)this.backgroundFile, (Object)part.backgroundFile) || !Intrinsics.areEqual((Object)this.maskFile, (Object)part.maskFile)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u000e\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J \u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020 H\u0003J\u0018\u0010!\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0016\u001a\u00020\u0017H\u0003J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00060%2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0003J\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060%2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0003J&\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00110)2\u0006\u0010*\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00110)2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J\u001c\u0010,\u001a\u0004\u0018\u00010\u00062\u0006\u0010&\u001a\u00020\u001a2\b\u0010-\u001a\u0004\u0018\u00010\u0006H\u0003J\"\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020#2\u0006\u00101\u001a\u0002022\u0006\u0010\u0016\u001a\u00020\u0017H\u0003J\u0010\u00103\u001a\u0002042\u0006\u00105\u001a\u000202H\u0003J(\u00106\u001a\u0002042\u0006\u0010&\u001a\u00020\u001a2\u0006\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u0004H\u0003J \u0010:\u001a\u0002042\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u00042\u0006\u00109\u001a\u00020\u0004H\u0003J(\u0010<\u001a\u0002042\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010;\u001a\u00020\u00042\u0006\u0010=\u001a\u00020\u00042\u0006\u0010>\u001a\u00020\u0004H\u0003J\u0012\u0010?\u001a\u0004\u0018\u00010\u001a2\u0006\u0010@\u001a\u00020/H\u0003J\u0014\u0010A\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0003J\u001c\u0010B\u001a\u00020\u0006*\u00020\u00062\u0006\u0010C\u001a\u00020D2\u0006\u0010\u0012\u001a\u00020\u0013H\u0003R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u00020\u0004*\u00020\u00068BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\u0004*\u00020\u00068BX\u0083\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\b\u001a\u0004\b\r\u0010\n\u00a8\u0006E"}, d2={"Lcom/android/tools/idea/emulator/SkinDefinition$Companion;", "", "()V", "ALPHA_MASK", "", "bottom", "Ljava/awt/Rectangle;", "getBottom$annotations", "(Ljava/awt/Rectangle;)V", "getBottom", "(Ljava/awt/Rectangle;)I", "right", "getRight$annotations", "getRight", "computeAdjustedFrameRectangle", "backgroundImages", "", "Lcom/android/tools/idea/emulator/AnchoredImage;", "displaySize", "Ljava/awt/Dimension;", "create", "Lcom/android/tools/idea/emulator/SkinDefinition;", "skinFolder", "Ljava/nio/file/Path;", "createAnchoredImage", "mask", "Ljava/awt/image/BufferedImage;", "cropBounds", "createLayout", "Lcom/android/tools/idea/emulator/SkinLayout;", "frameRectangle", "part", "Lcom/android/tools/idea/emulator/SkinDefinition$Part;", "createPart", "partNode", "Lcom/android/tools/idea/avdmanager/SkinLayoutDefinition;", "cutHorizontally", "Lkotlin/sequences/Sequence;", "image", "cutVertically", "disassembleFrame", "", "background", "disassembleMask", "getCropBounds", "initialCrop", "getReferencedFile", "Ljava/net/URL;", "node", "propertyName", "", "isCombinedMaskAndBackground", "", "filename", "isTransparentHorizontalLine", "startX", "endX", "y", "isTransparentPixel", "x", "isTransparentVerticalLine", "startY", "endY", "readImage", "url", "cropped", "rotated", "rotation", "Lcom/android/emulator/control/Rotation$SkinRotation;", "intellij.android.emulator"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Slow
        @JvmStatic
        @Nullable
        public final SkinDefinition create(@NotNull Path skinFolder) {
            Intrinsics.checkNotNullParameter((Object)skinFolder, (String)"skinFolder");
            try {
                Path path2 = skinFolder.resolve("layout");
                if (path2 == null) {
                    return null;
                }
                Path layoutFile = path2;
                byte[] byArray = Files.readAllBytes(layoutFile);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"Files.readAllBytes(layoutFile)");
                byte[] byArray2 = byArray;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Charset charset2 = charset;
                boolean bl = false;
                boolean bl2 = false;
                String contents = new String(byArray2, charset2);
                SkinLayoutDefinition skinLayoutDefinition = SkinLayoutDefinition.parseString(contents);
                Intrinsics.checkNotNullExpressionValue((Object)skinLayoutDefinition, (String)"SkinLayoutDefinition.parseString(contents)");
                SkinLayoutDefinition skin = skinLayoutDefinition;
                int displayWidth = 0;
                int displayHeight = 0;
                boolean bl3 = false;
                Map partsByName = new HashMap();
                Object object = skin.getNode("parts");
                if (object == null || (object = ((SkinLayoutDefinition)object).getChildren()) == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"skin.getNode(\"parts\")?.children ?: return null");
                Object partNodes = object;
                for (Map.Entry entry : partNodes.entrySet()) {
                    void name;
                    Object object2 = entry;
                    boolean bl4 = false;
                    String string = (String)object2.getKey();
                    object2 = entry;
                    bl4 = false;
                    SkinLayoutDefinition node2 = (SkinLayoutDefinition)object2.getValue();
                    if (Intrinsics.areEqual((Object)name, (Object)"device")) {
                        String string2 = node2.getValue("display.width");
                        if (string2 == null) {
                            return null;
                        }
                        object2 = string2;
                        bl4 = false;
                        displayWidth = Integer.parseInt((String)object2);
                        String string3 = node2.getValue("display.height");
                        if (string3 == null) {
                            return null;
                        }
                        object2 = string3;
                        bl4 = false;
                        displayHeight = Integer.parseInt((String)object2);
                        continue;
                    }
                    if (!(Intrinsics.areEqual((Object)name, (Object)"onion") ^ true) || !(Intrinsics.areEqual((Object)name, (Object)"controls") ^ true)) continue;
                    void v7 = name;
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"name");
                    SkinLayoutDefinition skinLayoutDefinition2 = node2;
                    Intrinsics.checkNotNullExpressionValue((Object)skinLayoutDefinition2, (String)"node");
                    partsByName.put(v7, this.createPart(skinLayoutDefinition2, skinFolder));
                }
                SkinLayout layout2 = null;
                Object object3 = skin.getNode("layouts");
                if (object3 == null || (object3 = ((SkinLayoutDefinition)object3).getChildren()) == null) {
                    return null;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"skin.getNode(\"layouts\")?.children ?: return null");
                Object layoutNodes = object3;
                block4: for (SkinLayoutDefinition layoutNode : layoutNodes.values()) {
                    String string;
                    String string4;
                    if (layoutNode.getValue("width") == null) continue;
                    boolean bl5 = false;
                    int width = Integer.parseInt(string4);
                    if (layoutNode.getValue("height") == null) continue;
                    boolean bl6 = false;
                    int height = Integer.parseInt(string);
                    Part part = null;
                    int frameX = 0;
                    int frameY = 0;
                    int partX = 0;
                    int partY = 0;
                    SkinLayoutDefinition skinLayoutDefinition3 = layoutNode;
                    Intrinsics.checkNotNullExpressionValue((Object)skinLayoutDefinition3, (String)"layoutNode");
                    for (SkinLayoutDefinition subnode : skinLayoutDefinition3.getChildren().values()) {
                        String name;
                        int y;
                        int n;
                        int x;
                        int n2;
                        if (subnode.getValue("x") != null) {
                            String string5;
                            boolean bl7 = false;
                            n2 = Integer.parseInt(string5);
                        } else {
                            n2 = x = 0;
                        }
                        if (subnode.getValue("y") != null) {
                            String string6;
                            boolean bl8 = false;
                            n = Integer.parseInt(string6);
                        } else {
                            n = y = 0;
                        }
                        if (subnode.getValue("name") == null) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"subnode.getValue(\"name\") ?: continue");
                        if (Intrinsics.areEqual((Object)name, (Object)"device")) {
                            int rotation;
                            int n3;
                            if (subnode.getValue("rotation") != null) {
                                String string7;
                                boolean bl9 = false;
                                n3 = Integer.parseInt(string7);
                            } else {
                                n3 = rotation = 0;
                            }
                            if (rotation != 0) continue block4;
                            frameX = -x;
                            frameY = -y;
                            continue;
                        }
                        if (part != null || (part = (Part)partsByName.get(name)) == null) continue;
                        partX = x;
                        partY = y;
                    }
                    if (part == null) continue;
                    Rectangle frameRectangle = new Rectangle(frameX + partX, frameY + partY, width, height);
                    layout2 = this.createLayout(new Dimension(displayWidth, displayHeight), frameRectangle, part);
                }
                if (layout2 != null) {
                    return new SkinDefinition(layout2, null);
                }
            }
            catch (NoSuchFileException e) {
                Companion $this$logger$iv = this;
                boolean $i$f$getLogger = false;
                Logger logger2 = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
                logger2.error("File not found: " + e.getFile());
            }
            catch (IOException e) {
                Companion $this$logger$iv = this;
                boolean $i$f$getLogger = false;
                Logger logger3 = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"Logger.getInstance(T::class.java)");
                logger3.error((Throwable)e);
            }
            return null;
        }

        @JvmStatic
        private final Rectangle rotated(Rectangle $this$rotated, Rotation.SkinRotation rotation, Dimension displaySize) {
            Rectangle rectangle;
            switch (SkinDefinition$Companion$WhenMappings.$EnumSwitchMapping$0[rotation.ordinal()]) {
                case 1: {
                    rectangle = new Rectangle($this$rotated.y, displaySize.width - $this$rotated.width - $this$rotated.x, $this$rotated.height, $this$rotated.width);
                    break;
                }
                case 2: {
                    rectangle = new Rectangle(displaySize.width - $this$rotated.width - $this$rotated.x, displaySize.height - $this$rotated.height - $this$rotated.y, $this$rotated.width, $this$rotated.height);
                    break;
                }
                case 3: {
                    rectangle = new Rectangle(displaySize.height - $this$rotated.height - $this$rotated.y, $this$rotated.x, $this$rotated.height, $this$rotated.width);
                    break;
                }
                default: {
                    rectangle = $this$rotated;
                }
            }
            return rectangle;
        }

        @JvmStatic
        private final Part createPart(SkinLayoutDefinition partNode, Path skinFolder) {
            URL background = this.getReferencedFile(partNode, "background.image", skinFolder);
            URL mask = this.getReferencedFile(partNode, "foreground.mask", skinFolder);
            return new Part(background, mask);
        }

        @JvmStatic
        private final URL getReferencedFile(SkinLayoutDefinition node2, String propertyName, Path skinFolder) {
            String string = node2.getValue(propertyName);
            if (string == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"node.getValue(propertyName) ?: return null");
            String filename = string;
            return skinFolder.resolve(filename).toUri().toURL();
        }

        /*
         * Unable to fully structure code
         */
        @JvmStatic
        private final SkinLayout createLayout(Dimension displaySize, Rectangle frameRectangle, Part part) {
            block5: {
                block4: {
                    backgroundImages = null;
                    maskImages = null;
                    v0 = part.getBackgroundFile();
                    if (v0 != null) {
                        var7_6 = v0;
                        var8_7 = false;
                        var9_10 = false;
                        it = var7_6;
                        $i$a$-let-SkinDefinition$Companion$createLayout$background$1 = false;
                        v1 = SkinDefinition.Companion.readImage(it);
                    } else {
                        v1 = null;
                    }
                    background = v1;
                    backgroundImages = background == null ? CollectionsKt.emptyList() : this.disassembleFrame(background, frameRectangle, displaySize);
                    if (part.getMaskFile() == null) break block4;
                    v2 = this.readImage(part.getMaskFile());
                    break block5;
                }
                v3 = part.getBackgroundFile();
                if (v3 == null || (v3 = v3.getFile()) == null) ** GOTO lbl-1000
                var8_8 = v3;
                var9_10 = false;
                var10_12 = false;
                it = var8_8;
                $i$a$-let-SkinDefinition$Companion$createLayout$mask$1 = false;
                if (SkinDefinition.Companion.isCombinedMaskAndBackground((String)it)) {
                    v4 = background;
                    v2 = v4 != null ? this.cropped(v4, new Rectangle(-frameRectangle.x, -frameRectangle.y, displaySize.width, displaySize.height)) : null;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = null;
                }
            }
            mask = v2;
            maskImages = mask == null ? CollectionsKt.emptyList() : this.disassembleMask(mask, displaySize);
            adjustedFrameRectangle = this.computeAdjustedFrameRectangle((Iterable<AnchoredImage>)backgroundImages, displaySize);
            return new SkinLayout(displaySize, adjustedFrameRectangle, backgroundImages, maskImages);
        }

        @JvmStatic
        private final boolean isCombinedMaskAndBackground(String filename) {
            String string = new PathString(filename).getParentFileName();
            if (string == null) {
                return false;
            }
            String skinName = string;
            return StringsKt.startsWith$default((String)skinName, (String)"AndroidWearRound", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)skinName, (String)"wear_round", (boolean)false, (int)2, null);
        }

        @JvmStatic
        private final List<AnchoredImage> disassembleFrame(BufferedImage background, Rectangle frameRectangle, Dimension displaySize) {
            Rectangle rectangle = this.getCropBounds(background, null);
            if (rectangle == null) {
                return CollectionsKt.emptyList();
            }
            Rectangle cropBounds = rectangle;
            int displayLeft = -frameRectangle.x;
            int displayRight = displayLeft + displaySize.width;
            int displayTop = -frameRectangle.y;
            int displayBottom = displayTop + displaySize.height;
            int marginLeft = displayLeft - cropBounds.x;
            int marginRight = this.getRight(cropBounds) - displayRight;
            int marginTop = displayTop - cropBounds.y;
            int marginBottom = this.getBottom(cropBounds) - displayBottom;
            boolean bl = false;
            List images = new ArrayList();
            Companion companion = this;
            boolean bl2 = false;
            boolean bl3 = false;
            Companion $this$run = companion;
            boolean bl4 = false;
            Rectangle rect = new Rectangle(displayRight, displayTop, marginRight, displaySize.height);
            BufferedImage image = $this$run.cropped(background, rect);
            Point offset2 = new Point(rect.x - displayRight, rect.y - displayTop);
            Dimension dimension2 = rect.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"rect.size");
            images.add(new AnchoredImage(image, dimension2, AnchorPoint.TOP_RIGHT, offset2));
            companion = this;
            bl2 = false;
            bl3 = false;
            $this$run = companion;
            boolean bl5 = false;
            rect = new Rectangle(displayRight, cropBounds.y, marginRight, marginTop);
            image = $this$run.cropped(background, rect);
            offset2 = new Point(rect.x - displayRight, rect.y - displayTop);
            Dimension dimension3 = rect.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension3, (String)"rect.size");
            images.add(new AnchoredImage(image, dimension3, AnchorPoint.TOP_RIGHT, offset2));
            companion = this;
            bl2 = false;
            bl3 = false;
            $this$run = companion;
            boolean bl6 = false;
            rect = new Rectangle(displayLeft, cropBounds.y, displaySize.width, marginTop);
            image = $this$run.cropped(background, rect);
            offset2 = new Point(rect.x - displayLeft, rect.y - displayTop);
            Dimension dimension4 = rect.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension4, (String)"rect.size");
            images.add(new AnchoredImage(image, dimension4, AnchorPoint.TOP_LEFT, offset2));
            companion = this;
            bl2 = false;
            bl3 = false;
            $this$run = companion;
            boolean bl7 = false;
            rect = new Rectangle(cropBounds.x, cropBounds.y, marginLeft, marginTop);
            image = $this$run.cropped(background, rect);
            offset2 = new Point(rect.x - displayLeft, rect.y - displayTop);
            Dimension dimension5 = rect.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension5, (String)"rect.size");
            images.add(new AnchoredImage(image, dimension5, AnchorPoint.TOP_LEFT, offset2));
            companion = this;
            bl2 = false;
            bl3 = false;
            $this$run = companion;
            boolean bl8 = false;
            rect = new Rectangle(cropBounds.x, displayTop, marginLeft, displaySize.height);
            image = $this$run.cropped(background, rect);
            offset2 = new Point(rect.x - displayLeft, rect.y - displayTop);
            Dimension dimension6 = rect.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension6, (String)"rect.size");
            images.add(new AnchoredImage(image, dimension6, AnchorPoint.TOP_LEFT, offset2));
            companion = this;
            bl2 = false;
            bl3 = false;
            $this$run = companion;
            boolean bl9 = false;
            rect = new Rectangle(cropBounds.x, displayBottom, marginLeft, marginBottom);
            image = $this$run.cropped(background, rect);
            offset2 = new Point(rect.x - displayLeft, rect.y - displayBottom);
            Dimension dimension7 = rect.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension7, (String)"rect.size");
            images.add(new AnchoredImage(image, dimension7, AnchorPoint.BOTTOM_LEFT, offset2));
            companion = this;
            bl2 = false;
            bl3 = false;
            $this$run = companion;
            boolean bl10 = false;
            rect = new Rectangle(displayLeft, displayBottom, displaySize.width, marginBottom);
            image = $this$run.cropped(background, rect);
            offset2 = new Point(rect.x - displayLeft, rect.y - displayBottom);
            Dimension dimension8 = rect.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension8, (String)"rect.size");
            images.add(new AnchoredImage(image, dimension8, AnchorPoint.BOTTOM_LEFT, offset2));
            companion = this;
            bl2 = false;
            bl3 = false;
            $this$run = companion;
            boolean bl11 = false;
            rect = new Rectangle(displayRight, displayBottom, marginRight, marginBottom);
            image = $this$run.cropped(background, rect);
            offset2 = new Point(rect.x - displayRight, rect.y - displayBottom);
            Dimension dimension9 = rect.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension9, (String)"rect.size");
            images.add(new AnchoredImage(image, dimension9, AnchorPoint.BOTTOM_RIGHT, offset2));
            return images;
        }

        @JvmStatic
        private final List<AnchoredImage> disassembleMask(BufferedImage mask, Dimension displaySize) {
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap(this.cutHorizontally(mask, new Rectangle(0, 0, mask.getWidth(), mask.getHeight())), (Function1)((Function1)new Function1<Rectangle, Sequence<? extends Rectangle>>(mask){
                final /* synthetic */ BufferedImage $mask;

                @NotNull
                public final Sequence<Rectangle> invoke(@NotNull Rectangle it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return com.android.tools.idea.emulator.SkinDefinition$Companion.access$cutVertically(SkinDefinition.Companion, this.$mask, it);
                }
                {
                    this.$mask = bufferedImage;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<Rectangle, AnchoredImage>(mask, displaySize){
                final /* synthetic */ BufferedImage $mask;
                final /* synthetic */ Dimension $displaySize;

                @NotNull
                public final AnchoredImage invoke(@NotNull Rectangle it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return com.android.tools.idea.emulator.SkinDefinition$Companion.access$createAnchoredImage(SkinDefinition.Companion, this.$mask, it, this.$displaySize);
                }
                {
                    this.$mask = bufferedImage;
                    this.$displaySize = dimension2;
                    super(1);
                }
            })));
        }

        @JvmStatic
        private final Sequence<Rectangle> cutHorizontally(BufferedImage image, Rectangle cropBounds) {
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Rectangle>, Continuation<? super Unit>, Object>(cropBounds, image, null){
                private /* synthetic */ Object L$0;
                Object L$1;
                int I$0;
                int label;
                final /* synthetic */ Rectangle $cropBounds;
                final /* synthetic */ BufferedImage $image;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    block11: {
                        block10: {
                            var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            block0 : switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    $this$sequence = (SequenceScope)this.L$0;
                                    bounds = this.$cropBounds;
lbl8:
                                    // 2 sources

                                    while (true) {
                                        var4_5 = bounds.y;
                                        var5_6 = com.android.tools.idea.emulator.SkinDefinition$Companion.access$getBottom$p(SkinDefinition.Companion, bounds);
lbl11:
                                        // 2 sources

                                        while (y < var5_6) {
                                            if (!com.android.tools.idea.emulator.SkinDefinition$Companion.access$isTransparentHorizontalLine(SkinDefinition.Companion, this.$image, bounds.x, com.android.tools.idea.emulator.SkinDefinition$Companion.access$getRight$p(SkinDefinition.Companion, bounds), y)) break block10;
                                            piece = com.android.tools.idea.emulator.SkinDefinition$Companion.access$getCropBounds(SkinDefinition.Companion, this.$image, new Rectangle(bounds.x, this.$cropBounds.y, bounds.width, y - bounds.y));
                                            if (piece == null) break block0;
                                            var8_9 = false;
                                            var9_10 = false;
                                            it = var7_8;
                                            $i$a$-let-SkinDefinition$Companion$cutHorizontally$1$1 = false;
                                            this.L$0 = $this$sequence;
                                            this.L$1 = bounds;
                                            this.I$0 = y;
                                            this.label = 1;
                                            v0 = $this$sequence.yield((Object)it, (Continuation)this);
                                            if (v0 == var12_2) {
                                                return var12_2;
                                            }
                                            break block0;
                                        }
                                        break block11;
                                        break;
                                    }
                                }
                                case 1: {
                                    $i$a$-let-SkinDefinition$Companion$cutHorizontally$1$1 = false;
                                    y = this.I$0;
                                    bounds = (Rectangle)this.L$1;
                                    $this$sequence = (SequenceScope)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
                                    break;
                                }
                            }
                            if (com.android.tools.idea.emulator.SkinDefinition$Companion.access$getCropBounds(SkinDefinition.Companion, this.$image, new Rectangle(bounds.x, y + 1, this.$cropBounds.width, bounds.height - y - 1)) == null) {
                                return Unit.INSTANCE;
                            }
                            ** while (true)
                        }
                        ++y;
                        ** GOTO lbl11
                    }
                    this.L$0 = null;
                    this.L$1 = null;
                    this.label = 2;
                    v1 = $this$sequence.yield((Object)bounds, (Continuation)this);
                    if (v1 == var12_2) {
                        return var12_2;
                    }
                    ** GOTO lbl53
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl53:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$cropBounds = rectangle;
                    this.$image = bufferedImage;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> completion2) {
                    Intrinsics.checkNotNullParameter(completion2, (String)"completion");
                    Function2<SequenceScope<? super Rectangle>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    Object object = function2.L$0 = value2;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        @JvmStatic
        private final Sequence<Rectangle> cutVertically(BufferedImage image, Rectangle cropBounds) {
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super Rectangle>, Continuation<? super Unit>, Object>(cropBounds, image, null){
                private /* synthetic */ Object L$0;
                Object L$1;
                int I$0;
                int label;
                final /* synthetic */ Rectangle $cropBounds;
                final /* synthetic */ BufferedImage $image;

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    block11: {
                        block10: {
                            var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            block0 : switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    $this$sequence = (SequenceScope)this.L$0;
                                    bounds = this.$cropBounds;
lbl8:
                                    // 2 sources

                                    while (true) {
                                        var4_5 = bounds.x;
                                        var5_6 = com.android.tools.idea.emulator.SkinDefinition$Companion.access$getRight$p(SkinDefinition.Companion, bounds);
lbl11:
                                        // 2 sources

                                        while (x < var5_6) {
                                            if (!com.android.tools.idea.emulator.SkinDefinition$Companion.access$isTransparentVerticalLine(SkinDefinition.Companion, this.$image, x, bounds.y, com.android.tools.idea.emulator.SkinDefinition$Companion.access$getBottom$p(SkinDefinition.Companion, bounds))) break block10;
                                            piece = com.android.tools.idea.emulator.SkinDefinition$Companion.access$getCropBounds(SkinDefinition.Companion, this.$image, new Rectangle(bounds.x, this.$cropBounds.y, x - bounds.x, bounds.height));
                                            if (piece == null) break block0;
                                            var8_9 = false;
                                            var9_10 = false;
                                            it = var7_8;
                                            $i$a$-let-SkinDefinition$Companion$cutVertically$1$1 = false;
                                            this.L$0 = $this$sequence;
                                            this.L$1 = bounds;
                                            this.I$0 = x;
                                            this.label = 1;
                                            v0 = $this$sequence.yield((Object)it, (Continuation)this);
                                            if (v0 == var12_2) {
                                                return var12_2;
                                            }
                                            break block0;
                                        }
                                        break block11;
                                        break;
                                    }
                                }
                                case 1: {
                                    $i$a$-let-SkinDefinition$Companion$cutVertically$1$1 = false;
                                    x = this.I$0;
                                    bounds = (Rectangle)this.L$1;
                                    $this$sequence = (SequenceScope)this.L$0;
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
                                    break;
                                }
                            }
                            if (com.android.tools.idea.emulator.SkinDefinition$Companion.access$getCropBounds(SkinDefinition.Companion, this.$image, new Rectangle(x + 1, bounds.y, this.$cropBounds.width - x - 1, bounds.height)) == null) {
                                return Unit.INSTANCE;
                            }
                            ** while (true)
                        }
                        ++x;
                        ** GOTO lbl11
                    }
                    this.L$0 = null;
                    this.L$1 = null;
                    this.label = 2;
                    v1 = $this$sequence.yield((Object)bounds, (Continuation)this);
                    if (v1 == var12_2) {
                        return var12_2;
                    }
                    ** GOTO lbl53
                    {
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl53:
                            // 2 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }
                {
                    this.$cropBounds = rectangle;
                    this.$image = bufferedImage;
                    super(2, continuation);
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> completion2) {
                    Intrinsics.checkNotNullParameter(completion2, (String)"completion");
                    Function2<SequenceScope<? super Rectangle>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    Object object = function2.L$0 = value2;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        private final boolean isTransparentHorizontalLine(BufferedImage image, int startX, int endX, int y) {
            int n = startX;
            int n2 = endX;
            while (n < n2) {
                void x;
                if (!this.isTransparentPixel(image, (int)x, y)) {
                    return false;
                }
                ++x;
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        private final boolean isTransparentVerticalLine(BufferedImage image, int x, int startY, int endY) {
            int n = startY;
            int n2 = endY;
            while (n < n2) {
                void y;
                if (!this.isTransparentPixel(image, x, (int)y)) {
                    return false;
                }
                ++y;
            }
            return true;
        }

        @JvmStatic
        private final boolean isTransparentPixel(BufferedImage image, int x, int y) {
            return (image.getRGB(x, y) & 0xFF000000) == 0;
        }

        @JvmStatic
        private final AnchoredImage createAnchoredImage(BufferedImage mask, Rectangle cropBounds, Dimension displaySize) {
            AnchorPoint anchorPoint = cropBounds.x > displaySize.width / 2 ? (cropBounds.y > displaySize.height / 2 ? AnchorPoint.BOTTOM_RIGHT : AnchorPoint.TOP_RIGHT) : (cropBounds.y > displaySize.height / 2 ? AnchorPoint.BOTTOM_LEFT : AnchorPoint.TOP_LEFT);
            Point offset2 = new Point(cropBounds.x - anchorPoint.getX() * displaySize.width, cropBounds.y - anchorPoint.getY() * displaySize.height);
            BufferedImage bufferedImage = this.cropped(mask, cropBounds);
            Dimension dimension2 = cropBounds.getSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"cropBounds.size");
            return new AnchoredImage(bufferedImage, dimension2, anchorPoint, offset2);
        }

        @JvmStatic
        private final Rectangle computeAdjustedFrameRectangle(Iterable<AnchoredImage> backgroundImages, Dimension displaySize) {
            int left2 = 0;
            int top = 0;
            int right2 = displaySize.width;
            int bottom2 = displaySize.height;
            for (AnchoredImage image : backgroundImages) {
                left2 = RangesKt.coerceAtMost((int)left2, (int)(image.getOffset().x + displaySize.width * image.getAnchorPoint().getX()));
                right2 = RangesKt.coerceAtLeast((int)right2, (int)(image.getOffset().x + image.getSize().width + displaySize.width * image.getAnchorPoint().getX()));
                top = RangesKt.coerceAtMost((int)top, (int)(image.getOffset().y + displaySize.height * image.getAnchorPoint().getY()));
                bottom2 = RangesKt.coerceAtLeast((int)bottom2, (int)(image.getOffset().y + image.getSize().height + displaySize.height * image.getAnchorPoint().getY()));
            }
            return new Rectangle(left2, top, right2 - left2, bottom2 - top);
        }

        @JvmStatic
        private final BufferedImage cropped(BufferedImage $this$cropped, Rectangle cropBounds) {
            BufferedImage bufferedImage = ImageUtils.getCroppedImage((BufferedImage)$this$cropped, (Rectangle)cropBounds, (int)-1);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"getCroppedImage(this, cropBounds, -1)");
            return bufferedImage;
        }

        @JvmStatic
        private final Rectangle getCropBounds(BufferedImage image, Rectangle initialCrop) {
            return ImageUtils.getCropBounds((BufferedImage)image, (ImageUtils.CropFilter)ImageUtils.TRANSPARENCY_FILTER, (Rectangle)initialCrop);
        }

        @JvmStatic
        private static /* synthetic */ void getRight$annotations(Rectangle rectangle) {
        }

        private final int getRight(Rectangle $this$right) {
            return $this$right.x + $this$right.width;
        }

        @JvmStatic
        private static /* synthetic */ void getBottom$annotations(Rectangle rectangle) {
        }

        private final int getBottom(Rectangle $this$bottom) {
            return $this$bottom.y + $this$bottom.height;
        }

        @JvmStatic
        private final BufferedImage readImage(URL url) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(url);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (image == null) {
                Path file2 = Paths.get(url.toURI());
                String detail = Files.notExists(file2, new LinkOption[0]) ? " - the file does not exist" : "";
                Companion $this$logger$iv = this;
                boolean $i$f$getLogger = false;
                Logger logger2 = Logger.getInstance(Companion.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(T::class.java)");
                logger2.warn("Failed to read Emulator skin image " + file2 + detail);
            }
            return image;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

