/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.emulator;

import com.android.annotations.concurrency.AnyThread;
import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.stdui.StandardColors;
import com.android.tools.idea.avdmanager.AvdManagerConnection;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.emulator.EmulatorSettings;
import com.android.tools.idea.emulator.EmulatorSettingsListener;
import com.android.tools.idea.emulator.EmulatorUtilsKt;
import com.android.tools.idea.emulator.settings.EmulatorSettingsUi;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.actions.RunAndroidAvdManagerAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\f\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0001H\u0002J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\b\u0010\u0016\u001a\u00020\u0010H\u0002J\b\u0010\u0017\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/emulator/PlaceholderPanel;", "Lcom/intellij/ui/components/JBPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "emulatorLaunchesInToolWindow", "", "emulatorVersionIsSufficient", "hyperlinkListener", "Ljavax/swing/event/HyperlinkListener;", "title", "", "getTitle", "()Ljava/lang/String;", "createContent", "", "createSpacer", "dispose", "localPackagesUpdated", "packages", "Lcom/android/repository/impl/meta/RepositoryPackages;", "updateContent", "updateUI", "intellij.android.emulator"})
public final class PlaceholderPanel
extends JBPanel<PlaceholderPanel>
implements Disposable {
    private boolean emulatorLaunchesInToolWindow;
    private boolean emulatorVersionIsSufficient;
    private HyperlinkListener hyperlinkListener;

    @NotNull
    public final String getTitle() {
        return "No Running Emulators";
    }

    @AnyThread
    private final void localPackagesUpdated(RepositoryPackages packages) {
        LocalPackage localPackage = (LocalPackage)packages.getLocalPackages().get("emulator");
        if (localPackage == null) {
            return;
        }
        LocalPackage emulatorPackage = localPackage;
        EmulatorUtilsKt.invokeLaterInAnyModalityState((Function0<Unit>)((Function0)new Function0<Unit>(this, emulatorPackage){
            final /* synthetic */ PlaceholderPanel this$0;
            final /* synthetic */ LocalPackage $emulatorPackage;

            public final void invoke() {
                boolean sufficient;
                boolean bl = sufficient = this.$emulatorPackage.getVersion().compareTo(Revision.parseRevision((String)"30.2.5")) >= 0;
                if (PlaceholderPanel.access$getEmulatorVersionIsSufficient$p(this.this$0) != sufficient) {
                    PlaceholderPanel.access$setEmulatorVersionIsSufficient$p(this.this$0, sufficient);
                    PlaceholderPanel.access$updateContent(this.this$0);
                }
            }
            {
                this.this$0 = placeholderPanel;
                this.$emulatorPackage = localPackage;
                super(0);
            }
        }));
    }

    private final void createContent() {
        int n = StudioColorsKt.getLinkForeground().getRGB() & 0xFFFFFF;
        int n2 = 16;
        boolean bl = false;
        String string = Integer.toString(n, CharsKt.checkRadix((int)n2));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.Integer.toStri\u2026(this, checkRadix(radix))");
        String linkColorString = string;
        String html = this.emulatorLaunchesInToolWindow ? (this.emulatorVersionIsSufficient ? StringsKt.trimIndent((String)("\n        <center>\n        No emulators are currently running.\n        To&nbsp;launch an&nbsp;emulator, use the&nbsp;<font color = " + linkColorString + "><a href=''>AVD&nbsp;Manager</a></font>\n        or run your app while targeting a&nbsp;virtual device.\n        </center>\n        ")) : StringsKt.trimIndent((String)("\n        <center>\n        To use the Android Emulator in this\n        window, install version 30.2.5 or higher.\n        Please <font color = " + linkColorString + "><a href=''>check for&nbsp;updates</a></font> and install\n        the&nbsp;latest version of the&nbsp;Android&nbsp;Emulator.\n        </center>\n        "))) : StringsKt.trimIndent((String)("\n      <center>\n      The&nbsp;Android Emulator is currently configured\n      to run as a&nbsp;standalone application. To&nbsp;make\n      the&nbsp;Android Emulator launch in this window\n      instead, select the&nbsp;<i>Launch in a&nbsp;tool window</i>\n      option in the&nbsp;<font color = " + linkColorString + "><a href=''>Emulator&nbsp;settings</a></font>.\n      </center>\n      "));
        Object object = this.hyperlinkListener;
        Color color = StandardColors.PLACEHOLDER_TEXT_COLOR;
        Font font = (Font)JBUI.Fonts.label((float)13.0f);
        Color color2 = null;
        boolean bl2 = true;
        object = ComponentsKt.htmlComponent$default((String)html, (Font)font, color2, (Color)color, (boolean)bl2, (HyperlinkListener)object, (int)4, null);
        boolean bl3 = false;
        boolean bl4 = false;
        Object $this$apply = object;
        boolean bl5 = false;
        ((JComponent)$this$apply).setOpaque(false);
        ((Component)$this$apply).setFocusable(false);
        ((JComponent)$this$apply).setBorder((Border)JBUI.Borders.empty());
        Object text2 = object;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        bl4 = false;
        boolean bl6 = false;
        GridBagConstraints $this$apply2 = gridBagConstraints;
        boolean bl7 = false;
        $this$apply2.fill = 1;
        $this$apply2.gridx = 1;
        $this$apply2.gridy = 0;
        $this$apply2.weightx = 0.7;
        $this$apply2.weighty = 0.45;
        GridBagConstraints c = gridBagConstraints;
        this.add((Component)this.createSpacer(), c);
        gridBagConstraints = c;
        bl4 = false;
        bl6 = false;
        $this$apply2 = gridBagConstraints;
        boolean bl8 = false;
        $this$apply2.gridx = 0;
        $this$apply2.gridy = 1;
        $this$apply2.weightx = 0.15;
        $this$apply2.weighty = 0.55;
        this.add((Component)this.createSpacer(), c);
        gridBagConstraints = c;
        bl4 = false;
        bl6 = false;
        $this$apply2 = gridBagConstraints;
        boolean bl9 = false;
        $this$apply2.gridx = 2;
        this.add((Component)this.createSpacer(), c);
        gridBagConstraints = c;
        bl4 = false;
        bl6 = false;
        $this$apply2 = gridBagConstraints;
        boolean bl10 = false;
        $this$apply2.gridx = 1;
        this.add((Component)text2, c);
    }

    private final JBPanel<?> createSpacer() {
        JBPanel jBPanel = new JBPanel().withBorder((Border)JBUI.Borders.empty()).withMinimumWidth(0).withMinimumHeight(0).withPreferredSize(0, 0).andTransparent();
        Intrinsics.checkNotNullExpressionValue((Object)jBPanel, (String)"JBPanel<JBPanel<*>>()\n  \u2026)\n      .andTransparent()");
        return jBPanel;
    }

    private final void updateContent() {
        this.removeAll();
        this.createContent();
        this.validate();
    }

    public void updateUI() {
        super.updateUI();
        this.updateContent();
    }

    public void dispose() {
    }

    public PlaceholderPanel(final @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super((LayoutManager)new GridBagLayout());
        Disposer.register((Disposable)EmulatorUtilsKt.getEarlyDisposable(project), (Disposable)this);
        this.setOpaque(true);
        this.setBackground(StandardColors.BACKGROUND_COLOR);
        this.setBorder((Border)JBUI.Borders.empty());
        this.setFocusable(true);
        this.emulatorLaunchesInToolWindow = EmulatorSettings.Companion.getInstance().getLaunchInToolWindow();
        this.emulatorVersionIsSufficient = true;
        this.hyperlinkListener = new HyperlinkListener(){

            @Override
            public final void hyperlinkUpdate(HyperlinkEvent event) {
                HyperlinkEvent hyperlinkEvent = event;
                Intrinsics.checkNotNullExpressionValue((Object)hyperlinkEvent, (String)"event");
                if (Intrinsics.areEqual((Object)hyperlinkEvent.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                    if (emulatorLaunchesInToolWindow) {
                        if (emulatorVersionIsSufficient) {
                            AnAction anAction = ActionManager.getInstance().getAction("Android.RunAndroidAvdManager");
                            if (anAction == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.android.actions.RunAndroidAvdManagerAction");
                            }
                            RunAndroidAvdManagerAction action2 = (RunAndroidAvdManagerAction)anAction;
                            action2.openAvdManager(project);
                        } else {
                            ActionManager actionManager = ActionManager.getInstance();
                            MouseEvent mouseEvent = new MouseEvent((Component)((Object)this), 500, System.currentTimeMillis(), 0, 0, 0, 1, false);
                            Intrinsics.checkNotNullExpressionValue((Object)actionManager.tryToExecute(actionManager.getAction("CheckForUpdate"), (InputEvent)mouseEvent, null, null, false), (String)"actionManager.tryToExecu\u2026Event, null, null, false)");
                        }
                    } else {
                        ShowSettingsUtil.getInstance().showSettingsDialog(project, EmulatorSettingsUi.class);
                    }
                }
            }
        };
        project.getMessageBus().connect((Disposable)this).subscribe(EmulatorSettingsListener.TOPIC, (Object)new EmulatorSettingsListener(){

            @Override
            public final void emulatorSettingsChanged(EmulatorSettings settings) {
                emulatorLaunchesInToolWindow = settings.getLaunchInToolWindow();
                this.updateContent();
            }
        });
        FutureUtils.executeOnPooledThread((Function0)((Function0)new Function0<Unit>(){

            public final void invoke() {
                AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
                Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"AndroidSdks.getInstance().tryToChooseSdkHandler()");
                AndroidSdkHandler sdkHandler = androidSdkHandler;
                ProgressIndicator progress = (ProgressIndicator)new StudioLoggerProgressIndicator(AvdManagerConnection.class);
                final RepoManager sdkManager = sdkHandler.getSdkManager(progress);
                final RepoManager.RepoLoadedListener listener2 = new RepoManager.RepoLoadedListener(this){
                    final /* synthetic */ 3 this$0;

                    public final void loaded(RepositoryPackages packages) {
                        PlaceholderPanel placeholderPanel = this.this$0.this;
                        RepositoryPackages repositoryPackages = packages;
                        Intrinsics.checkNotNullExpressionValue((Object)repositoryPackages, (String)"packages");
                        PlaceholderPanel.access$localPackagesUpdated(placeholderPanel, repositoryPackages);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                };
                sdkManager.addLocalChangeListener(listener2);
                Disposer.register((Disposable)this, (Disposable)new Disposable(){

                    public final void dispose() {
                        sdkManager.removeLocalChangeListener(listener2);
                    }
                });
                RepoManager repoManager = sdkManager;
                Intrinsics.checkNotNullExpressionValue((Object)repoManager, (String)"sdkManager");
                RepositoryPackages repositoryPackages = repoManager.getPackages();
                Intrinsics.checkNotNullExpressionValue((Object)repositoryPackages, (String)"sdkManager.packages");
                this.localPackagesUpdated(repositoryPackages);
            }
        }));
        this.updateContent();
    }

    public static final /* synthetic */ void access$setEmulatorVersionIsSufficient$p(PlaceholderPanel $this, boolean bl) {
        $this.emulatorVersionIsSufficient = bl;
    }
}

