/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.emulator;

import com.android.tools.idea.emulator.KeyValueFileUtils;
import com.android.tools.idea.emulator.KeyValueFiles;
import com.google.common.base.Splitter;
import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\r\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005H\u0002\u001a,\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\f\u001a$\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"KEY_VALUE_SPLITTER", "Lcom/google/common/base/Splitter;", "kotlin.jvm.PlatformType", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "readKeyValueFile", "", "", "file", "Ljava/nio/file/Path;", "keysToExtract", "", "updateKeyValueFile", "", "updates", "intellij.android.emulator"})
@JvmName(name="KeyValueFiles")
public final class KeyValueFiles {
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on((char)'=').trimResults();

    @Nullable
    public static final Map<String, String> readKeyValueFile(@NotNull Path file2, @Nullable Set<String> keysToExtract) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        try {
            for (String line2 : Files.readAllLines(file2)) {
                List keyValue = KEY_VALUE_SPLITTER.splitToList((CharSequence)line2);
                if (keyValue.size() != 2 || keysToExtract != null && !keysToExtract.contains(keyValue.get(0))) continue;
                Object e = keyValue.get(0);
                Intrinsics.checkNotNullExpressionValue(e, (String)"keyValue[0]");
                Object e2 = keyValue.get(1);
                Intrinsics.checkNotNullExpressionValue(e2, (String)"keyValue[1]");
                result2.put(e, e2);
            }
            return result2;
        }
        catch (IOException e) {
            if (e.getMessage() == null) {
                KeyValueFiles.logger().error("Error reading " + file2);
            } else {
                KeyValueFiles.logger().error("Error reading " + file2 + " - " + e.getMessage());
            }
            return null;
        }
    }

    public static final void updateKeyValueFile(@NotNull Path file2, @NotNull Map<String, String> updates) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(updates, (String)"updates");
        Map<String, String> map2 = KeyValueFiles.readKeyValueFile(file2, null);
        if (map2 == null) {
            return;
        }
        Map<String, String> originalContents = map2;
        TreeMap<String, String> sortedContents = new TreeMap<String, String>(originalContents);
        sortedContents.putAll(updates);
        Set<Map.Entry<String, String>> set = sortedContents.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"sortedContents.entries");
        List lines2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)updateKeyValueFile.lines.1.INSTANCE), (Function1)updateKeyValueFile.lines.2.INSTANCE));
        Path tempFile = file2.resolveSibling(((Object)file2.getFileName()).toString() + ".temp");
        try {
            Files.write(tempFile, (Iterable<? extends CharSequence>)lines2, Charsets.UTF_8, StandardOpenOption.CREATE);
            Files.move(tempFile, file2, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            if (e.getMessage() == null) {
                KeyValueFiles.logger().error("Error writing " + file2);
            } else {
                KeyValueFiles.logger().error("Error writing " + file2 + " - " + e.getMessage());
            }
            try {
                Files.deleteIfExists(tempFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final Logger logger() {
        Logger logger2 = Logger.getInstance(KeyValueFileUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(KeyValueFileUtils::class.java)");
        return logger2;
    }
}

