/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.emulator;

import com.android.emulator.control.Image;
import com.android.emulator.control.ImageFormat;
import com.android.tools.idea.emulator.EmulatorControllerKt;
import com.android.tools.idea.protobuf.CodedInputStream;
import com.android.tools.idea.protobuf.InvalidProtocolBufferException;
import com.android.tools.idea.protobuf.MessageLite;
import com.android.tools.idea.protobuf.UnsafeByteOperations;
import io.grpc.KnownLength;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/emulator/ImageResponseMarshaller;", "Lio/grpc/MethodDescriptor$Marshaller;", "Lcom/android/emulator/control/Image;", "()V", "reusableBuffer", "Ljava/lang/ThreadLocal;", "Ljava/lang/ref/Reference;", "", "createCodedInputStream", "Lcom/android/tools/idea/protobuf/CodedInputStream;", "stream", "Ljava/io/InputStream;", "parse", "parseImage", "input", "response", "intellij.android.emulator"})
final class ImageResponseMarshaller
implements MethodDescriptor.Marshaller<Image> {
    private final ThreadLocal<Reference<byte[]>> reusableBuffer = new ThreadLocal();

    @NotNull
    public InputStream stream(@NotNull Image response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public Image parse(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        try {
            CodedInputStream codedInputStream = this.createCodedInputStream(stream);
            if (codedInputStream == null) {
                Image image = Image.getDefaultInstance();
                Intrinsics.checkNotNullExpressionValue((Object)image, (String)"Image.getDefaultInstance()");
                return image;
            }
            CodedInputStream codedStream = codedInputStream;
            return this.parseImage(codedStream);
        }
        catch (InvalidProtocolBufferException e) {
            StatusRuntimeException statusRuntimeException = Status.INTERNAL.withDescription("Invalid protobuf byte sequence").withCause((Throwable)e).asRuntimeException();
            Intrinsics.checkNotNullExpressionValue((Object)statusRuntimeException, (String)"Status.INTERNAL.withDesc\u2026e(e).asRuntimeException()");
            throw (Throwable)statusRuntimeException;
        }
    }

    private final CodedInputStream createCodedInputStream(InputStream stream) throws InvalidProtocolBufferException {
        CodedInputStream codedStream = null;
        try {
            if (stream instanceof KnownLength) {
                int position;
                int remaining;
                int count;
                byte[] buf;
                int size = stream.available();
                if (size == 0) {
                    return null;
                }
                Reference<byte[]> reference2 = this.reusableBuffer.get();
                Object object = buf = (Object)(reference2 != null ? reference2.get() : null);
                if (buf == null || buf.length < size) {
                    buf = new byte[size];
                    this.reusableBuffer.set(new WeakReference<byte[]>(buf));
                }
                for (remaining = size; remaining > 0 && (count = stream.read(buf, position = size - remaining, remaining)) != -1; remaining -= count) {
                }
                if (remaining != 0) {
                    position = size - remaining;
                    throw (Throwable)new RuntimeException("Inaccurate size: " + size + " != " + position);
                }
                CodedInputStream codedInputStream = UnsafeByteOperations.unsafeWrap((byte[])buf, (int)0, (int)size).newCodedInput();
                Intrinsics.checkNotNullExpressionValue((Object)codedInputStream, (String)"UnsafeByteOperations.uns\u2026 0, size).newCodedInput()");
                codedStream = codedInputStream;
                codedStream.enableAliasing(true);
            } else {
                CodedInputStream codedInputStream = CodedInputStream.newInstance((InputStream)stream);
                Intrinsics.checkNotNullExpressionValue((Object)codedInputStream, (String)"CodedInputStream.newInstance(stream)");
                codedStream = codedInputStream;
            }
        }
        catch (IOException e) {
            throw (Throwable)new InvalidProtocolBufferException(e);
        }
        codedStream.setSizeLimit(Integer.MAX_VALUE);
        return codedStream;
    }

    /*
     * Unable to fully structure code
     */
    private final Image parseImage(CodedInputStream input) throws InvalidProtocolBufferException {
        builder = Image.newBuilder();
        try {
            block9: while (true) {
                tag = input.readTag();
                switch (tag) {
                    case 0: {
                        break block9;
                    }
                    case 10: {
                        v0 = builder;
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"builder");
                        v1 = input.readMessage(ImageFormat.parser(), EmulatorControllerKt.access$getEMPTY_REGISTRY$p());
                        if (v1 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.android.emulator.control.ImageFormat");
                        }
                        v0.setFormat((ImageFormat)v1);
                        continue block9;
                    }
                    case 34: {
                        v2 = builder;
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"builder");
                        v2.setImage(input.readBytes());
                        continue block9;
                    }
                    case 40: {
                        v3 = builder;
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"builder");
                        v3.setSeq(input.readUInt32());
                        continue block9;
                    }
                    default: {
                        if (!input.skipField(tag)) ** break;
                        continue block9;
                        break block9;
                    }
                }
                break;
            }
            input.checkLastTagWas(0);
            v4 = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"builder.build()");
            return v4;
        }
        catch (InvalidProtocolBufferException e) {
            v5 = e.setUnfinishedMessage((MessageLite)builder.build());
            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"e.setUnfinishedMessage(builder.build())");
            throw (Throwable)v5;
        }
        catch (IOException e) {
            v6 = new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.build());
            Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"InvalidProtocolBufferExc\u2026dMessage(builder.build())");
            throw (Throwable)v6;
        }
    }
}

