/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.emulator;

import com.android.emulator.control.Rotation;
import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.emulator.AnchorPoint;
import com.android.tools.idea.emulator.AnchoredImage$WhenMappings;
import com.android.tools.idea.emulator.EmulatorUtilsKt;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ \u0010\u0013\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/emulator/AnchoredImage;", "", "image", "Ljava/awt/image/BufferedImage;", "size", "Ljava/awt/Dimension;", "anchorPoint", "Lcom/android/tools/idea/emulator/AnchorPoint;", "offset", "Ljava/awt/Point;", "(Ljava/awt/image/BufferedImage;Ljava/awt/Dimension;Lcom/android/tools/idea/emulator/AnchorPoint;Ljava/awt/Point;)V", "getAnchorPoint", "()Lcom/android/tools/idea/emulator/AnchorPoint;", "getImage", "()Ljava/awt/image/BufferedImage;", "getOffset", "()Ljava/awt/Point;", "getSize", "()Ljava/awt/Dimension;", "rotatedAndScaled", "rotation", "Lcom/android/emulator/control/Rotation$SkinRotation;", "scaleX", "", "scaleY", "intellij.android.emulator"})
public final class AnchoredImage {
    @NotNull
    private final BufferedImage image;
    @NotNull
    private final Dimension size;
    @NotNull
    private final AnchorPoint anchorPoint;
    @NotNull
    private final Point offset;

    @Nullable
    public final AnchoredImage rotatedAndScaled(@NotNull Rotation.SkinRotation rotation, double scaleX, double scaleY) {
        Point point;
        Intrinsics.checkNotNullParameter((Object)rotation, (String)"rotation");
        Dimension rotatedSize = EmulatorUtilsKt.rotated(this.size, rotation);
        int width = EmulatorUtilsKt.scaled(rotatedSize.width, scaleX);
        int height = EmulatorUtilsKt.scaled(rotatedSize.height, scaleY);
        if (width == 0 || height == 0) {
            return null;
        }
        AnchorPoint rotatedAnchorPoint = this.anchorPoint.rotated(rotation);
        Point rotatedOffset = EmulatorUtilsKt.rotated(this.offset, rotation);
        switch (AnchoredImage$WhenMappings.$EnumSwitchMapping$0[rotation.ordinal()]) {
            case 1: {
                point = new Point(EmulatorUtilsKt.scaled(rotatedOffset.x, scaleX), EmulatorUtilsKt.scaled(rotatedOffset.y, scaleY) - height);
                break;
            }
            case 2: {
                point = new Point(EmulatorUtilsKt.scaled(rotatedOffset.x, scaleX) - width, EmulatorUtilsKt.scaled(rotatedOffset.y, scaleY) - height);
                break;
            }
            case 3: {
                point = new Point(EmulatorUtilsKt.scaled(rotatedOffset.x, scaleX) - width, EmulatorUtilsKt.scaled(rotatedOffset.y, scaleY));
                break;
            }
            default: {
                point = new Point(EmulatorUtilsKt.scaled(rotatedOffset.x, scaleX), EmulatorUtilsKt.scaled(rotatedOffset.y, scaleY));
            }
        }
        Point transformedOffset = point;
        BufferedImage bufferedImage = ImageUtils.rotateByQuadrantsAndScale((BufferedImage)this.image, (int)rotation.ordinal(), (int)width, (int)height);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageUtils.rotateByQuadr\u2026n.ordinal, width, height)");
        BufferedImage transformedImage = bufferedImage;
        return new AnchoredImage(transformedImage, new Dimension(width, height), rotatedAnchorPoint, transformedOffset);
    }

    @NotNull
    public final BufferedImage getImage() {
        return this.image;
    }

    @NotNull
    public final Dimension getSize() {
        return this.size;
    }

    @NotNull
    public final AnchorPoint getAnchorPoint() {
        return this.anchorPoint;
    }

    @NotNull
    public final Point getOffset() {
        return this.offset;
    }

    public AnchoredImage(@NotNull BufferedImage image, @NotNull Dimension size, @NotNull AnchorPoint anchorPoint, @NotNull Point offset2) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)((Object)anchorPoint), (String)"anchorPoint");
        Intrinsics.checkNotNullParameter((Object)offset2, (String)"offset");
        this.image = image;
        this.size = size;
        this.anchorPoint = anchorPoint;
        this.offset = offset2;
    }
}

