/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.tools.idea.AndroidTextUtils;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Component;
import java.awt.Font;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class ThemeEditorUtils {
    private ThemeEditorUtils() {
    }

    static int getMinApiLevel(@NotNull Module module2) {
        AndroidFacet facet2;
        if (module2 == null) {
            ThemeEditorUtils.$$$reportNull$$$0(0);
        }
        if ((facet2 = AndroidFacet.getInstance((Module)module2)) == null) {
            return 1;
        }
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(facet2);
        return moduleInfo.getMinSdkVersion().getApiLevel();
    }

    public static int getMinFolderApi(@NotNull List<String> folderNames, @NotNull Module module2) {
        if (folderNames == null) {
            ThemeEditorUtils.$$$reportNull$$$0(1);
        }
        if (module2 == null) {
            ThemeEditorUtils.$$$reportNull$$$0(2);
        }
        int minFolderApi = Integer.MAX_VALUE;
        int minModuleApi = ThemeEditorUtils.getMinApiLevel(module2);
        for (String folderName : folderNames) {
            FolderConfiguration folderConfig = FolderConfiguration.getConfigForFolder((String)folderName);
            if (folderConfig == null) continue;
            VersionQualifier version2 = folderConfig.getVersionQualifier();
            int folderApi = version2 != null ? version2.getVersion() : minModuleApi;
            minFolderApi = Math.min(minFolderApi, folderApi);
        }
        return minFolderApi;
    }

    @NotNull
    public static Configuration getConfigurationForModule(@NotNull Module module2) {
        if (module2 == null) {
            ThemeEditorUtils.$$$reportNull$$$0(3);
        }
        Project project = module2.getProject();
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        assert (facet2 != null) : "moduleComboModel must contain only Android modules";
        ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(module2);
        VirtualFile projectFile = project.getProjectFile();
        assert (projectFile != null);
        Configuration configuration = configurationManager.getConfiguration(projectFile);
        if (configuration == null) {
            ThemeEditorUtils.$$$reportNull$$$0(4);
        }
        return configuration;
    }

    @NotNull
    public static RenderTask configureRenderTask(@NotNull Module module2, @NotNull Configuration configuration) {
        if (module2 == null) {
            ThemeEditorUtils.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            ThemeEditorUtils.$$$reportNull$$$0(6);
        }
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        assert (facet2 != null);
        RenderService service = RenderService.getInstance(module2.getProject());
        RenderLogger logger2 = new RenderLogger("ThemeEditorLogger", null);
        RenderTask task2 = service.taskBuilder(facet2, configuration).withLogger(logger2).buildSynchronously();
        assert (task2 != null);
        task2.getLayoutlibCallback().setLogger(logger2);
        RenderTask renderTask = task2;
        if (renderTask == null) {
            ThemeEditorUtils.$$$reportNull$$$0(7);
        }
        return renderTask;
    }

    @NotNull
    public static String generateWordEnumeration(@NotNull Collection<String> words) {
        if (words == null) {
            ThemeEditorUtils.$$$reportNull$$$0(8);
        }
        String string = AndroidTextUtils.generateCommaSeparatedList(words, (String)"and");
        if (string == null) {
            ThemeEditorUtils.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public static Font scaleFontForAttribute(@NotNull Font font) {
        if (font == null) {
            ThemeEditorUtils.$$$reportNull$$$0(10);
        }
        Font font2 = font.deriveFont((float)Math.ceil((float)font.getSize() * 0.9f));
        if (font2 == null) {
            ThemeEditorUtils.$$$reportNull$$$0(11);
        }
        return font2;
    }

    public static void setInheritsPopupMenuRecursive(JComponent comp) {
        comp.setInheritsPopupMenu(true);
        for (Component child : comp.getComponents()) {
            if (!(child instanceof JComponent)) continue;
            ThemeEditorUtils.setInheritsPopupMenuRecursive((JComponent)child);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderNames";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/theme/ThemeEditorUtils";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "words";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/theme/ThemeEditorUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationForModule";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "configureRenderTask";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "generateWordEnumeration";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "scaleFontForAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMinApiLevel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMinFolderApi";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationForModule";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureRenderTask";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateWordEnumeration";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scaleFontForAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

