/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceType;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.MultiResourceRepository;
import com.android.tools.idea.res.ResourceFolderRepository;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceRepository {
    private final Map<VirtualFile, LocalResourceRepository> myResourceDirectoryRepositoryMap;
    private final LocalResourceRepository myDynamicResourceRepository;

    private StringResourceRepository(@NotNull MultiResourceRepository parent) {
        if (parent == null) {
            StringResourceRepository.$$$reportNull$$$0(0);
        }
        ImmutableList<LocalResourceRepository> localResources = parent.getLocalResources();
        LinkedHashMap resourceDirectoryRepositoryMap = Maps.newLinkedHashMapWithExpectedSize((int)localResources.size());
        LocalResourceRepository dynamicResourceRepository = null;
        for (LocalResourceRepository child : localResources) {
            if (child instanceof ResourceFolderRepository) {
                ResourceFolderRepository repository = (ResourceFolderRepository)child;
                ReadAction.run(() -> repository.scanRecursively(StringResourceRepository::isDirectoryOrStringResourceFile));
                resourceDirectoryRepositoryMap.put(repository.getResourceDir(), child);
                continue;
            }
            assert (dynamicResourceRepository == null);
            dynamicResourceRepository = child;
        }
        this.myResourceDirectoryRepositoryMap = resourceDirectoryRepositoryMap;
        this.myDynamicResourceRepository = dynamicResourceRepository;
    }

    private StringResourceRepository(@NotNull ResourceFolderRepository repository) {
        if (repository == null) {
            StringResourceRepository.$$$reportNull$$$0(1);
        }
        ReadAction.run(() -> repository.scanRecursively(StringResourceRepository::isDirectoryOrStringResourceFile));
        this.myResourceDirectoryRepositoryMap = Collections.singletonMap(repository.getResourceDir(), repository);
        this.myDynamicResourceRepository = null;
    }

    private StringResourceRepository(@NotNull LocalResourceRepository repository) {
        if (repository == null) {
            StringResourceRepository.$$$reportNull$$$0(2);
        }
        repository.sync();
        this.myResourceDirectoryRepositoryMap = Collections.emptyMap();
        this.myDynamicResourceRepository = repository;
    }

    private static boolean isDirectoryOrStringResourceFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StringResourceRepository.$$$reportNull$$$0(3);
        }
        return file2.isDirectory() || file2.getName().equals("strings.xml");
    }

    @NotNull
    public static StringResourceRepository empty() {
        return new StringResourceRepository(new LocalResourceRepository.EmptyRepository(ResourceNamespace.RES_AUTO));
    }

    @NotNull
    static StringResourceRepository create(@NotNull LocalResourceRepository repository) {
        if (repository == null) {
            StringResourceRepository.$$$reportNull$$$0(4);
        }
        if (repository instanceof MultiResourceRepository) {
            return new StringResourceRepository((MultiResourceRepository)repository);
        }
        if (repository instanceof ResourceFolderRepository) {
            return new StringResourceRepository((ResourceFolderRepository)repository);
        }
        return new StringResourceRepository(repository);
    }

    @NotNull
    final Stream<StringResourceKey> getKeys() {
        Set<Map.Entry<VirtualFile, LocalResourceRepository>> entries = this.myResourceDirectoryRepositoryMap.entrySet();
        Stream<StringResourceKey> resourceDirectoryKeys = entries.stream().flatMap(StringResourceRepository::getKeys);
        if (this.myDynamicResourceRepository == null) {
            Stream<StringResourceKey> stream = resourceDirectoryKeys;
            if (stream == null) {
                StringResourceRepository.$$$reportNull$$$0(5);
            }
            return stream;
        }
        Set<String> names = this.myDynamicResourceRepository.getResourceNames(ResourceNamespace.TODO(), ResourceType.STRING);
        Stream<StringResourceKey> dynamicResourceKeys = names.stream().map(name -> new StringResourceKey((String)name, null));
        Stream<StringResourceKey> stream = Stream.concat(resourceDirectoryKeys, dynamicResourceKeys);
        if (stream == null) {
            StringResourceRepository.$$$reportNull$$$0(6);
        }
        return stream;
    }

    @NotNull
    private static Stream<StringResourceKey> getKeys(@NotNull Map.Entry<VirtualFile, LocalResourceRepository> entry) {
        if (entry == null) {
            StringResourceRepository.$$$reportNull$$$0(7);
        }
        VirtualFile directory = entry.getKey();
        Stream<StringResourceKey> stream = entry.getValue().getResources(ResourceNamespace.TODO(), ResourceType.STRING).keySet().stream().map(name -> new StringResourceKey((String)name, directory));
        if (stream == null) {
            StringResourceRepository.$$$reportNull$$$0(8);
        }
        return stream;
    }

    @NotNull
    public Collection<ResourceItem> getItems(@NotNull StringResourceKey key) {
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(9);
        }
        return StringResourceRepository.getItems(this.getRepository(key), key);
    }

    @Nullable
    final ResourceItem getDefaultValue(@NotNull StringResourceKey key) {
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(10);
        }
        return this.getItem(key, item -> item.getConfiguration().getLocaleQualifier() == null);
    }

    @Nullable
    final ResourceItem getTranslation(@NotNull StringResourceKey key, @NotNull Locale locale) {
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(11);
        }
        if (locale == null) {
            StringResourceRepository.$$$reportNull$$$0(12);
        }
        return this.getItem(key, item -> StringResourceRepository.localeEquals((Configurable)item, locale));
    }

    private static boolean localeEquals(@NotNull Configurable item, @NotNull Locale locale) {
        LocaleQualifier qualifier;
        if (item == null) {
            StringResourceRepository.$$$reportNull$$$0(13);
        }
        if (locale == null) {
            StringResourceRepository.$$$reportNull$$$0(14);
        }
        return (qualifier = item.getConfiguration().getLocaleQualifier()) != null && Locale.create(qualifier).equals(locale);
    }

    @Nullable
    private ResourceItem getItem(@NotNull StringResourceKey key, @NotNull Predicate<ResourceItem> predicate2) {
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(15);
        }
        if (predicate2 == null) {
            StringResourceRepository.$$$reportNull$$$0(16);
        }
        LocalResourceRepository repository = this.getRepository(key);
        Optional<ResourceItem> optionalItem = StringResourceRepository.getItems(repository, key).stream().filter(predicate2).findFirst();
        return optionalItem.orElse(null);
    }

    @NotNull
    private LocalResourceRepository getRepository(@NotNull StringResourceKey key) {
        VirtualFile directory;
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(17);
        }
        LocalResourceRepository localResourceRepository = (directory = key.getDirectory()) == null ? this.myDynamicResourceRepository : this.myResourceDirectoryRepositoryMap.get(directory);
        if (localResourceRepository == null) {
            StringResourceRepository.$$$reportNull$$$0(18);
        }
        return localResourceRepository;
    }

    @NotNull
    private static Collection<ResourceItem> getItems(@NotNull LocalResourceRepository repository, @NotNull StringResourceKey key) {
        if (repository == null) {
            StringResourceRepository.$$$reportNull$$$0(19);
        }
        if (key == null) {
            StringResourceRepository.$$$reportNull$$$0(20);
        }
        repository.sync();
        List<ResourceItem> list = repository.getResources(ResourceNamespace.TODO(), ResourceType.STRING, key.getName());
        if (list == null) {
            StringResourceRepository.$$$reportNull$$$0(21);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 18: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/StringResourceRepository";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceRepository";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepository";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryOrStringResourceFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 18: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getKeys";
                break;
            }
            case 9: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getItems";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTranslation";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "localeEquals";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getItem";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getRepository";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

