/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.StringResourceUnescaper;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringResourceRepository;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.rename.RenameProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringResourceData {
    private static final int MAX_LOCALE_LABEL_COUNT = 3;
    private final Map<StringResourceKey, StringResource> myKeyToResourceMap;
    private final Project myProject;
    private final StringResourceUnescaper myUnescaper;
    private final StringResourceRepository myRepository;

    private StringResourceData(@NotNull Project project, @NotNull StringResourceRepository repository) {
        if (project == null) {
            StringResourceData.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            StringResourceData.$$$reportNull$$$0(1);
        }
        this.myKeyToResourceMap = new LinkedHashMap<StringResourceKey, StringResource>();
        this.myProject = project;
        this.myUnescaper = new StringResourceUnescaper();
        this.myRepository = repository;
    }

    @NotNull
    public static StringResourceData create(@NotNull Project project, @NotNull StringResourceRepository repository) {
        if (project == null) {
            StringResourceData.$$$reportNull$$$0(2);
        }
        if (repository == null) {
            StringResourceData.$$$reportNull$$$0(3);
        }
        StringResourceData data = new StringResourceData(project, repository);
        repository.getKeys().forEach(key -> data.myKeyToResourceMap.put((StringResourceKey)key, new StringResource((StringResourceKey)key, data)));
        StringResourceData stringResourceData = data;
        if (stringResourceData == null) {
            StringResourceData.$$$reportNull$$$0(4);
        }
        return stringResourceData;
    }

    @NotNull
    final Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            StringResourceData.$$$reportNull$$$0(5);
        }
        return project;
    }

    @NotNull
    final StringResourceUnescaper getUnescaper() {
        StringResourceUnescaper stringResourceUnescaper = this.myUnescaper;
        if (stringResourceUnescaper == null) {
            StringResourceData.$$$reportNull$$$0(6);
        }
        return stringResourceUnescaper;
    }

    @NotNull
    final StringResourceRepository getRepository() {
        StringResourceRepository stringResourceRepository = this.myRepository;
        if (stringResourceRepository == null) {
            StringResourceData.$$$reportNull$$$0(7);
        }
        return stringResourceRepository;
    }

    public void setKeyName(@NotNull StringResourceKey key, @NotNull String name) {
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(8);
        }
        if (name == null) {
            StringResourceData.$$$reportNull$$$0(9);
        }
        if (key.getName().equals(name)) {
            return;
        }
        boolean mapContainsName = this.myKeyToResourceMap.keySet().stream().map(k -> k.getName()).anyMatch(n -> n.equals(name));
        if (mapContainsName) {
            return;
        }
        ResourceItem value2 = this.getStringResource(key).getDefaultValueAsResourceItem();
        if (value2 == null) {
            return;
        }
        XmlTag stringElement = IdeResourcesUtil.getItemTag(this.myProject, value2);
        assert (stringElement != null);
        XmlAttribute nameAttribute = stringElement.getAttribute("name");
        assert (nameAttribute != null);
        XmlAttributeValue nameAttributeValue = nameAttribute.getValueElement();
        assert (nameAttributeValue != null);
        new RenameProcessor(this.myProject, (PsiElement)nameAttributeValue, name, false, false).run();
        this.myKeyToResourceMap.remove(key);
        key = new StringResourceKey(name, key.getDirectory());
        this.myKeyToResourceMap.put(key, new StringResource(key, this));
    }

    public boolean setTranslatable(@NotNull StringResourceKey key, boolean translatable) {
        StringResource stringResource;
        ResourceItem item;
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(10);
        }
        if ((item = (stringResource = this.getStringResource(key)).getDefaultValueAsResourceItem()) != null) {
            String translatableAsString;
            if (translatable) {
                translatableAsString = null;
                stringResource.setTranslatable(true);
            } else {
                translatableAsString = "false";
                stringResource.setTranslatable(false);
            }
            List<ResourceItem> list = Collections.singletonList(item);
            return StringsWriteUtils.setAttributeForItems(this.myProject, "translatable", translatableAsString, list);
        }
        return false;
    }

    @Nullable
    public String validateKey(@NotNull StringResourceKey key) {
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(11);
        }
        if (!this.myKeyToResourceMap.containsKey(key)) {
            throw new IllegalArgumentException("Key " + key + " does not exist.");
        }
        StringResource stringResource = this.getStringResource(key);
        if (!stringResource.isTranslatable()) {
            Collection<Locale> localesWithTranslation = stringResource.getTranslatedLocales();
            if (!localesWithTranslation.isEmpty()) {
                return String.format("Key '%1$s' is marked as non translatable, but is translated in %2$s %3$s", key.getName(), StringUtil.pluralize((String)"locale", (int)localesWithTranslation.size()), StringResourceData.summarizeLocales(localesWithTranslation));
            }
        } else {
            if (stringResource.getDefaultValueAsResourceItem() == null) {
                return "Key '" + key.getName() + "' missing default value";
            }
            Collection<Locale> missingTranslations = this.getMissingTranslations(key);
            if (!missingTranslations.isEmpty()) {
                return String.format("Key '%1$s' has translations missing for %2$s %3$s", key.getName(), StringUtil.pluralize((String)"locale", (int)missingTranslations.size()), StringResourceData.summarizeLocales(missingTranslations));
            }
        }
        return null;
    }

    @NotNull
    @VisibleForTesting
    Collection<Locale> getMissingTranslations(@NotNull StringResourceKey key) {
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(12);
        }
        HashSet<Locale> missingTranslations = new HashSet<Locale>();
        for (Locale locale : this.getLocaleSet()) {
            StringResource stringResource = this.getStringResource(key);
            if (!stringResource.isTranslationMissing(locale)) continue;
            missingTranslations.add(locale);
        }
        HashSet<Locale> hashSet = missingTranslations;
        if (hashSet == null) {
            StringResourceData.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @VisibleForTesting
    @NotNull
    static String summarizeLocales(@NotNull Collection<Locale> locales) {
        if (locales == null) {
            StringResourceData.$$$reportNull$$$0(14);
        }
        if (locales.isEmpty()) {
            return "";
        }
        int size = locales.size();
        if (size == 1) {
            String string = StringResourceData.getLabel((Locale)Iterables.getFirst(locales, null));
            if (string == null) {
                StringResourceData.$$$reportNull$$$0(15);
            }
            return string;
        }
        List<Locale> sorted2 = StringResourceData.getLowest(locales);
        if (size <= 3) {
            String string = StringResourceData.getLabels(sorted2.subList(0, size - 1)) + " and " + StringResourceData.getLabel(sorted2.get(size - 1));
            if (string == null) {
                StringResourceData.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = StringResourceData.getLabels(sorted2) + " and " + (size - 3) + " more";
        if (string == null) {
            StringResourceData.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    private static List<Locale> getLowest(@NotNull Collection<Locale> locales) {
        if (locales == null) {
            StringResourceData.$$$reportNull$$$0(18);
        }
        List<Locale> list = locales.stream().limit(3L).sorted(Comparator.comparing(StringResourceData::getLabel)).collect(Collectors.toList());
        if (list == null) {
            StringResourceData.$$$reportNull$$$0(19);
        }
        return list;
    }

    private static String getLabels(Collection<Locale> locales) {
        return locales.stream().map(StringResourceData::getLabel).collect(Collectors.joining(", "));
    }

    private static String getLabel(@Nullable Locale locale) {
        return locale == null ? "" : LocaleMenuAction.getLocaleLabel(locale, false);
    }

    boolean containsKey(@NotNull StringResourceKey key) {
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(20);
        }
        return this.myKeyToResourceMap.containsKey(key);
    }

    @NotNull
    public StringResource getStringResource(@NotNull StringResourceKey key) {
        StringResource resource;
        if (key == null) {
            StringResourceData.$$$reportNull$$$0(21);
        }
        if ((resource = this.myKeyToResourceMap.get(key)) == null) {
            throw new IllegalArgumentException(key.toString());
        }
        StringResource stringResource = resource;
        if (stringResource == null) {
            StringResourceData.$$$reportNull$$$0(22);
        }
        return stringResource;
    }

    @NotNull
    public Collection<StringResource> getResources() {
        Collection<StringResource> collection2 = this.myKeyToResourceMap.values();
        if (collection2 == null) {
            StringResourceData.$$$reportNull$$$0(23);
        }
        return collection2;
    }

    @NotNull
    public List<StringResourceKey> getKeys() {
        return new ArrayList<StringResourceKey>(this.myKeyToResourceMap.keySet());
    }

    @NotNull
    public List<Locale> getLocaleList() {
        List<Locale> list = this.getTranslatedLocaleStream().distinct().sorted(Locale.LANGUAGE_NAME_COMPARATOR).collect(Collectors.toList());
        if (list == null) {
            StringResourceData.$$$reportNull$$$0(24);
        }
        return list;
    }

    @NotNull
    Set<Locale> getLocaleSet() {
        Set<Locale> set = this.getTranslatedLocaleStream().collect(Collectors.toSet());
        if (set == null) {
            StringResourceData.$$$reportNull$$$0(25);
        }
        return set;
    }

    @NotNull
    private Stream<Locale> getTranslatedLocaleStream() {
        Stream<Locale> stream = this.myKeyToResourceMap.values().stream().flatMap(resource -> resource.getTranslatedLocales().stream());
        if (stream == null) {
            StringResourceData.$$$reportNull$$$0(26);
        }
        return stream;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/StringResourceData";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locales";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringResourceData";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnescaper";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepository";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingTranslations";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "summarizeLocales";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLowest";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringResource";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getResources";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocaleList";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocaleSet";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getTranslatedLocaleStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setKeyName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTranslatable";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateKey";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getMissingTranslations";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "summarizeLocales";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLowest";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getStringResource";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

