/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.StringResourceUnescaper;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.StringPsiUtils;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringsWriteUtils;
import com.android.tools.idea.editors.strings.VirtualFiles;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.res.DynamicValueResourceItem;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.PsiResourceItem;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StringResource {
    @NotNull
    private final StringResourceKey myKey;
    @NotNull
    private final String myResourceFolder;
    private boolean myTranslatable;
    @NotNull
    private ResourceItemEntry myDefaultValue;
    @NotNull
    private final Map<Locale, ResourceItemEntry> myLocaleToTranslationMap;
    @NotNull
    private final StringResourceData myData;

    public StringResource(@NotNull StringResourceKey key, @NotNull StringResourceData data) {
        if (key == null) {
            StringResource.$$$reportNull$$$0(0);
        }
        if (data == null) {
            StringResource.$$$reportNull$$$0(1);
        }
        Project project = data.getProject();
        boolean translatable = true;
        ResourceItemEntry defaultValue2 = new ResourceItemEntry();
        StringResourceUnescaper unescaper = data.getUnescaper();
        HashMap<Locale, ResourceItemEntry> localeToTranslationMap = new HashMap<Locale, ResourceItemEntry>();
        for (ResourceItem item : data.getRepository().getItems(key)) {
            LocaleQualifier qualifier;
            XmlTag tag;
            if (!(item instanceof PsiResourceItem) && !(item instanceof DynamicValueResourceItem)) {
                Logger.getInstance(StringResource.class).warn(item + " has an unexpected class " + item.getClass().getName());
            }
            if ((tag = IdeResourcesUtil.getItemTag(project, item)) != null && "false".equals(tag.getAttributeValue("translatable"))) {
                translatable = false;
            }
            if ((qualifier = item.getConfiguration().getLocaleQualifier()) == null) {
                defaultValue2 = new ResourceItemEntry(item, unescaper);
                continue;
            }
            localeToTranslationMap.put(Locale.create(qualifier), new ResourceItemEntry(item, unescaper));
        }
        this.myKey = key;
        VirtualFile folder = key.getDirectory();
        this.myResourceFolder = folder == null ? "" : VirtualFiles.toString(folder, project);
        this.myTranslatable = translatable;
        this.myDefaultValue = defaultValue2;
        this.myLocaleToTranslationMap = localeToTranslationMap;
        this.myData = data;
    }

    @NotNull
    StringResourceKey getKey() {
        StringResourceKey stringResourceKey = this.myKey;
        if (stringResourceKey == null) {
            StringResource.$$$reportNull$$$0(2);
        }
        return stringResourceKey;
    }

    @NotNull
    public String getResourceFolder() {
        String string = this.myResourceFolder;
        if (string == null) {
            StringResource.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    ResourceItem getDefaultValueAsResourceItem() {
        return this.myDefaultValue.myResourceItem;
    }

    @NotNull
    public String getDefaultValueAsString() {
        String string = this.myDefaultValue.myString;
        if (string == null) {
            StringResource.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean setDefaultValue(@NotNull String defaultValue2) {
        if (defaultValue2 == null) {
            StringResource.$$$reportNull$$$0(5);
        }
        if (this.myDefaultValue.myResourceItem == null) {
            ResourceItem item = this.createDefaultValue(defaultValue2);
            if (item == null) {
                return false;
            }
            this.myDefaultValue = new ResourceItemEntry(item, this.myData.getUnescaper());
            return true;
        }
        if (this.myDefaultValue.myString.equals(defaultValue2)) {
            return false;
        }
        boolean changed = StringsWriteUtils.setItemText(this.myData.getProject(), this.myDefaultValue.myResourceItem, defaultValue2);
        if (!changed) {
            return false;
        }
        if (defaultValue2.isEmpty()) {
            this.myDefaultValue = new ResourceItemEntry();
            return true;
        }
        ResourceItem item = this.myData.getRepository().getDefaultValue(this.myKey);
        assert (item != null);
        this.myDefaultValue = new ResourceItemEntry(item, this.myData.getUnescaper());
        return true;
    }

    @Nullable
    private ResourceItem createDefaultValue(@NotNull String value2) {
        if (value2 == null) {
            StringResource.$$$reportNull$$$0(6);
        }
        if (value2.isEmpty()) {
            return null;
        }
        Project project = this.myData.getProject();
        XmlFile file2 = StringPsiUtils.getDefaultStringResourceFile(project, this.myKey);
        if (file2 == null) {
            return null;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, null, null, () -> StringPsiUtils.addString(file2, this.myKey, this.myTranslatable, value2), (PsiFile[])new PsiFile[0]);
        return this.myData.getRepository().getDefaultValue(this.myKey);
    }

    @Nullable
    public String validateDefaultValue() {
        if (this.myDefaultValue.myResourceItem == null) {
            return "Key \"" + this.myKey.getName() + "\" is missing its default value";
        }
        if (!this.myDefaultValue.myStringValid) {
            return "Invalid XML";
        }
        return null;
    }

    public boolean isTranslatable() {
        return this.myTranslatable;
    }

    public void setTranslatable(boolean translatable) {
        this.myTranslatable = translatable;
    }

    @Nullable
    ResourceItem getTranslationAsResourceItem(@NotNull Locale locale) {
        ResourceItemEntry resourceItemEntry;
        if (locale == null) {
            StringResource.$$$reportNull$$$0(7);
        }
        return (resourceItemEntry = this.myLocaleToTranslationMap.get(locale)) == null ? null : resourceItemEntry.myResourceItem;
    }

    @NotNull
    public String getTranslationAsString(@NotNull Locale locale) {
        ResourceItemEntry resourceItemEntry;
        if (locale == null) {
            StringResource.$$$reportNull$$$0(8);
        }
        String string = (resourceItemEntry = this.myLocaleToTranslationMap.get(locale)) == null ? "" : resourceItemEntry.myString;
        if (string == null) {
            StringResource.$$$reportNull$$$0(9);
        }
        return string;
    }

    public boolean putTranslation(@NotNull Locale locale, @NotNull String translation) {
        if (locale == null) {
            StringResource.$$$reportNull$$$0(10);
        }
        if (translation == null) {
            StringResource.$$$reportNull$$$0(11);
        }
        if (this.getTranslationAsResourceItem(locale) == null) {
            ResourceItem item = this.createTranslation(locale, translation);
            if (item == null) {
                return false;
            }
            this.myLocaleToTranslationMap.put(locale, new ResourceItemEntry(item, this.myData.getUnescaper()));
            return true;
        }
        if (this.getTranslationAsString(locale).equals(translation)) {
            return false;
        }
        ResourceItem item = this.getTranslationAsResourceItem(locale);
        assert (item != null);
        boolean changed = StringsWriteUtils.setItemText(this.myData.getProject(), item, translation);
        if (!changed) {
            return false;
        }
        if (translation.isEmpty()) {
            this.myLocaleToTranslationMap.remove(locale);
            return true;
        }
        item = this.myData.getRepository().getTranslation(this.myKey, locale);
        assert (item != null);
        this.myLocaleToTranslationMap.put(locale, new ResourceItemEntry(item, this.myData.getUnescaper()));
        return true;
    }

    @Nullable
    private ResourceItem createTranslation(@NotNull Locale locale, @NotNull String value2) {
        if (locale == null) {
            StringResource.$$$reportNull$$$0(12);
        }
        if (value2 == null) {
            StringResource.$$$reportNull$$$0(13);
        }
        if (value2.isEmpty()) {
            return null;
        }
        Project project = this.myData.getProject();
        XmlFile file2 = StringPsiUtils.getStringResourceFile(project, this.myKey, locale);
        if (file2 == null) {
            return null;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, null, null, () -> StringPsiUtils.addString(file2, this.myKey, this.myTranslatable, value2), (PsiFile[])new PsiFile[0]);
        return this.myData.getRepository().getTranslation(this.myKey, locale);
    }

    @Nullable
    public String validateTranslation(@NotNull Locale locale) {
        ResourceItemEntry entry;
        if (locale == null) {
            StringResource.$$$reportNull$$$0(14);
        }
        if ((entry = this.myLocaleToTranslationMap.get(locale)) != null && !entry.myStringValid) {
            return "Invalid XML";
        }
        if (this.myTranslatable && this.isTranslationMissing(locale)) {
            return "Key \"" + this.myKey.getName() + "\" is missing its " + LocaleMenuAction.getLocaleLabel(locale, false) + " translation";
        }
        if (!this.myTranslatable && !this.isTranslationMissing(locale)) {
            return "Key \"" + this.myKey.getName() + "\" is untranslatable and should not be translated to " + LocaleMenuAction.getLocaleLabel(locale, false);
        }
        return null;
    }

    @NotNull
    Collection<Locale> getTranslatedLocales() {
        Set<Locale> set = this.myLocaleToTranslationMap.keySet();
        if (set == null) {
            StringResource.$$$reportNull$$$0(15);
        }
        return set;
    }

    boolean isTranslationMissing(@NotNull Locale locale) {
        ResourceItemEntry item;
        if (locale == null) {
            StringResource.$$$reportNull$$$0(16);
        }
        if (StringResource.isTranslationMissing(item = this.myLocaleToTranslationMap.get(locale)) && locale.hasRegion()) {
            String language = locale.qualifier.getLanguage();
            assert (language != null);
            locale = Locale.create(language);
            item = this.myLocaleToTranslationMap.get(locale);
        }
        return StringResource.isTranslationMissing(item);
    }

    private static boolean isTranslationMissing(@Nullable ResourceItemEntry item) {
        return item == null || item.myString.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/StringResource";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "translation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/StringResource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceFolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueAsString";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTranslationAsString";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTranslatedLocales";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTranslationAsResourceItem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTranslationAsString";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "putTranslation";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTranslation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "validateTranslation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isTranslationMissing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ResourceItemEntry {
        @Nullable
        private final ResourceItem myResourceItem;
        @NotNull
        private final String myString;
        private final boolean myStringValid;

        private ResourceItemEntry() {
            this.myResourceItem = null;
            this.myString = "";
            this.myStringValid = true;
        }

        private ResourceItemEntry(@NotNull ResourceItem resourceItem, @NotNull StringResourceUnescaper unescaper) {
            boolean stringValid;
            if (resourceItem == null) {
                ResourceItemEntry.$$$reportNull$$$0(0);
            }
            if (unescaper == null) {
                ResourceItemEntry.$$$reportNull$$$0(1);
            }
            this.myResourceItem = resourceItem;
            ResourceValue value2 = resourceItem.getResourceValue();
            if (value2 == null) {
                this.myString = "";
                this.myStringValid = true;
                return;
            }
            String string = value2.getRawXmlValue();
            assert (string != null);
            try {
                string = unescaper.unescapeCharacterData(string);
                stringValid = true;
            }
            catch (IllegalArgumentException exception) {
                stringValid = false;
            }
            this.myString = string;
            this.myStringValid = stringValid;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resourceItem";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "unescaper";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/editors/strings/StringResource$ResourceItemEntry";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

