/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.editors.strings.table.NeedsTranslationForLocaleRowFilter;
import com.android.tools.idea.editors.strings.table.NeedsTranslationsRowFilter;
import com.android.tools.idea.editors.strings.table.StringResourceTable;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.editors.strings.table.StringResourceTableRowFilter;
import com.android.tools.idea.editors.strings.table.TextRowFilter;
import com.android.tools.idea.editors.strings.table.TranslatableRowFilter;
import com.android.tools.idea.rendering.Locale;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.ui.DialogBuilder;
import java.util.stream.IntStream;
import javax.swing.JComponent;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class FilterKeysAction
extends ComboBoxAction {
    private final StringResourceTable myTable;

    FilterKeysAction(@NotNull StringResourceTable table2) {
        if (table2 == null) {
            FilterKeysAction.$$$reportNull$$$0(0);
        }
        this.myTable = table2;
    }

    public void update(@NotNull AnActionEvent event) {
        StringResourceTableRowFilter filter2;
        if (event == null) {
            FilterKeysAction.$$$reportNull$$$0(1);
        }
        if ((filter2 = this.myTable.getRowFilter()) == null) {
            Presentation presentation = event.getPresentation();
            presentation.setIcon(null);
            presentation.setText("Show All Keys");
        } else {
            filter2.update(event.getPresentation());
        }
    }

    @NotNull
    protected DefaultActionGroup createPopupActionGroup(@Nullable JComponent button2) {
        DefaultActionGroup group2 = new DefaultActionGroup();
        group2.add(new AnAction("Show All Keys"){

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                FilterKeysAction.this.myTable.setRowFilter(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/strings/FilterKeysAction$1", "actionPerformed"));
            }
        });
        group2.add(new AnAction("Show Translatable Keys"){

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                FilterKeysAction.this.myTable.setRowFilter(new TranslatableRowFilter());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/strings/FilterKeysAction$2", "actionPerformed"));
            }
        });
        group2.add(new AnAction("Show Keys Needing Translations"){

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                FilterKeysAction.this.myTable.setRowFilter(new NeedsTranslationsRowFilter());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/strings/FilterKeysAction$3", "actionPerformed"));
            }
        });
        group2.add(new AnAction("Filter by Text", "Filter the translations editor table keys by text", AllIcons.General.Filter){

            public void actionPerformed(@NotNull AnActionEvent e) {
                String filterString;
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                JTextField textField = new JTextField();
                DialogBuilder builder2 = new DialogBuilder();
                builder2.setTitle("Filter by Text");
                builder2.setCenterPanel((JComponent)textField);
                builder2.setPreferredFocusComponent((JComponent)textField);
                if (builder2.showAndGet() && !(filterString = textField.getText()).isEmpty()) {
                    FilterKeysAction.this.myTable.setRowFilter(new TextRowFilter(filterString));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/strings/FilterKeysAction$4", "actionPerformed"));
            }
        });
        StringResourceTableModel model2 = (StringResourceTableModel)this.myTable.getModel();
        IntStream.range(4, model2.getColumnCount()).mapToObj(model2::getLocale).map(this::newShowKeysNeedingTranslationForLocaleAction).forEach(arg_0 -> ((DefaultActionGroup)group2).add(arg_0));
        DefaultActionGroup defaultActionGroup = group2;
        if (defaultActionGroup == null) {
            FilterKeysAction.$$$reportNull$$$0(2);
        }
        return defaultActionGroup;
    }

    @NotNull
    private AnAction newShowKeysNeedingTranslationForLocaleAction(final @NotNull Locale locale) {
        if (locale == null) {
            FilterKeysAction.$$$reportNull$$$0(3);
        }
        String text2 = "Show Keys Needing a Translation for " + LocaleMenuAction.getLocaleLabel(locale, false);
        return new AnAction(text2, null, locale.getFlagImage()){

            public void actionPerformed(@NotNull AnActionEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                FilterKeysAction.this.myTable.setRowFilter(new NeedsTranslationForLocaleRowFilter(locale));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/editors/strings/FilterKeysAction$5", "actionPerformed"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/FilterKeysAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/FilterKeysAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopupActionGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "newShowKeysNeedingTranslationForLocaleAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

