/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.strings;

import com.android.ide.common.resources.LocaleManager;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.tools.idea.editors.strings.LocaleList;
import com.android.tools.idea.editors.strings.StringPsiUtils;
import com.android.tools.idea.editors.strings.StringResource;
import com.android.tools.idea.editors.strings.StringResourceData;
import com.android.tools.idea.editors.strings.StringResourceKey;
import com.android.tools.idea.editors.strings.StringResourceViewPanel;
import com.android.tools.idea.editors.strings.table.StringResourceTableModel;
import com.android.tools.idea.rendering.Locale;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlFile;
import icons.StudioIcons;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JList;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;

final class AddLocaleAction
extends AnAction {
    private final StringResourceViewPanel myPanel;

    AddLocaleAction(@NotNull StringResourceViewPanel panel2) {
        if (panel2 == null) {
            AddLocaleAction.$$$reportNull$$$0(0);
        }
        super("Add Locale", null, StudioIcons.LayoutEditor.Toolbar.ADD_LOCALE);
        this.myPanel = panel2;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            AddLocaleAction.$$$reportNull$$$0(1);
        }
        long count = ((StringResourceTableModel)this.myPanel.getTable().getModel()).getKeys().stream().filter(key -> key.getDirectory() != null).count();
        event.getPresentation().setEnabled(count != 0L);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            AddLocaleAction.$$$reportNull$$$0(2);
        }
        StringResourceData data = this.myPanel.getTable().getData();
        assert (data != null);
        LocaleList list = new LocaleList(AddLocaleAction.getLocales(data.getLocaleSet()));
        JBPopup popup2 = JBPopupFactory.getInstance().createListPopupBuilder((JList)((Object)list)).setItemChoosenCallback(() -> this.lambda$actionPerformed$1((JList)((Object)list))).createPopup();
        popup2.showUnderneathOf(event.getInputEvent().getComponent());
    }

    @NotNull
    @VisibleForTesting
    static Collection<Locale> getLocales(@NotNull Collection<Locale> localesToRemove) {
        if (localesToRemove == null) {
            AddLocaleAction.$$$reportNull$$$0(3);
        }
        Collection collection2 = LocaleManager.getLanguageCodes((boolean)true).stream().flatMap(AddLocaleAction::getLocales).filter(locale -> !localesToRemove.contains(locale)).sorted(Locale.LANGUAGE_NAME_COMPARATOR).collect(Collectors.toList());
        if (collection2 == null) {
            AddLocaleAction.$$$reportNull$$$0(4);
        }
        return collection2;
    }

    @NotNull
    private static Stream<Locale> getLocales(@NotNull String language) {
        if (language == null) {
            AddLocaleAction.$$$reportNull$$$0(5);
        }
        Stream<Locale> regionStream = LocaleManager.getRelevantRegions((String)language).stream().map(region -> Locale.create(new LocaleQualifier(null, language, region, null)));
        Stream<Locale> stream = Stream.concat(Stream.of(AddLocaleAction.createLocale(language)), regionStream);
        if (stream == null) {
            AddLocaleAction.$$$reportNull$$$0(6);
        }
        return stream;
    }

    @NotNull
    private static Locale createLocale(@NotNull String language) {
        if (language == null) {
            AddLocaleAction.$$$reportNull$$$0(7);
        }
        Object full = language.length() == 2 ? language : "b+" + language;
        Locale locale = Locale.create(new LocaleQualifier((String)full, language, null, null));
        if (locale == null) {
            AddLocaleAction.$$$reportNull$$$0(8);
        }
        return locale;
    }

    @VisibleForTesting
    void createItem(@NotNull Locale locale) {
        StringResource resource;
        StringResourceKey key;
        Project project;
        XmlFile file2;
        if (locale == null) {
            AddLocaleAction.$$$reportNull$$$0(9);
        }
        if ((file2 = StringPsiUtils.getStringResourceFile(project = this.myPanel.getFacet().getModule().getProject(), key = (resource = this.findResource()).getKey(), locale)) == null) {
            return;
        }
        WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            StringPsiUtils.addString(file2, key, resource.getDefaultValueAsString());
            this.myPanel.reloadData();
        });
    }

    @NotNull
    private StringResource findResource() {
        StringResourceKey key;
        StringResourceData data = this.myPanel.getTable().getData();
        assert (data != null);
        List<VirtualFile> folders = ResourceFolderManager.getInstance(this.myPanel.getFacet()).getFolders();
        if (!folders.isEmpty() && data.containsKey(key = new StringResourceKey("app_name", folders.get(0)))) {
            StringResource stringResource = data.getStringResource(key);
            if (stringResource == null) {
                AddLocaleAction.$$$reportNull$$$0(10);
            }
            return stringResource;
        }
        Optional<StringResource> optionalResource = data.getResources().stream().filter(resource -> resource.getKey().getDirectory() != null).findFirst();
        StringResource stringResource = optionalResource.orElseThrow(IllegalStateException::new);
        if (stringResource == null) {
            AddLocaleAction.$$$reportNull$$$0(11);
        }
        return stringResource;
    }

    private /* synthetic */ void lambda$actionPerformed$1(JList list) {
        this.createItem((Locale)list.getSelectedValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localesToRemove";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/strings/AddLocaleAction";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/strings/AddLocaleAction";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocales";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocale";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findResource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLocales";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLocale";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

