/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.manifest;

import com.android.tools.idea.editors.manifest.ManifestPanel;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.utils.concurrency.AsyncSupplier;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.BorderLayout;
import java.beans.PropertyChangeListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ManifestEditor
extends UserDataHolderBase
implements FileEditor {
    private volatile boolean showingStaleManifest;
    private volatile boolean failedToComputeFreshManifest;
    private final AndroidFacet myFacet;
    private JPanel myLazyContainer;
    private ManifestPanel myManifestPanel;
    private final VirtualFile mySelectedFile;
    private boolean mySelected;
    private final PsiTreeChangeListener myPsiChangeListener;

    ManifestEditor(@NotNull AndroidFacet facet2, @NotNull VirtualFile manifestFile) {
        if (facet2 == null) {
            ManifestEditor.$$$reportNull$$$0(0);
        }
        if (manifestFile == null) {
            ManifestEditor.$$$reportNull$$$0(1);
        }
        this.myPsiChangeListener = new PsiTreeChangeAdapter(){

            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                ManifestEditor.this.psiChange(event);
            }

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                ManifestEditor.this.psiChange(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                ManifestEditor.this.psiChange(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(3);
                }
                ManifestEditor.this.psiChange(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(4);
                }
                ManifestEditor.this.psiChange(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(5);
                }
                ManifestEditor.this.psiChange(event);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/android/tools/idea/editors/manifest/ManifestEditor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childAdded";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childRemoved";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childReplaced";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childMoved";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "childrenChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myFacet = facet2;
        this.mySelectedFile = manifestFile;
        this.myLazyContainer = new JPanel(new BorderLayout());
    }

    private void psiChange(PsiTreeChangeEvent event) {
        PsiFile file2 = event.getFile();
        if (file2 != null && "AndroidManifest.xml".equals(file2.getName())) {
            ApplicationManager.getApplication().invokeLater(this::reload);
        }
    }

    private void reload() {
        if (!this.mySelected) {
            return;
        }
        AsyncSupplier<MergedManifestSnapshot> supplier2 = MergedManifestManager.getMergedManifestSupplier(this.myFacet.getModule());
        ListenableFuture mergedManifest = supplier2.get();
        if (mergedManifest.isDone()) {
            try {
                this.showFreshManifest((MergedManifestSnapshot)mergedManifest.get());
            }
            catch (InterruptedException | ExecutionException e) {
                Logger.getInstance(ManifestEditor.class).warn("Error computing fresh merged manifest for module " + this.myFacet.getModule().getName(), (Throwable)e);
                this.showLoadingError();
            }
            return;
        }
        MergedManifestSnapshot cachedManifest = (MergedManifestSnapshot)supplier2.getNow();
        if (cachedManifest != null) {
            this.showStaleManifest(cachedManifest);
        } else {
            this.myManifestPanel.startLoading();
        }
        Futures.addCallback((ListenableFuture)mergedManifest, (FutureCallback)new FutureCallback<MergedManifestSnapshot>(){

            public void onSuccess(MergedManifestSnapshot result2) {
                ManifestEditor.this.showFreshManifest(result2);
            }

            public void onFailure(@Nullable Throwable t) {
                Logger.getInstance(ManifestEditor.class).warn("Error computing fresh merged manifest for module " + ManifestEditor.this.myFacet.getModule().getName(), t);
                ManifestEditor.this.showLoadingError();
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    private void showStaleManifest(MergedManifestSnapshot manifest) {
        this.showingStaleManifest = true;
        this.myManifestPanel.showManifest(manifest, this.mySelectedFile, false);
        EditorNotifications.getInstance((Project)this.myFacet.getModule().getProject()).updateNotifications(this.mySelectedFile);
    }

    private void showFreshManifest(MergedManifestSnapshot manifest) {
        if (this.showingStaleManifest || this.failedToComputeFreshManifest) {
            this.showingStaleManifest = false;
            this.failedToComputeFreshManifest = false;
            EditorNotifications.getInstance((Project)this.myFacet.getModule().getProject()).updateNotifications(this.mySelectedFile);
        }
        this.myManifestPanel.showManifest(manifest, this.mySelectedFile, true);
    }

    private void showLoadingError() {
        this.failedToComputeFreshManifest = true;
        if (this.showingStaleManifest) {
            EditorNotifications.getInstance((Project)this.myFacet.getModule().getProject()).updateNotifications(this.mySelectedFile);
        } else {
            this.myManifestPanel.showLoadingError();
        }
    }

    public boolean isShowingStaleManifest() {
        return this.showingStaleManifest;
    }

    public boolean failedToComputeFreshManifest() {
        return this.failedToComputeFreshManifest;
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myLazyContainer;
        if (jPanel == null) {
            ManifestEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    @NotNull
    public String getName() {
        return "Merged Manifest";
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            ManifestEditor.$$$reportNull$$$0(3);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        this.mySelected = true;
        Project project = this.myFacet.getModule().getProject();
        if (this.myManifestPanel == null) {
            this.myManifestPanel = new ManifestPanel(this.myFacet, (Disposable)this);
            this.myLazyContainer.add(this.myManifestPanel);
            project.getMessageBus().connect((Disposable)this).subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, result2 -> {
                if (result2.isSuccessful()) {
                    this.reload();
                }
            });
        }
        PsiManager.getInstance((Project)project).addPsiTreeChangeListener(this.myPsiChangeListener);
        this.reload();
    }

    public void deselectNotify() {
        this.mySelected = false;
        Project thisProject = this.myFacet.getModule().getProject();
        PsiManager.getInstance((Project)thisProject).removePsiTreeChangeListener(this.myPsiChangeListener);
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            ManifestEditor.$$$reportNull$$$0(4);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            ManifestEditor.$$$reportNull$$$0(5);
        }
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manifestFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/manifest/ManifestEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/manifest/ManifestEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

