/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.ui;

import com.android.layoutinspector.model.ViewNode;
import com.android.tools.adtui.workbench.ToolContent;
import com.android.tools.idea.editors.layoutInspector.LayoutInspectorContext;
import com.android.tools.idea.editors.layoutInspector.ui.RollOverTree;
import com.android.tools.idea.editors.layoutInspector.ui.ViewNodeTreeRenderer;
import com.android.tools.idea.observable.InvalidationListener;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;

public class LayoutTreePanel
extends JPanel
implements ToolContent<LayoutInspectorContext>,
InvalidationListener {
    @NotNull
    private final JScrollPane myTreePanel;
    private RollOverTree myTree;
    private ViewNodeTreeRenderer myTreeCellRenderer;
    private JPanel myBackPanel;
    private JLabel myBackLabel;
    private LayoutInspectorContext myContext;

    public LayoutTreePanel(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            LayoutTreePanel.$$$reportNull$$$0(0);
        }
        this.setLayout(new BorderLayout());
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myTreePanel = new JBScrollPane();
        this.myTreePanel.setBackground((Color)JBColor.WHITE);
        this.add((Component)this.myTreePanel, "Center");
        this.add((Component)this.createBackPanel(), "North");
    }

    public void setToolContext(LayoutInspectorContext toolContext) {
        if (toolContext != null) {
            this.myContext = toolContext;
            this.myContext.getSubviewList().addListener(this);
            this.setBackground((Color)JBColor.WHITE);
            this.myTree = toolContext.getNodeTree();
            if (this.myTree == null) {
                return;
            }
            this.myTreeCellRenderer = (ViewNodeTreeRenderer)((Object)this.myTree.getCellRenderer());
            this.myTreePanel.setViewportView((Component)((Object)this.myTree));
            this.myTreePanel.getViewport().setBackground((Color)JBColor.WHITE);
        }
    }

    @NotNull
    private JComponent createBackPanel() {
        this.myBackPanel = new JPanel(new BorderLayout());
        this.myBackLabel = new JLabel("Back", AllIcons.Actions.Back, 2);
        this.myBackLabel.setBorder(new EmptyBorder(8, 6, 8, 0));
        this.myBackPanel.setBackground((Color)JBColor.WHITE);
        this.myBackPanel.setVisible(false);
        this.myBackPanel.add((Component)this.myBackLabel, "West");
        this.myBackLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LayoutTreePanel.this.goBack();
            }
        });
        this.myBackPanel.add((Component)new JSeparator(), "South");
        JPanel jPanel = this.myBackPanel;
        if (jPanel == null) {
            LayoutTreePanel.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    private void goBack() {
        this.myContext.goBackSubView();
    }

    @NotNull
    public JComponent getComponent() {
        LayoutTreePanel layoutTreePanel = this;
        if (layoutTreePanel == null) {
            LayoutTreePanel.$$$reportNull$$$0(2);
        }
        return layoutTreePanel;
    }

    public boolean supportsFiltering() {
        return true;
    }

    public void setFilter(String filter2) {
        if (this.myTreeCellRenderer != null) {
            this.myTreeCellRenderer.setHighlight(filter2);
            this.myTree.repaint();
        }
    }

    public void dispose() {
        this.myContext.getSubviewList().removeListener(this);
    }

    @Override
    public void onInvalidated() {
        if (!this.myContext.getSubviewList().isEmpty()) {
            ViewNode parentNode = this.myContext.getSubviewList().get(this.myContext.getSubviewList().size() - 1);
            if (parentNode == null) {
                return;
            }
            this.myBackPanel.setVisible(true);
            String id = ViewNodeTreeRenderer.getId(parentNode);
            this.myBackLabel.setText(id != null ? id : ViewNodeTreeRenderer.getName(parentNode));
        } else {
            this.myBackPanel.setVisible(false);
        }
        this.myTree = this.myContext.getNodeTree();
        this.myTreePanel.setViewportView((Component)((Object)this.myTree));
    }

    @VisibleForTesting
    JPanel getBackPanel() {
        return this.myBackPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/layoutInspector/ui/LayoutTreePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/layoutInspector/ui/LayoutTreePanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createBackPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

