/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.layoutInspector.actions;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.editors.layoutInspector.ui.ViewNodeActiveDisplay;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutInspectorEvent;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.awt.Image;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u00012\u00020\u0002:\u0001\u0016B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/editors/layoutInspector/actions/LoadOverlayAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "myPreview", "Lcom/android/tools/idea/editors/layoutInspector/ui/ViewNodeActiveDisplay;", "(Lcom/android/tools/idea/editors/layoutInspector/ui/ViewNodeActiveDisplay;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "loadImageFile", "Ljava/awt/Image;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadOverlay", "update", "Companion", "intellij.android.android-layout-inspector"})
public final class LoadOverlayAction
extends AnAction
implements CustomComponentAction {
    private final ViewNodeActiveDisplay myPreview;
    @NotNull
    public static final String ACTION_ID = "Load Overlay";
    @JvmField
    @NotNull
    public static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        return (JComponent)new ActionButtonWithText((AnAction)this, presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        if (this.myPreview.hasOverlay()) {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setIcon(StudioIcons.LayoutInspector.CLEAR_OVERLAY);
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            presentation2.setText("Clear Overlay");
        } else {
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
            presentation.setIcon(StudioIcons.LayoutInspector.LOAD_OVERLAY);
            Presentation presentation3 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
            presentation3.setText(ACTION_ID);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.myPreview.hasOverlay()) {
            this.myPreview.setOverLay(null, null);
        } else {
            AndroidStudioEvent.Builder builder2 = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.LAYOUT_INSPECTOR_EVENT).setLayoutInspectorEvent(LayoutInspectorEvent.newBuilder().setType(LayoutInspectorEvent.LayoutInspectorEventType.OVERLAY_IMAGE));
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"AndroidStudioEvent.newBu\u2026Y_IMAGE)\n               )");
            UsageTracker.log((AndroidStudioEvent.Builder)builder2);
            this.loadOverlay(e);
        }
    }

    private final void loadOverlay(AnActionEvent e) {
        FileTypeDescriptor descriptor2 = new FileTypeDescriptor("Choose Overlay", new String[]{"svg", "png", "jpg"});
        FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser((FileChooserDescriptor)descriptor2, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDialog, (String)"FileChooserFactory.getIn\u2026r(descriptor, null, null)");
        FileChooserDialog fileChooserDialog2 = fileChooserDialog;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Object object = e.getProject();
        if (object == null || (object = object.getBasePath()) == null) {
            object = "/";
        }
        VirtualFile toSelect = localFileSystem.refreshAndFindFileByPath((String)object);
        VirtualFile[] virtualFileArray = new VirtualFile[1];
        VirtualFile virtualFile = toSelect;
        Intrinsics.checkNotNull((Object)virtualFile);
        virtualFileArray[0] = virtualFile;
        VirtualFile[] files2 = fileChooserDialog2.choose(null, virtualFileArray);
        Intrinsics.checkNotNullExpressionValue((Object)files2, (String)"files");
        VirtualFile[] virtualFileArray2 = files2;
        boolean bl = false;
        if (virtualFileArray2.length == 0) {
            return;
        }
        boolean bl2 = files2.length == 1;
        bl = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        VirtualFile virtualFile2 = files2[0];
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"files[0]");
        Image image = this.loadImageFile(virtualFile2);
        VirtualFile virtualFile3 = files2[0];
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"files[0]");
        this.myPreview.setOverLay(image, virtualFile3.getName());
    }

    private final Image loadImageFile(VirtualFile file2) {
        Image image;
        try {
            image = ImageIO.read(file2.getInputStream());
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)("Failed to read image from \"" + file2.getName() + "\" Error: " + e.getMessage()), (String)"Error");
            LOG.warn((Throwable)e);
            return null;
        }
        return image;
    }

    public LoadOverlayAction(@NotNull ViewNodeActiveDisplay myPreview) {
        Intrinsics.checkNotNullParameter((Object)myPreview, (String)"myPreview");
        super(ACTION_ID, "Overlay Image", StudioIcons.LayoutInspector.LOAD_OVERLAY);
        this.myPreview = myPreview;
    }

    static {
        Companion = new Companion(null);
        Logger logger2 = Logger.getInstance(LoadOverlayAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(LoadOverlayAction::class.java)");
        LOG = logger2;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/editors/layoutInspector/actions/LoadOverlayAction$Companion;", "", "()V", "ACTION_ID", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.android.android-layout-inspector"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

