/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.intellij.codeEditor.JavaEditorFileSwapper;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.ArrayList;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttachAndroidSdkSourcesNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"add sdk sources to class");
    private final Project myProject;

    public AttachAndroidSdkSourcesNotificationProvider(@NotNull Project project) {
        if (project == null) {
            AttachAndroidSdkSourcesNotificationProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            AttachAndroidSdkSourcesNotificationProvider.$$$reportNull$$$0(1);
        }
        return key;
    }

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        if (file2 == null) {
            AttachAndroidSdkSourcesNotificationProvider.$$$reportNull$$$0(2);
        }
        if (fileEditor == null) {
            AttachAndroidSdkSourcesNotificationProvider.$$$reportNull$$$0(3);
        }
        if (file2.getFileType() != JavaClassFileType.INSTANCE) {
            return null;
        }
        if (JavaEditorFileSwapper.findSourceFile((Project)this.myProject, (VirtualFile)file2) == null) {
            JdkOrderEntry jdkOrderEntry = this.findAndroidSdkEntryForFile(file2);
            if (jdkOrderEntry == null) {
                return null;
            }
            Sdk sdk = jdkOrderEntry.getJdk();
            if (sdk == null) {
                return null;
            }
            String sdkHome = sdk.getHomePath();
            if (sdkHome == null) {
                return null;
            }
            if (sdk.getRootProvider().getFiles(OrderRootType.SOURCES).length > 0) {
                return null;
            }
            AndroidPlatform platform = AndroidPlatform.getInstance(sdk);
            if (platform == null) {
                return null;
            }
            EditorNotificationPanel panel2 = new EditorNotificationPanel(fileEditor);
            panel2.setText("Sources for '" + jdkOrderEntry.getJdkName() + "' not found.");
            panel2.createActionLabel("Download", () -> {
                ArrayList<String> requested = new ArrayList<String>();
                requested.add(DetailsTypes.getSourcesPath((AndroidVersion)platform.getApiVersion()));
                ModelWizardDialog dialog2 = SdkQuickfixUtils.createDialogForPaths(this.myProject, requested);
                if (dialog2 != null && dialog2.showAndGet()) {
                    AndroidSdkUtils.updateSdkSourceRoot(sdk);
                }
            });
            panel2.createActionLabel("Refresh (if already downloaded)", () -> AndroidSdkUtils.updateSdkSourceRoot(sdk));
            return panel2;
        }
        return null;
    }

    @Nullable
    private JdkOrderEntry findAndroidSdkEntryForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            AttachAndroidSdkSourcesNotificationProvider.$$$reportNull$$$0(4);
        }
        ProjectFileIndex index2 = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        for (OrderEntry entry : index2.getOrderEntriesForFile(file2)) {
            JdkOrderEntry jdkOrderEntry;
            Sdk jdk;
            if (!(entry instanceof JdkOrderEntry) || (jdk = (jdkOrderEntry = (JdkOrderEntry)entry).getJdk()) == null || !AndroidSdks.getInstance().isAndroidSdk(jdk)) continue;
            return jdkOrderEntry;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/editors/AttachAndroidSdkSourcesNotificationProvider";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/editors/AttachAndroidSdkSourcesNotificationProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAndroidSdkEntryForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

