/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.windows;

import com.android.tools.idea.diagnostics.windows.VirusCheckerStatusProvider;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class WindowsDefenderRegistryStatusProvider
implements VirusCheckerStatusProvider {
    public static final String LOCAL_EXCLUDED_PATHS_KEY = "SOFTWARE\\Microsoft\\Windows Defender\\Exclusions\\Paths";
    public static final String POLICY_EXCLUDED_PATHS_KEY = "SOFTWARE\\Policies\\Microsoft\\Windows Defender\\exclusions\\paths";
    public static final String POLICY_SCANNING_STATUS_KEY = "SOFTWARE\\Policies\\Microsoft\\Windows Defender\\Real-Time Protection";
    public static final String LOCAL_SCANNING_STATUS_KEY = "SOFTWARE\\Microsoft\\Windows Defender\\Real-Time Protection";
    public static final String DISABLE_MONITORING_VALUE_NAME = "DisableRealtimeMonitoring";

    @Override
    @NotNull
    public List<String> getExcludedPaths() throws IOException {
        ArrayList<String> excludedPaths = new ArrayList<String>();
        excludedPaths.addAll(WindowsDefenderRegistryStatusProvider.readExcludedPaths(LOCAL_EXCLUDED_PATHS_KEY));
        excludedPaths.addAll(WindowsDefenderRegistryStatusProvider.readExcludedPaths(POLICY_EXCLUDED_PATHS_KEY));
        ArrayList<String> arrayList = excludedPaths;
        if (arrayList == null) {
            WindowsDefenderRegistryStatusProvider.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    @NotNull
    private static Collection<String> readExcludedPaths(@NotNull String key) throws IOException {
        if (key == null) {
            WindowsDefenderRegistryStatusProvider.$$$reportNull$$$0(1);
        }
        try {
            return new HashSet<String>(Advapi32Util.registryGetValues((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key).keySet());
        }
        catch (Win32Exception exception) {
            if (exception.getErrorCode() != 2) {
                throw new IOException("Error code " + exception.getErrorCode() + ": " + exception.getMessage(), exception);
            }
            return new HashSet<String>();
        }
    }

    @Override
    @NotNull
    public VirusCheckerStatusProvider.RealtimeScanningStatus getRealtimeScanningStatus() throws IOException {
        Optional<Boolean> isMonitoringDisabled = WindowsDefenderRegistryStatusProvider.readMonitoringDisabled(POLICY_SCANNING_STATUS_KEY);
        if (!isMonitoringDisabled.isPresent()) {
            isMonitoringDisabled = WindowsDefenderRegistryStatusProvider.readMonitoringDisabled(LOCAL_SCANNING_STATUS_KEY);
        }
        VirusCheckerStatusProvider.RealtimeScanningStatus realtimeScanningStatus = isMonitoringDisabled.orElse(false) != false ? VirusCheckerStatusProvider.RealtimeScanningStatus.SCANNING_DISABLED : VirusCheckerStatusProvider.RealtimeScanningStatus.SCANNING_ENABLED;
        if (realtimeScanningStatus == null) {
            WindowsDefenderRegistryStatusProvider.$$$reportNull$$$0(2);
        }
        return realtimeScanningStatus;
    }

    @NotNull
    private static Optional<Boolean> readMonitoringDisabled(@NotNull String key) throws IOException {
        block8: {
            Optional<Boolean> optional2;
            if (key == null) {
                WindowsDefenderRegistryStatusProvider.$$$reportNull$$$0(3);
            }
            try {
                boolean policyValueExists = Advapi32Util.registryValueExists((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key, (String)DISABLE_MONITORING_VALUE_NAME);
                if (!policyValueExists) break block8;
                int policyDisableRealtimeValue = Advapi32Util.registryGetIntValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)key, (String)DISABLE_MONITORING_VALUE_NAME);
                optional2 = Optional.of(policyDisableRealtimeValue != 0);
            }
            catch (Win32Exception exception) {
                if (exception.getErrorCode() != 2) {
                    throw new IOException("Error code " + exception.getErrorCode() + ": " + exception.getMessage(), exception);
                }
                Optional<Boolean> optional3 = Optional.empty();
                if (optional3 == null) {
                    WindowsDefenderRegistryStatusProvider.$$$reportNull$$$0(6);
                }
                return optional3;
            }
            if (optional2 == null) {
                WindowsDefenderRegistryStatusProvider.$$$reportNull$$$0(4);
            }
            return optional2;
        }
        Optional<Boolean> optional4 = Optional.empty();
        if (optional4 == null) {
            WindowsDefenderRegistryStatusProvider.$$$reportNull$$$0(5);
        }
        return optional4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/diagnostics/windows/WindowsDefenderRegistryStatusProvider";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedPaths";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/diagnostics/windows/WindowsDefenderRegistryStatusProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealtimeScanningStatus";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readMonitoringDisabled";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readExcludedPaths";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readMonitoringDisabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

