/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.diagnostics.hprof.analysis;

import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisConfig;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalysisContext;
import com.android.tools.idea.diagnostics.hprof.analysis.AnalyzeGraph;
import com.android.tools.idea.diagnostics.hprof.analysis.ClassNomination;
import com.android.tools.idea.diagnostics.hprof.classstore.HProfMetadata;
import com.android.tools.idea.diagnostics.hprof.histogram.Histogram;
import com.android.tools.idea.diagnostics.hprof.histogram.HistogramEntry;
import com.android.tools.idea.diagnostics.hprof.navigator.ObjectNavigator;
import com.android.tools.idea.diagnostics.hprof.parser.HProfEventBasedParser;
import com.android.tools.idea.diagnostics.hprof.util.FileBackedIntList;
import com.android.tools.idea.diagnostics.hprof.util.FileBackedUByteList;
import com.android.tools.idea.diagnostics.hprof.util.HeapReportUtils;
import com.android.tools.idea.diagnostics.hprof.util.IntList;
import com.android.tools.idea.diagnostics.hprof.util.PartialProgressIndicator;
import com.android.tools.idea.diagnostics.hprof.util.UByteList;
import com.android.tools.idea.diagnostics.hprof.visitors.RemapIDsVisitor;
import com.google.common.base.Stopwatch;
import com.intellij.openapi.progress.ProgressIndicator;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0019\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis;", "", "hprofFileChannel", "Ljava/nio/channels/FileChannel;", "tempFilenameSupplier", "Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$TempFilenameSupplier;", "(Ljava/nio/channels/FileChannel;Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$TempFilenameSupplier;)V", "includeMetaInfo", "", "tempFiles", "", "Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$TempFile;", "analyze", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "closeAndDeleteTemporaryFiles", "", "isSupported", "instanceCount", "", "openTempEmptyFileChannel", "type", "setIncludeMetaInfo", "value", "TempFile", "TempFilenameSupplier", "intellij.android.core"})
public final class HProfAnalysis {
    private final List<TempFile> tempFiles;
    private boolean includeMetaInfo;
    private final FileChannel hprofFileChannel;
    private final TempFilenameSupplier tempFilenameSupplier;

    @TestOnly
    public final void setIncludeMetaInfo(boolean value2) {
        this.includeMetaInfo = value2;
    }

    private final FileChannel openTempEmptyFileChannel(String type) {
        FileChannel tempChannel;
        Path tempPath = this.tempFilenameSupplier.getTempFilePath(type);
        FileChannel fileChannel = tempChannel = FileChannel.open(tempPath, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.DELETE_ON_CLOSE);
        Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"tempChannel");
        this.tempFiles.add(new TempFile(type, tempPath, fileChannel));
        return tempChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final String analyze(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        StringBuilder result2 = new StringBuilder();
        Stopwatch totalStopwatch = Stopwatch.createStarted();
        Stopwatch prepareFilesStopwatch = Stopwatch.createStarted();
        Stopwatch analysisStopwatch = Stopwatch.createUnstarted();
        progress.setText("Analyze Heap");
        progress.setText2("Open heap file");
        progress.setFraction(0.0);
        HProfEventBasedParser parser = new HProfEventBasedParser(this.hprofFileChannel);
        try {
            void $this$mapTo$iv$iv;
            progress.setText2("Collect heap metadata");
            progress.setFraction(0.0);
            HProfMetadata hprofMetadata = HProfMetadata.Companion.create(parser);
            progress.setText2("Create histogram");
            progress.setFraction(0.1);
            Histogram histogram2 = Histogram.Companion.create(parser, hprofMetadata.getClassStore());
            List<HistogramEntry> nominatedClasses = new ClassNomination(histogram2, 5).nominateClasses();
            progress.setText2("Remap object IDs");
            progress.setFraction(0.2);
            if (!this.isSupported(histogram2.getInstanceCount())) {
                CharSequence charSequence = result2;
                String string = histogram2.prepareReport("All", 50);
                boolean bl = false;
                StringBuilder stringBuilder = charSequence.append(string);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder);
                String string2 = result2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"result.toString()");
                charSequence = string2;
                return charSequence;
            }
            FileChannel idMappingChannel = this.openTempEmptyFileChannel("id-mapping");
            RemapIDsVisitor remapIDsVisitor = RemapIDsVisitor.Companion.createFileBased(idMappingChannel, histogram2.getInstanceCount());
            parser.accept(remapIDsVisitor, "id mapping");
            parser.setIdRemappingFunction(remapIDsVisitor.getRemappingFunction());
            hprofMetadata.remapIds(remapIDsVisitor.getRemappingFunction());
            progress.setText2("Create reference graph");
            progress.setFraction(0.3);
            ObjectNavigator navigator = ObjectNavigator.Companion.createOnAuxiliaryFiles(parser, this.openTempEmptyFileChannel("auxOffset"), this.openTempEmptyFileChannel("aux"), hprofMetadata, histogram2.getInstanceCount());
            prepareFilesStopwatch.stop();
            IntList parentList = FileBackedIntList.Companion.createEmpty(this.openTempEmptyFileChannel("parents"), navigator.getInstanceCount() + 1L);
            IntList sizesList = FileBackedIntList.Companion.createEmpty(this.openTempEmptyFileChannel("sizes"), navigator.getInstanceCount() + 1L);
            IntList visitedList = FileBackedIntList.Companion.createEmpty(this.openTempEmptyFileChannel("visited"), navigator.getInstanceCount() + 1L);
            UByteList refIndexList = FileBackedUByteList.Companion.createEmpty(this.openTempEmptyFileChannel("refIndex"), navigator.getInstanceCount() + 1L);
            analysisStopwatch.start();
            Iterable $this$map$iv = nominatedClasses;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                HistogramEntry histogramEntry = (HistogramEntry)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                String string = it.getClassDefinition().getName();
                collection2.add(string);
            }
            List nominatedClassNames = (List)destination$iv$iv;
            AnalysisConfig analysisConfig = new AnalysisConfig(new AnalysisConfig.PerClassOptions(nominatedClassNames, false, null, 6, null), null, null, null, new AnalysisConfig.MetaInfoOptions(this.includeMetaInfo), 14, null);
            AnalysisContext analysisContext = new AnalysisContext(navigator, analysisConfig, parentList, sizesList, visitedList, refIndexList, histogram2);
            String analysisReport = new AnalyzeGraph(analysisContext).analyze((ProgressIndicator)new PartialProgressIndicator(progress, 0.4, 0.4));
            destination$iv$iv = result2;
            $i$f$mapTo2 = false;
            StringBuilder stringBuilder = ((StringBuilder)destination$iv$iv).append(analysisReport);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(value)");
            StringsKt.appendln((StringBuilder)stringBuilder);
            analysisStopwatch.stop();
            if (this.includeMetaInfo) {
                destination$iv$iv = result2;
                String $i$f$mapTo2 = HeapReportUtils.INSTANCE.sectionHeader("Analysis information");
                boolean bl = false;
                StringBuilder stringBuilder2 = ((StringBuilder)destination$iv$iv).append($i$f$mapTo2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder2);
                destination$iv$iv = result2;
                $i$f$mapTo2 = "Prepare files duration: " + prepareFilesStopwatch;
                bl = false;
                StringBuilder stringBuilder3 = ((StringBuilder)destination$iv$iv).append($i$f$mapTo2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder3);
                destination$iv$iv = result2;
                $i$f$mapTo2 = "Analysis duration: " + analysisStopwatch;
                bl = false;
                StringBuilder stringBuilder4 = ((StringBuilder)destination$iv$iv).append($i$f$mapTo2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder4);
                destination$iv$iv = result2;
                $i$f$mapTo2 = "TOTAL DURATION: " + totalStopwatch;
                bl = false;
                StringBuilder stringBuilder5 = ((StringBuilder)destination$iv$iv).append($i$f$mapTo2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder5);
                destination$iv$iv = result2;
                $i$f$mapTo2 = "Temp files:";
                bl = false;
                StringBuilder stringBuilder6 = ((StringBuilder)destination$iv$iv).append($i$f$mapTo2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder6);
                destination$iv$iv = result2;
                $i$f$mapTo2 = "  heapdump = " + HeapReportUtils.INSTANCE.toShortStringAsCount(this.hprofFileChannel.size());
                bl = false;
                StringBuilder stringBuilder7 = ((StringBuilder)destination$iv$iv).append($i$f$mapTo2);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(value)");
                StringsKt.appendln((StringBuilder)stringBuilder7);
                Iterable $this$forEach$iv = this.tempFiles;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TempFile temp = (TempFile)element$iv;
                    boolean bl2 = false;
                    FileChannel channel = temp.getChannel();
                    if (!channel.isOpen()) continue;
                    StringBuilder stringBuilder8 = result2;
                    String string = "  " + temp.getType() + " = " + HeapReportUtils.INSTANCE.toShortStringAsCount(channel.size());
                    boolean bl3 = false;
                    StringBuilder stringBuilder9 = stringBuilder8.append(string);
                    Intrinsics.checkNotNullExpressionValue((Object)stringBuilder9, (String)"append(value)");
                    StringsKt.appendln((StringBuilder)stringBuilder9);
                }
            }
        }
        finally {
            parser.close();
            this.closeAndDeleteTemporaryFiles();
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private final boolean isSupported(long instanceCount) {
        return RemapIDsVisitor.Companion.isSupported(instanceCount) && instanceCount <= (long)Integer.MAX_VALUE;
    }

    private final void closeAndDeleteTemporaryFiles() {
        Iterable $this$forEach$iv = this.tempFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TempFile tempFile = (TempFile)element$iv;
            boolean bl = false;
            try {
                tempFile.getChannel().close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Path path2 = tempFile.getPath();
                boolean bl2 = false;
                boolean bl3 = false;
                Path it = path2;
                boolean bl4 = false;
                Files.deleteIfExists(it);
            }
            catch (Throwable throwable) {
            }
        }
        this.tempFiles.clear();
    }

    public HProfAnalysis(@NotNull FileChannel hprofFileChannel, @NotNull TempFilenameSupplier tempFilenameSupplier) {
        Intrinsics.checkNotNullParameter((Object)hprofFileChannel, (String)"hprofFileChannel");
        Intrinsics.checkNotNullParameter((Object)tempFilenameSupplier, (String)"tempFilenameSupplier");
        this.hprofFileChannel = hprofFileChannel;
        this.tempFilenameSupplier = tempFilenameSupplier;
        boolean bl = false;
        this.tempFiles = new ArrayList();
        this.includeMetaInfo = true;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$TempFilenameSupplier;", "", "getTempFilePath", "Ljava/nio/file/Path;", "type", "", "intellij.android.core"})
    public static interface TempFilenameSupplier {
        @NotNull
        public Path getTempFilePath(@NotNull String var1);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/diagnostics/hprof/analysis/HProfAnalysis$TempFile;", "", "type", "", "path", "Ljava/nio/file/Path;", "channel", "Ljava/nio/channels/FileChannel;", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/channels/FileChannel;)V", "getChannel", "()Ljava/nio/channels/FileChannel;", "getPath", "()Ljava/nio/file/Path;", "getType", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.core"})
    private static final class TempFile {
        @NotNull
        private final String type;
        @NotNull
        private final Path path;
        @NotNull
        private final FileChannel channel;

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final Path getPath() {
            return this.path;
        }

        @NotNull
        public final FileChannel getChannel() {
            return this.channel;
        }

        public TempFile(@NotNull String type, @NotNull Path path2, @NotNull FileChannel channel) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            this.type = type;
            this.path = path2;
            this.channel = channel;
        }

        @NotNull
        public final String component1() {
            return this.type;
        }

        @NotNull
        public final Path component2() {
            return this.path;
        }

        @NotNull
        public final FileChannel component3() {
            return this.channel;
        }

        @NotNull
        public final TempFile copy(@NotNull String type, @NotNull Path path2, @NotNull FileChannel channel) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            return new TempFile(type, path2, channel);
        }

        public static /* synthetic */ TempFile copy$default(TempFile tempFile, String string, Path path2, FileChannel fileChannel, int n, Object object) {
            if ((n & 1) != 0) {
                string = tempFile.type;
            }
            if ((n & 2) != 0) {
                path2 = tempFile.path;
            }
            if ((n & 4) != 0) {
                fileChannel = tempFile.channel;
            }
            return tempFile.copy(string, path2, fileChannel);
        }

        @NotNull
        public String toString() {
            return "TempFile(type=" + this.type + ", path=" + this.path + ", channel=" + this.channel + ")";
        }

        public int hashCode() {
            String string = this.type;
            Path path2 = this.path;
            FileChannel fileChannel = this.channel;
            return ((string != null ? string.hashCode() : 0) * 31 + (path2 != null ? ((Object)path2).hashCode() : 0)) * 31 + (fileChannel != null ? fileChannel.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof TempFile)) break block3;
                    TempFile tempFile = (TempFile)object;
                    if (!Intrinsics.areEqual((Object)this.type, (Object)tempFile.type) || !Intrinsics.areEqual((Object)this.path, (Object)tempFile.path) || !Intrinsics.areEqual((Object)this.channel, (Object)tempFile.channel)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

