/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.JavaDebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.descriptors.data.DescriptorData;
import com.intellij.debugger.impl.descriptors.data.UserExpressionData;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.NodeDescriptorFactory;
import com.intellij.debugger.ui.tree.UserExpressionDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayMapRendererBase
extends NodeRendererImpl {
    private static final int MAX_CHILDREN = 10;
    @NonNls
    private static final String MORE_ELEMENTS = "...";
    private final String myFqn;
    private final LabelRenderer myLabelRenderer;
    private final MyArrayMapSizeEvaluator mySizeEvaluator;

    public ArrayMapRendererBase(@NotNull String mapFqn) {
        if (mapFqn == null) {
            ArrayMapRendererBase.$$$reportNull$$$0(0);
        }
        super("unnamed", true);
        this.myLabelRenderer = new LabelRenderer();
        this.mySizeEvaluator = new MyArrayMapSizeEvaluator();
        this.myProperties.setName(mapFqn);
        this.myFqn = mapFqn;
    }

    public void buildChildren(Value value2, ChildrenBuilder builder2, EvaluationContext evaluationContext) {
        int size;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ArrayList<DebuggerTreeNodeImpl> children = new ArrayList<DebuggerTreeNodeImpl>();
        NodeManagerImpl nodeManager = (NodeManagerImpl)builder2.getNodeManager();
        NodeDescriptorFactory descriptorFactory = builder2.getDescriptorManager();
        try {
            size = this.getArrayMapSize(value2, evaluationContext);
        }
        catch (Exception e) {
            size = 0;
        }
        int n = Math.min(size, 10);
        for (int i2 = 0; i2 < n; ++i2) {
            String expression2 = String.format(Locale.US, "this.valueAt(%1$d)", i2);
            UserExpressionData descriptorData = new UserExpressionData((ValueDescriptorImpl)builder2.getParentDescriptor(), this.myFqn, String.format(Locale.US, "value[%1$d]", i2), (TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expression2, "", (FileType)JavaFileType.INSTANCE));
            UserExpressionDescriptor userExpressionDescriptor = descriptorFactory.getUserExpressionDescriptor((NodeDescriptor)builder2.getParentDescriptor(), (DescriptorData)descriptorData);
            DebuggerTreeNodeImpl arrayMapItemNode = nodeManager.createNode((NodeDescriptor)userExpressionDescriptor, evaluationContext);
            children.add(arrayMapItemNode);
        }
        if (size > 10) {
            children.add(nodeManager.createMessageNode(new MessageDescriptor(MORE_ELEMENTS, 3)));
        }
        builder2.setChildren(children);
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode node2, DebuggerContext context) throws EvaluateException {
        return null;
    }

    public boolean isExpandable(Value value2, EvaluationContext context, NodeDescriptor parentDescriptor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.getArrayMapIsEmpty(value2, context);
    }

    public String calcLabel(ValueDescriptor descriptor2, EvaluationContext evaluationContext, DescriptorLabelListener listener2) throws EvaluateException {
        if (!(descriptor2.getValue() instanceof ObjectReference)) {
            return JavaDebuggerBundle.message((String)"label.undefined", (Object[])new Object[0]);
        }
        ObjectReference ref = (ObjectReference)descriptor2.getValue();
        this.myLabelRenderer.setLabelExpression((TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "size()", "", (FileType)JavaFileType.INSTANCE));
        return ValueDescriptorImpl.getIdLabel((ObjectReference)ref) + ", size = " + this.myLabelRenderer.calcLabel(descriptor2, evaluationContext, listener2);
    }

    public String getUniqueId() {
        return this.myFqn;
    }

    public boolean isApplicable(@Nullable Type type) {
        return type != null && this.myFqn.equals(type.name());
    }

    private boolean getArrayMapIsEmpty(Value arrayMapValue, EvaluationContext context) {
        try {
            return this.getArrayMapSize(arrayMapValue, context) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private int getArrayMapSize(Value arrayMapValue, EvaluationContext context) throws InvalidTypeException, EvaluateException {
        EvaluationContext evaluationContext = context.createEvaluationContext(arrayMapValue);
        Value v = this.mySizeEvaluator.evaluate(evaluationContext.getProject(), evaluationContext);
        if (v instanceof IntegerValue) {
            return ((IntegerValue)v).intValue();
        }
        throw new InvalidTypeException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapFqn", "com/android/tools/idea/debug/ArrayMapRendererBase", "<init>"));
    }

    private class MyArrayMapSizeEvaluator
    extends CachedEvaluator {
        public MyArrayMapSizeEvaluator() {
            this.setReferenceExpression((TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "size()", "", (FileType)JavaFileType.INSTANCE));
        }

        protected String getClassName() {
            return ArrayMapRendererBase.this.myFqn;
        }

        public Value evaluate(Project p, EvaluationContext context) throws EvaluateException {
            return this.getEvaluator(p).evaluate(context);
        }
    }
}

