/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.debug;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoManager;
import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.debug.DesugarUtils;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.intellij.debugger.NoDataException;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.ClassPrepareRequest;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidPositionManager
extends PositionManagerImpl {
    private static final Logger LOG = Logger.getInstance(AndroidPositionManager.class);
    private Map<AndroidVersion, VirtualFile> mySourceFoldersByApiLevel;
    private final DebugProcessImpl myDebugProcess;

    public AndroidPositionManager(DebugProcessImpl debugProcess) {
        super(debugProcess);
        this.myDebugProcess = debugProcess;
    }

    @NotNull
    public List<ReferenceType> getAllClasses(@NotNull SourcePosition position) throws NoDataException {
        List<ReferenceType> referenceTypes;
        if (position == null) {
            AndroidPositionManager.$$$reportNull$$$0(0);
        }
        if ((referenceTypes = DesugarUtils.addExtraClassesIfNeeded((DebugProcess)this.myDebugProcess, position, super.getAllClasses(position), (PositionManager)this)).isEmpty()) {
            throw NoDataException.INSTANCE;
        }
        List<ReferenceType> list = referenceTypes;
        if (list == null) {
            AndroidPositionManager.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public List<ClassPrepareRequest> createPrepareRequests(@NotNull ClassPrepareRequestor requestor, @NotNull SourcePosition position) throws NoDataException {
        List<ClassPrepareRequest> requests;
        if (requestor == null) {
            AndroidPositionManager.$$$reportNull$$$0(2);
        }
        if (position == null) {
            AndroidPositionManager.$$$reportNull$$$0(3);
        }
        if ((requests = DesugarUtils.addExtraPrepareRequestsIfNeeded((DebugProcess)this.myDebugProcess, requestor, position, super.createPrepareRequests(requestor, position))).isEmpty()) {
            throw NoDataException.INSTANCE;
        }
        List<ClassPrepareRequest> list = requests;
        if (list == null) {
            AndroidPositionManager.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Nullable
    public Set<? extends FileType> getAcceptedFileTypes() {
        return ImmutableSet.of((Object)JavaClassFileType.INSTANCE);
    }

    @Nullable
    public SourcePosition getSourcePosition(Location location) throws NoDataException {
        SourcePosition position = super.getSourcePosition(location);
        if (position == null) {
            throw NoDataException.INSTANCE;
        }
        return position;
    }

    @Nullable
    protected PsiFile getPsiFileByLocation(Project project, Location location) {
        PsiFile file2 = super.getPsiFileByLocation(project, location);
        if (file2 == null) {
            return null;
        }
        if (!DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE) {
            return null;
        }
        AndroidVersion version2 = AndroidPositionManager.getAndroidVersionFromDebugSession(project);
        if (version2 == null) {
            LOG.debug("getPsiFileByLocation returned null because cannot determine version from device.");
            return null;
        }
        return this.getApiSpecificPsi(project, file2, version2);
    }

    @Nullable
    protected PsiFile getApiSpecificPsi(@NotNull Project project, @NotNull PsiFile file2, @NotNull AndroidVersion version2) {
        if (project == null) {
            AndroidPositionManager.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            AndroidPositionManager.$$$reportNull$$$0(6);
        }
        if (version2 == null) {
            AndroidPositionManager.$$$reportNull$$$0(7);
        }
        if (!AndroidSdks.getInstance().isInAndroidSdk((PsiElement)file2)) {
            return null;
        }
        String relPath = AndroidPositionManager.getRelPathFromSourceRoot(project, file2);
        if (relPath == null) {
            LOG.debug("getApiSpecificPsi returned null because relPath is null for file: " + file2.getName());
            return null;
        }
        return this.getSourceForApiLevel(project, version2, relPath);
    }

    @Nullable
    private static AndroidVersion getAndroidVersionFromDebugSession(@NotNull Project project) {
        XDebugSession session;
        if (project == null) {
            AndroidPositionManager.$$$reportNull$$$0(8);
        }
        if ((session = XDebuggerManager.getInstance((Project)project).getCurrentSession()) == null) {
            return null;
        }
        return (AndroidVersion)session.getDebugProcess().getProcessHandler().getUserData(AndroidSessionInfo.ANDROID_DEVICE_API_LEVEL);
    }

    @Nullable
    private PsiFile getSourceForApiLevel(@NotNull Project project, @NotNull AndroidVersion version2, @NotNull String relPath) {
        VirtualFile sourceFolder;
        if (project == null) {
            AndroidPositionManager.$$$reportNull$$$0(9);
        }
        if (version2 == null) {
            AndroidPositionManager.$$$reportNull$$$0(10);
        }
        if (relPath == null) {
            AndroidPositionManager.$$$reportNull$$$0(11);
        }
        if ((sourceFolder = this.getSourceFolder(version2)) == null) {
            return null;
        }
        VirtualFile vfile = sourceFolder.findFileByRelativePath(relPath);
        if (vfile == null) {
            LOG.debug("getSourceForApiLevel returned null because " + relPath + " is not present in " + sourceFolder);
            return null;
        }
        return PsiManager.getInstance((Project)project).findFile(vfile);
    }

    @Nullable
    private VirtualFile getSourceFolder(@NotNull AndroidVersion version2) {
        if (version2 == null) {
            AndroidPositionManager.$$$reportNull$$$0(12);
        }
        if (this.mySourceFoldersByApiLevel == null) {
            this.mySourceFoldersByApiLevel = AndroidPositionManager.createSourcesByApiLevel();
            if (this.mySourceFoldersByApiLevel.get(version2) == null) {
                LOG.debug("getSourceFolder returned null for version: " + version2);
            }
        }
        return this.mySourceFoldersByApiLevel.get(version2);
    }

    private static Map<AndroidVersion, VirtualFile> createSourcesByApiLevel() {
        Collection<? extends LocalPackage> sourcePackages = AndroidPositionManager.getAllPlatformSourcePackages();
        HashMap sourcesByApi = Maps.newHashMap();
        for (LocalPackage localPackage : sourcePackages) {
            TypeDetails typeDetails = localPackage.getTypeDetails();
            if (!(typeDetails instanceof DetailsTypes.ApiDetailsType)) {
                LOG.warn("Unable to get type details for source package @ " + localPackage.getLocation().getPath());
                continue;
            }
            DetailsTypes.ApiDetailsType details = (DetailsTypes.ApiDetailsType)typeDetails;
            AndroidVersion version2 = details.getAndroidVersion();
            VirtualFile sourceFolder = VfsUtil.findFileByIoFile((File)localPackage.getLocation(), (boolean)false);
            if (sourceFolder == null || !sourceFolder.isValid()) continue;
            sourcesByApi.put(version2, sourceFolder);
        }
        return ImmutableMap.copyOf((Map)sourcesByApi);
    }

    private static Collection<? extends LocalPackage> getAllPlatformSourcePackages() {
        AndroidSdkHandler sdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        RepoManager sdkManager = sdkHandler.getSdkManager((ProgressIndicator)new StudioLoggerProgressIndicator(AndroidPositionManager.class));
        return sdkManager.getPackages().getLocalPackagesForPrefix("sources");
    }

    @Nullable
    private static String getRelPathFromSourceRoot(@NotNull Project project, @NotNull PsiFile file2) {
        ProjectFileIndex fileIndex;
        VirtualFile sourceRoot;
        if (project == null) {
            AndroidPositionManager.$$$reportNull$$$0(13);
        }
        if (file2 == null) {
            AndroidPositionManager.$$$reportNull$$$0(14);
        }
        if ((sourceRoot = (fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project)).getSourceRootForFile(file2.getVirtualFile())) == null) {
            LOG.debug("Could not determine source root for file: " + file2.getVirtualFile().getPath());
            return null;
        }
        return VfsUtilCore.getRelativePath((VirtualFile)file2.getVirtualFile(), (VirtualFile)sourceRoot);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/debug/AndroidPositionManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestor";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/debug/AndroidPositionManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllClasses";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrepareRequests";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllClasses";
                break;
            }
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPrepareRequests";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getApiSpecificPsi";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAndroidVersionFromDebugSession";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSourceForApiLevel";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getSourceFolder";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getRelPathFromSourceRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

