/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractDeviceAction;
import com.android.tools.idea.ddms.screenshot.ScreenshotTask;
import com.android.tools.idea.ddms.screenshot.ScreenshotViewer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public class ScreenshotAction
extends AbstractDeviceAction {
    private final Project myProject;

    public ScreenshotAction(@NotNull Project p, @NotNull DeviceContext context) {
        if (p == null) {
            ScreenshotAction.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ScreenshotAction.$$$reportNull$$$0(1);
        }
        super(context, AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]), AndroidBundle.message("android.ddms.actions.screenshot.description", new Object[0]), StudioIcons.Logcat.Toolbar.SNAPSHOT);
        this.myProject = p;
    }

    @Override
    protected void performAction(final @NotNull IDevice device) {
        if (device == null) {
            ScreenshotAction.$$$reportNull$$$0(2);
        }
        final Project project = this.myProject;
        new ScreenshotTask(project, device){

            public void onSuccess() {
                String msg = this.getError();
                if (msg != null) {
                    Messages.showErrorDialog((Project)project, (String)msg, (String)AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]));
                    return;
                }
                try {
                    File backingFile = FileUtil.createTempFile((String)"screenshot", (String)".png", (boolean)true);
                    ImageIO.write((RenderedImage)this.getScreenshot(), "png", backingFile);
                    new ScreenshotViewer(project, this.getScreenshot(), backingFile, device, device.getProperty("ro.product.model")){

                        @Override
                        protected void doOKAction() {
                            super.doOKAction();
                            File screenshot = this.getScreenshot();
                            VirtualFile vf = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(screenshot);
                            if (vf != null) {
                                vf.refresh(false, false);
                                FileEditorManager.getInstance((Project)project).openFile(vf, true);
                            }
                        }
                    }.show();
                }
                catch (Exception e) {
                    Logger.getInstance(ScreenshotAction.class).warn("Error while displaying screenshot viewer: ", (Throwable)e);
                    Messages.showErrorDialog((Project)project, (String)AndroidBundle.message("android.ddms.screenshot.generic.error", e), (String)AndroidBundle.message("android.ddms.actions.screenshot", new Object[0]));
                }
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/ddms/actions/ScreenshotAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "performAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

