/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms.actions;

import com.android.annotations.concurrency.Slow;
import com.android.annotations.concurrency.UiThread;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.EmulatorConsole;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.ScreenRecorderOptions;
import com.android.tools.idea.ddms.actions.PullRecordingTask;
import com.android.tools.idea.ddms.actions.ScreenRecorderAction;
import com.android.tools.idea.ddms.actions.ScreenRecorderDialog;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ScreenRecorderTask
implements Runnable {
    private static final CharSequence MEDIA_UNSUPPORTED_ERROR = "-1010";
    private static final long MAX_RECORDING_TIME_MILLIS = TimeUnit.MINUTES.toMillis(3L);
    private final Project myProject;
    private final IDevice myDevice;
    private final Path myHostRecordingFile;
    private final ScreenRecorderOptions myOptions;
    private DialogWrapper myDialogWrapper;

    public ScreenRecorderTask(@NotNull Project project, @NotNull IDevice device, @Nullable Path hostRecordingFile, @NotNull ScreenRecorderOptions options2) {
        if (project == null) {
            ScreenRecorderTask.$$$reportNull$$$0(0);
        }
        if (device == null) {
            ScreenRecorderTask.$$$reportNull$$$0(1);
        }
        if (options2 == null) {
            ScreenRecorderTask.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myDevice = device;
        this.myHostRecordingFile = hostRecordingFile;
        this.myOptions = options2;
    }

    @Override
    @Slow
    public void run() {
        CountDownLatch completionLatch = null;
        CollectingOutputReceiver receiver = null;
        EmulatorConsole console = null;
        if (this.myHostRecordingFile != null) {
            console = EmulatorConsole.getConsole((IDevice)this.myDevice);
            if (console == null) {
                return;
            }
            try {
                console.startEmulatorScreenRecording(ScreenRecorderTask.getEmulatorScreenRecorderOptions(this.myHostRecordingFile, this.myOptions));
            }
            catch (Exception e) {
                EventQueue.invokeLater(() -> this.showError("Unexpected error while launching screen recording", e));
                return;
            }
        } else {
            completionLatch = new CountDownLatch(1);
            receiver = new CollectingOutputReceiver(completionLatch);
            this.startDeviceRecording(receiver, completionLatch);
        }
        long start2 = System.currentTimeMillis();
        CountDownLatch stoppingLatch = new CountDownLatch(1);
        ScreenRecorderDialog dialog2 = new ScreenRecorderDialog("Screen Recorder", stoppingLatch::countDown);
        EventQueue.invokeLater(() -> {
            this.myDialogWrapper = dialog2.createWrapper(this.myProject);
            this.myDialogWrapper.show();
        });
        try {
            while (!(stoppingLatch.await(this.millisUntilNextSecondTick(start2), TimeUnit.MILLISECONDS) || System.currentTimeMillis() - start2 >= MAX_RECORDING_TIME_MILLIS || completionLatch != null && completionLatch.getCount() <= 0L)) {
                EventQueue.invokeLater(() -> dialog2.setRecordingTimeMillis(System.currentTimeMillis() - start2));
                if (console == null || (console = EmulatorConsole.getConsole((IDevice)this.myDevice)) != null) continue;
            }
            EventQueue.invokeLater(() -> dialog2.setRecordingLabelText("Stopping..."));
            this.stopRecording(receiver, completionLatch, console);
        }
        catch (InterruptedException e) {
            this.stopRecording(receiver, null, console);
            throw new ProcessCanceledException();
        }
        finally {
            EventQueue.invokeLater(() -> this.myDialogWrapper.close(1));
        }
        if (receiver != null) {
            this.pullRecording(receiver);
        } else {
            this.pullEmulatorRecording();
        }
    }

    private long millisUntilNextSecondTick(long start2) {
        return 1000L - (System.currentTimeMillis() - start2) % 1000L;
    }

    private void startDeviceRecording(@NotNull CollectingOutputReceiver receiver, @NotNull CountDownLatch completionLatch) {
        if (receiver == null) {
            ScreenRecorderTask.$$$reportNull$$$0(3);
        }
        if (completionLatch == null) {
            ScreenRecorderTask.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                this.myDevice.startScreenRecorder("/sdcard/ddmsrec.mp4", this.myOptions, (IShellOutputReceiver)receiver);
            }
            catch (Exception e) {
                completionLatch.countDown();
                EventQueue.invokeLater(() -> this.showError("Unexpected error while launching screen recording", e));
            }
        });
    }

    private void stopRecording(@Nullable CollectingOutputReceiver receiver, @Nullable CountDownLatch completionLatch, @Nullable EmulatorConsole console) {
        if (receiver != null) {
            receiver.cancel();
            if (completionLatch != null) {
                try {
                    completionLatch.await(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    throw new ProcessCanceledException();
                }
            }
        } else if (console != null) {
            console.stopScreenRecording();
        }
    }

    private void pullEmulatorRecording() {
        assert (this.myHostRecordingFile != null);
        if (!Files.exists(this.myHostRecordingFile, new LinkOption[0])) {
            return;
        }
        EventQueue.invokeLater(() -> {
            VirtualFileWrapper fileWrapper = this.getTargetFile("webm");
            if (fileWrapper == null) {
                return;
            }
            try {
                Files.move(this.myHostRecordingFile, fileWrapper.getFile().toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                this.showError("Unable to copy file to destination", e);
            }
        });
    }

    private void pullRecording(@NotNull CollectingOutputReceiver receiver) {
        if (receiver == null) {
            ScreenRecorderTask.$$$reportNull$$$0(5);
        }
        EventQueue.invokeLater(() -> {
            if (receiver.getOutput().contains(MEDIA_UNSUPPORTED_ERROR)) {
                Messages.showErrorDialog((String)receiver.getOutput(), (String)"Screen Recorder Error");
                return;
            }
            VirtualFileWrapper fileWrapper = this.getTargetFile("mp4");
            if (fileWrapper == null) {
                return;
            }
            File file2 = fileWrapper.getFile();
            new PullRecordingTask(this.myProject, this.myDevice, file2.getAbsolutePath()).queue();
        });
    }

    @Nullable
    private VirtualFileWrapper getTargetFile(@NotNull String extension) {
        if (extension == null) {
            ScreenRecorderTask.$$$reportNull$$$0(6);
        }
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor("Save As", "", new String[]{extension});
        FileSaverDialog saveFileDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, this.myProject);
        VirtualFile baseDir = VfsUtil.getUserHomeDir();
        return saveFileDialog.save(baseDir, ScreenRecorderTask.getDefaultFileName(extension));
    }

    @UiThread
    private void showError(@NotNull String message2, @Nullable Throwable throwable) {
        if (message2 == null) {
            ScreenRecorderTask.$$$reportNull$$$0(7);
        }
        ScreenRecorderAction.showError(this.myProject, message2, throwable);
    }

    @NotNull
    private static String getDefaultFileName(@NotNull String extension) {
        if (extension == null) {
            ScreenRecorderTask.$$$reportNull$$$0(8);
        }
        Calendar now = Calendar.getInstance();
        String fileName = "device-%tF-%tH%tM%tS";
        String string = String.format(Locale.US, (String)(SystemInfo.isMac ? fileName + "." + extension : fileName), now, now, now, now);
        if (string == null) {
            ScreenRecorderTask.$$$reportNull$$$0(9);
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    static String getEmulatorScreenRecorderOptions(@NotNull Path filePath, @NotNull ScreenRecorderOptions options2) {
        if (filePath == null) {
            ScreenRecorderTask.$$$reportNull$$$0(10);
        }
        if (options2 == null) {
            ScreenRecorderTask.$$$reportNull$$$0(11);
        }
        StringBuilder sb = new StringBuilder();
        if (options2.width > 0 && options2.height > 0) {
            sb.append("--size ");
            sb.append(options2.width);
            sb.append('x');
            sb.append(options2.height);
            sb.append(' ');
        }
        if (options2.bitrateMbps > 0) {
            sb.append("--bit-rate ");
            sb.append(options2.bitrateMbps * 1000000);
            sb.append(' ');
        }
        if (options2.timeLimit > 0L) {
            sb.append("--time-limit ");
            long seconds = TimeUnit.SECONDS.convert(options2.timeLimit, options2.timeLimitUnits);
            if (seconds > 180L) {
                seconds = 180L;
            }
            sb.append(seconds);
            sb.append(' ');
        }
        sb.append(filePath);
        String string = sb.toString();
        if (string == null) {
            ScreenRecorderTask.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "completionLatch";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ddms/actions/ScreenRecorderTask";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ddms/actions/ScreenRecorderTask";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getEmulatorScreenRecorderOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startDeviceRecording";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "pullRecording";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTargetFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultFileName";
                break;
            }
            case 9: 
            case 12: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getEmulatorScreenRecorderOptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

