/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ddms;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.ClientCellRenderer;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DeviceNameProperties;
import com.android.tools.idea.ddms.DeviceNamePropertiesFetcher;
import com.android.tools.idea.ddms.DeviceNamePropertiesProvider;
import com.android.tools.idea.ddms.DeviceRenderer;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.swing.JComboBox;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DevicePanel
implements AndroidDebugBridge.IDeviceChangeListener,
AndroidDebugBridge.IDebugBridgeChangeListener,
AndroidDebugBridge.IClientChangeListener,
Disposable {
    private static final Logger LOG = Logger.getInstance(DevicePanel.class);
    private final DeviceContext myDeviceContext;
    @Nullable
    private AndroidDebugBridge myBridge;
    @NotNull
    private final Project myProject;
    @NotNull
    private final DeviceNamePropertiesProvider myProvider;
    @NotNull
    private final Map<String, String> myPreferredClients;
    private boolean myIgnoringActionEvents;
    private DeviceComboBox myDeviceCombo;
    private JComboBox<Client> myProcessComboBox;
    private final NullableLazyValue<String> myCandidateClientName;

    public DevicePanel(@NotNull Project project, @NotNull DeviceContext deviceContext) {
        if (project == null) {
            DevicePanel.$$$reportNull$$$0(0);
        }
        if (deviceContext == null) {
            DevicePanel.$$$reportNull$$$0(1);
        }
        this(project, deviceContext, new MyDeviceComboBox(), new MyProcessComboBox());
    }

    @VisibleForTesting
    DevicePanel(@NotNull Project project, @NotNull DeviceContext deviceContext, @NotNull DeviceComboBox deviceComboBox, @NotNull ComboBox<Client> processComboBox) {
        if (project == null) {
            DevicePanel.$$$reportNull$$$0(2);
        }
        if (deviceContext == null) {
            DevicePanel.$$$reportNull$$$0(3);
        }
        if (deviceComboBox == null) {
            DevicePanel.$$$reportNull$$$0(4);
        }
        if (processComboBox == null) {
            DevicePanel.$$$reportNull$$$0(5);
        }
        this.myCandidateClientName = new NullableLazyValue<String>(){

            @Nullable
            protected String compute() {
                return DevicePanel.this.getApplicationName();
            }
        };
        this.myProject = project;
        this.myProvider = new DeviceNamePropertiesFetcher((Disposable)this.myProject);
        this.myDeviceContext = deviceContext;
        this.myPreferredClients = new HashMap<String, String>();
        this.initializeDeviceCombo(deviceComboBox);
        this.initializeProcessComboBox(processComboBox);
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.addClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        AndroidDebugBridge.addDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        Disposer.register((Disposable)this.myProject, (Disposable)this);
    }

    private void initializeDeviceCombo(@NotNull DeviceComboBox deviceComboBox) {
        if (deviceComboBox == null) {
            DevicePanel.$$$reportNull$$$0(6);
        }
        deviceComboBox.initRenderer(new MyFutureCallback());
        deviceComboBox.addActionListener(event -> {
            if (this.myIgnoringActionEvents) {
                return;
            }
            this.updateProcessComboBox();
            Object device = this.myDeviceCombo.getSelectedItem();
            this.myDeviceContext.fireDeviceSelected(device instanceof IDevice ? (IDevice)device : null);
        });
        this.myDeviceCombo = deviceComboBox;
    }

    private void initializeProcessComboBox(@NotNull ComboBox<Client> processComboBox) {
        if (processComboBox == null) {
            DevicePanel.$$$reportNull$$$0(7);
        }
        processComboBox.setName("Processes");
        AccessibleContextUtil.setName(processComboBox, (String)"Processes");
        processComboBox.addActionListener(event -> {
            if (this.myIgnoringActionEvents) {
                return;
            }
            Client client = (Client)this.myProcessComboBox.getSelectedItem();
            if (client != null) {
                this.myPreferredClients.put(client.getDevice().getName(), client.getClientData().getClientDescription());
            }
            this.myDeviceContext.fireClientSelected(client);
        });
        this.myProcessComboBox = processComboBox;
    }

    @NotNull
    public JComboBox<IDevice> getDeviceComboBox() {
        DeviceComboBox deviceComboBox = this.myDeviceCombo;
        if (deviceComboBox == null) {
            DevicePanel.$$$reportNull$$$0(8);
        }
        return deviceComboBox;
    }

    public void selectDevice(IDevice device) {
        this.myDeviceCombo.setSelectedItem(device);
    }

    @NotNull
    public Component getClientComboBox() {
        JComboBox<Client> jComboBox = this.myProcessComboBox;
        if (jComboBox == null) {
            DevicePanel.$$$reportNull$$$0(9);
        }
        return jComboBox;
    }

    public void selectClient(Client client) {
        this.myProcessComboBox.setSelectedItem(client);
    }

    @Nullable
    private String getApplicationName() {
        for (Module module2 : ModuleManager.getInstance((Project)this.myProject).getModules()) {
            String pkg;
            AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance(module2);
            if (moduleInfo == null || (pkg = moduleInfo.getPackage()) == null) continue;
            return pkg;
        }
        return null;
    }

    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        AndroidDebugBridge.removeClientChangeListener((AndroidDebugBridge.IClientChangeListener)this);
        AndroidDebugBridge.removeDebugBridgeChangeListener((AndroidDebugBridge.IDebugBridgeChangeListener)this);
        this.myBridge = null;
        if (this.myDeviceCombo != null) {
            Disposer.dispose((Disposable)this.myDeviceCombo);
            this.myDeviceCombo = null;
        }
    }

    public void bridgeChanged(AndroidDebugBridge bridge) {
        if (bridge == null) {
            return;
        }
        StartupManager.getInstance((Project)this.myProject).runWhenProjectIsInitialized(() -> UIUtil.invokeLaterIfNeeded(() -> {
            this.myBridge = bridge;
            this.updateDeviceCombo();
        }));
    }

    @VisibleForTesting
    void setBridge(@NotNull AndroidDebugBridge bridge) {
        if (bridge == null) {
            DevicePanel.$$$reportNull$$$0(10);
        }
        this.myBridge = bridge;
    }

    public void deviceConnected(@NotNull IDevice device) {
        if (device == null) {
            DevicePanel.$$$reportNull$$$0(11);
        }
        LOG.info("Device connected: " + device.getName());
        UIUtil.invokeLaterIfNeeded(this::updateDeviceCombo);
    }

    public void deviceDisconnected(@NotNull IDevice device) {
        if (device == null) {
            DevicePanel.$$$reportNull$$$0(12);
        }
        LOG.info("Device disconnected: " + device.getName());
        UIUtil.invokeLaterIfNeeded(this::updateDeviceCombo);
    }

    public void deviceChanged(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            DevicePanel.$$$reportNull$$$0(13);
        }
        UIUtil.invokeLaterIfNeeded(() -> this.deviceChangedImpl(device, changeMask));
    }

    @VisibleForTesting
    void deviceChangedImpl(@NotNull IDevice device, int changeMask) {
        if (device == null) {
            DevicePanel.$$$reportNull$$$0(14);
        }
        if ((changeMask & 2) != 0) {
            this.updateProcessComboBox();
        } else if ((changeMask & 1) != 0) {
            this.updateDeviceCombo();
        }
        this.myDeviceContext.fireDeviceChanged(device, changeMask);
    }

    public void clientChanged(@NotNull Client client, int changeMask) {
        if (client == null) {
            DevicePanel.$$$reportNull$$$0(15);
        }
        if ((changeMask & 1) != 0) {
            ApplicationManager.getApplication().invokeLater(this::updateProcessComboBox);
        }
    }

    @VisibleForTesting
    void updateDeviceCombo() {
        if (this.myBridge == null) {
            return;
        }
        this.myIgnoringActionEvents = true;
        IDevice selectedDevice = (IDevice)this.myDeviceCombo.getSelectedItem();
        this.myDeviceCombo.removeAllItems();
        List<IDevice> devices2 = Arrays.asList(this.myBridge.getDevices());
        devices2.forEach(device -> this.myDeviceCombo.addItem(device));
        this.myDeviceCombo.setSerialNumbersVisible(DeviceRenderer.shouldShowSerialNumbers(devices2, this.myProvider));
        Optional<IDevice> optionalDevice = IntStream.range(0, this.myDeviceCombo.getItemCount()).mapToObj(i2 -> (IDevice)this.myDeviceCombo.getItemAt(i2)).filter(device -> DevicePanel.equals(device, selectedDevice)).findFirst();
        if (optionalDevice.isPresent()) {
            IDevice device2 = optionalDevice.get();
            this.myDeviceCombo.setSelectedItem(device2);
            this.myDeviceContext.fireDeviceSelected(device2);
        } else if (selectedDevice != null) {
            this.myDeviceCombo.addItem(selectedDevice);
            this.myDeviceCombo.setSelectedItem(selectedDevice);
            this.myDeviceContext.fireDeviceSelected(selectedDevice);
        }
        this.updateProcessComboBox();
        this.myIgnoringActionEvents = false;
    }

    private static boolean equals(@NotNull IDevice device1, @Nullable IDevice device2) {
        if (device1 == null) {
            DevicePanel.$$$reportNull$$$0(16);
        }
        if (device2 == null) {
            return false;
        }
        boolean device1Emulator = device1.isEmulator();
        if (device1Emulator != device2.isEmulator()) {
            return false;
        }
        if (device1Emulator) {
            return Objects.equals(device1.getAvdName(), device2.getAvdName());
        }
        return device1.getSerialNumber().equals(device2.getSerialNumber());
    }

    private void updateProcessComboBox() {
        if (this.myDeviceCombo == null) {
            return;
        }
        this.myIgnoringActionEvents = true;
        IDevice device = (IDevice)this.myDeviceCombo.getSelectedItem();
        Client selected = (Client)this.myProcessComboBox.getSelectedItem();
        Client toSelect = null;
        boolean update2 = true;
        this.myProcessComboBox.removeAllItems();
        if (device != null) {
            boolean selectedClientDied;
            Client preferredClient;
            String preferred = this.getPreferredClient(device.getName());
            if (preferred != null && (preferredClient = device.getClient(preferred)) != null) {
                toSelect = preferredClient;
            }
            ArrayList clients = Lists.newArrayList((Object[])device.getClients());
            boolean bl = selectedClientDied = selected != null && selected.getDevice() == device && !clients.contains(selected);
            if (selectedClientDied) {
                if (toSelect == null) {
                    toSelect = selected;
                }
                clients.add(selected);
            }
            clients.sort(new ClientCellRenderer.ClientComparator());
            for (Client client : clients) {
                this.myProcessComboBox.addItem(client);
            }
            this.myProcessComboBox.setSelectedItem(toSelect);
            update2 = toSelect != selected;
        }
        this.myIgnoringActionEvents = false;
        if (update2) {
            this.myDeviceContext.fireClientSelected((Client)this.myProcessComboBox.getSelectedItem());
        }
    }

    @VisibleForTesting
    void setIgnoringActionEvents(boolean ignoringActionEvents) {
        this.myIgnoringActionEvents = ignoringActionEvents;
    }

    @Nullable
    private String getPreferredClient(@NotNull String device) {
        String client;
        if (device == null) {
            DevicePanel.$$$reportNull$$$0(17);
        }
        return (client = this.myPreferredClients.get(device)) == null ? (String)this.myCandidateClientName.getValue() : client;
    }

    @VisibleForTesting
    void putPreferredClient(@NotNull String device, @NotNull String client) {
        if (device == null) {
            DevicePanel.$$$reportNull$$$0(18);
        }
        if (client == null) {
            DevicePanel.$$$reportNull$$$0(19);
        }
        this.myPreferredClients.put(device, client);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceContext";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deviceComboBox";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processComboBox";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/ddms/DevicePanel";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bridge";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "client";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "device1";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/ddms/DevicePanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeviceComboBox";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getClientComboBox";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "initializeDeviceCombo";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "initializeProcessComboBox";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setBridge";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "deviceConnected";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deviceDisconnected";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "deviceChanged";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "deviceChangedImpl";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "clientChanged";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredClient";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "putPreferredClient";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class MyProcessComboBox
    extends ComboBox<Client> {
        private MyProcessComboBox() {
            this.setRenderer((ListCellRenderer)((Object)new ClientCellRenderer("No debuggable processes")));
        }
    }

    private final class MyFutureCallback
    implements FutureCallback<DeviceNameProperties> {
        private MyFutureCallback() {
        }

        public void onSuccess(@Nullable DeviceNameProperties properties2) {
            DevicePanel.this.updateDeviceCombo();
        }

        public void onFailure(@NotNull Throwable throwable) {
            if (throwable == null) {
                MyFutureCallback.$$$reportNull$$$0(0);
            }
            LOG.warn("Error retrieving device name properties", throwable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwable", "com/android/tools/idea/ddms/DevicePanel$MyFutureCallback", "onFailure"));
        }
    }

    private static final class MyDeviceComboBox
    extends DeviceComboBox {
        private DeviceNamePropertiesFetcher myFetcher;
        private DeviceRenderer.DeviceComboBoxRenderer myRenderer;

        private MyDeviceComboBox() {
        }

        @Override
        void initRenderer(@NotNull FutureCallback<DeviceNameProperties> callback2) {
            if (callback2 == null) {
                MyDeviceComboBox.$$$reportNull$$$0(0);
            }
            this.myFetcher = new DeviceNamePropertiesFetcher(this, callback2);
            this.myRenderer = new DeviceRenderer.DeviceComboBoxRenderer("No connected devices", false, this.myFetcher);
            this.setRenderer((ListCellRenderer)((Object)this.myRenderer));
        }

        public void dispose() {
            Disposer.dispose((Disposable)this.myFetcher);
        }

        @Override
        void setSerialNumbersVisible(boolean visible) {
            this.myRenderer.setShowSerial(visible);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/android/tools/idea/ddms/DevicePanel$MyDeviceComboBox", "initRenderer"));
        }
    }

    static abstract class DeviceComboBox
    extends ComboBox<IDevice>
    implements Disposable {
        DeviceComboBox() {
            AccessibleContextUtil.setName((Component)((Object)this), (String)"Devices");
        }

        abstract void initRenderer(@NotNull FutureCallback<DeviceNameProperties> var1);

        abstract void setSerialNumbersVisible(boolean var1);
    }
}

