/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.util;

import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.idea.databinding.DataBindingMode;
import com.android.tools.idea.databinding.index.BindingLayoutType;
import com.android.tools.idea.databinding.index.BindingXmlIndex;
import com.android.tools.idea.databinding.index.ViewIdData;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.databinding.util.ViewBindingUtil;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\r\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/databinding/util/LayoutBindingTypeUtil;", "", "()V", "VIEW_PACKAGE_ELEMENTS", "", "", "getViewClassName", "viewIdData", "Lcom/android/tools/idea/databinding/index/ViewIdData;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "viewName", "layoutName", "getViewClassNameFromIncludeTag", "getViewClassNameFromLayoutAttribute", "getViewClassNameFromMergeTag", "parsePsiType", "Lcom/intellij/psi/PsiType;", "typeStr", "context", "Lcom/intellij/psi/PsiElement;", "resolveViewPsiType", "viewTag", "intellij.android.core"})
public final class LayoutBindingTypeUtil {
    private static final List<String> VIEW_PACKAGE_ELEMENTS;
    @NotNull
    public static final LayoutBindingTypeUtil INSTANCE;

    @JvmStatic
    @Nullable
    public static final PsiType parsePsiType(@NotNull String typeStr, @NotNull PsiElement context) {
        PsiType psiType;
        Intrinsics.checkNotNullParameter((Object)typeStr, (String)"typeStr");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            psiType = PsiElementFactory.getInstance((Project)context.getProject()).createTypeFromText(typeStr, context);
        }
        catch (IncorrectOperationException e) {
            psiType = null;
        }
        return psiType;
    }

    @JvmStatic
    @Nullable
    public static final PsiType resolveViewPsiType(@NotNull ViewIdData viewIdData, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)viewIdData, (String)"viewIdData");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)context);
        if (androidFacet == null) {
            return null;
        }
        AndroidFacet androidFacet2 = androidFacet;
        String string = INSTANCE.getViewClassName(viewIdData, androidFacet2);
        if (string == null) {
            return null;
        }
        String viewClassName = string;
        CharSequence charSequence = viewClassName;
        boolean bl = false;
        return charSequence.length() > 0 ? (PsiType)PsiType.getTypeByName((String)viewClassName, (Project)context.getProject(), (GlobalSearchScope)context.getResolveScope()) : null;
    }

    @JvmStatic
    @Nullable
    public static final PsiType resolveViewPsiType(@NotNull String viewTag, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)viewTag, (String)"viewTag");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        AndroidFacet androidFacet = ModuleExtensionsKt.getAndroidFacet((PsiElement)context);
        if (androidFacet == null) {
            return null;
        }
        AndroidFacet androidFacet2 = androidFacet;
        String string = INSTANCE.getViewClassName(viewTag, null, androidFacet2);
        if (string == null) {
            return null;
        }
        String viewClassName = string;
        CharSequence charSequence = viewClassName;
        boolean bl = false;
        return charSequence.length() > 0 ? (PsiType)PsiType.getTypeByName((String)viewClassName, (Project)context.getProject(), (GlobalSearchScope)context.getResolveScope()) : null;
    }

    private final String getViewClassName(ViewIdData viewIdData, AndroidFacet facet2) {
        return this.getViewClassName(viewIdData.getViewName(), viewIdData.getLayoutName(), facet2);
    }

    private final String getViewClassName(String viewName, String layoutName, AndroidFacet facet2) {
        if (StringsKt.indexOf$default((CharSequence)viewName, (char)'.', (int)0, (boolean)false, (int)6, null) == -1) {
            if (VIEW_PACKAGE_ELEMENTS.contains(viewName)) {
                return "android.view." + viewName;
            }
            if (Intrinsics.areEqual((Object)"WebView", (Object)viewName)) {
                return "android.webkit." + viewName;
            }
            if (Intrinsics.areEqual((Object)"merge", (Object)viewName)) {
                return this.getViewClassNameFromMergeTag(layoutName, facet2);
            }
            if (Intrinsics.areEqual((Object)"include", (Object)viewName)) {
                return this.getViewClassNameFromIncludeTag(layoutName, facet2);
            }
            if (Intrinsics.areEqual((Object)"ViewStub", (Object)viewName)) {
                DataBindingMode dataBindingMode = DataBindingUtil.getDataBindingMode(facet2);
                Intrinsics.checkNotNullExpressionValue((Object)((Object)dataBindingMode), (String)"DataBindingUtil.getDataBindingMode(facet)");
                DataBindingMode mode = dataBindingMode;
                if (mode != DataBindingMode.NONE) {
                    return mode.viewStubProxy;
                }
                return "android.view.ViewStub";
            }
            if (Intrinsics.areEqual((Object)"fragment", (Object)viewName)) {
                return null;
            }
            return "android.widget." + viewName;
        }
        return viewName;
    }

    private final String getViewClassNameFromIncludeTag(String layoutName, AndroidFacet facet2) {
        String reference2 = this.getViewClassNameFromLayoutAttribute(layoutName, facet2);
        String string = reference2;
        if (string == null) {
            string = "android.view.View";
        }
        return string;
    }

    private final String getViewClassNameFromMergeTag(String layoutName, AndroidFacet facet2) {
        return this.getViewClassNameFromLayoutAttribute(layoutName, facet2);
    }

    private final String getViewClassNameFromLayoutAttribute(String layoutName, AndroidFacet facet2) {
        Module module2;
        BindingXmlIndex.Entry indexEntry;
        block8: {
            block7: {
                if (layoutName == null) {
                    return null;
                }
                ResourceUrl resourceUrl = ResourceUrl.parse((String)layoutName);
                if (resourceUrl == null || resourceUrl.type != ResourceType.LAYOUT) {
                    return null;
                }
                Module module3 = facet2.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"facet.module");
                Project project = module3.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"facet.module.project");
                String string = resourceUrl.name;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"resourceUrl.name");
                BindingXmlIndex.Entry entry = (BindingXmlIndex.Entry)CollectionsKt.firstOrNull((Iterable)BindingXmlIndex.Companion.getEntriesForLayout(project, string));
                if (entry == null) {
                    return null;
                }
                indexEntry = entry;
                VirtualFile virtualFile = indexEntry.getFile();
                Module module4 = facet2.getModule();
                Intrinsics.checkNotNullExpressionValue((Object)module4, (String)"facet.module");
                Project project2 = module4.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"facet.module.project");
                module2 = ProjectStructureUtilKt.getModule((VirtualFile)virtualFile, (Project)project2);
                if (module2 == null) break block7;
                Module module5 = module2;
                boolean bl = false;
                boolean bl2 = false;
                Module it = module5;
                boolean bl3 = false;
                module2 = AndroidFacet.getInstance((Module)it);
                if (module2 != null) break block8;
            }
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"indexEntry.file.getModul\u2026ance(it) } ?: return null");
        Module resourceFacet = module2;
        if (indexEntry.getData().getLayoutType() == BindingLayoutType.PLAIN_LAYOUT && !ViewBindingUtil.isViewBindingEnabled((AndroidFacet)resourceFacet)) {
            return this.getViewClassName(indexEntry.getData().getRootTag(), null, (AndroidFacet)resourceFacet);
        }
        return DataBindingUtil.getQualifiedBindingName((AndroidFacet)resourceFacet, indexEntry);
    }

    private LayoutBindingTypeUtil() {
    }

    static {
        LayoutBindingTypeUtil layoutBindingTypeUtil;
        INSTANCE = layoutBindingTypeUtil = new LayoutBindingTypeUtil();
        VIEW_PACKAGE_ELEMENTS = CollectionsKt.listOf((Object[])new String[]{"View", "ViewGroup", "TextureView", "SurfaceView"});
    }
}

