/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.psiclass;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.tools.idea.databinding.BindingLayout;
import com.android.tools.idea.databinding.BindingLayoutFile;
import com.android.tools.idea.databinding.index.BindingLayoutType;
import com.android.tools.idea.databinding.index.BindingXmlData;
import com.android.tools.idea.databinding.index.ImportData;
import com.android.tools.idea.databinding.index.VariableData;
import com.android.tools.idea.databinding.index.ViewIdData;
import com.android.tools.idea.databinding.psiclass.LightBindingClassConfig;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.databinding.util.LayoutBindingTypeUtil;
import com.android.tools.idea.databinding.util.ViewBindingUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.projectsystem.ScopeType;
import com.android.tools.idea.psi.light.DeprecatableLightMethodBuilder;
import com.android.tools.idea.psi.light.NullabilityLightFieldBuilder;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ObjectArrays;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.XmlRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.light.LightField;
import com.intellij.psi.impl.light.LightIdentifier;
import com.intellij.psi.impl.light.LightMethod;
import com.intellij.psi.impl.light.LightMethodBuilder;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Pair;
import org.jetbrains.android.augment.AndroidLightClassBase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightBindingClass
extends AndroidLightClassBase {
    @NotNull
    private final LightBindingClassConfig myConfig;
    @NotNull
    private final PsiJavaFile myBackingFile;
    @Nullable
    private PsiClass[] myPsiSupers;
    @Nullable
    private PsiMethod[] myPsiConstructors;
    @Nullable
    private PsiMethod[] myPsiAllMethods;
    @Nullable
    private PsiMethod[] myPsiMethods;
    @Nullable
    private PsiField[] myPsiFields;
    @Nullable
    private PsiReferenceList myExtendsList;
    @Nullable
    private PsiClassType[] myExtendsListTypes;

    public LightBindingClass(@NotNull PsiManager psiManager, @NotNull LightBindingClassConfig config) {
        if (psiManager == null) {
            LightBindingClass.$$$reportNull$$$0(0);
        }
        if (config == null) {
            LightBindingClass.$$$reportNull$$$0(1);
        }
        super(psiManager, (Collection<String>)ImmutableSet.of((Object)"public", (Object)"final"));
        this.myConfig = config;
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)this.getProject());
        this.myBackingFile = (PsiJavaFile)fileFactory.createFileFromText(this.myConfig.getClassName() + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)"// This class is generated on-the-fly by the IDE.");
        this.myBackingFile.setPackageName(StringUtil.getPackageName((String)this.myConfig.getQualifiedName()));
        this.setModuleInfo(this.myConfig.getFacet().getModule(), false);
    }

    private PsiMethod[] computeMethods() {
        ArrayList<PsiMethod> methods2 = new ArrayList<PsiMethod>();
        this.createRootOverride(methods2);
        for (Pair<VariableData, XmlTag> variableTag : this.myConfig.getVariableTags()) {
            this.createVariableMethods(variableTag, methods2);
        }
        if (this.myConfig.shouldGenerateGettersAndStaticMethods()) {
            this.createStaticMethods(methods2);
        }
        return methods2.toArray(PsiMethod.EMPTY_ARRAY);
    }

    private PsiField[] computeFields() {
        Map<BindingLayout, Collection<ViewIdData>> scopedViewIds = this.myConfig.getScopedViewIds();
        if (scopedViewIds.isEmpty()) {
            return PsiField.EMPTY_ARRAY;
        }
        boolean allEmpty = true;
        for (Collection<ViewIdData> viewIds : scopedViewIds.values()) {
            if (viewIds.isEmpty()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            return PsiField.EMPTY_ARRAY;
        }
        int numLayouts = scopedViewIds.keySet().size();
        if (numLayouts == 1) {
            Collection<ViewIdData> viewIds;
            viewIds = scopedViewIds.values().stream().findFirst().get();
            return (PsiField[])viewIds.stream().map(viewId -> this.createPsiField((ViewIdData)viewId, true)).filter(field2 -> field2 != null).toArray(PsiField[]::new);
        }
        HashMap<String, Integer> idCounts = new HashMap<String, Integer>();
        HashSet<ViewIdData> dedupedViewIds = new HashSet<ViewIdData>();
        for (Collection<ViewIdData> viewIds : scopedViewIds.values()) {
            for (ViewIdData viewId2 : viewIds) {
                int count = idCounts.compute(viewId2.getId(), (key, value2) -> value2 == null ? 1 : value2 + 1);
                if (count != 1) continue;
                dedupedViewIds.add(viewId2);
            }
        }
        return (PsiField[])dedupedViewIds.stream().map(viewId -> this.createPsiField((ViewIdData)viewId, (Integer)idCounts.get(viewId.getId()) == numLayouts)).filter(field2 -> field2 != null).toArray(PsiField[]::new);
    }

    @NotNull
    private PsiMethod createConstructor() {
        LightMethodBuilder constructor = new LightMethodBuilder((PsiClass)this, (Language)JavaLanguage.INSTANCE);
        constructor.setConstructor(true);
        constructor.addModifier("private");
        LightMethodBuilder lightMethodBuilder = constructor;
        if (lightMethodBuilder == null) {
            LightBindingClass.$$$reportNull$$$0(2);
        }
        return lightMethodBuilder;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myConfig.getQualifiedName();
        if (string == null) {
            LightBindingClass.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    @NotNull
    public PsiField[] getFields() {
        if (this.myPsiFields == null) {
            this.myPsiFields = this.computeFields();
        }
        if (this.myPsiFields == null) {
            LightBindingClass.$$$reportNull$$$0(4);
        }
        return this.myPsiFields;
    }

    @Override
    @NotNull
    public PsiField[] getAllFields() {
        PsiField[] psiFieldArray = this.getFields();
        if (psiFieldArray == null) {
            LightBindingClass.$$$reportNull$$$0(5);
        }
        return psiFieldArray;
    }

    @Override
    @NotNull
    public PsiMethod[] getConstructors() {
        if (this.myPsiConstructors == null) {
            this.myPsiConstructors = new PsiMethod[]{this.createConstructor()};
        }
        if (this.myPsiConstructors == null) {
            LightBindingClass.$$$reportNull$$$0(6);
        }
        return this.myPsiConstructors;
    }

    @Override
    @NotNull
    public PsiMethod[] getMethods() {
        if (this.myPsiMethods == null) {
            this.myPsiMethods = this.computeMethods();
        }
        if (this.myPsiMethods == null) {
            LightBindingClass.$$$reportNull$$$0(7);
        }
        return this.myPsiMethods;
    }

    @Override
    @NotNull
    public PsiClass[] getSupers() {
        if (this.myPsiSupers == null) {
            PsiClass superClass = this.getSuperClass();
            this.myPsiSupers = superClass != null ? new PsiClass[]{superClass} : PsiClass.EMPTY_ARRAY;
        }
        if (this.myPsiSupers == null) {
            LightBindingClass.$$$reportNull$$$0(8);
        }
        return this.myPsiSupers;
    }

    @Override
    public PsiClass getSuperClass() {
        return JavaPsiFacade.getInstance((Project)this.getProject()).findClass(this.myConfig.getSuperName(), this.getModuleScope());
    }

    @Override
    public PsiReferenceList getExtendsList() {
        if (this.myExtendsList == null) {
            PsiElementFactory factory2 = PsiElementFactory.getInstance((Project)this.getProject());
            PsiJavaCodeReferenceElement referenceElementByType = factory2.createReferenceElementByType(this.getExtendsListTypes()[0]);
            this.myExtendsList = factory2.createReferenceList(new PsiJavaCodeReferenceElement[]{referenceElementByType});
        }
        return this.myExtendsList;
    }

    @Override
    @NotNull
    public PsiClassType[] getSuperTypes() {
        PsiClassType[] psiClassTypeArray = this.getExtendsListTypes();
        if (psiClassTypeArray == null) {
            LightBindingClass.$$$reportNull$$$0(9);
        }
        return psiClassTypeArray;
    }

    @Override
    @NotNull
    public PsiClassType[] getExtendsListTypes() {
        if (this.myExtendsListTypes == null) {
            this.myExtendsListTypes = new PsiClassType[]{PsiType.getTypeByName((String)this.myConfig.getSuperName(), (Project)this.getProject(), (GlobalSearchScope)this.getModuleScope())};
        }
        if (this.myExtendsListTypes == null) {
            LightBindingClass.$$$reportNull$$$0(10);
        }
        return this.myExtendsListTypes;
    }

    @Override
    @NotNull
    public PsiMethod[] getAllMethods() {
        if (this.myPsiAllMethods == null) {
            PsiClass superClass = this.getSuperClass();
            this.myPsiAllMethods = superClass != null ? (PsiMethod[])ObjectArrays.concat((Object[])superClass.getAllMethods(), (Object[])this.getMethods(), PsiMethod.class) : this.getMethods();
        }
        if (this.myPsiAllMethods == null) {
            LightBindingClass.$$$reportNull$$$0(11);
        }
        return this.myPsiAllMethods;
    }

    @Override
    @NotNull
    public PsiMethod[] findMethodsByName(@NonNls String name, boolean checkBases) {
        PsiMethod[] methods2;
        ArrayList<PsiMethod> matched = null;
        for (PsiMethod method2 : methods2 = checkBases ? this.getAllMethods() : this.getMethods()) {
            if (!name.equals(method2.getName())) continue;
            if (matched == null) {
                matched = new ArrayList<PsiMethod>();
            }
            matched.add(method2);
        }
        PsiMethod[] psiMethodArray = matched == null ? PsiMethod.EMPTY_ARRAY : matched.toArray(PsiMethod.EMPTY_ARRAY);
        if (psiMethodArray == null) {
            LightBindingClass.$$$reportNull$$$0(12);
        }
        return psiMethodArray;
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        boolean continueProcessing;
        if (processor == null) {
            LightBindingClass.$$$reportNull$$$0(13);
        }
        if (state == null) {
            LightBindingClass.$$$reportNull$$$0(14);
        }
        if (place == null) {
            LightBindingClass.$$$reportNull$$$0(15);
        }
        if (!(continueProcessing = super.processDeclarations(processor, state, lastParent, place))) {
            return false;
        }
        Collection<ImportData> imports = this.myConfig.getTargetLayout().getData().getImports();
        if (imports.isEmpty()) {
            return true;
        }
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        if (classHint != null && classHint.shouldProcess(ElementClassHint.DeclarationKind.CLASS)) {
            NameHint nameHint = (NameHint)processor.getHint(NameHint.KEY);
            String name = nameHint != null ? nameHint.getName(state) : null;
            for (ImportData anImport : imports) {
                PsiClass aClass;
                if (anImport.getAlias() != null) continue;
                String qName = anImport.getType();
                if (name != null && !qName.endsWith(name) || (aClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(qName, this.getModuleScope())) == null || processor.execute((PsiElement)aClass, state)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    private GlobalSearchScope getModuleScope() {
        GlobalSearchScope globalSearchScope = ProjectSystemUtil.getModuleSystem(this.myConfig.getFacet()).getResolveScope(ScopeType.MAIN);
        if (globalSearchScope == null) {
            LightBindingClass.$$$reportNull$$$0(16);
        }
        return globalSearchScope;
    }

    private void createRootOverride(@NotNull List<PsiMethod> outPsiMethods) {
        XmlFile xmlFile;
        if (outPsiMethods == null) {
            LightBindingClass.$$$reportNull$$$0(17);
        }
        if ((xmlFile = this.myConfig.getTargetLayout().toXmlFile()) == null) {
            return;
        }
        BindingXmlData xmlData = this.myConfig.getTargetLayout().getData();
        if (xmlData.getLayoutType() == BindingLayoutType.PLAIN_LAYOUT && ViewBindingUtil.isViewBindingEnabled(this.myConfig.getFacet())) {
            XmlTag xmlRootTag = xmlFile.getRootTag();
            if (xmlRootTag == null) {
                return;
            }
            String rootTag = this.myConfig.getRootType();
            PsiType type = LayoutBindingTypeUtil.resolveViewPsiType(rootTag, (PsiElement)this);
            if (type != null) {
                DeprecatableLightMethodBuilder rootMethod = this.createPublicMethod("getRoot", type);
                outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)xmlRootTag, this.getManager(), (PsiMethod)rootMethod, this, (Language)JavaLanguage.INSTANCE));
            }
        }
    }

    private void createVariableMethods(@NotNull Pair<VariableData, XmlTag> variableTag, @NotNull List<PsiMethod> outPsiMethods) {
        if (variableTag == null) {
            LightBindingClass.$$$reportNull$$$0(18);
        }
        if (outPsiMethods == null) {
            LightBindingClass.$$$reportNull$$$0(19);
        }
        PsiManager psiManager = this.getManager();
        VariableData variable = (VariableData)variableTag.getFirst();
        XmlTag xmlTag = (XmlTag)variableTag.getSecond();
        String typeName = variable.getType();
        String variableType = DataBindingUtil.getQualifiedType(this.getProject(), typeName, this.myConfig.getTargetLayout().getData(), true);
        if (variableType == null) {
            return;
        }
        PsiType type = LayoutBindingTypeUtil.parsePsiType(variableType, (PsiElement)xmlTag);
        if (type == null) {
            return;
        }
        String javaName = DataBindingUtil.convertVariableNameToJavaFieldName(variable.getName());
        String capitalizedName = StringUtil.capitalize((String)javaName);
        DeprecatableLightMethodBuilder setter = this.createPublicMethod("set" + capitalizedName, (PsiType)PsiType.VOID);
        setter.addParameter(javaName, type);
        if (this.myConfig.settersShouldBeAbstract()) {
            setter.addModifier("abstract");
        }
        outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)xmlTag, psiManager, (PsiMethod)setter, this, (Language)JavaLanguage.INSTANCE));
        if (this.myConfig.shouldGenerateGettersAndStaticMethods()) {
            DeprecatableLightMethodBuilder getter = this.createPublicMethod("get" + capitalizedName, type);
            outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)xmlTag, psiManager, (PsiMethod)getter, this, (Language)JavaLanguage.INSTANCE));
        }
    }

    private void createStaticMethods(@NotNull List<PsiMethod> outPsiMethods) {
        XmlFile xmlFile;
        if (outPsiMethods == null) {
            LightBindingClass.$$$reportNull$$$0(20);
        }
        if ((xmlFile = this.myConfig.getTargetLayout().toXmlFile()) == null) {
            return;
        }
        Project project = this.getProject();
        GlobalSearchScope moduleScope = this.getModuleScope();
        PsiClassType bindingType = PsiElementFactory.getInstance((Project)this.getProject()).createType((PsiClass)this);
        PsiClassType viewGroupType = PsiType.getTypeByName((String)"android.view.ViewGroup", (Project)project, (GlobalSearchScope)moduleScope);
        PsiClassType inflaterType = PsiType.getTypeByName((String)"android.view.LayoutInflater", (Project)project, (GlobalSearchScope)moduleScope);
        PsiClassType viewType = PsiType.getTypeByName((String)"android.view.View", (Project)project, (GlobalSearchScope)moduleScope);
        PsiClassType dataBindingComponentType = PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)moduleScope);
        ArrayList<DeprecatableLightMethodBuilder> methods2 = new ArrayList<DeprecatableLightMethodBuilder>();
        BindingXmlData xmlData = this.myConfig.getTargetLayout().getData();
        if (xmlData.getLayoutType() == BindingLayoutType.DATA_BINDING_LAYOUT) {
            DeprecatableLightMethodBuilder inflate4Params = this.createPublicStaticMethod("inflate", (PsiType)bindingType, NullabilityType.NONNULL);
            inflate4Params.addNullabilityParameter("inflater", (PsiType)inflaterType, true);
            inflate4Params.addNullabilityParameter("root", (PsiType)viewGroupType, false);
            inflate4Params.addParameter("attachToRoot", (PsiType)PsiType.BOOLEAN);
            inflate4Params.addNullabilityParameter("bindingComponent", (PsiType)dataBindingComponentType, false);
            inflate4Params.setDeprecated(true);
            DeprecatableLightMethodBuilder inflate3Params = this.createPublicStaticMethod("inflate", (PsiType)bindingType, NullabilityType.NONNULL);
            inflate3Params.addNullabilityParameter("inflater", (PsiType)inflaterType, true);
            inflate3Params.addNullabilityParameter("root", (PsiType)viewGroupType, false);
            inflate3Params.addParameter("attachToRoot", (PsiType)PsiType.BOOLEAN);
            DeprecatableLightMethodBuilder deprecatableLightMethodBuilder = this.createPublicStaticMethod("inflate", (PsiType)bindingType, NullabilityType.NONNULL);
            deprecatableLightMethodBuilder.addNullabilityParameter("inflater", (PsiType)inflaterType, true);
            deprecatableLightMethodBuilder.addNullabilityParameter("bindingComponent", (PsiType)dataBindingComponentType, false);
            deprecatableLightMethodBuilder.setDeprecated(true);
            DeprecatableLightMethodBuilder inflate1Param = this.createPublicStaticMethod("inflate", (PsiType)bindingType, NullabilityType.NONNULL);
            inflate1Param.addNullabilityParameter("inflater", (PsiType)inflaterType, true);
            DeprecatableLightMethodBuilder bind2 = this.createPublicStaticMethod("bind", (PsiType)bindingType, NullabilityType.NONNULL);
            bind2.addNullabilityParameter("view", (PsiType)viewType, true);
            DeprecatableLightMethodBuilder bindWithComponent = this.createPublicStaticMethod("bind", (PsiType)bindingType, NullabilityType.NONNULL);
            bindWithComponent.addNullabilityParameter("view", (PsiType)viewType, true);
            bindWithComponent.addNullabilityParameter("bindingComponent", (PsiType)dataBindingComponentType, false);
            bindWithComponent.setDeprecated(true);
            methods2.add(inflate1Param);
            methods2.add(deprecatableLightMethodBuilder);
            methods2.add(inflate3Params);
            methods2.add(inflate4Params);
            methods2.add(bind2);
            methods2.add(bindWithComponent);
        } else {
            assert (xmlData.getLayoutType() == BindingLayoutType.PLAIN_LAYOUT && ViewBindingUtil.isViewBindingEnabled(this.myConfig.getFacet()));
            if (!xmlData.getRootTag().equals("merge")) {
                DeprecatableLightMethodBuilder inflate3Params = this.createPublicStaticMethod("inflate", (PsiType)bindingType, NullabilityType.NONNULL);
                inflate3Params.addNullabilityParameter("inflater", (PsiType)inflaterType, true);
                inflate3Params.addNullabilityParameter("parent", (PsiType)viewGroupType, false);
                inflate3Params.addParameter("attachToParent", (PsiType)PsiType.BOOLEAN);
                DeprecatableLightMethodBuilder inflate1Param = this.createPublicStaticMethod("inflate", (PsiType)bindingType, NullabilityType.NONNULL);
                inflate1Param.addNullabilityParameter("inflater", (PsiType)inflaterType, true);
                methods2.add(inflate1Param);
                methods2.add(inflate3Params);
            } else {
                DeprecatableLightMethodBuilder inflate2Params = this.createPublicStaticMethod("inflate", (PsiType)bindingType, NullabilityType.NONNULL);
                inflate2Params.addNullabilityParameter("inflater", (PsiType)inflaterType, true);
                inflate2Params.addNullabilityParameter("parent", (PsiType)viewGroupType, true);
                methods2.add(inflate2Params);
            }
            DeprecatableLightMethodBuilder bind3 = this.createPublicStaticMethod("bind", (PsiType)bindingType, NullabilityType.NONNULL);
            bind3.addNullabilityParameter("view", (PsiType)viewType, true);
            methods2.add(bind3);
        }
        PsiManager psiManager = this.getManager();
        for (PsiMethod psiMethod : methods2) {
            outPsiMethods.add((PsiMethod)new LightDataBindingMethod((PsiElement)xmlFile, psiManager, psiMethod, this, (Language)JavaLanguage.INSTANCE));
        }
    }

    @NotNull
    private DeprecatableLightMethodBuilder createPublicStaticMethod(@NotNull String name, @NotNull PsiType returnType, @NotNull NullabilityType nullabilityType) {
        if (name == null) {
            LightBindingClass.$$$reportNull$$$0(21);
        }
        if (returnType == null) {
            LightBindingClass.$$$reportNull$$$0(22);
        }
        if (nullabilityType == null) {
            LightBindingClass.$$$reportNull$$$0(23);
        }
        DeprecatableLightMethodBuilder method2 = this.createPublicMethod(name, returnType, nullabilityType);
        method2.addModifier("static");
        DeprecatableLightMethodBuilder deprecatableLightMethodBuilder = method2;
        if (deprecatableLightMethodBuilder == null) {
            LightBindingClass.$$$reportNull$$$0(24);
        }
        return deprecatableLightMethodBuilder;
    }

    @NotNull
    private DeprecatableLightMethodBuilder createPublicMethod(@NotNull String name, @NotNull PsiType returnType) {
        if (name == null) {
            LightBindingClass.$$$reportNull$$$0(25);
        }
        if (returnType == null) {
            LightBindingClass.$$$reportNull$$$0(26);
        }
        return this.createPublicMethod(name, returnType, NullabilityType.UNSPECIFIED);
    }

    @NotNull
    private DeprecatableLightMethodBuilder createPublicMethod(@NotNull String name, @NotNull PsiType returnType, @NotNull NullabilityType nullabilityType) {
        if (name == null) {
            LightBindingClass.$$$reportNull$$$0(27);
        }
        if (returnType == null) {
            LightBindingClass.$$$reportNull$$$0(28);
        }
        if (nullabilityType == null) {
            LightBindingClass.$$$reportNull$$$0(29);
        }
        DeprecatableLightMethodBuilder method2 = new DeprecatableLightMethodBuilder(this.getManager(), (Language)JavaLanguage.INSTANCE, name);
        method2.setContainingClass((PsiClass)this);
        if (nullabilityType == NullabilityType.UNSPECIFIED) {
            method2.setMethodReturnType(returnType);
        } else {
            method2.setMethodReturnType(returnType, !nullabilityType.isNullable());
        }
        method2.addModifier("public");
        DeprecatableLightMethodBuilder deprecatableLightMethodBuilder = method2;
        if (deprecatableLightMethodBuilder == null) {
            LightBindingClass.$$$reportNull$$$0(30);
        }
        return deprecatableLightMethodBuilder;
    }

    @Nullable
    private PsiField createPsiField(@NotNull ViewIdData viewIdData, boolean isNonNull) {
        if (viewIdData == null) {
            LightBindingClass.$$$reportNull$$$0(31);
        }
        String name = DataBindingUtil.convertAndroidIdToJavaFieldName(viewIdData.getId());
        PsiType type = LayoutBindingTypeUtil.resolveViewPsiType(viewIdData, (PsiElement)this);
        if (type == null) {
            return null;
        }
        NullabilityLightFieldBuilder field2 = new NullabilityLightFieldBuilder(PsiManager.getInstance((Project)this.getProject()), name, type, isNonNull, new String[]{"public", "final"});
        return new LightDataBindingField(this.myConfig.getTargetLayout(), viewIdData, this.getManager(), (PsiField)field2, this);
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @NotNull
    public PsiElement getNavigationElement() {
        XmlFile xmlFile = this.myConfig.getTargetLayout().toXmlFile();
        if (xmlFile == null) {
            PsiElement psiElement = super.getNavigationElement();
            if (psiElement == null) {
                LightBindingClass.$$$reportNull$$$0(32);
            }
            return psiElement;
        }
        return new BindingLayoutFile(this, xmlFile);
    }

    @NotNull
    public String getName() {
        String string = this.myConfig.getClassName();
        if (string == null) {
            LightBindingClass.$$$reportNull$$$0(33);
        }
        return string;
    }

    @Override
    @Nullable
    public PsiFile getContainingFile() {
        return this.myBackingFile;
    }

    public boolean isValid() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 24: 
            case 30: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 24: 
            case 30: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 24: 
            case 30: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/databinding/psiclass/LightBindingClass";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outPsiMethods";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableTag";
                break;
            }
            case 21: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 22: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
            case 23: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullabilityType";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewIdData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/databinding/psiclass/LightBindingClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConstructor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFields";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructors";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupers";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperTypes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtendsListTypes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMethods";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findMethodsByName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleScope";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createPublicStaticMethod";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createPublicMethod";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationElement";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 24: 
            case 30: 
            case 32: 
            case 33: {
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processDeclarations";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createRootOverride";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createVariableMethods";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createStaticMethods";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createPublicStaticMethod";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "createPublicMethod";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createPsiField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 24: 
            case 30: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LightDataBindingField
    extends LightField {
        private final BindingLayout myLayout;
        private final ViewIdData myViewIdData;
        @Nullable
        private XmlTag myNavigationTag;

        public LightDataBindingField(@NotNull BindingLayout layout2, @NotNull ViewIdData viewIdData, @NotNull PsiManager manager, @NotNull PsiField field2, @NotNull PsiClass containingClass) {
            if (layout2 == null) {
                LightDataBindingField.$$$reportNull$$$0(0);
            }
            if (viewIdData == null) {
                LightDataBindingField.$$$reportNull$$$0(1);
            }
            if (manager == null) {
                LightDataBindingField.$$$reportNull$$$0(2);
            }
            if (field2 == null) {
                LightDataBindingField.$$$reportNull$$$0(3);
            }
            if (containingClass == null) {
                LightDataBindingField.$$$reportNull$$$0(4);
            }
            super(manager, field2, containingClass);
            this.myNavigationTag = null;
            this.myLayout = layout2;
            this.myViewIdData = viewIdData;
        }

        @Nullable
        private XmlTag computeTag() {
            XmlFile xmlFile = this.myLayout.toXmlFile();
            if (xmlFile == null) {
                return null;
            }
            final Ref resultTag = new Ref();
            xmlFile.accept((PsiElementVisitor)new XmlRecursiveElementWalkingVisitor(){

                public void visitXmlTag(XmlTag tag) {
                    super.visitXmlTag(tag);
                    String idValue = tag.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
                    if (idValue != null && myViewIdData.getId().equals(ResourcesUtil.stripPrefixFromId((String)idValue))) {
                        resultTag.set((Object)tag);
                        this.stopWalking();
                    }
                }
            });
            return (XmlTag)resultTag.get();
        }

        @Nullable
        public PsiFile getContainingFile() {
            return this.myLayout.toXmlFile();
        }

        public TextRange getTextRange() {
            return TextRange.EMPTY_RANGE;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            if (this.myNavigationTag != null) {
                XmlTag xmlTag = this.myNavigationTag;
                if (xmlTag == null) {
                    LightDataBindingField.$$$reportNull$$$0(5);
                }
                return xmlTag;
            }
            this.myNavigationTag = this.computeTag();
            Object object = this.myNavigationTag != null ? this.myNavigationTag : super.getNavigationElement();
            if (object == null) {
                LightDataBindingField.$$$reportNull$$$0(6);
            }
            return object;
        }

        @NotNull
        public PsiElement setName(@NotNull String name) {
            if (name == null) {
                LightDataBindingField.$$$reportNull$$$0(7);
            }
            LightDataBindingField lightDataBindingField = this;
            if (lightDataBindingField == null) {
                LightDataBindingField.$$$reportNull$$$0(8);
            }
            return lightDataBindingField;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "layout";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "viewIdData";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingClass";
                    break;
                }
                case 5: 
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/databinding/psiclass/LightBindingClass$LightDataBindingField";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/databinding/psiclass/LightBindingClass$LightDataBindingField";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 8: {
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class LightDataBindingMethod
    extends LightMethod {
        private PsiElement myNavigationElement;

        public LightDataBindingMethod(@NotNull PsiElement navigationElement, @NotNull PsiManager manager, @NotNull PsiMethod method2, @NotNull PsiClass containingClass, @NotNull Language language) {
            if (navigationElement == null) {
                LightDataBindingMethod.$$$reportNull$$$0(0);
            }
            if (manager == null) {
                LightDataBindingMethod.$$$reportNull$$$0(1);
            }
            if (method2 == null) {
                LightDataBindingMethod.$$$reportNull$$$0(2);
            }
            if (containingClass == null) {
                LightDataBindingMethod.$$$reportNull$$$0(3);
            }
            if (language == null) {
                LightDataBindingMethod.$$$reportNull$$$0(4);
            }
            super(manager, method2, containingClass, language);
            this.myNavigationElement = navigationElement;
        }

        public TextRange getTextRange() {
            return TextRange.EMPTY_RANGE;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myNavigationElement;
            if (psiElement == null) {
                LightDataBindingMethod.$$$reportNull$$$0(5);
            }
            return psiElement;
        }

        public PsiIdentifier getNameIdentifier() {
            return new LightIdentifier(this.getManager(), this.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "navigationElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "manager";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingClass";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/databinding/psiclass/LightBindingClass$LightDataBindingMethod";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/databinding/psiclass/LightBindingClass$LightDataBindingMethod";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum NullabilityType {
        UNSPECIFIED,
        NONNULL,
        NULLABLE;


        public boolean isNullable() {
            return this == NULLABLE;
        }
    }
}

