/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.psiclass;

import com.android.tools.idea.databinding.BindingLayout;
import com.android.tools.idea.databinding.BindingLayoutGroup;
import com.android.tools.idea.databinding.index.BindingLayoutType;
import com.android.tools.idea.databinding.index.BindingXmlData;
import com.android.tools.idea.databinding.index.BindingXmlIndex;
import com.android.tools.idea.databinding.index.VariableData;
import com.android.tools.idea.databinding.index.ViewIdData;
import com.android.tools.idea.databinding.module.LayoutBindingModuleCache;
import com.android.tools.idea.databinding.psiclass.LightBindingClassConfig;
import com.android.tools.idea.databinding.psiclass.LightBindingClassConfigKt;
import com.android.tools.idea.databinding.util.ViewBindingUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020%H\u0016R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0014\u0010\u000f\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR&\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\nR\u0014\u0010\u001a\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR&\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f0\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/databinding/psiclass/BindingClassConfig;", "Lcom/android/tools/idea/databinding/psiclass/LightBindingClassConfig;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "group", "Lcom/android/tools/idea/databinding/BindingLayoutGroup;", "(Lorg/jetbrains/android/facet/AndroidFacet;Lcom/android/tools/idea/databinding/BindingLayoutGroup;)V", "className", "", "getClassName", "()Ljava/lang/String;", "getFacet", "()Lorg/jetbrains/android/facet/AndroidFacet;", "qualifiedName", "getQualifiedName", "rootType", "getRootType", "scopedViewIds", "", "Lcom/android/tools/idea/databinding/BindingLayout;", "", "Lcom/android/tools/idea/databinding/index/ViewIdData;", "getScopedViewIds", "()Ljava/util/Map;", "superName", "getSuperName", "targetLayout", "getTargetLayout", "()Lcom/android/tools/idea/databinding/BindingLayout;", "variableTags", "", "Lkotlin/Pair;", "Lcom/android/tools/idea/databinding/index/VariableData;", "Lcom/intellij/psi/xml/XmlTag;", "getVariableTags", "()Ljava/util/List;", "settersShouldBeAbstract", "", "shouldGenerateGettersAndStaticMethods", "intellij.android.databinding"})
public final class BindingClassConfig
implements LightBindingClassConfig {
    @NotNull
    private final String className;
    @NotNull
    private final String qualifiedName;
    @NotNull
    private final AndroidFacet facet;
    private final BindingLayoutGroup group;

    @Override
    @NotNull
    public BindingLayout getTargetLayout() {
        return this.group.getMainLayout();
    }

    @Override
    @NotNull
    public String getSuperName() {
        String string;
        if (this.getTargetLayout().getData().getLayoutType() == BindingLayoutType.DATA_BINDING_LAYOUT) {
            string = LayoutBindingModuleCache.Companion.getInstance((AndroidFacet)this.getFacet()).getDataBindingMode().viewDataBinding;
        } else {
            Module module2 = this.getFacet().getModule();
            Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
            Project project = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"facet.module.project");
            string = ViewBindingUtil.getViewBindingClassName(project);
        }
        return string;
    }

    @Override
    @NotNull
    public String getClassName() {
        return this.className;
    }

    @Override
    @NotNull
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    @NotNull
    public String getRootType() {
        boolean bl;
        String mainTag;
        block4: {
            mainTag = this.group.getMainLayout().getData().getRootTag();
            Iterable $this$all$iv = this.group.getLayouts();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    BindingLayout it = (BindingLayout)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)it.getData().getRootTag(), (Object)mainTag)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (bl) {
            return mainTag;
        }
        return "View";
    }

    @Override
    @NotNull
    public List<Pair<VariableData, XmlTag>> getVariableTags() {
        return LightBindingClassConfigKt.access$getAggregatedVariables(this.group);
    }

    @Override
    @NotNull
    public Map<BindingLayout, Collection<ViewIdData>> getScopedViewIds() {
        boolean bl = false;
        Map viewIds = new LinkedHashMap();
        for (BindingLayout layout2 : this.group.getLayouts()) {
            BindingXmlData xmlData;
            XmlFile xmlFile;
            if (layout2.toXmlFile() == null) {
                continue;
            }
            if (BindingXmlIndex.Companion.getDataForFile((PsiFile)xmlFile) == null) {
                continue;
            }
            viewIds.put(layout2, xmlData.getViewIds());
        }
        return viewIds;
    }

    @Override
    public boolean shouldGenerateGettersAndStaticMethods() {
        return true;
    }

    @Override
    public boolean settersShouldBeAbstract() {
        return this.group.getLayouts().size() > 1;
    }

    @Override
    @NotNull
    public AndroidFacet getFacet() {
        return this.facet;
    }

    public BindingClassConfig(@NotNull AndroidFacet facet2, @NotNull BindingLayoutGroup group2) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)((Object)group2), (String)"group");
        this.facet = facet2;
        this.group = group2;
        this.className = this.group.getMainLayout().getClassName();
        this.qualifiedName = this.group.getMainLayout().getQualifiedClassName();
    }
}

