/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.databinding.analytics;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.databinding.LayoutBindingEnabledFacetsProvider;
import com.android.tools.idea.databinding.analytics.api.DataBindingTracker;
import com.android.tools.idea.databinding.index.BindingLayoutType;
import com.android.tools.idea.databinding.index.BindingXmlData;
import com.android.tools.idea.databinding.index.BindingXmlIndex;
import com.android.tools.idea.databinding.util.DataBindingUtil;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.tools.idea.util.ModuleExtensionsKt;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.DataBindingEvent;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

@VisibleForTesting
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bH\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000eH\u0016J$\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/databinding/analytics/LayoutBindingTracker;", "Lcom/android/tools/idea/databinding/analytics/api/DataBindingTracker;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "enabledFacetsProvider", "Lcom/android/tools/idea/databinding/LayoutBindingEnabledFacetsProvider;", "createStudioEventBuilder", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "kotlin.jvm.PlatformType", "isDataBindingEnabled", "", "isViewBindingEnabled", "runInBackground", "", "runnable", "Ljava/lang/Runnable;", "trackDataBindingCompletion", "eventType", "Lcom/google/wireless/android/sdk/stats/DataBindingEvent$EventType;", "context", "Lcom/google/wireless/android/sdk/stats/DataBindingEvent$DataBindingContext;", "trackPolledMetaData", "trackPollingEvent", "dataBindingMetadata", "Lcom/google/wireless/android/sdk/stats/DataBindingEvent$DataBindingPollMetadata;", "viewBindingMetaData", "Lcom/google/wireless/android/sdk/stats/DataBindingEvent$ViewBindingPollMetadata;", "trackUserEvent", "TrackPollingMetadataTask", "intellij.android.databinding"})
public class LayoutBindingTracker
implements DataBindingTracker {
    private final LayoutBindingEnabledFacetsProvider enabledFacetsProvider;
    private final Project project;

    @Override
    public void trackPolledMetaData() {
        Collection collection2 = this.enabledFacetsProvider.getAllBindingEnabledFacets();
        boolean bl = false;
        if (!collection2.isEmpty()) {
            this.runInBackground(new TrackPollingMetadataTask(this.project));
        }
    }

    @Override
    public void trackDataBindingCompletion(@NotNull DataBindingEvent.EventType eventType, @NotNull DataBindingEvent.DataBindingContext context) {
        Intrinsics.checkNotNullParameter((Object)eventType, (String)"eventType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.isDataBindingEnabled()) {
            this.trackUserEvent(eventType, context);
        }
    }

    private final boolean isDataBindingEnabled() {
        Collection collection2 = this.enabledFacetsProvider.getDataBindingEnabledFacets();
        boolean bl = false;
        return !collection2.isEmpty();
    }

    private final boolean isViewBindingEnabled() {
        Collection collection2 = this.enabledFacetsProvider.getViewBindingEnabledFacets();
        boolean bl = false;
        return !collection2.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    private final void trackUserEvent(DataBindingEvent.EventType eventType, DataBindingEvent.DataBindingContext context) {
        AndroidStudioEvent.Builder studioEventBuilder;
        void $this$apply;
        AndroidStudioEvent.Builder builder2 = this.createStudioEventBuilder();
        boolean bl = false;
        boolean bl2 = false;
        AndroidStudioEvent.Builder $this$apply2 = builder2;
        boolean bl3 = false;
        DataBindingEvent.Builder builder3 = DataBindingEvent.newBuilder();
        boolean bl4 = false;
        boolean bl5 = false;
        DataBindingEvent.Builder builder4 = builder3;
        AndroidStudioEvent.Builder builder5 = $this$apply2;
        boolean bl6 = false;
        $this$apply.setType(eventType);
        void v0 = $this$apply;
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"this");
        v0.setContext(context);
        Unit unit = Unit.INSTANCE;
        builder5.setDataBindingEvent(builder3.build());
        AndroidStudioEvent.Builder builder6 = studioEventBuilder = builder2;
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"studioEventBuilder");
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(builder6, this.project));
    }

    /*
     * WARNING - void declaration
     */
    private final void trackPollingEvent(DataBindingEvent.EventType eventType, DataBindingEvent.DataBindingPollMetadata dataBindingMetadata, DataBindingEvent.ViewBindingPollMetadata viewBindingMetaData) {
        AndroidStudioEvent.Builder studioEventBuilder;
        void $this$apply;
        AndroidStudioEvent.Builder builder2 = this.createStudioEventBuilder();
        boolean bl = false;
        boolean bl2 = false;
        AndroidStudioEvent.Builder $this$apply2 = builder2;
        boolean bl3 = false;
        DataBindingEvent.Builder builder3 = DataBindingEvent.newBuilder();
        boolean bl4 = false;
        boolean bl5 = false;
        DataBindingEvent.Builder builder4 = builder3;
        AndroidStudioEvent.Builder builder5 = $this$apply2;
        boolean bl6 = false;
        $this$apply.setType(eventType);
        $this$apply.setPollMetadata(dataBindingMetadata);
        $this$apply.setViewBindingMetadata(viewBindingMetaData);
        Unit unit = Unit.INSTANCE;
        builder5.setDataBindingEvent(builder3.build());
        AndroidStudioEvent.Builder builder6 = studioEventBuilder = builder2;
        Intrinsics.checkNotNullExpressionValue((Object)builder6, (String)"studioEventBuilder");
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId(builder6, this.project));
    }

    protected void runInBackground(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        ApplicationManager.getApplication().executeOnPooledThread(runnable2);
    }

    private final AndroidStudioEvent.Builder createStudioEventBuilder() {
        return AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.DATA_BINDING);
    }

    public LayoutBindingTracker(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.enabledFacetsProvider = LayoutBindingEnabledFacetsProvider.Companion.getInstance(this.project);
    }

    public static final /* synthetic */ void access$trackPollingEvent(LayoutBindingTracker $this, DataBindingEvent.EventType eventType, DataBindingEvent.DataBindingPollMetadata dataBindingMetadata, DataBindingEvent.ViewBindingPollMetadata viewBindingMetaData) {
        $this.trackPollingEvent(eventType, dataBindingMetadata, viewBindingMetaData);
    }

    public static final /* synthetic */ boolean access$isDataBindingEnabled(LayoutBindingTracker $this) {
        return $this.isDataBindingEnabled();
    }

    public static final /* synthetic */ boolean access$isViewBindingEnabled(LayoutBindingTracker $this) {
        return $this.isViewBindingEnabled();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/databinding/analytics/LayoutBindingTracker$TrackPollingMetadataTask;", "Ljava/lang/Runnable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/android/tools/idea/databinding/analytics/LayoutBindingTracker;Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "run", "", "intellij.android.databinding"})
    private final class TrackPollingMetadataTask
    implements Runnable {
        @NotNull
        private final Project project;

        @Override
        public void run() {
            DumbService.getInstance((Project)this.project).runReadActionInSmartMode(new Runnable(this){
                final /* synthetic */ TrackPollingMetadataTask this$0;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    int n;
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    Module[] $this$count$iv;
                    Iterable $this$apply;
                    Object element$iv22;
                    void $this$forEach$iv;
                    BindingXmlData bindingXmlData;
                    int n7;
                    int n2;
                    E element$iv$iv;
                    void $this$mapNotNullTo$iv$iv2;
                    Iterable $this$mapNotNull$iv2;
                    Object it;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    int dataBindingLayoutCount = 0;
                    int viewBindingLayoutCount = 0;
                    int importCount = 0;
                    int variableCount = 0;
                    Collection collection2 = FileTypeIndex.getFiles((FileType)((FileType)XmlFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)this.this$0.getProject()));
                    Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"FileTypeIndex\n          \u2026pe.projectScope(project))");
                    Iterable iterable = collection2;
                    boolean $i$f$filter = false;
                    Iterator<T> iterator = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv2 : $this$filterTo$iv$iv) {
                        it = (VirtualFile)element$iv$iv2;
                        boolean bl = false;
                        VirtualFile virtualFile = it;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                        if (!BindingXmlIndex.Companion.acceptsFile(virtualFile)) continue;
                        destination$iv$iv.add(element$iv$iv2);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$mapNotNull = false;
                    $this$filterTo$iv$iv = $this$mapNotNull$iv2;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
                    boolean $i$f$forEach = false;
                    it = $this$forEach$iv$iv$iv.iterator();
                    while (it.hasNext()) {
                        E element$iv$iv$iv;
                        element$iv$iv = element$iv$iv$iv = it.next();
                        boolean bl = false;
                        VirtualFile it2 = (VirtualFile)element$iv$iv;
                        boolean bl2 = false;
                        Project project = this.this$0.getProject();
                        VirtualFile virtualFile = it2;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                        if (BindingXmlIndex.Companion.getDataForFile(project, virtualFile) == null) continue;
                        n2 = 0;
                        n7 = 0;
                        BindingXmlData it$iv$iv = bindingXmlData;
                        boolean bl22 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv2 = (List)destination$iv$iv;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv22 : $this$forEach$iv) {
                        int n5;
                        BindingXmlData layoutInfo = (BindingXmlData)element$iv22;
                        boolean bl5 = false;
                        if (layoutInfo.getLayoutType() == BindingLayoutType.DATA_BINDING_LAYOUT) {
                            n5 = dataBindingLayoutCount;
                            dataBindingLayoutCount = n5 + 1;
                            importCount += layoutInfo.getImports().size();
                            variableCount += layoutInfo.getVariables().size();
                            continue;
                        }
                        if (layoutInfo.getLayoutType() != BindingLayoutType.PLAIN_LAYOUT || layoutInfo.getViewBindingIgnore()) continue;
                        n5 = viewBindingLayoutCount;
                        viewBindingLayoutCount = n5 + 1;
                    }
                    iterable = DataBindingEvent.DataBindingPollMetadata.newBuilder();
                    boolean bl = false;
                    boolean bl3 = false;
                    element$iv22 = iterable;
                    DataBindingEvent.EventType eventType = DataBindingEvent.EventType.DATA_BINDING_BUILD_EVENT;
                    LayoutBindingTracker layoutBindingTracker = this.this$0.LayoutBindingTracker.this;
                    boolean bl4 = false;
                    $this$apply.setDataBindingEnabled(LayoutBindingTracker.access$isDataBindingEnabled(this.this$0.LayoutBindingTracker.this));
                    $this$apply.setLayoutXmlCount(dataBindingLayoutCount);
                    void v4 = $this$apply;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"this");
                    v4.setImportCount(importCount);
                    $this$apply.setVariableCount(variableCount);
                    ModuleManager moduleManager = ModuleManager.getInstance((Project)this.this$0.getProject());
                    Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                    Module[] moduleArray = moduleManager.getModules();
                    Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
                    Module[] bl5 = moduleArray;
                    void var11_16 = $this$apply;
                    boolean $i$f$count = false;
                    int count$iv232 = 0;
                    element$iv$iv = $this$count$iv;
                    int n3 = ((E)element$iv$iv).length;
                    for (int it2 = 0; it2 < n3; ++it2) {
                        E element$iv3;
                        E it3 = element$iv3 = element$iv$iv[it2];
                        boolean bl6 = false;
                        E e = it3;
                        Intrinsics.checkNotNullExpressionValue(e, (String)"it");
                        if (!(ModuleExtensionsKt.getAndroidFacet(e) != null)) continue;
                        ++count$iv232;
                    }
                    n7 = count$iv232;
                    var11_16.setModuleCount(n7);
                    ModuleManager moduleManager2 = ModuleManager.getInstance((Project)this.this$0.getProject());
                    Intrinsics.checkNotNullExpressionValue((Object)moduleManager2, (String)"ModuleManager.getInstance(project)");
                    Module[] moduleArray2 = moduleManager2.getModules();
                    Intrinsics.checkNotNullExpressionValue((Object)moduleArray2, (String)"ModuleManager.getInstance(project).modules");
                    $this$count$iv = moduleArray2;
                    var11_16 = $this$apply;
                    boolean $i$f$mapNotNull2 = false;
                    void count$iv232 = $this$mapNotNull$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean bl6 = false;
                    void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach3 = false;
                    bindingXmlData = $this$forEach$iv$iv$iv2;
                    n2 = ((BindingXmlData)bindingXmlData).length;
                    for (int j = 0; j < n2; ++j) {
                        AndroidFacet androidFacet;
                        BindingXmlData element$iv$iv$iv;
                        BindingXmlData element$iv$iv3 = element$iv$iv$iv = bindingXmlData[j];
                        boolean bl7 = false;
                        BindingXmlData it4 = element$iv$iv3;
                        boolean bl8 = false;
                        BindingXmlData bindingXmlData2 = it4;
                        Intrinsics.checkNotNullExpressionValue((Object)bindingXmlData2, (String)"it");
                        if (ModuleExtensionsKt.getAndroidFacet((Module)bindingXmlData2) == null) continue;
                        boolean bl9 = false;
                        boolean bl10 = false;
                        AndroidFacet it$iv$iv = androidFacet;
                        boolean bl11 = false;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    List list = (List)destination$iv$iv2;
                    $this$mapNotNull$iv = list;
                    $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (T t : $this$count$iv) {
                            AndroidFacet it5 = (AndroidFacet)t;
                            boolean bl12 = false;
                            if (!DataBindingUtil.isDataBindingEnabled(it5)) continue;
                            int n4 = ++count$iv;
                            boolean bl11 = false;
                            if (n4 >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    int n5 = n;
                    var11_16.setDataBindingEnabledModuleCount(n5);
                    Unit unit = Unit.INSTANCE;
                    DataBindingEvent.DataBindingPollMetadata dataBindingPollMetadata = iterable.build();
                    iterable = DataBindingEvent.ViewBindingPollMetadata.newBuilder();
                    bl = false;
                    bl3 = false;
                    $this$apply = iterable;
                    unit = dataBindingPollMetadata;
                    boolean bl14 = false;
                    $this$apply.setViewBindingEnabled(LayoutBindingTracker.access$isViewBindingEnabled(this.this$0.LayoutBindingTracker.this));
                    $this$apply.setLayoutXmlCount(viewBindingLayoutCount);
                    Unit unit2 = Unit.INSTANCE;
                    LayoutBindingTracker.access$trackPollingEvent(layoutBindingTracker, eventType, (DataBindingEvent.DataBindingPollMetadata)unit, iterable.build());
                }
                {
                    this.this$0 = trackPollingMetadataTask;
                }
            });
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public TrackPollingMetadataTask(Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }
    }
}

