/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.resources.ScreenSize;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.configurations.ThemeUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.model.ActivityAttributesSnapshot;
import com.android.tools.idea.model.AndroidManifestIndex;
import com.android.tools.idea.model.AndroidManifestIndexQueryUtils;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.MergedManifestManager;
import com.android.tools.idea.model.MergedManifestSnapshot;
import com.android.tools.idea.run.activity.DefaultActivityLocator;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000v\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001aE\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u00112\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u00152\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00180\u0017\"\u00020\u0018\u00a2\u0006\u0002\u0010\u0019\u001a,\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u000e\b\u0002\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0002\u001a9\u0010\u001e\u001a\r\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\u001f0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u0011H\u0002\u001a1\u0010!\u001a\r\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\u001f0\u001b2\u0006\u0010\"\u001a\u00020\u00132\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u0011\u001a\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\"\u001a\u00020\u0013\u001a1\u0010$\u001a\r\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\u001f0\u001b2\u0006\u0010\"\u001a\u00020\u00132\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u0011\u001a\u0014\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\"\u001a\u00020\u0013\u001a\u0010\u0010&\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u0001H\u0000\u001a1\u0010'\u001a\r\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\u001f0\u001b2\u0006\u0010\"\u001a\u00020\u00132\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u0011\u001a\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\"\u001a\u00020\u0013\u001a\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0002\u001a.\u0010*\u001a\u0010\u0012\f\u0012\n +*\u0004\u0018\u00010\u00010\u00010\u001b2\u0006\u0010\n\u001a\u00020\u000b2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015H\u0007\u001a1\u0010,\u001a\r\u0012\t\u0012\u00070\u0001\u00a2\u0006\u0002\b\u001f0\u001b2\u0006\u0010\"\u001a\u00020\u00132\u0016\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000ej\u0002`\u0011\u001a\u0014\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\"\u001a\u00020\u0013\u001a\u0010\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00010\u0015*\u00020/\u001a\f\u00100\u001a\u0004\u0018\u00010\u0001*\u00020/\u001a(\u00101\u001a\u00020\u0001*\u00020/2\b\u00102\u001a\u0004\u0018\u0001032\b\u00104\u001a\u0004\u0018\u0001052\b\u00106\u001a\u0004\u0018\u000107\u001a\u0014\u00108\u001a\u0004\u0018\u00010\u0001*\u00020/2\u0006\u00109\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000*\"\u0010:\"\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a8\u0006;"}, d2={"ANDROID_THEME", "", "ANDROID_THEME_PREFIX", "MAX_RECENTLY_USED_THEMES", "", "PROJECT_THEME", "PROJECT_THEME_PREFIX", "RECENTLY_USED_THEMES_PROPERTY", "addRecentlyUsedTheme", "", "project", "Lcom/intellij/openapi/project/Project;", "theme", "createFilter", "Lkotlin/Function1;", "Lcom/android/tools/idea/editors/theme/datamodels/ConfiguredThemeEditorStyle;", "", "Lcom/android/tools/idea/configurations/ThemeStyleFilter;", "resolver", "Lcom/android/tools/idea/editors/theme/ThemeResolver;", "excludedNames", "", "baseThemes", "", "Lcom/android/ide/common/rendering/api/StyleResourceValue;", "(Lcom/android/tools/idea/editors/theme/ThemeResolver;Ljava/util/Set;[Lcom/android/ide/common/rendering/api/StyleResourceValue;)Lkotlin/jvm/functions/Function1;", "getFilteredByPrefixSortedByName", "", "themes", "excludedPrefixes", "getFilteredNames", "Lorg/jetbrains/annotations/NotNull;", "filter", "getFrameworkThemeNames", "themeResolver", "getFrameworkThemes", "getLibraryThemeNames", "getLibraryThemes", "getPreferredThemeName", "getProjectThemeNames", "getProjectThemes", "getPublicThemes", "getRecentlyUsedThemes", "kotlin.jvm.PlatformType", "getRecommendedThemeNames", "getRecommendedThemes", "getAllActivityThemeNames", "Lcom/intellij/openapi/module/Module;", "getAppThemeName", "getDefaultTheme", "renderingTarget", "Lcom/android/sdklib/IAndroidTarget;", "screenSize", "Lcom/android/resources/ScreenSize;", "device", "Lcom/android/sdklib/devices/Device;", "getThemeNameForActivity", "activityFqcn", "ThemeStyleFilter", "intellij.android.core"})
@JvmName(name="ThemeUtils")
public final class ThemeUtils {
    private static final String ANDROID_THEME = "android:Theme";
    private static final String ANDROID_THEME_PREFIX = "android:Theme.";
    private static final String PROJECT_THEME_PREFIX = "Theme.";
    private static final String PROJECT_THEME = "Theme";
    private static final String RECENTLY_USED_THEMES_PROPERTY = "android.recentlyUsedThemes";
    private static final int MAX_RECENTLY_USED_THEMES = 5;

    @NotNull
    public static final String getPreferredThemeName(@NotNull String theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        if (Intrinsics.areEqual((Object)theme, (Object)ANDROID_THEME) || Intrinsics.areEqual((Object)theme, (Object)PROJECT_THEME)) {
            return PROJECT_THEME;
        }
        return StringsKt.removePrefix((String)StringsKt.removePrefix((String)StringsKt.removePrefix((String)theme, (CharSequence)ANDROID_THEME_PREFIX), (CharSequence)PROJECT_THEME_PREFIX), (CharSequence)"@style/");
    }

    @NotNull
    public static final Function1<ConfiguredThemeEditorStyle, Boolean> createFilter(@NotNull ThemeResolver resolver, @NotNull Set<String> excludedNames, StyleResourceValue ... baseThemes) {
        Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
        Intrinsics.checkNotNullParameter(excludedNames, (String)"excludedNames");
        Intrinsics.checkNotNullParameter((Object)baseThemes, (String)"baseThemes");
        StyleResourceValue[] styleResourceValueArray = baseThemes;
        boolean bl = false;
        if (styleResourceValueArray.length == 0) {
            return (Function1)new Function1<ConfiguredThemeEditorStyle, Boolean>(excludedNames){
                final /* synthetic */ Set $excludedNames;

                public final boolean invoke(@NotNull ConfiguredThemeEditorStyle style) {
                    Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                    return !this.$excludedNames.contains(style.getQualifiedName());
                }
                {
                    this.$excludedNames = set;
                    super(1);
                }
            };
        }
        return (Function1)new Function1<ConfiguredThemeEditorStyle, Boolean>(excludedNames, resolver, baseThemes){
            final /* synthetic */ Set $excludedNames;
            final /* synthetic */ ThemeResolver $resolver;
            final /* synthetic */ StyleResourceValue[] $baseThemes;

            public final boolean invoke(@NotNull ConfiguredThemeEditorStyle style) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                return !this.$excludedNames.contains(style.getQualifiedName()) && this.$resolver.themeIsChildOfAny((StyleResourceValue)style.getStyleResourceValue(), Arrays.copyOf(this.$baseThemes, this.$baseThemes.length));
            }
            {
                this.$excludedNames = set;
                this.$resolver = themeResolver;
                this.$baseThemes = styleResourceValueArray;
                super(1);
            }
        };
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getFrameworkThemes(@NotNull ThemeResolver themeResolver) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = themeResolver.getFrameworkThemes();
        Intrinsics.checkNotNullExpressionValue(immutableList, (String)"themeResolver.frameworkThemes");
        return ThemeUtils.getFilteredByPrefixSortedByName$default(ThemeUtils.getPublicThemes((List)immutableList), null, 2, null);
    }

    @NotNull
    public static final List<String> getFrameworkThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Function1<? super ConfiguredThemeEditorStyle, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        return ThemeUtils.getFilteredNames(ThemeUtils.getFrameworkThemes(themeResolver), filter2);
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getProjectThemes(@NotNull ThemeResolver themeResolver) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = themeResolver.getLocalThemes();
        Intrinsics.checkNotNullExpressionValue(immutableList, (String)"themeResolver.localThemes");
        return ThemeUtils.getFilteredByPrefixSortedByName$default(ThemeUtils.getPublicThemes((List)immutableList), null, 2, null);
    }

    @NotNull
    public static final List<String> getProjectThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Function1<? super ConfiguredThemeEditorStyle, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        return ThemeUtils.getFilteredNames(ThemeUtils.getProjectThemes(themeResolver), filter2);
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getLibraryThemes(@NotNull ThemeResolver themeResolver) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = themeResolver.getExternalLibraryThemes();
        Intrinsics.checkNotNullExpressionValue(immutableList, (String)"themeResolver.externalLibraryThemes");
        return ThemeUtils.getFilteredByPrefixSortedByName(ThemeUtils.getPublicThemes((List)immutableList), SetsKt.setOf((Object[])new String[]{"Base.", "Platform."}));
    }

    @NotNull
    public static final List<String> getLibraryThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Function1<? super ConfiguredThemeEditorStyle, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        ImmutableList<ConfiguredThemeEditorStyle> immutableList = themeResolver.getExternalLibraryThemes();
        Intrinsics.checkNotNullExpressionValue(immutableList, (String)"themeResolver.externalLibraryThemes");
        return ThemeUtils.getFilteredNames(ThemeUtils.getPublicThemes((List)immutableList), filter2);
    }

    @NotNull
    public static final List<ConfiguredThemeEditorStyle> getRecommendedThemes(@NotNull ThemeResolver themeResolver) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        List<ResourceReference> list = themeResolver.getRecommendedThemes();
        Intrinsics.checkNotNullExpressionValue(list, (String)"themeResolver.recommendedThemes");
        List<ResourceReference> recommendedThemes = list;
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.sequenceOf((Object[])new List[]{ThemeUtils.getLibraryThemes(themeResolver), ThemeUtils.getFrameworkThemes(themeResolver)})), (Function1)((Function1)new Function1<ConfiguredThemeEditorStyle, Boolean>(recommendedThemes){
            final /* synthetic */ List $recommendedThemes;

            public final boolean invoke(@NotNull ConfiguredThemeEditorStyle it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$recommendedThemes.contains(it.getStyleReference());
            }
            {
                this.$recommendedThemes = list;
                super(1);
            }
        })));
    }

    @NotNull
    public static final List<String> getRecommendedThemeNames(@NotNull ThemeResolver themeResolver, @NotNull Function1<? super ConfiguredThemeEditorStyle, Boolean> filter2) {
        Intrinsics.checkNotNullParameter((Object)themeResolver, (String)"themeResolver");
        Intrinsics.checkNotNullParameter(filter2, (String)"filter");
        return ThemeUtils.getFilteredNames(ThemeUtils.getRecommendedThemes(themeResolver), filter2);
    }

    @JvmOverloads
    @NotNull
    public static final List<String> getRecentlyUsedThemes(@NotNull Project project, @NotNull Set<String> excludedNames) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(excludedNames, (String)"excludedNames");
        Object object = PropertiesComponent.getInstance((Project)project).getValues(RECENTLY_USED_THEMES_PROPERTY);
        if (object == null || (object = ArraysKt.asList((Object[])object)) == null || (object = CollectionsKt.minus((Iterable)((Iterable)object), (Iterable)excludedNames)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static /* synthetic */ List getRecentlyUsedThemes$default(Project project, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return ThemeUtils.getRecentlyUsedThemes(project, set);
    }

    @JvmOverloads
    @NotNull
    public static final List<String> getRecentlyUsedThemes(@NotNull Project project) {
        return ThemeUtils.getRecentlyUsedThemes$default(project, null, 2, null);
    }

    public static final void addRecentlyUsedTheme(@NotNull Project project, @NotNull String theme) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        Object object = PropertiesComponent.getInstance((Project)project).getValues(RECENTLY_USED_THEMES_PROPERTY);
        if (object == null || (object = ArraysKt.toSet((Object[])object)) == null) {
            object = SetsKt.emptySet();
        }
        Object old2 = object;
        Collection $this$toTypedArray$iv = CollectionsKt.take((Iterable)SetsKt.plus((Set)SetsKt.setOf((Object)theme), (Iterable)((Iterable)old2)), (int)5);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        String[] stringArray2 = stringArray;
        PropertiesComponent.getInstance((Project)project).setValues(RECENTLY_USED_THEMES_PROPERTY, stringArray2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConfiguredThemeEditorStyle> getPublicThemes(List<? extends ConfiguredThemeEditorStyle> themes) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = themes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConfiguredThemeEditorStyle it = (ConfiguredThemeEditorStyle)element$iv$iv;
            boolean bl = false;
            if (!it.isPublic()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ConfiguredThemeEditorStyle> getFilteredByPrefixSortedByName(List<? extends ConfiguredThemeEditorStyle> themes, Set<String> excludedPrefixes) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = themes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                ConfiguredThemeEditorStyle theme = (ConfiguredThemeEditorStyle)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$none$iv = excludedPrefixes;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String prefix = (String)element$iv;
                        boolean bl3 = false;
                        String string = theme.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"theme.name");
                        if (!StringsKt.startsWith$default((String)string, (String)prefix, (boolean)false, (int)2, null)) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ConfiguredThemeEditorStyle it = (ConfiguredThemeEditorStyle)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getQualifiedName());
                it = (ConfiguredThemeEditorStyle)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getQualifiedName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
    }

    static /* synthetic */ List getFilteredByPrefixSortedByName$default(List list, Set set, int n, Object object) {
        if ((n & 2) != 0) {
            set = SetsKt.emptySet();
        }
        return ThemeUtils.getFilteredByPrefixSortedByName(list, set);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> getFilteredNames(List<? extends ConfiguredThemeEditorStyle> themes, Function1<? super ConfiguredThemeEditorStyle, Boolean> filter2) {
        void $this$mapTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = themes;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)filter2.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConfiguredThemeEditorStyle configuredThemeEditorStyle = (ConfiguredThemeEditorStyle)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            String string = it.getQualifiedName();
            collection2.add(string);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final String getAppThemeName(@NotNull Module $this$getAppThemeName) {
        Intrinsics.checkNotNullParameter((Object)$this$getAppThemeName, (String)"$this$getAppThemeName");
        Boolean bl = AndroidManifestIndex.Companion.indexEnabled();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"AndroidManifestIndex.indexEnabled()");
        if (bl.booleanValue()) {
            try {
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)$this$getAppThemeName);
                if (facet2 != null) {
                    return (String)DumbService.getInstance((Project)$this$getAppThemeName.getProject()).runReadActionInSmartMode(new Computable(facet2){
                        final /* synthetic */ AndroidFacet $facet;

                        @Nullable
                        public final String compute() {
                            return AndroidManifestIndexQueryUtils.queryApplicationThemeFromManifestIndex(this.$facet);
                        }
                        {
                            this.$facet = androidFacet;
                        }
                    });
                }
            }
            catch (IndexNotReadyException e) {
                AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
            }
        }
        return MergedManifestManager.Companion.getFreshSnapshot($this$getAppThemeName).getManifestTheme();
    }

    @NotNull
    public static final Set<String> getAllActivityThemeNames(@NotNull Module $this$getAllActivityThemeNames) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllActivityThemeNames, (String)"$this$getAllActivityThemeNames");
        Boolean bl = AndroidManifestIndex.Companion.indexEnabled();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"AndroidManifestIndex.indexEnabled()");
        if (bl.booleanValue()) {
            try {
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)$this$getAllActivityThemeNames);
                if (facet2 != null) {
                    Object object = DumbService.getInstance((Project)$this$getAllActivityThemeNames.getProject()).runReadActionInSmartMode(new Computable(facet2){
                        final /* synthetic */ AndroidFacet $facet;

                        public final Set<String> compute() {
                            List<DefaultActivityLocator.ActivityWrapper> activities = AndroidManifestIndexQueryUtils.queryActivitiesFromManifestIndex(this.$facet).getActivities();
                            return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)activities), (Function1)getAllActivityThemeNames.1.INSTANCE));
                        }
                        {
                            this.$facet = androidFacet;
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DumbService.getInstance(\u2026      .toSet()\n        })");
                    return (Set)object;
                }
            }
            catch (IndexNotReadyException e) {
                AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
            }
        }
        MergedManifestSnapshot manifest = MergedManifestManager.Companion.getSnapshot($this$getAllActivityThemeNames);
        return SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)manifest.getActivityAttributesMap().values()), (Function1)getAllActivityThemeNames.2.INSTANCE));
    }

    @Nullable
    public static final String getThemeNameForActivity(@NotNull Module $this$getThemeNameForActivity, @NotNull String activityFqcn) {
        Object object;
        MergedManifestSnapshot manifest;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)$this$getThemeNameForActivity, (String)"$this$getThemeNameForActivity");
        Intrinsics.checkNotNullParameter((Object)activityFqcn, (String)"activityFqcn");
        Boolean bl = AndroidManifestIndex.Companion.indexEnabled();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"AndroidManifestIndex.indexEnabled()");
        if (bl.booleanValue()) {
            try {
                AndroidFacet facet2 = AndroidFacet.getInstance((Module)$this$getThemeNameForActivity);
                if (facet2 != null) {
                    return (String)DumbService.getInstance((Project)$this$getThemeNameForActivity.getProject()).runReadActionInSmartMode(new Computable(facet2, activityFqcn){
                        final /* synthetic */ AndroidFacet $facet;
                        final /* synthetic */ String $activityFqcn;

                        @Nullable
                        public final String compute() {
                            List<DefaultActivityLocator.ActivityWrapper> activities = AndroidManifestIndexQueryUtils.queryActivitiesFromManifestIndex(this.$facet).getActivities();
                            return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)activities), (Function1)((Function1)new Function1<DefaultActivityLocator.ActivityWrapper, Boolean>(this){
                                final /* synthetic */ getThemeNameForActivity.1 this$0;

                                public final boolean invoke(@NotNull DefaultActivityLocator.ActivityWrapper it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    return Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)this.this$0.$activityFqcn);
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }
                            })), (Function1)getThemeNameForActivity.2.INSTANCE), (Function1)getThemeNameForActivity.3.INSTANCE));
                        }
                        {
                            this.$facet = androidFacet;
                            this.$activityFqcn = string;
                        }
                    });
                }
            }
            catch (IndexNotReadyException e) {
                AndroidManifestIndexQueryUtils.logManifestIndexQueryError((Exception)((Object)e));
            }
        }
        if ((object2 = (manifest = MergedManifestManager.Companion.getSnapshot($this$getThemeNameForActivity)).getActivityAttributes(activityFqcn)) != null && (object2 = ((ActivityAttributesSnapshot)object2).getTheme()) != null) {
            Object object3 = object2;
            boolean bl2 = false;
            boolean bl3 = false;
            Object it = object3;
            boolean bl4 = false;
            Object object4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"it");
            object = StringsKt.startsWith$default((String)object4, (String)"@", (boolean)false, (int)2, null) ? object3 : null;
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public static final String getDefaultTheme(@NotNull Module $this$getDefaultTheme, @Nullable IAndroidTarget renderingTarget, @Nullable ScreenSize screenSize, @Nullable Device device) {
        Intrinsics.checkNotNullParameter((Object)$this$getDefaultTheme, (String)"$this$getDefaultTheme");
        if (device != null) {
            if (HardwareConfigHelper.isWear((Device)device)) {
                return "@android:style/Theme.DeviceDefault.Light";
            }
            if (HardwareConfigHelper.isTv((Device)device)) {
                return "@style/Theme.Leanback";
            }
        }
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)$this$getDefaultTheme);
        if (androidFacet == null) {
            return "@android:style/Theme.Material.Light";
        }
        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"AndroidFacet.getInstance\u2026 + \"Theme.Material.Light\"");
        AndroidFacet facet2 = androidFacet;
        AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(facet2);
        Intrinsics.checkNotNullExpressionValue((Object)androidModuleInfo, (String)"AndroidModuleInfo.getInstance(facet)");
        AndroidVersion androidVersion = androidModuleInfo.getTargetSdkVersion();
        Intrinsics.checkNotNullExpressionValue((Object)androidVersion, (String)"AndroidModuleInfo.getIns\u2026e(facet).targetSdkVersion");
        int targetSdk = androidVersion.getApiLevel();
        IAndroidTarget iAndroidTarget = renderingTarget;
        int renderingTargetSdk = iAndroidTarget != null && (iAndroidTarget = iAndroidTarget.getVersion()) != null ? iAndroidTarget.getApiLevel() : targetSdk;
        int apiLevel = RangesKt.coerceAtMost((int)targetSdk, (int)renderingTargetSdk);
        return "@android:style/" + (apiLevel >= 21 ? "Theme.Material.Light" : (apiLevel >= 14 || apiLevel >= 11 && screenSize == ScreenSize.XLARGE ? "Theme.Holo" : PROJECT_THEME));
    }
}

