/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ThemeSelectionDialog;
import com.android.tools.idea.configurations.ThemeUtils;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.editors.theme.ThemeResolver;
import com.android.tools.idea.editors.theme.datamodels.ConfiguredThemeEditorStyle;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.FilterComponent;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import icons.StudioIcons;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThemeSelectionPanel
implements TreeSelectionListener,
ListSelectionListener,
Disposable {
    private static final String DEVICE_LIGHT_PREFIX = "android:Theme.DeviceDefault.Light";
    private static final String DEVICE_PREFIX = "android:Theme.DeviceDefault";
    private static final String HOLO_LIGHT_PREFIX = "android:Theme.Holo.Light";
    private static final String HOLO_PREFIX = "android:Theme.Holo";
    private static final String MATERIAL_LIGHT_PREFIX = "android:Theme.Material.Light";
    private static final String MATERIAL_PREFIX = "android:Theme.Material";
    private static final String LIGHT_PREFIX = "android:Theme.Light";
    private static final String DIALOG_SUFFIX = ".Dialog";
    private static final String DIALOG_PART = ".Dialog.";
    private static final SimpleTextAttributes SEARCH_HIGHLIGHT_ATTRIBUTES = new SimpleTextAttributes(null, JBColor.MAGENTA, null, 1);
    @NotNull
    private final Configuration myConfiguration;
    @NotNull
    private final ThemeSelectionDialog myDialog;
    private JBList<String> myThemeList;
    private Tree myCategoryTree;
    private JPanel myContentPanel;
    private ThemeFilterComponent myFilter;
    @NotNull
    private final List<String> myFrameworkThemes;
    @NotNull
    private final List<String> myProjectThemes;
    @NotNull
    private final List<String> myLibraryThemes;
    @Nullable
    private static Deque<String> ourRecent;
    @Nullable
    private ThemeCategory myCategory;
    @NotNull
    private Map<ThemeCategory, List<String>> myThemeMap;
    @NotNull
    private final Set<String> myExcludedThemes;
    private boolean myIgnore;
    private ThemeChangedListener myThemeChangedListener;

    public ThemeSelectionPanel(@NotNull ThemeSelectionDialog dialog2, @NotNull Configuration configuration, @NotNull Set<String> excludedThemes) {
        if (dialog2 == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(0);
        }
        if (configuration == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(1);
        }
        if (excludedThemes == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(2);
        }
        this.myCategory = ThemeCategory.ALL;
        this.$$$setupUI$$$();
        this.myThemeMap = Maps.newEnumMap(ThemeCategory.class);
        this.myDialog = dialog2;
        this.myConfiguration = configuration;
        this.myExcludedThemes = excludedThemes;
        ThemeResolver themeResolver = new ThemeResolver(configuration);
        StyleResourceValue[] baseThemes = themeResolver.requiredBaseThemes();
        Function1<ConfiguredThemeEditorStyle, Boolean> filter2 = ThemeUtils.createFilter(themeResolver, this.myExcludedThemes, baseThemes);
        this.myFrameworkThemes = baseThemes.length == 0 ? ThemeUtils.getFrameworkThemeNames(themeResolver, filter2) : Collections.emptyList();
        this.myProjectThemes = ThemeUtils.getProjectThemeNames(themeResolver, filter2);
        this.myLibraryThemes = ThemeUtils.getLibraryThemeNames(themeResolver, filter2);
        String currentTheme = ResolutionUtils.getQualifiedNameFromResourceUrl(configuration.getTheme());
        ThemeSelectionPanel.touchTheme(currentTheme, this.myExcludedThemes);
        this.myCategoryTree.setModel((TreeModel)new CategoryModel());
        this.myCategoryTree.setRootVisible(false);
        this.myCategoryTree.getSelectionModel().setSelectionMode(1);
        this.myCategoryTree.addTreeSelectionListener((TreeSelectionListener)this);
        this.setInitialSelection(currentTheme);
        this.myThemeList.addListSelectionListener((ListSelectionListener)this);
        this.myThemeList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<String>(){

            protected void customizeCellRenderer(@NotNull JList list, String style, int index2, boolean selected, boolean hasFocus) {
                int matchIndex;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.setIcon(StudioIcons.Shell.Menu.THEME_EDITOR);
                String filter2 = ThemeSelectionPanel.this.myFilter.getFilter();
                style = ThemeUtils.getPreferredThemeName(style);
                if (!filter2.isEmpty() && (matchIndex = StringUtil.indexOfIgnoreCase((String)style, (String)filter2, (int)(index2 + 1))) != -1) {
                    if (matchIndex > 0) {
                        this.append(style.substring(0, matchIndex), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    int matchEnd = matchIndex + filter2.length();
                    this.append(style.substring(matchIndex, matchEnd), SEARCH_HIGHLIGHT_ATTRIBUTES);
                    if (matchEnd < style.length()) {
                        this.append(style.substring(matchEnd), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    }
                    return;
                }
                int lastDot = style.lastIndexOf(46);
                if (lastDot > 0) {
                    this.append(style.substring(0, lastDot + 1), SimpleTextAttributes.GRAY_ATTRIBUTES);
                    this.append(style.substring(lastDot + 1), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else {
                    this.append(style, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/android/tools/idea/configurations/ThemeSelectionPanel$1", "customizeCellRenderer"));
            }
        });
    }

    public void installDoubleClickListener(@NotNull DoubleClickListener listener2) {
        if (listener2 == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(3);
        }
        listener2.installOn(this.myThemeList);
    }

    public void setThemeChangedListener(@NotNull ThemeChangedListener themeChangedListener) {
        if (themeChangedListener == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(4);
        }
        this.myThemeChangedListener = themeChangedListener;
    }

    private void setInitialSelection(@Nullable String currentTheme) {
        if (currentTheme == null) {
            this.myCategoryTree.setSelectionRow(0);
            return;
        }
        if (currentTheme.startsWith(HOLO_LIGHT_PREFIX)) {
            this.selectCategory(ThemeCategory.HOLO_LIGHT, true);
        } else if (currentTheme.startsWith(HOLO_PREFIX)) {
            this.selectCategory(ThemeCategory.HOLO, true);
        }
        if (currentTheme.startsWith(MATERIAL_LIGHT_PREFIX)) {
            this.selectCategory(ThemeCategory.MATERIAL_LIGHT, true);
        } else if (currentTheme.startsWith(MATERIAL_PREFIX)) {
            this.selectCategory(ThemeCategory.MATERIAL, true);
        } else if (currentTheme.startsWith(DEVICE_PREFIX)) {
            this.selectCategory(ThemeCategory.DEVICE, true);
        } else if (currentTheme.startsWith("@style/")) {
            this.selectCategory(ThemeCategory.PROJECT, true);
        } else {
            this.selectCategory(ThemeCategory.ALL, true);
        }
        this.updateThemeList();
        this.myThemeList.setSelectedValue((Object)currentTheme, true);
    }

    private void selectCategory(ThemeCategory category, boolean updateList) {
        try {
            this.myIgnore = true;
            this.myCategoryTree.setSelectionPath(new TreePath((Object[])new ThemeCategory[]{ThemeCategory.ROOT, category}));
            this.myCategory = category;
        }
        finally {
            this.myIgnore = false;
        }
        if (updateList) {
            this.updateThemeList();
        }
    }

    @NotNull
    public JPanel getContentPanel() {
        JPanel jPanel = this.myContentPanel;
        if (jPanel == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @NotNull
    private List<String> getThemes(@Nullable ThemeCategory category) {
        if (category == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                ThemeSelectionPanel.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<String> themes = this.myThemeMap.get((Object)category);
        if (themes != null) {
            List<String> list = themes;
            if (list == null) {
                ThemeSelectionPanel.$$$reportNull$$$0(7);
            }
            return list;
        }
        themes = new ArrayList<String>(50);
        switch (category) {
            case RECENT: {
                if (ourRecent == null) break;
                themes.addAll(ourRecent);
                break;
            }
            case HOLO: {
                for (String theme : this.myFrameworkThemes) {
                    if (!theme.startsWith(HOLO_PREFIX) || theme.startsWith(HOLO_LIGHT_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case HOLO_LIGHT: {
                for (String theme : this.myFrameworkThemes) {
                    if (!theme.startsWith(HOLO_LIGHT_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case MATERIAL: {
                for (String theme : this.myFrameworkThemes) {
                    if (!theme.startsWith(MATERIAL_PREFIX) || theme.startsWith(MATERIAL_LIGHT_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case MATERIAL_LIGHT: {
                for (String theme : this.myFrameworkThemes) {
                    if (!theme.startsWith(MATERIAL_LIGHT_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case PROJECT: {
                themes.addAll(this.myProjectThemes);
                break;
            }
            case CLASSIC: {
                for (String theme : this.myFrameworkThemes) {
                    if (theme.startsWith(HOLO_PREFIX) || theme.startsWith(DEVICE_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case CLASSIC_LIGHT: {
                for (String theme : this.myFrameworkThemes) {
                    if (!theme.startsWith(LIGHT_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case LIGHT: {
                for (String theme : this.myFrameworkThemes) {
                    if (!theme.startsWith(HOLO_LIGHT_PREFIX) && !theme.startsWith(LIGHT_PREFIX) && !theme.startsWith(DEVICE_LIGHT_PREFIX) && !theme.startsWith(MATERIAL_LIGHT_PREFIX)) continue;
                    themes.add(theme);
                }
                for (String theme : this.myLibraryThemes) {
                    if (!theme.startsWith(HOLO_LIGHT_PREFIX) && !theme.startsWith(LIGHT_PREFIX) && !theme.startsWith(DEVICE_LIGHT_PREFIX) && !theme.startsWith(MATERIAL_LIGHT_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case DEVICE: {
                for (String theme : this.myFrameworkThemes) {
                    if (!theme.startsWith(DEVICE_PREFIX)) continue;
                    themes.add(theme);
                }
                break;
            }
            case DIALOGS: {
                for (String theme : this.myProjectThemes) {
                    if (!theme.endsWith(DIALOG_SUFFIX) && !theme.contains(DIALOG_PART)) continue;
                    themes.add(theme);
                }
                for (String theme : this.myFrameworkThemes) {
                    if (!theme.endsWith(DIALOG_SUFFIX) && !theme.contains(DIALOG_PART)) continue;
                    themes.add(theme);
                }
                for (String theme : this.myLibraryThemes) {
                    if (!theme.endsWith(DIALOG_SUFFIX) && !theme.contains(DIALOG_PART)) continue;
                    themes.add(theme);
                }
                break;
            }
            case MANIFEST: {
                ThemeSelectionPanel.collectThemesFromManifest(this.myConfiguration.getModule()).sorted().map(ResolutionUtils::getQualifiedNameFromResourceUrl).forEach(themes::add);
                break;
            }
            case ALL: {
                themes.addAll(this.myProjectThemes);
                themes.addAll(this.myFrameworkThemes);
                themes.addAll(this.myLibraryThemes);
                break;
            }
            default: {
                assert (false) : category;
                break;
            }
        }
        this.myThemeMap.put(category, themes);
        List<String> list = themes;
        if (list == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    private static Stream<String> collectThemesFromManifest(@NotNull Module module2) {
        if (module2 == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(9);
        }
        String appTheme = ThemeUtils.getAppThemeName(module2);
        Set<String> activityThemes = ThemeUtils.getAllActivityThemeNames(module2);
        if (appTheme != null && !activityThemes.contains(appTheme)) {
            Stream stream = Streams.concat((Stream[])new Stream[]{Stream.of(appTheme), activityThemes.stream()});
            if (stream == null) {
                ThemeSelectionPanel.$$$reportNull$$$0(10);
            }
            return stream;
        }
        Stream<String> stream = activityThemes.stream();
        if (stream == null) {
            ThemeSelectionPanel.$$$reportNull$$$0(11);
        }
        return stream;
    }

    private void updateThemeList() {
        if (this.myCategory == null) {
            return;
        }
        String selected = (String)this.myThemeList.getSelectedValue();
        SortedListModel model2 = new SortedListModel(String.CASE_INSENSITIVE_ORDER);
        String filter2 = this.myFilter.getFilter();
        List<String> themes = this.getThemes(this.myCategory);
        for (String theme : themes) {
            if (!ThemeSelectionPanel.matchesFilter(theme, filter2)) continue;
            model2.add((Object)theme);
        }
        this.myThemeList.setModel((ListModel)model2);
        if (selected != null) {
            this.myThemeList.setSelectedValue((Object)selected, true);
        } else if (model2.getSize() > 0) {
            this.myThemeList.setSelectedIndex(0);
        }
    }

    private static boolean matchesFilter(String theme, String filter2) {
        int index2 = theme.lastIndexOf(47);
        return filter2.isEmpty() || StringUtil.indexOfIgnoreCase((String)theme, (String)filter2, (int)(index2 + 1)) != -1;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String themeName;
        if (this.myIgnore) {
            return;
        }
        if (this.myThemeChangedListener != null && (themeName = this.getTheme()) != null) {
            this.myThemeChangedListener.themeChanged(themeName);
        }
        this.myDialog.checkValidation();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.myIgnore) {
            return;
        }
        TreePath path2 = treeSelectionEvent.getPath();
        if (path2 == null) {
            return;
        }
        this.myCategory = (ThemeCategory)((Object)path2.getLastPathComponent());
        this.updateThemeList();
        if (this.myThemeList.getModel().getSize() > 0) {
            this.myThemeList.setSelectedIndex(0);
        }
    }

    @Nullable
    public String getTheme() {
        String selected = (String)this.myThemeList.getSelectedValue();
        ThemeSelectionPanel.touchTheme(selected, this.myExcludedThemes);
        return selected;
    }

    private static void touchTheme(@Nullable String selected, Set<String> excludedThemes) {
        if (!(selected == null || ourRecent != null && ourRecent.contains(selected))) {
            if (ourRecent == null) {
                ourRecent = new LinkedList<String>();
            }
            if (!excludedThemes.contains(selected)) {
                ourRecent.addFirst(selected);
            }
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCategoryTree;
    }

    public void dispose() {
        this.myFilter.dispose();
    }

    public void focus() {
        Project project = this.myConfiguration.getModule().getProject();
        IdeFocusManager focusManager = project.isDefault() ? IdeFocusManager.getGlobalInstance() : IdeFocusManager.getInstance((Project)project);
        focusManager.doWhenFocusSettlesDown(() -> focusManager.requestFocus(this.myThemeList, true));
    }

    private static boolean haveMatches(String filter2, List<String> themes) {
        for (String theme : themes) {
            if (!ThemeSelectionPanel.matchesFilter(theme, filter2)) continue;
            return true;
        }
        return false;
    }

    private boolean haveAnyMatches(String filter2) {
        return ThemeSelectionPanel.haveMatches(filter2, this.myFrameworkThemes) || ThemeSelectionPanel.haveMatches(filter2, this.myProjectThemes);
    }

    private void createUIComponents() {
        this.myFilter = new ThemeFilterComponent("ANDROID_THEME_HISTORY", 10, true);
        this.myFilter.getTextEditor().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
                    ThemeSelectionPanel.this.myThemeList.dispatchEvent((AWTEvent)e);
                    e.consume();
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedThemes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "themeChangedListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/ThemeSelectionPanel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/ThemeSelectionPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentPanel";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getThemes";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectThemesFromManifest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "installDoubleClickListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setThemeChangedListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectThemesFromManifest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBList jBList;
        Tree tree;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myCategoryTree = tree = new Tree();
        jPanel.add((Component)tree, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 1, 2, 1, 0, 3, 3, 3, null, null, null));
        this.myThemeList = jBList = new JBList();
        jBScrollPane.setViewportView((Component)jBList);
        ThemeFilterComponent themeFilterComponent = this.myFilter;
        jPanel.add((Component)((Object)themeFilterComponent), new GridConstraints(0, 0, 1, 1, 1, 1, 3, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    public static interface ThemeChangedListener {
        public void themeChanged(@NotNull String var1);
    }

    private class ThemeFilterComponent
    extends FilterComponent {
        private ThemeFilterComponent(String propertyName, int historySize, boolean onTheFlyUpdate) {
            super(propertyName, historySize, onTheFlyUpdate);
        }

        public void filter() {
            String filter2 = this.getFilter();
            assert (filter2 != null);
            if (ThemeSelectionPanel.this.myCategory != ThemeCategory.ALL && !ThemeSelectionPanel.haveMatches(filter2, ThemeSelectionPanel.this.getThemes(ThemeSelectionPanel.this.myCategory)) && ThemeSelectionPanel.this.haveAnyMatches(filter2)) {
                ThemeSelectionPanel.this.selectCategory(ThemeCategory.ALL, false);
            }
            ThemeSelectionPanel.this.updateThemeList();
        }

        protected void onEscape(@NotNull KeyEvent event) {
            if (event == null) {
                ThemeFilterComponent.$$$reportNull$$$0(0);
            }
            ThemeSelectionPanel.this.focus();
            event.consume();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/configurations/ThemeSelectionPanel$ThemeFilterComponent", "onEscape"));
        }
    }

    private static enum ThemeCategory {
        ROOT(""),
        RECENT("Recent"),
        MANIFEST("Manifest Themes"),
        PROJECT("Project Themes"),
        MATERIAL_LIGHT("Material Light"),
        MATERIAL("Material Dark"),
        HOLO_LIGHT("Holo Light"),
        HOLO("Holo Dark"),
        CLASSIC("Classic"),
        CLASSIC_LIGHT("Classic Light"),
        DEVICE("Device Default"),
        DIALOGS("Dialogs"),
        LIGHT("Light"),
        ALL("All");

        private final String myName;

        private ThemeCategory(String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }
    }

    private class CategoryModel
    implements TreeModel {
        @NotNull
        private final Map<ThemeCategory, List<ThemeCategory>> myLabels = Maps.newHashMap();

        CategoryModel() {
            ArrayList<ThemeCategory> topLevel = new ArrayList<ThemeCategory>();
            if (ourRecent != null) {
                topLevel.add(ThemeCategory.RECENT);
            }
            this.addCategory(topLevel, ThemeCategory.MANIFEST);
            this.addCategory(topLevel, ThemeCategory.PROJECT);
            AndroidModuleInfo info2 = AndroidModuleInfo.getInstance(ThemeSelectionPanel.this.myConfiguration.getConfigurationManager().getModule());
            if (info2 != null && info2.getBuildSdkVersion() != null && info2.getBuildSdkVersion().getFeatureLevel() >= 21) {
                this.addCategory(topLevel, ThemeCategory.MATERIAL);
                this.addCategory(topLevel, ThemeCategory.MATERIAL_LIGHT);
            }
            this.addCategory(topLevel, ThemeCategory.HOLO);
            this.addCategory(topLevel, ThemeCategory.HOLO_LIGHT);
            if (info2 == null || info2.getMinSdkVersion().getFeatureLevel() <= 14) {
                this.addCategory(topLevel, ThemeCategory.CLASSIC);
                this.addCategory(topLevel, ThemeCategory.CLASSIC_LIGHT);
            }
            this.addCategory(topLevel, ThemeCategory.DEVICE);
            this.addCategory(topLevel, ThemeCategory.DIALOGS);
            this.addCategory(topLevel, ThemeCategory.LIGHT);
            this.addCategory(topLevel, ThemeCategory.ALL);
            this.myLabels.put(ThemeCategory.ROOT, topLevel);
        }

        private void addCategory(@NotNull List<ThemeCategory> categories, @NotNull ThemeCategory category) {
            if (categories == null) {
                CategoryModel.$$$reportNull$$$0(0);
            }
            if (category == null) {
                CategoryModel.$$$reportNull$$$0(1);
            }
            if (!ThemeSelectionPanel.this.getThemes(category).isEmpty()) {
                categories.add(category);
            }
        }

        @Override
        public Object getRoot() {
            return ThemeCategory.ROOT;
        }

        @Override
        public Object getChild(Object parent, int index2) {
            assert (parent instanceof ThemeCategory);
            return this.myLabels.get(parent).get(index2);
        }

        @Override
        public int getChildCount(Object parent) {
            assert (parent instanceof ThemeCategory);
            List<ThemeCategory> list = this.myLabels.get(parent);
            return list == null ? 0 : list.size();
        }

        @Override
        public boolean isLeaf(Object node2) {
            assert (node2 instanceof ThemeCategory);
            return this.myLabels.get(node2) == null;
        }

        @Override
        public void valueForPathChanged(TreePath path2, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            assert (parent instanceof ThemeCategory);
            assert (child instanceof ThemeCategory);
            List<ThemeCategory> list = this.myLabels.get(parent);
            return list == null ? -1 : list.indexOf(child);
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "categories";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "category";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/configurations/ThemeSelectionPanel$CategoryModel";
            objectArray[2] = "addCategory";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

