/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.Locale;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetMenuAction
extends DropDownAction {
    private static final int SHOW_FROM_API_LEVEL = 7;
    private final ConfigurationHolder myRenderContext;
    private final boolean myUseCompatibilityTarget;

    public TargetMenuAction(ConfigurationHolder renderContext, boolean useCompatibilityTarget) {
        super("API Version for Preview", "API Version for Preview", StudioIcons.LayoutEditor.Toolbar.ANDROID_API);
        boolean visible;
        this.myRenderContext = renderContext;
        this.myUseCompatibilityTarget = useCompatibilityTarget;
        Presentation presentation = this.getTemplatePresentation();
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            IAndroidTarget target = configuration.getTarget();
            String brief = TargetMenuAction.getRenderingTargetLabel(target, true);
            presentation.setText(brief);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    public TargetMenuAction(ConfigurationHolder renderContext) {
        this(renderContext, false);
    }

    public void update(@NotNull AnActionEvent e) {
        IAndroidTarget target;
        String brief;
        boolean visible;
        if (e == null) {
            TargetMenuAction.$$$reportNull$$$0(0);
        }
        Presentation presentation = e.getPresentation();
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible && !(brief = TargetMenuAction.getRenderingTargetLabel(target = configuration.getTarget(), true)).equals(presentation.getText())) {
            presentation.setText(brief, false);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private int getMinSdkVersion() {
        AndroidFacet facet2;
        Module module2;
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && (module2 = configuration.getModule()) != null && (facet2 = AndroidFacet.getInstance((Module)module2)) != null) {
            return AndroidModuleInfo.getInstance(facet2).getMinSdkVersion().getFeatureLevel();
        }
        return -1;
    }

    private void addCompatibilityTargets(@NotNull DefaultActionGroup group2) {
        if (group2 == null) {
            TargetMenuAction.$$$reportNull$$$0(1);
        }
        Configuration configuration = this.myRenderContext.getConfiguration();
        assert (configuration != null);
        IAndroidTarget currentTarget = configuration.getTarget();
        IAndroidTarget highestTarget = configuration.getConfigurationManager().getHighestApiTarget();
        assert (highestTarget != null);
        int highestApiLevel = highestTarget.getVersion().getFeatureLevel();
        int minApi = Math.max(this.getMinSdkVersion(), 7);
        for (int apiLevel = highestApiLevel; apiLevel >= minApi; --apiLevel) {
            CompatibilityRenderTarget target = new CompatibilityRenderTarget(highestTarget, apiLevel, null);
            boolean isSelected = currentTarget != null && target.getVersion().equals((Object)currentTarget.getVersion());
            group2.add((AnAction)new SetTargetAction(this.myRenderContext, target.getVersionName(), target, isSelected));
        }
    }

    private void addRealTargets(@NotNull DefaultActionGroup group2) {
        if (group2 == null) {
            TargetMenuAction.$$$reportNull$$$0(2);
        }
        Configuration configuration = this.myRenderContext.getConfiguration();
        assert (configuration != null);
        IAndroidTarget current = configuration.getTarget();
        IAndroidTarget[] targets = configuration.getConfigurationManager().getTargets();
        boolean haveRecent = false;
        int minSdk = this.getMinSdkVersion();
        for (int i2 = targets.length - 1; i2 >= 0; --i2) {
            AndroidVersion version2;
            IAndroidTarget target = targets[i2];
            if (!ConfigurationManager.isLayoutLibTarget(target) || (version2 = target.getVersion()).getFeatureLevel() < minSdk) continue;
            if (version2.getApiLevel() >= 7) {
                haveRecent = true;
            } else if (haveRecent) break;
            String title = TargetMenuAction.getRenderingTargetLabel(target, true);
            boolean select2 = current != null && target.getVersion().equals((Object)current.getVersion());
            group2.add((AnAction)new SetTargetAction(this.myRenderContext, title, target, select2));
        }
    }

    protected boolean updateActions(@NotNull DataContext context) {
        if (context == null) {
            TargetMenuAction.$$$reportNull$$$0(3);
        }
        this.removeAll();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return true;
        }
        this.add(new TogglePickBestAction(configuration.getConfigurationManager()));
        this.addSeparator();
        if (this.myUseCompatibilityTarget && configuration.getConfigurationManager().getHighestApiTarget() != null) {
            this.addCompatibilityTargets((DefaultActionGroup)this);
        } else {
            this.addRealTargets((DefaultActionGroup)this);
        }
        return true;
    }

    public static String getRenderingTargetLabel(@Nullable IAndroidTarget target, boolean brief) {
        if (target == null) {
            return "<null>";
        }
        AndroidVersion version2 = target.getVersion();
        if (brief) {
            if (target.isPlatform()) {
                String codename = version2.getCodename();
                if (codename != null && !codename.isEmpty()) {
                    if (codename.length() <= 3) {
                        return codename;
                    }
                    return Character.toString(codename.charAt(0));
                }
                return Integer.toString(version2.getApiLevel());
            }
            return target.getName() + ":" + Integer.toString(version2.getApiLevel());
        }
        return String.format(Locale.US, "API %1$d: %2$s", version2.getApiLevel(), target.getShortClasspathName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/configurations/TargetMenuAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addCompatibilityTargets";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addRealTargets";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "updateActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SetTargetAction
    extends ConfigurationAction {
        private final IAndroidTarget myTarget;

        public SetTargetAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull IAndroidTarget target, boolean select2) {
            if (renderContext == null) {
                SetTargetAction.$$$reportNull$$$0(0);
            }
            if (title == null) {
                SetTargetAction.$$$reportNull$$$0(1);
            }
            if (target == null) {
                SetTargetAction.$$$reportNull$$$0(2);
            }
            super(renderContext, title);
            this.myTarget = target;
            this.getTemplatePresentation().putClientProperty("selected", (Object)select2);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                SetTargetAction.$$$reportNull$$$0(3);
            }
            if (commit) {
                this.setProjectWideTarget();
            } else {
                configuration.setTarget(this.myTarget);
            }
        }

        @Override
        protected void pickedBetterMatch(@NotNull VirtualFile file2, @NotNull VirtualFile old2) {
            if (file2 == null) {
                SetTargetAction.$$$reportNull$$$0(4);
            }
            if (old2 == null) {
                SetTargetAction.$$$reportNull$$$0(5);
            }
            super.pickedBetterMatch(file2, old2);
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                this.setProjectWideTarget();
            }
        }

        private void setProjectWideTarget() {
            Configuration configuration = this.myRenderContext.getConfiguration();
            if (configuration != null) {
                configuration.getConfigurationManager().setTarget(this.myTarget);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "old";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/TargetMenuAction$SetTargetAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateConfiguration";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pickedBetterMatch";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TogglePickBestAction
    extends AnAction
    implements Toggleable {
        private final ConfigurationManager myManager;

        TogglePickBestAction(ConfigurationManager manager) {
            super("Automatically Pick Best");
            this.myManager = manager;
            if (manager.getStateManager().getProjectState().isPickTarget()) {
                this.getTemplatePresentation().putClientProperty("selected", (Object)true);
            }
        }

        private boolean isSelected() {
            return this.myManager.getStateManager().getProjectState().isPickTarget();
        }

        private void setSelected(boolean state) {
            this.myManager.getStateManager().getProjectState().setPickTarget(state);
            if (state) {
                this.myManager.setTarget(null);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                TogglePickBestAction.$$$reportNull$$$0(0);
            }
            this.setSelected(!this.isSelected());
        }

        public void update(@NotNull AnActionEvent event) {
            if (event == null) {
                TogglePickBestAction.$$$reportNull$$$0(1);
            }
            Presentation presentation = event.getPresentation();
            Toggleable.setSelected((Presentation)presentation, (boolean)this.isSelected());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "com/android/tools/idea/configurations/TargetMenuAction$TogglePickBestAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

