/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.SmallestScreenWidthQualifier;
import com.android.resources.ResourceFolderType;
import com.android.resources.ScreenOrientation;
import com.android.resources.UiMode;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.List;
import org.jetbrains.android.intentions.OverrideResourceAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OrientationMenuAction
extends DropDownAction {
    private final ConfigurationHolder myRenderContext;
    private final EditorDesignSurface mySurface;

    public OrientationMenuAction(@NotNull ConfigurationHolder renderContext, @Nullable EditorDesignSurface surface2) {
        if (renderContext == null) {
            OrientationMenuAction.$$$reportNull$$$0(0);
        }
        super("Orientation for Preview", "Orientation for Preview", StudioIcons.LayoutEditor.Toolbar.ROTATE_BUTTON);
        this.myRenderContext = renderContext;
        this.mySurface = surface2;
    }

    protected boolean updateActions(@NotNull DataContext context) {
        if (context == null) {
            OrientationMenuAction.$$$reportNull$$$0(1);
        }
        this.removeAll();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null) {
            Device device = configuration.getCachedDevice();
            if (device != null) {
                State currentDeviceState = configuration.getDeviceState();
                List states = device.getAllStates();
                for (State state : states) {
                    String stateName;
                    String title = stateName = state.getName();
                    VirtualFile better = ConfigurationMatcher.getBetterMatch(configuration, null, stateName, null, null);
                    if (better != null) {
                        title = ConfigurationAction.getBetterMatchLabel(stateName, better, configuration.getFile());
                    }
                    this.add(new SetDeviceStateAction(this.myRenderContext, title, state, state == currentDeviceState));
                }
            }
            this.addSeparator();
            DefaultActionGroup uiModeGroup = DefaultActionGroup.createPopupGroup(() -> "_UI Mode");
            UiMode currentUiMode = configuration.getUiMode();
            for (UiMode uiMode : UiMode.values()) {
                String title = uiMode.getShortDisplayValue();
                boolean checked = uiMode == currentUiMode;
                uiModeGroup.add((AnAction)new SetUiModeAction(this.myRenderContext, title, uiMode, checked));
            }
            this.add((AnAction)uiModeGroup);
            if (this.mySurface != null) {
                this.addSeparator();
                this.createVariationsActions(configuration, this.mySurface);
            }
        }
        return true;
    }

    private void createVariationsActions(@NotNull Configuration configuration, @NotNull EditorDesignSurface surface2) {
        VirtualFile virtualFile;
        if (configuration == null) {
            OrientationMenuAction.$$$reportNull$$$0(2);
        }
        if (surface2 == null) {
            OrientationMenuAction.$$$reportNull$$$0(3);
        }
        if ((virtualFile = configuration.getFile()) != null) {
            ResourceFolderType folderType;
            Module module2 = configuration.getModule();
            if (module2 == null) {
                return;
            }
            Project project = module2.getProject();
            List<VirtualFile> variations = IdeResourcesUtil.getResourceVariations(virtualFile, true);
            if (variations.size() > 1) {
                for (VirtualFile file2 : variations) {
                    String title = String.format("Switch to %1$s", file2.getParent().getName());
                    this.add(new SwitchToVariationAction(title, project, file2, virtualFile.equals(file2)));
                }
                this.addSeparator();
            }
            if ((folderType = IdeResourcesUtil.getFolderType(configuration.getFile())) == ResourceFolderType.LAYOUT) {
                boolean haveLandscape = false;
                boolean haveTablet = false;
                for (VirtualFile file3 : variations) {
                    SmallestScreenWidthQualifier size;
                    FolderConfiguration config;
                    String name = file3.getParent().getName();
                    if (!name.startsWith("layout") || (config = FolderConfiguration.getConfigForFolder((String)name)) == null) continue;
                    ScreenOrientationQualifier orientation = config.getScreenOrientationQualifier();
                    if (orientation != null && orientation.getValue() == ScreenOrientation.LANDSCAPE) {
                        haveLandscape = true;
                        if (haveTablet) break;
                    }
                    if ((size = config.getSmallestScreenWidthQualifier()) == null || size.getValue() < 600) continue;
                    haveTablet = true;
                    if (!haveLandscape) continue;
                    break;
                }
                if (!haveLandscape) {
                    this.add(new CreateVariationAction(surface2, "Create Landscape Variation", "layout-land"));
                }
                if (!haveTablet) {
                    this.add(new CreateVariationAction(surface2, "Create Tablet Variation", "layout-sw600dp"));
                }
                this.add(new CreateVariationAction(surface2, "Create Other...", null));
            } else {
                this.add(new CreateVariationAction(surface2, "Create Alternative...", null));
            }
        }
    }

    @NotNull
    public static ScreenOrientation getOrientation(@NotNull State state) {
        if (state == null) {
            OrientationMenuAction.$$$reportNull$$$0(4);
        }
        FolderConfiguration config = DeviceConfigHelper.getFolderConfig((State)state);
        ScreenOrientation orientation = null;
        if (config != null && config.getScreenOrientationQualifier() != null) {
            orientation = config.getScreenOrientationQualifier().getValue();
        }
        if (orientation == null) {
            orientation = ScreenOrientation.PORTRAIT;
        }
        ScreenOrientation screenOrientation = orientation;
        if (screenOrientation == null) {
            OrientationMenuAction.$$$reportNull$$$0(5);
        }
        return screenOrientation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/OrientationMenuAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/OrientationMenuAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrientation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateActions";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createVariationsActions";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getOrientation";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @VisibleForTesting
    static class CreateVariationAction
    extends AnAction {
        @NotNull
        private EditorDesignSurface mySurface;
        @Nullable
        private String myNewFolder;

        public CreateVariationAction(@NotNull EditorDesignSurface surface2, @NotNull String title, @Nullable String newFolder) {
            if (surface2 == null) {
                CreateVariationAction.$$$reportNull$$$0(0);
            }
            if (title == null) {
                CreateVariationAction.$$$reportNull$$$0(1);
            }
            super(title, null, null);
            this.mySurface = surface2;
            this.myNewFolder = newFolder;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CreateVariationAction.$$$reportNull$$$0(2);
            }
            OverrideResourceAction.forkResourceFile(this.mySurface, this.myNewFolder, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "surface";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/OrientationMenuAction$CreateVariationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class SwitchToVariationAction
    extends AnAction
    implements Toggleable {
        private final Project myProject;
        private final VirtualFile myFile;

        public SwitchToVariationAction(@NotNull String title, @NotNull Project project, @NotNull VirtualFile file2, boolean select2) {
            if (title == null) {
                SwitchToVariationAction.$$$reportNull$$$0(0);
            }
            if (project == null) {
                SwitchToVariationAction.$$$reportNull$$$0(1);
            }
            if (file2 == null) {
                SwitchToVariationAction.$$$reportNull$$$0(2);
            }
            super(title, null, null);
            this.myFile = file2;
            this.myProject = project;
            if (select2) {
                Presentation templatePresentation = this.getTemplatePresentation();
                templatePresentation.putClientProperty("selected", (Object)true);
                templatePresentation.setEnabled(false);
            }
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                SwitchToVariationAction.$$$reportNull$$$0(3);
            }
            OpenFileDescriptor descriptor2 = new OpenFileDescriptor(this.myProject, this.myFile, -1);
            FileEditorManager.getInstance((Project)this.myProject).openEditor(descriptor2, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/OrientationMenuAction$SwitchToVariationAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class SetUiModeAction
    extends ConfigurationAction {
        @NotNull
        private final UiMode myUiMode;

        private SetUiModeAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull UiMode uiMode, boolean checked) {
            if (renderContext == null) {
                SetUiModeAction.$$$reportNull$$$0(0);
            }
            if (title == null) {
                SetUiModeAction.$$$reportNull$$$0(1);
            }
            if (uiMode == null) {
                SetUiModeAction.$$$reportNull$$$0(2);
            }
            super(renderContext, title);
            this.myUiMode = uiMode;
            this.getTemplatePresentation().putClientProperty("selected", (Object)checked);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                SetUiModeAction.$$$reportNull$$$0(3);
            }
            configuration.setUiMode(this.myUiMode);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "uiMode";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/OrientationMenuAction$SetUiModeAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @VisibleForTesting
    static class SetDeviceStateAction
    extends ConfigurationAction {
        @NotNull
        private final State myState;

        private SetDeviceStateAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @NotNull State state, boolean isCurrentState) {
            if (renderContext == null) {
                SetDeviceStateAction.$$$reportNull$$$0(0);
            }
            if (title == null) {
                SetDeviceStateAction.$$$reportNull$$$0(1);
            }
            if (state == null) {
                SetDeviceStateAction.$$$reportNull$$$0(2);
            }
            super(renderContext, title);
            this.myState = state;
            this.getTemplatePresentation().putClientProperty("selected", (Object)isCurrentState);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                SetDeviceStateAction.$$$reportNull$$$0(3);
            }
            configuration.setDeviceState(this.myState);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/OrientationMenuAction$SetDeviceStateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

