/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.resources.NightMode;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.DeviceMenuAction;
import com.android.tools.idea.configurations.LocaleMenuAction;
import com.android.tools.idea.configurations.TargetMenuAction;
import com.android.tools.idea.rendering.Locale;
import com.google.common.base.MoreObjects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestedConfiguration
extends Configuration
implements ConfigurationListener {
    protected Configuration myParent;
    private int myOverride;

    protected NestedConfiguration(@NotNull Configuration configuration) {
        if (configuration == null) {
            NestedConfiguration.$$$reportNull$$$0(0);
        }
        super(configuration.getConfigurationManager(), configuration.getFile(), configuration.getEditedConfig());
        this.myParent = configuration;
        this.myFullConfig.set(this.myParent.myFullConfig);
        this.myParent.addListener(this);
    }

    public int getOverrideFlags() {
        return this.myOverride;
    }

    @NotNull
    public static NestedConfiguration create(@NotNull NestedConfiguration other, @NotNull Configuration values2, @NotNull Configuration parent) {
        if (other == null) {
            NestedConfiguration.$$$reportNull$$$0(1);
        }
        if (values2 == null) {
            NestedConfiguration.$$$reportNull$$$0(2);
        }
        if (parent == null) {
            NestedConfiguration.$$$reportNull$$$0(3);
        }
        NestedConfiguration configuration = new NestedConfiguration(parent);
        NestedConfiguration.initFrom(configuration, other, values2);
        NestedConfiguration nestedConfiguration = configuration;
        if (nestedConfiguration == null) {
            NestedConfiguration.$$$reportNull$$$0(4);
        }
        return nestedConfiguration;
    }

    protected static void initFrom(NestedConfiguration configuration, NestedConfiguration other, Configuration values2) {
        State deviceState;
        Device device;
        IAndroidTarget target;
        configuration.startBulkEditing();
        configuration.myOverride = other.myOverride;
        configuration.setDisplayName(values2.getDisplayName());
        String activity = values2.getActivity();
        if (activity != null) {
            configuration.setActivity(activity);
        }
        if (configuration.isOverridingLocale()) {
            configuration.setLocale(values2.getLocale());
        }
        if (configuration.isOverridingTarget() && (target = values2.getTarget()) != null) {
            configuration.setTarget(target);
        }
        if (configuration.isOverridingDevice() && (device = values2.getDevice()) != null) {
            configuration.setDevice(device, true);
        }
        if (configuration.isOverridingDeviceState() && (deviceState = values2.getDeviceState()) != null) {
            configuration.setDeviceState(deviceState);
        }
        if (configuration.isOverridingNightMode()) {
            configuration.setNightMode(values2.getNightMode());
        }
        if (configuration.isOverridingUiMode()) {
            configuration.setUiMode(values2.getUiMode());
        }
        configuration.finishBulkEditing();
    }

    public void setParent(@NotNull Configuration parent) {
        if (parent == null) {
            NestedConfiguration.$$$reportNull$$$0(5);
        }
        this.myParent = parent;
    }

    @NotNull
    public static NestedConfiguration create(@NotNull Configuration parent) {
        if (parent == null) {
            NestedConfiguration.$$$reportNull$$$0(6);
        }
        return new NestedConfiguration(parent);
    }

    @Override
    @NotNull
    public String getTheme() {
        if (this.isOverridingTarget()) {
            String string = super.getTheme();
            if (string == null) {
                NestedConfiguration.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = this.myParent.getTheme();
        if (string == null) {
            NestedConfiguration.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    public void setTheme(@Nullable String theme) {
        if (this.isOverridingTarget()) {
            super.setTheme(theme);
        } else {
            this.myParent.setTheme(theme);
        }
    }

    public void setOverrideLocale(boolean override) {
        this.myOverride = override ? (this.myOverride |= 0x10) : (this.myOverride &= 0xFFFFFFEF);
    }

    public final boolean isOverridingLocale() {
        return (this.myOverride & 0x10) != 0;
    }

    @Override
    @NotNull
    public Locale getLocale() {
        if (this.isOverridingLocale()) {
            Locale locale = super.getLocale();
            if (locale == null) {
                NestedConfiguration.$$$reportNull$$$0(9);
            }
            return locale;
        }
        Locale locale = this.myParent.getLocale();
        if (locale == null) {
            NestedConfiguration.$$$reportNull$$$0(10);
        }
        return locale;
    }

    @Override
    public void setLocale(@NotNull Locale locale) {
        if (locale == null) {
            NestedConfiguration.$$$reportNull$$$0(11);
        }
        if (this.isOverridingLocale()) {
            super.setLocale(locale);
        } else {
            this.myParent.setLocale(locale);
        }
    }

    public void setOverrideTarget(boolean override) {
        this.myOverride = override ? (this.myOverride |= 0x20) : (this.myOverride &= 0xFFFFFFDF);
    }

    public final boolean isOverridingTarget() {
        return (this.myOverride & 0x20) != 0;
    }

    @Override
    @Nullable
    public IAndroidTarget getTarget() {
        if (this.isOverridingTarget()) {
            return super.getTarget();
        }
        return this.myParent.getTarget();
    }

    @Override
    public void setTarget(IAndroidTarget target) {
        if (this.isOverridingTarget()) {
            super.setTarget(target);
        } else {
            this.myParent.setTarget(target);
        }
    }

    public void setOverrideDevice(boolean override) {
        this.myOverride = override ? (this.myOverride |= 2) : (this.myOverride &= 0xFFFFFFFD);
    }

    public final boolean isOverridingDevice() {
        return (this.myOverride & 2) != 0;
    }

    @Override
    @Nullable
    public Device getDevice() {
        if (this.isOverridingDevice()) {
            return super.getDevice();
        }
        return this.myParent.getDevice();
    }

    @Override
    public void setDevice(Device device, boolean preserveState) {
        if (this.isOverridingDevice()) {
            super.setDevice(device, preserveState);
        } else {
            this.myParent.setDevice(device, preserveState);
        }
    }

    public void setOverrideDeviceState(boolean override) {
        this.myOverride = override ? (this.myOverride |= 4) : (this.myOverride &= 0xFFFFFFFB);
    }

    public final boolean isOverridingDeviceState() {
        return (this.myOverride & 4) != 0;
    }

    @Override
    @Nullable
    public State getDeviceState() {
        Device device;
        if (this.isOverridingDeviceState()) {
            return super.getDeviceState();
        }
        State state = this.myParent.getDeviceState();
        if (this.isOverridingDevice() && state != null && (device = super.getDevice()) != null) {
            String name = state.getName();
            if ((state = device.getState(name)) != null) {
                return state;
            }
            int nameLen = name.length();
            for (State s : device.getAllStates()) {
                String n = s.getName();
                if (!n.regionMatches(0, name, 0, Math.min(nameLen, n.length()))) continue;
                return s;
            }
            return device.getDefaultState();
        }
        return state;
    }

    @Override
    public void setDeviceState(State state) {
        if (this.isOverridingDeviceState()) {
            super.setDeviceState(state);
        } else {
            State equivalentState;
            Device device;
            if (this.isOverridingDevice() && (device = super.getDevice()) != null && (equivalentState = device.getState(state.getName())) != null) {
                state = equivalentState;
            }
            this.myParent.setDeviceState(state);
        }
    }

    public void setOverrideNightMode(boolean override) {
        this.myOverride = override ? (this.myOverride |= 0x40) : (this.myOverride &= 0xFFFFFFBF);
    }

    public final boolean isOverridingNightMode() {
        return (this.myOverride & 0x40) != 0;
    }

    @Override
    @NotNull
    public NightMode getNightMode() {
        if (this.isOverridingNightMode()) {
            NightMode nightMode = super.getNightMode();
            if (nightMode == null) {
                NestedConfiguration.$$$reportNull$$$0(12);
            }
            return nightMode;
        }
        NightMode nightMode = this.myParent.getNightMode();
        if (nightMode == null) {
            NestedConfiguration.$$$reportNull$$$0(13);
        }
        return nightMode;
    }

    @Override
    public void setNightMode(@NotNull NightMode night) {
        if (night == null) {
            NestedConfiguration.$$$reportNull$$$0(14);
        }
        if (this.isOverridingNightMode()) {
            super.setNightMode(night);
        } else {
            this.myParent.setNightMode(night);
        }
    }

    public void setOverrideUiMode(boolean override) {
        this.myOverride = override ? (this.myOverride |= 0x80) : (this.myOverride &= 0xFFFFFF7F);
    }

    public final boolean isOverridingUiMode() {
        return (this.myOverride & 0x80) != 0;
    }

    @Override
    @NotNull
    public UiMode getUiMode() {
        if (this.isOverridingUiMode()) {
            UiMode uiMode = super.getUiMode();
            if (uiMode == null) {
                NestedConfiguration.$$$reportNull$$$0(15);
            }
            return uiMode;
        }
        UiMode uiMode = this.myParent.getUiMode();
        if (uiMode == null) {
            NestedConfiguration.$$$reportNull$$$0(16);
        }
        return uiMode;
    }

    @Override
    public void setUiMode(@NotNull UiMode uiMode) {
        if (uiMode == null) {
            NestedConfiguration.$$$reportNull$$$0(17);
        }
        if (this.isOverridingUiMode()) {
            super.setUiMode(uiMode);
        } else {
            this.myParent.setUiMode(uiMode);
        }
    }

    @NotNull
    public Configuration getParent() {
        Configuration configuration = this.myParent;
        if (configuration == null) {
            NestedConfiguration.$$$reportNull$$$0(18);
        }
        return configuration;
    }

    @Override
    @Nullable
    public String getActivity() {
        return this.myParent.getActivity();
    }

    @Override
    public void setActivity(String activity) {
        super.setActivity(activity);
    }

    @Nullable
    public String computeDisplayName() {
        return NestedConfiguration.computeDisplayName(this.myOverride, this);
    }

    @Nullable
    public static String computeDisplayName(int flags, @NotNull Configuration configuration) {
        State deviceState;
        if (configuration == null) {
            NestedConfiguration.$$$reportNull$$$0(19);
        }
        if ((flags & 0x10) != 0) {
            return LocaleMenuAction.getLocaleLabel(configuration.getLocale(), false);
        }
        if ((flags & 0x20) != 0) {
            return TargetMenuAction.getRenderingTargetLabel(configuration.getTarget(), false);
        }
        if ((flags & 2) != 0) {
            return DeviceMenuAction.getDeviceLabel(configuration.getDevice(), true);
        }
        if ((flags & 4) != 0 && (deviceState = configuration.getDeviceState()) != null) {
            return deviceState.getName();
        }
        if ((flags & 0x40) != 0) {
            return configuration.getNightMode().getLongDisplayValue();
        }
        if ((flags & 0x80) != 0) {
            configuration.getUiMode().getLongDisplayValue();
        }
        return null;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("parent", (Object)this.myParent.getDisplayName()).add("display", (Object)this.getDisplayName()).add("overrideLocale", this.isOverridingLocale()).add("overrideTarget", this.isOverridingTarget()).add("overrideDevice", this.isOverridingDevice()).add("overrideDeviceState", this.isOverridingDeviceState()).add("inherited", (Object)super.toString()).toString();
    }

    @Override
    public void dispose() {
        this.myParent.removeListener(this);
    }

    @Override
    public boolean changed(int flags) {
        if ((flags &= ~this.myOverride) != 0) {
            this.updated(flags);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/NestedConfiguration";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "night";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/NestedConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheme";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNightMode";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiMode";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getParent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setLocale";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setNightMode";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setUiMode";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "computeDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

