/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.adtui.actions.DropDownAction;
import com.android.tools.adtui.device.DeviceArtPainter;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationAction;
import com.android.tools.idea.configurations.ConfigurationHolder;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.DeviceGroup;
import com.android.tools.idea.configurations.DeviceUtils;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeviceMenuAction
extends DropDownAction {
    private static final boolean LIST_RECENT_DEVICES = false;
    private final ConfigurationHolder myRenderContext;

    public DeviceMenuAction(@NotNull ConfigurationHolder renderContext) {
        if (renderContext == null) {
            DeviceMenuAction.$$$reportNull$$$0(0);
        }
        super("Device for Preview", "Device for Preview", StudioIcons.LayoutEditor.Toolbar.VIRTUAL_DEVICES);
        this.myRenderContext = renderContext;
        Presentation presentation = this.getTemplatePresentation();
        this.updatePresentation(presentation);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DeviceMenuAction.$$$reportNull$$$0(1);
        }
        super.update(e);
        this.updatePresentation(e.getPresentation());
    }

    public boolean displayTextInToolbar() {
        return true;
    }

    private void updatePresentation(Presentation presentation) {
        boolean visible;
        Configuration configuration = this.myRenderContext.getConfiguration();
        boolean bl = visible = configuration != null;
        if (visible) {
            Device device = configuration.getCachedDevice();
            String label = DeviceMenuAction.getDeviceLabel(device, true);
            presentation.setText(label, false);
        }
        if (visible != presentation.isVisible()) {
            presentation.setVisible(visible);
        }
    }

    public static String getDeviceLabel(@Nullable Device device, boolean brief) {
        if (device == null) {
            return "";
        }
        String name = device.getDisplayName();
        if (brief) {
            int end;
            int begin;
            int nexus = name.indexOf("Nexus");
            if (nexus != -1 && (begin = name.indexOf(40)) != -1 && (end = name.indexOf(41, ++begin)) != -1) {
                if (name.equals("Nexus 7 (2012)")) {
                    return "Nexus 7";
                }
                return name.substring(begin, end).trim();
            }
            String skipPrefix = "Android ";
            name = StringUtil.trimStart((String)name, (String)skipPrefix);
        }
        return name;
    }

    private static Icon getDeviceClassIcon(@Nullable Device device) {
        if (device != null) {
            if (HardwareConfigHelper.isWear((Device)device)) {
                return StudioIcons.LayoutEditor.Toolbar.DEVICE_WEAR;
            }
            if (HardwareConfigHelper.isTv((Device)device)) {
                return StudioIcons.LayoutEditor.Toolbar.DEVICE_TV;
            }
            if (HardwareConfigHelper.isAutomotive((Device)device)) {
                return StudioIcons.LayoutEditor.Toolbar.DEVICE_AUTOMOTIVE;
            }
            if (DeviceArtPainter.isTablet((Device)device)) {
                return StudioIcons.LayoutEditor.Toolbar.DEVICE_TABLET;
            }
        }
        return StudioIcons.LayoutEditor.Toolbar.DEVICE_PHONE;
    }

    protected boolean updateActions(@NotNull DataContext context) {
        if (context == null) {
            DeviceMenuAction.$$$reportNull$$$0(2);
        }
        this.removeAll();
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration == null) {
            return true;
        }
        Device current = configuration.getCachedDevice();
        ConfigurationManager configurationManager = configuration.getConfigurationManager();
        this.createDeviceMenuList(configuration, current);
        return true;
    }

    private void createDeviceMenuList(@NotNull Configuration configuration, @Nullable Device currentDevice) {
        if (configuration == null) {
            DeviceMenuAction.$$$reportNull$$$0(3);
        }
        Map<DeviceGroup, List<Device>> groupedDevices = DeviceUtils.getSuitableDevices(configuration);
        this.addDeviceSection(groupedDevices, DeviceGroup.NEXUS_XL, currentDevice);
        this.addDeviceSection(groupedDevices, DeviceGroup.NEXUS_TABLET, currentDevice);
        this.addDeviceSection(groupedDevices, DeviceGroup.WEAR, currentDevice);
        this.addDeviceSection(groupedDevices, DeviceGroup.TV, currentDevice);
        this.addDeviceSection(groupedDevices, DeviceGroup.AUTOMOTIVE, currentDevice);
        this.addCustomDeviceSection(currentDevice);
        this.addAvdDeviceSection(DeviceUtils.getAvdDevices(configuration), currentDevice);
        this.addGenericDeviceSection(groupedDevices.getOrDefault((Object)DeviceGroup.GENERIC, Collections.emptyList()), currentDevice);
        this.add(ActionManager.getInstance().getAction("Android.RunAndroidAvdManager"));
    }

    private void addDeviceSection(@NotNull Map<DeviceGroup, List<Device>> groupedDevices, @NotNull DeviceGroup group2, @Nullable Device current) {
        List devices2;
        if (groupedDevices == null) {
            DeviceMenuAction.$$$reportNull$$$0(4);
        }
        if (group2 == null) {
            DeviceMenuAction.$$$reportNull$$$0(5);
        }
        if (!(devices2 = groupedDevices.getOrDefault((Object)group2, Collections.emptyList())).isEmpty()) {
            this.add(new DeviceCategory(DeviceMenuAction.getGroupTitle(group2), null, DeviceMenuAction.getDeviceClassIcon((Device)devices2.get(0))));
            for (Device device : devices2) {
                String label = this.getLabel(device, HardwareConfigHelper.isNexus((Device)device));
                this.add(new SetDeviceAction(this.myRenderContext, label, device, null, current == device));
            }
            this.addSeparator();
        }
    }

    @NotNull
    private static String getGroupTitle(@NotNull DeviceGroup group2) {
        if (group2 == null) {
            DeviceMenuAction.$$$reportNull$$$0(6);
        }
        switch (group2) {
            case NEXUS: 
            case NEXUS_XL: {
                return "Phone";
            }
            case NEXUS_TABLET: {
                return "Tablet";
            }
            case WEAR: {
                return "Wear";
            }
            case TV: {
                return "TV";
            }
            case AUTOMOTIVE: {
                return "Automotive";
            }
            case GENERIC: {
                return "Generic";
            }
            case OTHER: {
                return "Other";
            }
        }
        return "Device";
    }

    private void addCustomDeviceSection(@Nullable Device currentDevice) {
        this.add(new SetCustomDeviceAction(this.myRenderContext, currentDevice));
        this.addSeparator();
    }

    private void addAvdDeviceSection(@NotNull List<Device> devices2, @Nullable Device current) {
        if (devices2 == null) {
            DeviceMenuAction.$$$reportNull$$$0(7);
        }
        if (!devices2.isEmpty()) {
            this.add(new DeviceCategory("Virtual Device", null, StudioIcons.LayoutEditor.Toolbar.VIRTUAL_DEVICES));
            for (Device device : devices2) {
                boolean selected = current != null && current.getId().equals(device.getId());
                String avdDisplayName = "AVD: " + device.getDisplayName();
                this.add(new SetAvdAction(this.myRenderContext, device, avdDisplayName, selected));
            }
            this.addSeparator();
        }
    }

    private void addGenericDeviceSection(@NotNull List<Device> devices2, @Nullable Device current) {
        if (devices2 == null) {
            DeviceMenuAction.$$$reportNull$$$0(8);
        }
        if (!devices2.isEmpty()) {
            DefaultActionGroup genericGroup = DefaultActionGroup.createPopupGroup(() -> "_Generic Phones and Tablets");
            for (Device device : devices2) {
                String label = this.getLabel(device, HardwareConfigHelper.isNexus((Device)device));
                genericGroup.add((AnAction)new SetDeviceAction(this.myRenderContext, label, device, null, current == device));
            }
            this.add((AnAction)genericGroup);
        }
    }

    @NotNull
    public static ImmutableList<Device> getSortedDevicesInMenu(@NotNull Configuration configuration) {
        if (configuration == null) {
            DeviceMenuAction.$$$reportNull$$$0(9);
        }
        Map<DeviceGroup, List<Device>> groupedDevices = DeviceUtils.getSuitableDevices(configuration);
        ImmutableList.Builder builder2 = new ImmutableList.Builder();
        builder2.addAll((Iterable)groupedDevices.getOrDefault((Object)DeviceGroup.NEXUS_XL, Collections.emptyList()));
        builder2.addAll((Iterable)groupedDevices.getOrDefault((Object)DeviceGroup.NEXUS_TABLET, Collections.emptyList()));
        builder2.addAll((Iterable)groupedDevices.getOrDefault((Object)DeviceGroup.WEAR, Collections.emptyList()));
        builder2.addAll((Iterable)groupedDevices.getOrDefault((Object)DeviceGroup.TV, Collections.emptyList()));
        builder2.addAll((Iterable)groupedDevices.getOrDefault((Object)DeviceGroup.AUTOMOTIVE, Collections.emptyList()));
        builder2.addAll(DeviceUtils.getAvdDevices(configuration));
        builder2.addAll((Iterable)groupedDevices.getOrDefault((Object)DeviceGroup.GENERIC, Collections.emptyList()));
        ImmutableList immutableList = builder2.build();
        if (immutableList == null) {
            DeviceMenuAction.$$$reportNull$$$0(10);
        }
        return immutableList;
    }

    private String getLabel(Device device, boolean isNexus) {
        VirtualFile better;
        Configuration configuration = this.myRenderContext.getConfiguration();
        if (configuration != null && (better = ConfigurationMatcher.getBetterMatch(configuration, device, null, null, null)) != null) {
            return ConfigurationAction.getBetterMatchLabel(device.getDisplayName(), better, configuration.getFile());
        }
        return isNexus ? HardwareConfigHelper.getNexusMenuLabel((Device)device) : HardwareConfigHelper.getGenericLabel((Device)device);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupedDevices";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "devices";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/DeviceMenuAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/DeviceMenuAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedDevicesInMenu";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateActions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createDeviceMenuList";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addDeviceSection";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getGroupTitle";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAvdDeviceSection";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addGenericDeviceSection";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSortedDevicesInMenu";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SetAvdAction
    extends ConfigurationAction {
        @NotNull
        private final Device myAvdDevice;

        public SetAvdAction(@NotNull ConfigurationHolder renderContext, @NotNull Device avdDevice, String displayName, boolean select2) {
            if (renderContext == null) {
                SetAvdAction.$$$reportNull$$$0(0);
            }
            if (avdDevice == null) {
                SetAvdAction.$$$reportNull$$$0(1);
            }
            if (displayName == null) {
                SetAvdAction.$$$reportNull$$$0(2);
            }
            super(renderContext, displayName);
            this.myAvdDevice = avdDevice;
            this.getTemplatePresentation().putClientProperty("selected", (Object)select2);
        }

        @Override
        protected void updatePresentation(@NotNull Presentation presentation) {
            if (presentation == null) {
                SetAvdAction.$$$reportNull$$$0(3);
            }
            DeviceMenuAction.this.updatePresentation(presentation);
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                SetAvdAction.$$$reportNull$$$0(4);
            }
            configuration.setEffectiveDevice(this.myAvdDevice, this.myAvdDevice.getDefaultState());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "avdDevice";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "displayName";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/DeviceMenuAction$SetAvdAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SetCustomDeviceAction
    extends DeviceAction {
        private static final String CUSTOM_DEVICE_NAME = "Custom";
        @Nullable
        private final Device myDevice;
        @Nullable
        private Device myCustomDevice;

        public SetCustomDeviceAction(@Nullable ConfigurationHolder renderContext, Device device) {
            if (renderContext == null) {
                SetCustomDeviceAction.$$$reportNull$$$0(0);
            }
            super(renderContext, CUSTOM_DEVICE_NAME);
            this.myDevice = device;
            if (this.myDevice != null && CUSTOM_DEVICE_NAME.equals(this.myDevice.getId())) {
                this.getTemplatePresentation().putClientProperty("selected", (Object)true);
            }
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            if (configuration == null) {
                SetCustomDeviceAction.$$$reportNull$$$0(1);
            }
            if (this.myDevice != null) {
                Device.Builder customBuilder = new Device.Builder(this.myDevice);
                customBuilder.setTagId(this.myDevice.getTagId());
                customBuilder.setName(CUSTOM_DEVICE_NAME);
                customBuilder.setId(CUSTOM_DEVICE_NAME);
                this.myCustomDevice = customBuilder.build();
                configuration.setEffectiveDevice(this.myCustomDevice, this.myDevice.getDefaultState());
            }
        }

        @Override
        @Nullable
        public Device getDevice() {
            return this.myCustomDevice;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/DeviceMenuAction$SetCustomDeviceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateConfiguration";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class SetDeviceAction
    extends DeviceAction {
        private final Device myDevice;

        public SetDeviceAction(@NotNull ConfigurationHolder renderContext, @NotNull String title, @Nullable Device device, Icon defaultIcon, boolean select2) {
            if (renderContext == null) {
                SetDeviceAction.$$$reportNull$$$0(0);
            }
            if (title == null) {
                SetDeviceAction.$$$reportNull$$$0(1);
            }
            if (device == null) {
                SetDeviceAction.$$$reportNull$$$0(2);
            }
            super(renderContext, null);
            this.myDevice = device;
            this.getTemplatePresentation().setText(title, false);
            if (select2) {
                this.getTemplatePresentation().putClientProperty("selected", (Object)true);
            } else if (ConfigurationAction.isBetterMatchLabel(title)) {
                this.getTemplatePresentation().setIcon(ConfigurationAction.getBetterMatchIcon());
            } else if (defaultIcon != null) {
                this.getTemplatePresentation().setIcon(defaultIcon);
            }
        }

        @Override
        protected void updateConfiguration(@NotNull Configuration configuration, boolean commit) {
            String name;
            VirtualFile file2;
            String newState;
            if (configuration == null) {
                SetDeviceAction.$$$reportNull$$$0(3);
            }
            Device prevDevice = configuration.getCachedDevice();
            State prevState = configuration.getDeviceState();
            String string = newState = prevState != null ? prevState.getName() : null;
            if (prevDevice != null && prevState != null && prevState.isDefaultState() && !this.myDevice.getDefaultState().getName().equals(prevState.getName()) && configuration.getEditedConfig().getScreenOrientationQualifier() == null && (file2 = configuration.getFile()) != null && ConfigurationMatcher.getBetterMatch(configuration, this.myDevice, name = this.myDevice.getDefaultState().getName(), null, null) == null) {
                newState = name;
            }
            if (newState != null) {
                configuration.setDeviceStateName(newState);
            }
            if (commit) {
                configuration.getConfigurationManager().selectDevice(this.myDevice);
            }
            configuration.setDevice(this.myDevice, true);
        }

        @Override
        @NotNull
        public Device getDevice() {
            Device device = this.myDevice;
            if (device == null) {
                SetDeviceAction.$$$reportNull$$$0(4);
            }
            return device;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "device";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/configurations/DeviceMenuAction$SetDeviceAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/configurations/DeviceMenuAction$SetDeviceAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDevice";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateConfiguration";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected abstract class DeviceAction
    extends ConfigurationAction {
        DeviceAction(@Nullable ConfigurationHolder renderContext, String title) {
            if (renderContext == null) {
                DeviceAction.$$$reportNull$$$0(0);
            }
            super(renderContext, title);
        }

        @Override
        protected final void updatePresentation(@NotNull Presentation presentation) {
            if (presentation == null) {
                DeviceAction.$$$reportNull$$$0(1);
            }
            DeviceMenuAction.this.updatePresentation(presentation);
        }

        @Nullable
        public abstract Device getDevice();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "renderContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/configurations/DeviceMenuAction$DeviceAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updatePresentation";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class DeviceCategory
    extends AnAction {
        private Icon myIcon;

        public DeviceCategory(@Nullable String text2, @Nullable String description2, @Nullable Icon icon2) {
            super(text2, description2, null);
            this.myIcon = icon2;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DeviceCategory.$$$reportNull$$$0(0);
            }
            Presentation p = e.getPresentation();
            p.setEnabled(false);
            p.setDisabledIcon(this.myIcon);
        }

        public void actionPerformed(AnActionEvent e) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/configurations/DeviceMenuAction$DeviceCategory", "update"));
        }
    }
}

