/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.configurations;

import com.android.annotations.concurrency.Slow;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourceResolver;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.DeviceConfigHelper;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.ide.common.resources.configuration.NightModeQualifier;
import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.android.ide.common.resources.configuration.ScreenOrientationQualifier;
import com.android.ide.common.resources.configuration.ScreenSizeQualifier;
import com.android.ide.common.resources.configuration.UiModeQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.resources.Density;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.LayoutDirection;
import com.android.resources.NightMode;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenSize;
import com.android.resources.UiMode;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.configurations.ConfigurationFileState;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationMatcher;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.android.tools.idea.configurations.ResourceResolverCache;
import com.android.tools.idea.editors.theme.ResolutionUtils;
import com.android.tools.idea.layoutlib.LayoutLibrary;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.sdk.StudioEmbeddedRenderTarget;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Configuration
implements Disposable,
ModificationTracker {
    public static final String AVD_ID_PREFIX = "_android_virtual_device_id_";
    public static final String CUSTOM_DEVICE_ID = "Custom";
    private static final int UI_MODE_TYPE_MASK = 15;
    private static final int UI_MODE_TYPE_APPLIANCE = 5;
    private static final int UI_MODE_TYPE_CAR = 3;
    private static final int UI_MODE_TYPE_DESK = 2;
    private static final int UI_MODE_TYPE_NORMAL = 1;
    private static final int UI_MODE_TYPE_TELEVISION = 4;
    private static final int UI_MODE_TYPE_VR_HEADSET = 7;
    private static final int UI_MODE_TYPE_WATCH = 6;
    private static final int UI_MODE_NIGHT_MASK = 48;
    private static final int UI_MODE_NIGHT_YES = 32;
    private static final int UI_MODE_NIGHT_NO = 16;
    @Nullable
    final VirtualFile myFile;
    @Nullable
    private PsiFile myPsiFile;
    @NotNull
    protected final FolderConfiguration myFullConfig;
    @NotNull
    protected final ConfigurationManager myManager;
    @NotNull
    protected final FolderConfiguration myEditedConfig;
    @Nullable
    private IAndroidTarget myTarget;
    @Nullable
    private String myTheme;
    @Nullable
    private Device mySpecificDevice;
    @Nullable
    private State myState;
    @Nullable
    private Device myDevice;
    @Nullable
    private String myStateName;
    @Nullable
    private String myActivity;
    @Nullable
    private Locale myLocale;
    @NotNull
    private UiMode myUiMode;
    @NotNull
    private NightMode myNightMode;
    private String myDisplayName;
    private int myBulkEditingCount;
    @Nullable
    private List<ConfigurationListener> myListeners;
    protected int myNotifyDirty;
    protected int myFolderConfigDirty;
    protected int myProjectStateVersion;
    private long myModificationCount;
    private float myFontScale;
    private int myUiModeFlagValue;
    private static final String NO_ACTIVITY = new String();

    protected Configuration(@NotNull ConfigurationManager manager, @Nullable VirtualFile file2, @NotNull FolderConfiguration editedConfig) {
        if (manager == null) {
            Configuration.$$$reportNull$$$0(0);
        }
        if (editedConfig == null) {
            Configuration.$$$reportNull$$$0(1);
        }
        this.myFullConfig = new FolderConfiguration();
        this.myLocale = null;
        this.myUiMode = UiMode.NORMAL;
        this.myNightMode = NightMode.NOTNIGHT;
        this.myFolderConfigDirty = 246;
        this.myFontScale = 1.0f;
        this.myManager = manager;
        this.myFile = file2;
        this.myEditedConfig = editedConfig;
        if (this.isLocaleSpecificLayout()) {
            this.myLocale = Locale.create(editedConfig);
        }
        if (this.isOrientationSpecificLayout()) {
            ScreenOrientationQualifier qualifier = editedConfig.getScreenOrientationQualifier();
            assert (qualifier != null);
            ScreenOrientation orientation = qualifier.getValue();
            if (orientation != null) {
                this.myStateName = orientation.getShortDisplayValue();
            }
        }
    }

    @NotNull
    public static Configuration create(@NotNull ConfigurationManager manager, @Nullable VirtualFile file2, @NotNull FolderConfiguration editedConfig) {
        if (manager == null) {
            Configuration.$$$reportNull$$$0(2);
        }
        if (editedConfig == null) {
            Configuration.$$$reportNull$$$0(3);
        }
        return new Configuration(manager, file2, editedConfig);
    }

    @NotNull
    public static Configuration create(@NotNull Configuration base, @NotNull VirtualFile file2) {
        if (base == null) {
            Configuration.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            Configuration.$$$reportNull$$$0(5);
        }
        Configuration configuration = Configuration.copyWithNewFile(base, file2);
        ConfigurationMatcher matcher = new ConfigurationMatcher(configuration, file2);
        configuration.getEditedConfig().set(FolderConfiguration.getConfigForFolder((String)file2.getParent().getName()));
        matcher.adaptConfigSelection(true);
        Configuration configuration2 = configuration;
        if (configuration2 == null) {
            Configuration.$$$reportNull$$$0(6);
        }
        return configuration2;
    }

    @NotNull
    public static Configuration create(@NotNull ConfigurationManager manager, @Nullable VirtualFile file2, @Nullable ConfigurationFileState fileState, @NotNull FolderConfiguration editedConfig) {
        if (manager == null) {
            Configuration.$$$reportNull$$$0(7);
        }
        if (editedConfig == null) {
            Configuration.$$$reportNull$$$0(8);
        }
        Configuration configuration = new Configuration(manager, file2, editedConfig);
        configuration.startBulkEditing();
        if (fileState != null) {
            fileState.loadState(configuration);
        }
        configuration.finishBulkEditing();
        Configuration configuration2 = configuration;
        if (configuration2 == null) {
            Configuration.$$$reportNull$$$0(9);
        }
        return configuration2;
    }

    @NotNull
    public static Configuration copy(@NotNull Configuration original) {
        if (original == null) {
            Configuration.$$$reportNull$$$0(10);
        }
        return Configuration.copyWithNewFile(original, original.myFile);
    }

    @NotNull
    private static Configuration copyWithNewFile(@NotNull Configuration original, @Nullable VirtualFile newFile) {
        if (original == null) {
            Configuration.$$$reportNull$$$0(11);
        }
        FolderConfiguration copiedConfig = new FolderConfiguration();
        copiedConfig.set(original.getEditedConfig());
        Configuration copy2 = new Configuration(original.myManager, newFile, copiedConfig);
        copy2.myFullConfig.set(original.myFullConfig);
        copy2.myFolderConfigDirty = original.myFolderConfigDirty;
        copy2.myProjectStateVersion = original.myProjectStateVersion;
        copy2.myTarget = original.myTarget;
        copy2.myLocale = original.myLocale;
        copy2.myTheme = original.getTheme();
        copy2.mySpecificDevice = original.mySpecificDevice;
        copy2.myDevice = original.myDevice;
        copy2.myStateName = original.myStateName;
        copy2.myState = original.myState;
        copy2.myActivity = original.getActivity();
        copy2.myUiMode = original.getUiMode();
        copy2.myNightMode = original.getNightMode();
        copy2.myDisplayName = original.getDisplayName();
        copy2.myFontScale = original.myFontScale;
        copy2.myUiModeFlagValue = original.myUiModeFlagValue;
        Configuration configuration = copy2;
        if (configuration == null) {
            Configuration.$$$reportNull$$$0(12);
        }
        return configuration;
    }

    public Configuration clone() {
        return Configuration.copy(this);
    }

    public void save() {
        ConfigurationStateManager stateManager = ConfigurationStateManager.get(this.myManager.getModule().getProject());
        if (this.myFile != null) {
            ConfigurationFileState fileState = new ConfigurationFileState();
            fileState.saveState(this);
            stateManager.setConfigurationState(this.myFile, fileState);
        }
    }

    @NotNull
    public ConfigurationManager getConfigurationManager() {
        ConfigurationManager configurationManager = this.myManager;
        if (configurationManager == null) {
            Configuration.$$$reportNull$$$0(13);
        }
        return configurationManager;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Nullable
    public PsiFile getPsiFile() {
        if (this.myPsiFile == null && this.myFile != null) {
            this.myPsiFile = AndroidPsiUtils.getPsiFileSafely((Project)this.myManager.getProject(), (VirtualFile)this.myFile);
        }
        return this.myPsiFile;
    }

    @Nullable
    public String getActivity() {
        if (this.myActivity == NO_ACTIVITY) {
            return null;
        }
        if (this.myActivity == null && this.myFile != null) {
            this.myActivity = (String)ApplicationManager.getApplication().runReadAction(() -> {
                XmlAttribute attribute;
                XmlFile xmlFile;
                XmlTag rootTag;
                if (this.myPsiFile == null) {
                    this.myPsiFile = PsiManager.getInstance((Project)this.myManager.getProject()).findFile(this.myFile);
                }
                if (this.myPsiFile instanceof XmlFile && (rootTag = (xmlFile = (XmlFile)this.myPsiFile).getRootTag()) != null && (attribute = rootTag.getAttribute("context", "http://schemas.android.com/tools")) != null) {
                    return attribute.getValue();
                }
                return null;
            });
            if (this.myActivity == null) {
                this.myActivity = NO_ACTIVITY;
                return null;
            }
        }
        return this.myActivity;
    }

    @Slow
    @Nullable
    public Device getDevice() {
        Device cached2 = this.getCachedDevice();
        if (cached2 != null) {
            return cached2;
        }
        this.myDevice = this.mySpecificDevice != null ? this.mySpecificDevice : this.computeBestDevice();
        return this.myDevice;
    }

    @Nullable
    public Device getCachedDevice() {
        return this.myDevice;
    }

    @Nullable
    public static FolderConfiguration getFolderConfig(@NotNull Module module2, @NotNull State state, @NotNull Locale locale, @Nullable IAndroidTarget target) {
        FolderConfiguration currentConfig;
        if (module2 == null) {
            Configuration.$$$reportNull$$$0(14);
        }
        if (state == null) {
            Configuration.$$$reportNull$$$0(15);
        }
        if (locale == null) {
            Configuration.$$$reportNull$$$0(16);
        }
        if ((currentConfig = DeviceConfigHelper.getFolderConfig((State)state)) != null && locale.hasLanguage()) {
            LayoutLibrary layoutLib;
            currentConfig.setLocaleQualifier(locale.qualifier);
            if (locale.hasLanguage() && (layoutLib = RenderService.getLayoutLibrary(module2, target)) != null && layoutLib.isRtl(locale.toLocaleId())) {
                currentConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.RTL));
            }
        }
        return currentConfig;
    }

    @Slow
    @Nullable
    private Device computeBestDevice() {
        for (Device device : this.myManager.getRecentDevices()) {
            LocalResourceRepository resources;
            String stateName = this.myStateName;
            if (stateName == null) {
                stateName = device.getDefaultState().getName();
            }
            State selectedState = ConfigurationFileState.getState(device, stateName);
            Module module2 = this.myManager.getModule();
            FolderConfiguration currentConfig = Configuration.getFolderConfig(module2, selectedState, this.getLocale(), this.getTarget());
            if (currentConfig == null || !this.myEditedConfig.isMatchFor(currentConfig) || (resources = ResourceRepositoryManager.getAppResources(module2)) == null || this.myFile == null) continue;
            ResourceFolderType folderType = IdeResourcesUtil.getFolderType(this.myFile);
            if (folderType != null) {
                if (ResourceFolderType.VALUES.equals((Object)folderType)) {
                    LocalResourceManager resourceManager = LocalResourceManager.getInstance(module2);
                    if (resourceManager == null) continue;
                    for (PsiFile resourceFile : resourceManager.findResourceFiles(ResourceNamespace.TODO(), ResourceFolderType.VALUES)) {
                        FolderConfiguration folderConfiguration;
                        if (!this.myFile.equals(resourceFile.getVirtualFile()) || resourceFile.getParent() == null || !currentConfig.isMatchFor(folderConfiguration = FolderConfiguration.getConfigForFolder((String)resourceFile.getParent().getName()))) continue;
                        return device;
                    }
                    continue;
                }
                List types2 = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
                if (types2.isEmpty()) continue;
                ResourceType type = (ResourceType)types2.get(0);
                List<VirtualFile> matches = ConfigurationMatcher.getMatchingFiles((ResourceRepository)resources, this.myFile, ResourceNamespace.TODO(), type, currentConfig);
                if (!matches.contains(this.myFile)) continue;
                return device;
            }
            if ("Kotlin".equals(this.myFile.getFileType().getName())) {
                return device;
            }
            if (!this.myFile.equals(this.myManager.getProject().getProjectFile())) continue;
            return device;
        }
        return this.myManager.getDefaultDevice();
    }

    @Nullable
    public State getDeviceState() {
        if (this.myState == null) {
            Device device = this.getDevice();
            this.myState = ConfigurationFileState.getState(device, this.myStateName);
        }
        return this.myState;
    }

    @NotNull
    public Locale getLocale() {
        if (this.myLocale == null) {
            Locale locale = this.myManager.getLocale();
            if (locale == null) {
                Configuration.$$$reportNull$$$0(17);
            }
            return locale;
        }
        Locale locale = this.myLocale;
        if (locale == null) {
            Configuration.$$$reportNull$$$0(18);
        }
        return locale;
    }

    @NotNull
    public UiMode getUiMode() {
        UiMode uiMode = this.myUiMode;
        if (uiMode == null) {
            Configuration.$$$reportNull$$$0(19);
        }
        return uiMode;
    }

    @NotNull
    public NightMode getNightMode() {
        NightMode nightMode = this.myNightMode;
        if (nightMode == null) {
            Configuration.$$$reportNull$$$0(20);
        }
        return nightMode;
    }

    @NotNull
    public String getTheme() {
        if (this.myTheme == null) {
            this.myTheme = this.myManager.computePreferredTheme(this);
        }
        String string = this.myTheme;
        if (string == null) {
            Configuration.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    public IAndroidTarget getTarget() {
        if (this.myTarget == null) {
            IAndroidTarget target = this.myManager.getTarget();
            VersionQualifier version2 = this.myEditedConfig.getVersionQualifier();
            if (target != null && version2 != null && version2.getVersion() > target.getVersion().getFeatureLevel()) {
                target = this.myManager.getTarget(version2.getVersion());
            }
            return Configuration.getTargetForRendering(target);
        }
        return this.myTarget;
    }

    @Nullable
    public IAndroidTarget getRealTarget() {
        CompatibilityRenderTarget compatTarget;
        IAndroidTarget target = this.getTarget();
        if (target instanceof CompatibilityRenderTarget && (compatTarget = (CompatibilityRenderTarget)target).getRealTarget() != null) {
            return compatTarget.getRealTarget();
        }
        return target;
    }

    @Nullable
    public String getDisplayName() {
        return this.myDisplayName;
    }

    public boolean isLocaleSpecificLayout() {
        return this.myEditedConfig.getLocaleQualifier() != null;
    }

    public boolean isTargetSpecificLayout() {
        return this.myEditedConfig.getVersionQualifier() != null;
    }

    public boolean isOrientationSpecificLayout() {
        return this.myEditedConfig.getScreenOrientationQualifier() != null;
    }

    @NotNull
    public FolderConfiguration getFullConfig() {
        if ((this.myFolderConfigDirty & 0xF6) != 0 || this.myProjectStateVersion != this.myManager.getStateVersion()) {
            this.syncFolderConfig();
        }
        FolderConfiguration folderConfiguration = this.myFullConfig;
        if (folderConfiguration == null) {
            Configuration.$$$reportNull$$$0(22);
        }
        return folderConfiguration;
    }

    @NotNull
    public FolderConfiguration getEditedConfig() {
        FolderConfiguration folderConfiguration = this.myEditedConfig;
        if (folderConfiguration == null) {
            Configuration.$$$reportNull$$$0(23);
        }
        return folderConfiguration;
    }

    public void setActivity(@Nullable String activity) {
        if (!StringUtil.equals((CharSequence)this.myActivity, (CharSequence)activity)) {
            this.myActivity = activity;
            this.updated(256);
        }
    }

    public void setDevice(Device device, boolean preserveState) {
        if (this.mySpecificDevice != device) {
            Device prevDevice = this.mySpecificDevice;
            State prevState = this.myState;
            this.myDevice = this.mySpecificDevice = device;
            int updateFlags = 2;
            if (device != null) {
                State state = null;
                if (preserveState && prevDevice != null) {
                    if (prevState != null) {
                        FolderConfiguration oldConfig = DeviceConfigHelper.getFolderConfig((State)prevState);
                        if (oldConfig != null) {
                            String stateName = Configuration.getClosestMatch(oldConfig, device.getAllStates());
                            state = device.getState(stateName);
                        } else {
                            state = device.getState(prevState.getName());
                        }
                    }
                } else if (preserveState && this.myStateName != null) {
                    state = device.getState(this.myStateName);
                }
                if (state == null) {
                    state = device.getDefaultState();
                }
                if (this.myState != state) {
                    this.setDeviceStateName(state.getName());
                    this.myState = state;
                    updateFlags |= 4;
                }
            }
            this.updated(updateFlags);
        }
    }

    @Nullable
    private static String getClosestMatch(@NotNull FolderConfiguration oldConfig, @NotNull List<State> states) {
        if (oldConfig == null) {
            Configuration.$$$reportNull$$$0(24);
        }
        if (states == null) {
            Configuration.$$$reportNull$$$0(25);
        }
        ArrayList<Object> list1 = new ArrayList<Object>(states.size());
        ArrayList<State> list2 = new ArrayList<State>(states.size());
        list1.addAll(states);
        int count = FolderConfiguration.getQualifierCount();
        for (int i2 = 0; i2 < count; ++i2) {
            for (State state : list1) {
                ResourceQualifier newQualifier;
                ResourceQualifier oldQualifier = oldConfig.getQualifier(i2);
                FolderConfiguration folderConfig = DeviceConfigHelper.getFolderConfig((State)state);
                ResourceQualifier resourceQualifier = newQualifier = folderConfig != null ? folderConfig.getQualifier(i2) : null;
                if (oldQualifier == null) {
                    if (newQualifier != null) continue;
                    list2.add(state);
                    continue;
                }
                if (!oldQualifier.equals((Object)newQualifier)) continue;
                list2.add(state);
            }
            if (list2.size() == 1) {
                return ((State)list2.get(0)).getName();
            }
            if (list2.isEmpty()) continue;
            list1.clear();
            list1.addAll(list2);
            list2.clear();
        }
        if (!list1.isEmpty()) {
            return ((State)list1.get(0)).getName();
        }
        return null;
    }

    public void setDeviceState(State state) {
        if (this.myState != state) {
            if (state != null) {
                this.setDeviceStateName(state.getName());
            } else {
                this.myStateName = null;
            }
            this.myState = state;
            this.updated(4);
        }
    }

    public void setDeviceStateName(@Nullable String stateName) {
        ScreenOrientation orientation;
        ScreenOrientationQualifier qualifier = this.myEditedConfig.getScreenOrientationQualifier();
        if (qualifier != null && (orientation = qualifier.getValue()) != null) {
            stateName = orientation.getShortDisplayValue();
        }
        if (!Objects.equal((Object)stateName, (Object)this.myStateName)) {
            this.myStateName = stateName;
            this.myState = null;
            this.updated(4);
        }
    }

    public void setLocale(@NotNull Locale locale) {
        if (locale == null) {
            Configuration.$$$reportNull$$$0(26);
        }
        if (!Objects.equal((Object)this.myLocale, (Object)locale)) {
            this.myLocale = locale;
            this.updated(16);
        }
    }

    public void setTarget(@Nullable IAndroidTarget target) {
        if (this.myTarget != target) {
            this.myTarget = Configuration.getTargetForRendering(target);
            this.updated(32);
        }
    }

    public void setDisplayName(@Nullable String displayName) {
        if (!StringUtil.equals((CharSequence)this.myDisplayName, (CharSequence)displayName)) {
            this.myDisplayName = displayName;
            this.updated(512);
        }
    }

    public void setNightMode(@NotNull NightMode night) {
        if (night == null) {
            Configuration.$$$reportNull$$$0(27);
        }
        if (this.myNightMode != night) {
            if (night == NightMode.NIGHT) {
                this.setUiModeFlagValue(this.getUiModeFlagValue() & 0xF | 0x20);
            } else {
                this.setUiModeFlagValue(this.getUiModeFlagValue() & 0xF | 0x10);
            }
        }
    }

    public void setUiMode(@NotNull UiMode uiMode) {
        if (uiMode == null) {
            Configuration.$$$reportNull$$$0(28);
        }
        if (this.myUiMode != uiMode) {
            int newUiTypeFlags = 0;
            switch (uiMode) {
                case NORMAL: {
                    newUiTypeFlags = 1;
                    break;
                }
                case DESK: {
                    newUiTypeFlags = 2;
                    break;
                }
                case WATCH: {
                    newUiTypeFlags = 6;
                    break;
                }
                case TELEVISION: {
                    newUiTypeFlags = 4;
                    break;
                }
                case APPLIANCE: {
                    newUiTypeFlags = 5;
                    break;
                }
                case CAR: {
                    newUiTypeFlags = 3;
                    break;
                }
                case VR_HEADSET: {
                    newUiTypeFlags = 7;
                }
            }
            this.setUiModeFlagValue(this.getUiModeFlagValue() & 0x30 | newUiTypeFlags);
        }
    }

    public void setUiModeFlagValue(int uiMode) {
        int modifiedElements = this.myUiModeFlagValue ^ uiMode;
        this.myUiModeFlagValue = uiMode;
        int updatedFlags = 0;
        if ((modifiedElements & 0x30) != 0) {
            this.myNightMode = (uiMode & 0x30) == 32 ? NightMode.NIGHT : NightMode.NOTNIGHT;
            updatedFlags |= 0x40;
        }
        if ((modifiedElements & 0xF) != 0) {
            switch (uiMode & 0xF) {
                case 5: {
                    this.myUiMode = UiMode.APPLIANCE;
                    break;
                }
                case 3: {
                    this.myUiMode = UiMode.CAR;
                    break;
                }
                case 4: {
                    this.myUiMode = UiMode.TELEVISION;
                    break;
                }
                case 6: {
                    this.myUiMode = UiMode.WATCH;
                    break;
                }
                case 2: {
                    this.myUiMode = UiMode.DESK;
                    break;
                }
                case 7: {
                    this.myUiMode = UiMode.VR_HEADSET;
                    break;
                }
                default: {
                    this.myUiMode = UiMode.NORMAL;
                }
            }
            updatedFlags |= 0x80;
        }
        if (updatedFlags != 0) {
            this.updated(updatedFlags);
        }
    }

    public int getUiModeFlagValue() {
        return this.myUiModeFlagValue;
    }

    public void setTheme(@Nullable String theme) {
        if (!StringUtil.equals((CharSequence)this.myTheme, (CharSequence)theme)) {
            this.myTheme = theme;
            this.checkThemePrefix();
            this.updated(8);
        }
    }

    public void setFontScale(float fontScale) {
        assert (fontScale > 0.0f) : "fontScale must be greater than 0";
        if (this.myFontScale != fontScale) {
            this.myFontScale = fontScale;
            this.updated(1024);
        }
    }

    public float getFontScale() {
        return this.myFontScale;
    }

    protected void syncFolderConfig() {
        Device device = this.getDevice();
        if (device == null) {
            return;
        }
        State deviceState = this.getDeviceState();
        if (deviceState == null) {
            deviceState = device.getDefaultState();
        }
        FolderConfiguration config = Configuration.getFolderConfig(this.getModule(), deviceState, this.getLocale(), this.getTarget());
        this.myFullConfig.set(config);
        Locale locale = this.getLocale();
        this.myFullConfig.setLocaleQualifier(locale.qualifier);
        LayoutDirectionQualifier layoutDirectionQualifier = this.myEditedConfig.getLayoutDirectionQualifier();
        if (layoutDirectionQualifier != null && layoutDirectionQualifier != layoutDirectionQualifier.getNullQualifier()) {
            this.myFullConfig.setLayoutDirectionQualifier(layoutDirectionQualifier);
        } else if (!locale.hasLanguage()) {
            this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.LTR));
        } else {
            LayoutLibrary layoutLib = RenderService.getLayoutLibrary(this.getModule(), this.getTarget());
            if (layoutLib != null) {
                if (layoutLib.isRtl(locale.toLocaleId())) {
                    this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.RTL));
                } else {
                    this.myFullConfig.setLayoutDirectionQualifier(new LayoutDirectionQualifier(LayoutDirection.LTR));
                }
            }
        }
        UiMode uiMode = this.getUiMode();
        this.myFullConfig.setUiModeQualifier(new UiModeQualifier(uiMode));
        NightMode nightMode = this.getNightMode();
        this.myFullConfig.setNightModeQualifier(new NightModeQualifier(nightMode));
        IAndroidTarget target = this.getTarget();
        if (target != null) {
            int apiLevel = target.getVersion().getFeatureLevel();
            this.myFullConfig.setVersionQualifier(new VersionQualifier(apiLevel));
        }
        this.myFolderConfigDirty = 0;
        this.myProjectStateVersion = this.myManager.getStateVersion();
    }

    @Nullable
    public ScreenSize getScreenSize() {
        FolderConfiguration folderConfig;
        State deviceState = this.getDeviceState();
        if (deviceState != null && (folderConfig = DeviceConfigHelper.getFolderConfig((State)deviceState)) != null) {
            ScreenSizeQualifier qualifier = folderConfig.getScreenSizeQualifier();
            assert (qualifier != null);
            return qualifier.getValue();
        }
        ScreenSize screenSize = null;
        Device device = this.getDevice();
        if (device != null) {
            List states = device.getAllStates();
            for (State state : states) {
                FolderConfiguration folderConfig2 = DeviceConfigHelper.getFolderConfig((State)state);
                if (folderConfig2 == null) continue;
                ScreenSizeQualifier qualifier = folderConfig2.getScreenSizeQualifier();
                assert (qualifier != null);
                screenSize = qualifier.getValue();
                break;
            }
        }
        return screenSize;
    }

    private void checkThemePrefix() {
        if (this.myTheme != null && !this.myTheme.startsWith("@")) {
            if (this.myTheme.isEmpty()) {
                this.myTheme = this.myManager.computePreferredTheme(this);
                return;
            }
            this.myTheme = ResolutionUtils.getStyleResourceUrl(this.myTheme);
        }
    }

    @NotNull
    public Density getDensity() {
        Density d;
        DensityQualifier qualifier = this.getFullConfig().getDensityQualifier();
        if (qualifier != null && (d = qualifier.getValue()) != null && d.isValidValueForDevice()) {
            Density density = d;
            if (density == null) {
                Configuration.$$$reportNull$$$0(29);
            }
            return density;
        }
        Density density = Density.MEDIUM;
        if (density == null) {
            Configuration.$$$reportNull$$$0(30);
        }
        return density;
    }

    @Nullable
    public State getNextDeviceState(@Nullable State from) {
        Device device = this.getDevice();
        if (device == null) {
            return null;
        }
        List states = device.getAllStates();
        for (int i2 = 0; i2 < states.size(); ++i2) {
            if (states.get(i2) != from) continue;
            return (State)states.get((i2 + 1) % states.size());
        }
        if (from != null) {
            String name = from.getName();
            for (int i3 = 0; i3 < states.size(); ++i3) {
                if (!((State)states.get(i3)).getName().equals(name)) continue;
                return (State)states.get((i3 + 1) % states.size());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBulkEditing() {
        Configuration configuration = this;
        synchronized (configuration) {
            ++this.myBulkEditingCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishBulkEditing() {
        boolean notify = false;
        Configuration configuration = this;
        synchronized (configuration) {
            --this.myBulkEditingCount;
            if (this.myBulkEditingCount == 0) {
                notify = true;
            }
        }
        if (notify) {
            this.updated(0);
        }
    }

    public void updated(int flags) {
        this.myNotifyDirty |= flags;
        this.myFolderConfigDirty |= flags;
        ++this.myModificationCount;
        if (this.myManager.getStateVersion() != this.myProjectStateVersion) {
            this.myNotifyDirty |= 0x32;
            this.myFolderConfigDirty |= 0x32;
            this.myDevice = null;
            this.myState = null;
        }
        if (this.myBulkEditingCount == 0) {
            int changed = this.myNotifyDirty;
            if (this.myListeners != null) {
                for (ConfigurationListener listener2 : this.myListeners) {
                    listener2.changed(changed);
                }
            }
            this.myNotifyDirty = 0;
        }
    }

    public void addListener(@NotNull ConfigurationListener listener2) {
        if (listener2 == null) {
            Configuration.$$$reportNull$$$0(31);
        }
        if (this.myListeners == null) {
            this.myListeners = new ArrayList<ConfigurationListener>();
        }
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull ConfigurationListener listener2) {
        if (listener2 == null) {
            Configuration.$$$reportNull$$$0(32);
        }
        if (this.myListeners != null) {
            this.myListeners.remove(listener2);
            if (this.myListeners.isEmpty()) {
                this.myListeners = null;
            }
        }
    }

    @NotNull
    public ResourceResolver getResourceResolver() {
        String theme = this.getTheme();
        Device device = this.getDevice();
        ResourceResolverCache resolverCache = this.myManager.getResolverCache();
        if (device != null && CUSTOM_DEVICE_ID.equals(device.getId())) {
            resolverCache.replaceCustomConfig(theme, this.getFullConfig());
        }
        ResourceResolver resourceResolver2 = resolverCache.getResourceResolver(this.getTarget(), theme, this.getFullConfig());
        if (resourceResolver2 == null) {
            Configuration.$$$reportNull$$$0(33);
        }
        return resourceResolver2;
    }

    @Nullable
    public ResourceRepository getFrameworkResources() {
        IAndroidTarget target = this.getTarget();
        if (target != null) {
            return this.myManager.getResolverCache().getFrameworkResources(this.getFullConfig(), target);
        }
        return null;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("display", (Object)this.getDisplayName()).add("theme", (Object)this.getTheme()).add("activity", (Object)this.getActivity()).add("device", (Object)this.getDevice()).add("state", (Object)this.getDeviceState()).add("locale", (Object)this.getLocale()).add("target", (Object)this.getTarget()).add("uimode", (Object)this.getUiMode()).add("nightmode", (Object)this.getNightMode()).toString();
    }

    public Module getModule() {
        return this.myManager.getModule();
    }

    public void dispose() {
    }

    public void setEffectiveDevice(@Nullable Device device, @Nullable State state) {
        int updateFlags = 0;
        if (this.myDevice != device) {
            updateFlags = 2;
            this.myDevice = device;
        }
        if (this.myState != state) {
            this.myState = state;
            this.myStateName = state != null ? state.getName() : null;
            updateFlags |= 4;
        }
        if (updateFlags != 0) {
            this.updated(updateFlags);
        }
    }

    public long getModificationCount() {
        return this.myModificationCount;
    }

    @Nullable
    private static IAndroidTarget getTargetForRendering(@Nullable IAndroidTarget target) {
        if (target == null) {
            return null;
        }
        return StudioEmbeddedRenderTarget.getCompatibilityTarget(target);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 30: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 30: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editedConfig";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/configurations/Configuration";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 16: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locale";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldConfig";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "states";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "night";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiMode";
                break;
            }
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/configurations/Configuration";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithNewFile";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationManager";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocale";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiMode";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNightMode";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTheme";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullConfig";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditedConfig";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDensity";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 30: 
            case 33: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copy";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewFile";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getFolderConfig";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getClosestMatch";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setLocale";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setNightMode";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setUiMode";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 29: 
            case 30: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

