/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.literals;

import com.android.tools.idea.common.util.BuildListener;
import com.android.tools.idea.common.util.ChangeManagerKt;
import com.android.tools.idea.compose.preview.literals.LiveLiteralsManager;
import com.android.tools.idea.editors.literals.EmptyLiteralReferenceSnapshot;
import com.android.tools.idea.editors.literals.LiteralReference;
import com.android.tools.idea.editors.literals.LiteralReferenceSnapshot;
import com.android.tools.idea.editors.literals.LiteralUsageReference;
import com.android.tools.idea.editors.literals.LiteralsManager;
import com.android.tools.idea.editors.literals.LiteralsManagerKt;
import com.android.tools.idea.rendering.classloading.ConstantRemapperManager;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001f\u001a\u00020\nH\u0002J\b\u0010 \u001a\u00020\nH\u0002J\b\u0010!\u001a\u00020\nH\u0016J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u0013@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/compose/preview/literals/LiveLiteralsManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "psiFilePointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiFile;", "requestRefresh", "Lkotlin/Function0;", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Lcom/intellij/psi/SmartPsiElementPointer;Lkotlin/jvm/functions/Function0;)V", "LITERAL_TEXT_ATTRIBUTE", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "activationDisposable", "value", "", "isEnabled", "()Z", "setEnabled", "(Z)V", "lastSnapshot", "Lcom/android/tools/idea/editors/literals/LiteralReferenceSnapshot;", "literalsManager", "Lcom/android/tools/idea/editors/literals/LiteralsManager;", "updateMergingQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "kotlin.jvm.PlatformType", "activate", "deactivate", "dispose", "onDocumentUpdated", "lastUpdateNanos", "", "intellij.android.compose-designer"})
public final class LiveLiteralsManager
implements Disposable {
    private final Logger LOG;
    private final TextAttributes LITERAL_TEXT_ATTRIBUTE;
    private final MergingUpdateQueue updateMergingQueue;
    private final LiteralsManager literalsManager;
    private LiteralReferenceSnapshot lastSnapshot;
    private Disposable activationDisposable;
    private boolean isEnabled;
    private final Project project;
    private final Disposable parentDisposable;
    private final SmartPsiElementPointer<PsiFile> psiFilePointer;
    private final Function0<Unit> requestRefresh;

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean value2) {
        if (value2 != this.isEnabled) {
            this.isEnabled = value2;
            if (value2) {
                this.activate();
            } else {
                this.deactivate();
            }
        }
    }

    private final synchronized void onDocumentUpdated(long lastUpdateNanos) {
        boolean requestRefresh = false;
        Iterable $this$forEach$iv = this.lastSnapshot.getModified();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LiteralReference it = (LiteralReference)element$iv;
            boolean bl = false;
            if (it.getConstantValue() == null) {
                continue;
            }
            Iterable $this$forEach$iv2 = it.getUsages();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Object constantValue;
                LiteralUsageReference elementPath = (LiteralUsageReference)element$iv2;
                boolean bl2 = false;
                ConstantRemapperManager.INSTANCE.getConstantRemapper().addConstant(null, elementPath, it.getInitialConstantValue(), constantValue);
                this.LOG.debug('[' + it.getUniqueId() + "] Constant updated to " + it.getText() + " path=" + elementPath);
            }
            requestRefresh = true;
        }
        if (requestRefresh) {
            this.requestRefresh.invoke();
        }
    }

    private final synchronized void activate() {
        block3: {
            PsiFile psiFile2 = (PsiFile)this.psiFilePointer.getElement();
            if (psiFile2 == null) break block3;
            PsiFile psiFile3 = psiFile2;
            boolean bl = false;
            boolean bl2 = false;
            PsiFile file2 = psiFile3;
            boolean bl3 = false;
            PsiFile psiFile4 = file2;
            Intrinsics.checkNotNullExpressionValue((Object)psiFile4, (String)"file");
            this.lastSnapshot = this.literalsManager.findLiterals((PsiElement)psiFile4);
            Iterable $this$forEach$iv = this.lastSnapshot.getAll();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LiteralReference it = (LiteralReference)element$iv;
                boolean bl4 = false;
                String elementPathString2 = CollectionsKt.joinToString$default((Iterable)it.getUsages(), (CharSequence)"\n", null, null, (int)0, null, (Function1)activate.1.1.elementPathString.1.INSTANCE, (int)30, null);
                this.LOG.debug('[' + it.getUniqueId() + "] Found constant " + it.getText() + " \n" + elementPathString2 + "\n\n");
            }
            Disposable disposable2 = Disposer.newDisposable();
            Intrinsics.checkNotNullExpressionValue((Object)disposable2, (String)"Disposer.newDisposable()");
            Disposable newActivationDisposable = disposable2;
            Editor editor2 = PsiEditorUtil.findEditor((PsiElement)((PsiElement)file2));
            if (editor2 != null) {
                HighlightManager highlightManager = HighlightManager.getInstance((Project)this.project);
                boolean bl5 = false;
                Set outHighlighters = new LinkedHashSet();
                LiteralsManagerKt.highlightSnapshotInEditor(this.lastSnapshot, this.project, editor2, this.LITERAL_TEXT_ATTRIBUTE, outHighlighters);
                Collection collection2 = outHighlighters;
                boolean bl6 = false;
                if (!collection2.isEmpty()) {
                    Disposer.register((Disposable)newActivationDisposable, (Disposable)new Disposable(outHighlighters, highlightManager, editor2){
                        final /* synthetic */ Set $outHighlighters;
                        final /* synthetic */ HighlightManager $highlightManager;
                        final /* synthetic */ Editor $editor;

                        public final void dispose() {
                            Iterable $this$forEach$iv = this.$outHighlighters;
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                RangeHighlighter it = (RangeHighlighter)element$iv;
                                boolean bl = false;
                                this.$highlightManager.removeSegmentHighlighter(this.$editor, it);
                            }
                        }
                        {
                            this.$outHighlighters = set;
                            this.$highlightManager = highlightManager;
                            this.$editor = editor2;
                        }
                    });
                }
            }
            Function1 function1 = (Function1)new Function1<Long, Unit>(this){

                public final void invoke(long p1) {
                    LiveLiteralsManager.access$onDocumentUpdated((LiveLiteralsManager)this.receiver, p1);
                }
            };
            MergingUpdateQueue mergingUpdateQueue = this.updateMergingQueue;
            Intrinsics.checkNotNullExpressionValue((Object)mergingUpdateQueue, (String)"updateMergingQueue");
            ChangeManagerKt.setupChangeListener$default(this.project, file2, function1, newActivationDisposable, mergingUpdateQueue, null, 32, null);
            ChangeManagerKt.setupBuildListener(this.project, new BuildListener(this){
                final /* synthetic */ LiveLiteralsManager this$0;
                {
                    this.this$0 = liveLiteralsManager2;
                }

                public void buildSucceeded() {
                    ConstantRemapperManager.INSTANCE.getConstantRemapper().clearConstants(null);
                }

                public void buildFailed() {
                    ConstantRemapperManager.INSTANCE.getConstantRemapper().clearConstants(null);
                }

                public void buildStarted() {
                    LiveLiteralsManager.access$deactivate(this.this$0);
                }
            }, newActivationDisposable);
            Disposer.register((Disposable)this.parentDisposable, (Disposable)newActivationDisposable);
            this.activationDisposable = newActivationDisposable;
        }
    }

    private final synchronized void deactivate() {
        this.setEnabled(false);
        ConstantRemapperManager.INSTANCE.getConstantRemapper().clearConstants(null);
        Disposable disposable2 = this.activationDisposable;
        if (disposable2 != null) {
            Disposable disposable3 = disposable2;
            boolean bl = false;
            boolean bl2 = false;
            Disposable it = disposable3;
            boolean bl3 = false;
            Disposer.dispose((Disposable)it);
        }
        this.activationDisposable = null;
        this.requestRefresh.invoke();
    }

    public void dispose() {
        this.deactivate();
    }

    public LiveLiteralsManager(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull SmartPsiElementPointer<PsiFile> psiFilePointer, @NotNull Function0<Unit> requestRefresh) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter(psiFilePointer, (String)"psiFilePointer");
        Intrinsics.checkNotNullParameter(requestRefresh, (String)"requestRefresh");
        this.project = project;
        this.parentDisposable = parentDisposable;
        this.psiFilePointer = psiFilePointer;
        this.requestRefresh = requestRefresh;
        Logger logger2 = Logger.getInstance(LiveLiteralsManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(LiveL\u2026eralsManager::class.java)");
        this.LOG = logger2;
        this.LITERAL_TEXT_ATTRIBUTE = new TextAttributes(UIUtil.getActiveTextColor(), null, UIUtil.getInactiveTextColor(), EffectType.ROUNDED_BOX, 1);
        this.updateMergingQueue = new MergingUpdateQueue("Live literals change queue", 200, true, null, this.parentDisposable, null, false).setRestartTimerOnAdd(true);
        this.literalsManager = new LiteralsManager(null, null, 3, null);
        this.lastSnapshot = EmptyLiteralReferenceSnapshot.INSTANCE;
        Disposer.register((Disposable)this.parentDisposable, (Disposable)this);
    }

    public static final /* synthetic */ void access$onDocumentUpdated(LiveLiteralsManager $this, long lastUpdateNanos) {
        $this.onDocumentUpdated(lastUpdateNanos);
    }

    public static final /* synthetic */ void access$deactivate(LiveLiteralsManager $this) {
        $this.deactivate();
    }
}

