/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation;

import androidx.compose.animation.tooling.ComposeAnimation;
import androidx.compose.animation.tooling.ComposeAnimationType;
import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.compose.preview.analytics.AnimationToolingEvent;
import com.android.tools.idea.compose.preview.analytics.AnimationToolingUsageTracker;
import com.android.tools.idea.compose.preview.animation.AnimationClock;
import com.android.tools.idea.compose.preview.animation.AnimationInspectorPanel;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.ComposeAnimationToolingEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.UIUtil;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0010\u001a\u00020\nJ&\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\u0006\u0010\u0017\u001a\u00020\nJ\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\nJ\u0018\u0010\u001b\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001d\u001a\u00020\rJ\u000e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\rR$\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u00048G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposePreviewAnimationManager;", "", "()V", "<set-?>", "Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel;", "currentInspector", "getCurrentInspector", "()Lcom/android/tools/idea/compose/preview/animation/AnimationInspectorPanel;", "newInspectorOpenedCallback", "Lkotlin/Function0;", "", "subscribedAnimations", "", "Landroidx/compose/animation/tooling/ComposeAnimation;", "getSubscribedAnimations", "()Ljava/util/Set;", "closeCurrentInspector", "createAnimationInspectorPanel", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "parent", "Lcom/intellij/openapi/Disposable;", "onNewInspectorOpen", "invalidate", "isInspectorOpen", "", "onAnimationInspectorOpened", "onAnimationSubscribed", "clock", "animation", "onAnimationUnsubscribed", "intellij.android.compose-designer"})
public final class ComposePreviewAnimationManager {
    @Nullable
    private static AnimationInspectorPanel currentInspector;
    @NotNull
    private static final Set<ComposeAnimation> subscribedAnimations;
    private static Function0<Unit> newInspectorOpenedCallback;
    @NotNull
    public static final ComposePreviewAnimationManager INSTANCE;

    @VisibleForTesting
    @Nullable
    public final AnimationInspectorPanel getCurrentInspector() {
        return currentInspector;
    }

    @VisibleForTesting
    @NotNull
    public final Set<ComposeAnimation> getSubscribedAnimations() {
        return subscribedAnimations;
    }

    @Slow
    @NotNull
    public final AnimationInspectorPanel createAnimationInspectorPanel(@NotNull DesignSurface surface2, @NotNull Disposable parent, @NotNull Function0<Unit> onNewInspectorOpen) {
        Intrinsics.checkNotNullParameter((Object)((Object)surface2), (String)"surface");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(onNewInspectorOpen, (String)"onNewInspectorOpen");
        newInspectorOpenedCallback = onNewInspectorOpen;
        AnimationToolingUsageTracker.Companion.getInstance(surface2).logEvent(new AnimationToolingEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.OPEN_ANIMATION_INSPECTOR));
        return (AnimationInspectorPanel)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<AnimationInspectorPanel>(surface2, parent){
            final /* synthetic */ DesignSurface $surface;
            final /* synthetic */ Disposable $parent;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final AnimationInspectorPanel invoke() {
                void var1_1;
                AnimationInspectorPanel animationInspectorPanel = new AnimationInspectorPanel(this.$surface);
                Disposer.register((Disposable)this.$parent, (Disposable)animationInspectorPanel);
                ComposePreviewAnimationManager.access$setCurrentInspector$p(ComposePreviewAnimationManager.INSTANCE, animationInspectorPanel);
                return var1_1;
            }
            {
                this.$surface = designSurface;
                this.$parent = disposable2;
                super(0);
            }
        }), (int)1, null);
    }

    public final void closeCurrentInspector() {
        AnimationInspectorPanel animationInspectorPanel = currentInspector;
        if (animationInspectorPanel != null) {
            AnimationInspectorPanel animationInspectorPanel2 = animationInspectorPanel;
            boolean bl = false;
            boolean bl2 = false;
            AnimationInspectorPanel it = animationInspectorPanel2;
            boolean bl3 = false;
            Disposer.dispose((Disposable)it);
            AnimationToolingUsageTracker.Companion.getInstance(it.getSurface$intellij_android_compose_designer()).logEvent(new AnimationToolingEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CLOSE_ANIMATION_INSPECTOR));
        }
        currentInspector = null;
        newInspectorOpenedCallback = null;
        subscribedAnimations.clear();
    }

    public final void onAnimationInspectorOpened() {
        block0: {
            Function0<Unit> function0 = newInspectorOpenedCallback;
            if (function0 == null) break block0;
            Unit cfr_ignored_0 = (Unit)function0.invoke();
        }
    }

    public final void onAnimationSubscribed(@Nullable Object clock, @NotNull ComposeAnimation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        if (clock == null) {
            return;
        }
        AnimationInspectorPanel animationInspectorPanel = currentInspector;
        if (animationInspectorPanel == null) {
            return;
        }
        AnimationInspectorPanel inspector = animationInspectorPanel;
        if (inspector.getAnimationClock$intellij_android_compose_designer() == null) {
            inspector.setAnimationClock$intellij_android_compose_designer(new AnimationClock(clock));
        }
        AnimationClock animationClock = inspector.getAnimationClock$intellij_android_compose_designer();
        if (animationClock != null) {
            AnimationClock animationClock2 = animationClock;
            boolean bl = false;
            boolean bl2 = false;
            AnimationClock it = animationClock2;
            boolean bl3 = false;
            if (Intrinsics.areEqual((Object)it.getClock(), (Object)clock) ^ true) {
                Iterator<ComposeAnimation> subscribedAnimationsIterator;
                Iterator<ComposeAnimation> iterator = subscribedAnimationsIterator = subscribedAnimations.iterator();
                boolean bl4 = false;
                Iterator<ComposeAnimation> iterator2 = iterator;
                while (iterator2.hasNext()) {
                    ComposeAnimation subscribedAnimation = iterator2.next();
                    INSTANCE.onAnimationUnsubscribed(subscribedAnimation);
                }
                inspector.setAnimationClock$intellij_android_compose_designer(new AnimationClock(clock));
            }
        }
        if (subscribedAnimations.add(animation)) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(inspector, animation){
                final /* synthetic */ AnimationInspectorPanel $inspector;
                final /* synthetic */ ComposeAnimation $animation;

                public final void run() {
                    this.$inspector.addTab$intellij_android_compose_designer(this.$animation);
                    if (this.$animation.getType() == ComposeAnimationType.TRANSITION_ANIMATION) {
                        this.$inspector.updateTransitionStates(this.$animation, this.$animation.getStates());
                    }
                }
                {
                    this.$inspector = animationInspectorPanel;
                    this.$animation = composeAnimation;
                }
            });
        }
    }

    public final void onAnimationUnsubscribed(@NotNull ComposeAnimation animation) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        if (subscribedAnimations.remove(animation)) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(animation){
                final /* synthetic */ ComposeAnimation $animation;

                public final void run() {
                    block0: {
                        AnimationInspectorPanel animationInspectorPanel = ComposePreviewAnimationManager.INSTANCE.getCurrentInspector();
                        if (animationInspectorPanel == null) break block0;
                        animationInspectorPanel.removeTab$intellij_android_compose_designer(this.$animation);
                    }
                }
                {
                    this.$animation = composeAnimation;
                }
            });
        }
    }

    public final boolean isInspectorOpen() {
        return currentInspector != null;
    }

    public final void invalidate() {
        block0: {
            AnimationInspectorPanel animationInspectorPanel = currentInspector;
            if (animationInspectorPanel == null) break block0;
            AnimationInspectorPanel animationInspectorPanel2 = animationInspectorPanel;
            boolean bl = false;
            boolean bl2 = false;
            AnimationInspectorPanel it = animationInspectorPanel2;
            boolean bl3 = false;
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(it){
                final /* synthetic */ AnimationInspectorPanel $it;

                public final void run() {
                    this.$it.invalidatePanel$intellij_android_compose_designer();
                }
                {
                    this.$it = animationInspectorPanel;
                }
            });
        }
    }

    private ComposePreviewAnimationManager() {
    }

    static {
        ComposePreviewAnimationManager composePreviewAnimationManager;
        INSTANCE = composePreviewAnimationManager = new ComposePreviewAnimationManager();
        boolean bl = false;
        subscribedAnimations = new LinkedHashSet();
    }

    public static final /* synthetic */ AnimationInspectorPanel access$getCurrentInspector$p(ComposePreviewAnimationManager $this) {
        ComposePreviewAnimationManager composePreviewAnimationManager = $this;
        return currentInspector;
    }

    public static final /* synthetic */ void access$setCurrentInspector$p(ComposePreviewAnimationManager $this, AnimationInspectorPanel animationInspectorPanel) {
        ComposePreviewAnimationManager composePreviewAnimationManager = $this;
        currentInspector = animationInspectorPanel;
    }
}

