/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview;

import com.android.tools.idea.common.util.ChangeManagerKt;
import com.android.tools.idea.compose.preview.NeedsBuild;
import com.android.tools.idea.compose.preview.NotReady;
import com.android.tools.idea.compose.preview.OutOfDate;
import com.android.tools.idea.compose.preview.ProjectBuildStatusManagerKt;
import com.android.tools.idea.compose.preview.ProjectStatus;
import com.android.tools.idea.compose.preview.Ready;
import com.android.tools.idea.compose.preview.util.BuildKt;
import com.android.tools.idea.gradle.project.build.BuildContext;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.GradleBuildListener;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.util.SyncUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e8F@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/compose/preview/ProjectBuildStatusManager;", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "editorFile", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/psi/PsiFile;)V", "lastModificationCount", "", "modificationTracker", "Lcom/intellij/openapi/util/ModificationTracker;", "project", "Lcom/intellij/openapi/project/Project;", "value", "Lcom/android/tools/idea/compose/preview/ProjectStatus;", "status", "getStatus", "()Lcom/android/tools/idea/compose/preview/ProjectStatus;", "setStatus", "(Lcom/android/tools/idea/compose/preview/ProjectStatus;)V", "isBuildOutOfDate", "", "intellij.android.compose-designer"})
public final class ProjectBuildStatusManager {
    private final ModificationTracker modificationTracker;
    private long lastModificationCount;
    private final Project project;
    @NotNull
    private ProjectStatus status;

    @NotNull
    public final ProjectStatus getStatus() {
        return this.isBuildOutOfDate() ? (ProjectStatus)OutOfDate.INSTANCE : this.status;
    }

    private final void setStatus(ProjectStatus value2) {
        if (Intrinsics.areEqual((Object)this.status, (Object)value2) ^ true) {
            ProjectBuildStatusManagerKt.access$getLOG$p().debug("Status change old = " + this.status + ", new = " + value2);
            this.status = value2;
        }
    }

    private final boolean isBuildOutOfDate() {
        return this.lastModificationCount < this.modificationTracker.getModificationCount();
    }

    public ProjectBuildStatusManager(@NotNull Disposable parentDisposable, final @NotNull PsiFile editorFile) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)editorFile, (String)"editorFile");
        VirtualFile virtualFile = editorFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"editorFile.virtualFile");
        this.modificationTracker = (ModificationTracker)virtualFile;
        this.lastModificationCount = this.modificationTracker.getModificationCount();
        Project project = editorFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"editorFile.project");
        this.project = project;
        this.status = NotReady.INSTANCE;
        GradleBuildState.subscribe(this.project, new GradleBuildListener.Adapter(){

            @Override
            public void buildStarted(@NotNull BuildContext context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                ProjectBuildStatusManagerKt.access$getLOG$p().debug("buildStarted " + context);
                if (context.getBuildMode() == BuildMode.CLEAN) {
                    this.setStatus(NeedsBuild.INSTANCE);
                }
            }

            @Override
            public void buildFinished(@NotNull BuildStatus buildStatus, @Nullable BuildContext context) {
                Intrinsics.checkNotNullParameter((Object)((Object)buildStatus), (String)"buildStatus");
                ProjectBuildStatusManagerKt.access$getLOG$p().debug("buildFinished " + (Object)((Object)buildStatus) + ' ' + context);
                lastModificationCount = modificationTracker.getModificationCount();
                BuildContext buildContext = context;
                if ((buildContext != null ? buildContext.getBuildMode() : null) == BuildMode.CLEAN) {
                    return;
                }
                if (ChangeManagerKt.isSuccess(buildStatus)) {
                    this.setStatus(new Ready(false, 1, null));
                } else {
                    ProjectStatus projectStatus = this.getStatus();
                    this.setStatus(projectStatus instanceof Ready ? (ProjectStatus)new Ready(false) : (ProjectStatus)NeedsBuild.INSTANCE);
                }
            }
        });
        SyncUtil.runWhenSmartAndSyncedOnEdt$default(this.project, parentDisposable, new Consumer(){

            public final void accept(@NotNull ProjectSystemSyncManager.SyncResult it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                if (this.getStatus() == NotReady.INSTANCE) {
                    lastModificationCount = modificationTracker.getModificationCount();
                    this.setStatus(BuildKt.hasBeenBuiltSuccessfully(project, (Function0<? extends PsiFile>)((Function0)new Function0<PsiFile>(){

                        @NotNull
                        public final PsiFile invoke() {
                            return editorFile;
                        }
                    })) ? (ProjectStatus)new Ready(false, 1, null) : (ProjectStatus)NeedsBuild.INSTANCE);
                }
            }
        }, null, 4, null);
    }

    public static final /* synthetic */ ProjectStatus access$getStatus$p(ProjectBuildStatusManager $this) {
        return $this.getStatus();
    }

    public static final /* synthetic */ long access$getLastModificationCount$p(ProjectBuildStatusManager $this) {
        return $this.lastModificationCount;
    }
}

