/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview;

import com.android.tools.idea.compose.preview.ComposePreviewBundle;
import com.android.tools.idea.compose.preview.ComposePreviewManager;
import com.android.tools.idea.compose.preview.ComposePreviewRepresentationProviderKt;
import com.android.tools.idea.compose.preview.NotificationsKt;
import com.android.tools.idea.compose.preview.util.UtilsKt;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gradle.project.build.BuildStatus;
import com.android.tools.idea.gradle.project.build.BuildSummary;
import com.android.tools.idea.gradle.project.build.GradleBuildState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LightColors;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00020\u00020\u0005\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/compose/preview/ComposePreviewNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "()V", "COMPONENT_KEY", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "getKey", "intellij.android.compose-designer"})
public final class ComposePreviewNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private final Key<EditorNotificationPanel> COMPONENT_KEY;
    private final Logger LOG;

    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.LOG.debug("createNotificationsProvider");
        if (!((Boolean)StudioFlags.COMPOSE_PREVIEW.get()).booleanValue() || !UtilsKt.isKotlinFileType(file2)) {
            return null;
        }
        ComposePreviewManager composePreviewManager = ComposePreviewRepresentationProviderKt.getComposePreviewManager(fileEditor);
        if (composePreviewManager == null) {
            return null;
        }
        ComposePreviewManager previewManager = composePreviewManager;
        ComposePreviewManager.Status status = previewManager.status();
        if (status == null) {
            return null;
        }
        ComposePreviewManager.Status previewStatus = status;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug(previewStatus.toString());
        }
        if (previewStatus.isRefreshing()) {
            this.LOG.debug("Refresh in progress");
            EditorNotificationPanel editorNotificationPanel = new EditorNotificationPanel(fileEditor);
            boolean bl = false;
            boolean bl2 = false;
            EditorNotificationPanel $this$apply = editorNotificationPanel;
            boolean bl3 = false;
            $this$apply.setText(ComposePreviewBundle.message("notification.preview.is.refreshing", new Object[0]));
            $this$apply.icon((Icon)new AnimatedIcon.Default());
            return editorNotificationPanel;
        }
        GradleBuildState gradleBuildState = GradleBuildState.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gradleBuildState, (String)"GradleBuildState.getInstance(project)");
        GradleBuildState gradleBuildState2 = gradleBuildState;
        if (gradleBuildState2.isBuildInProgress()) {
            this.LOG.debug("Build in progress");
            return null;
        }
        GradleBuildState gradleBuildState3 = GradleBuildState.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)gradleBuildState3, (String)"GradleBuildState.getInstance(project)");
        BuildSummary buildSummary = gradleBuildState3.getSummary();
        BuildStatus status2 = buildSummary != null ? buildSummary.getStatus() : null;
        boolean lastBuildSuccessful = status2 == null || status2.isBuildSuccessful();
        return !lastBuildSuccessful ? NotificationsKt.createBuildNotificationPanel$default(project, file2, ComposePreviewBundle.message("notification.needs.build.broken", new Object[0]), null, LightColors.RED, 8, null) : (previewStatus.isOutOfDate() ? NotificationsKt.createBuildNotificationPanel$default(project, file2, ComposePreviewBundle.message("notification.preview.out.of.date", new Object[0]), ComposePreviewBundle.message("notification.action.build.and.refresh", new Object[0]) + com.android.tools.idea.editors.shortcuts.UtilsKt.asString$default(com.android.tools.idea.editors.shortcuts.UtilsKt.getBuildAndRefreshShortcut(), null, null, 3, null), null, 16, null) : (previewStatus.getHasErrors() ? NotificationsKt.createBuildNotificationPanel$default(project, file2, previewStatus.getHasSyntaxErrors() ? ComposePreviewBundle.message("notification.syntax.errors", new Object[0]) : ComposePreviewBundle.message("notification.needs.build", new Object[0]), null, LightColors.RED, 8, null) : null));
    }

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return this.COMPONENT_KEY;
    }

    public ComposePreviewNotificationProvider() {
        Key key = Key.create((String)"android.tools.compose.preview.notification");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<EditorNotific\u2026se.preview.notification\")");
        this.COMPONENT_KEY = key;
        Logger logger2 = Logger.getInstance(ComposePreviewNotificationProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"Logger.getInstance(Compo\u2026tionProvider::class.java)");
        this.LOG = logger2;
    }
}

