/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.util;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NlTreeDumper {
    private final Map<NlComponent, Integer> myComponentIds;
    private final boolean myIncludeIdentity;
    private final boolean myShowBoundaries;

    public NlTreeDumper() {
        this(true, true);
    }

    public NlTreeDumper(boolean includeIdentity, boolean showBoundaries) {
        this.myComponentIds = includeIdentity ? new HashMap() : Collections.emptyMap();
        this.myIncludeIdentity = includeIdentity;
        this.myShowBoundaries = showBoundaries;
    }

    @NotNull
    public static String dumpTree(@NotNull List<NlComponent> roots) {
        if (roots == null) {
            NlTreeDumper.$$$reportNull$$$0(0);
        }
        String string = new NlTreeDumper(false, true).toTree(roots);
        if (string == null) {
            NlTreeDumper.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String toTree(@NotNull List<NlComponent> roots) {
        if (roots == null) {
            NlTreeDumper.$$$reportNull$$$0(2);
        }
        StringBuilder sb = new StringBuilder(200);
        for (NlComponent root2 : roots) {
            this.describe(sb, root2, 0, new HashSet<NlComponent>());
        }
        String string = sb.toString().trim();
        if (string == null) {
            NlTreeDumper.$$$reportNull$$$0(3);
        }
        return string;
    }

    private void describe(@NotNull StringBuilder sb, @NotNull NlComponent component, int depth, @NotNull HashSet<NlComponent> visited) {
        if (sb == null) {
            NlTreeDumper.$$$reportNull$$$0(4);
        }
        if (component == null) {
            NlTreeDumper.$$$reportNull$$$0(5);
        }
        if (visited == null) {
            NlTreeDumper.$$$reportNull$$$0(6);
        }
        boolean isLoop = !visited.add(component);
        for (int i2 = 0; i2 < depth; ++i2) {
            sb.append("    ");
        }
        if (isLoop) {
            sb.append("!!LOOP!! ");
        }
        sb.append(this.describe(component)).append('\n');
        if (isLoop) {
            return;
        }
        for (NlComponent child : component.getChildren()) {
            this.describe(sb, child, depth + 1, visited);
        }
    }

    @NotNull
    private String describe(@NotNull NlComponent root2) {
        if (root2 == null) {
            NlTreeDumper.$$$reportNull$$$0(7);
        }
        MoreObjects.ToStringHelper helper2 = MoreObjects.toStringHelper((Object)root2).omitNullValues().add("tag", (Object)("<" + root2.getTagName() + ">"));
        if (this.myShowBoundaries && NlComponentHelperKt.getHasNlComponentInfo(root2)) {
            helper2.add("bounds", (Object)("[" + NlComponentHelperKt.getX(root2) + "," + NlComponentHelperKt.getY(root2) + ":" + NlComponentHelperKt.getW(root2) + "x" + NlComponentHelperKt.getH(root2)));
        }
        if (this.myIncludeIdentity) {
            helper2.add("instance", this.getInstanceId(root2));
        }
        String string = helper2.toString();
        if (string == null) {
            NlTreeDumper.$$$reportNull$$$0(8);
        }
        return string;
    }

    private int getInstanceId(@NotNull NlComponent root2) {
        Integer id;
        if (root2 == null) {
            NlTreeDumper.$$$reportNull$$$0(9);
        }
        if ((id = this.myComponentIds.get(root2)) == null) {
            id = this.myComponentIds.size();
            this.myComponentIds.put(root2, id);
        }
        return id;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/util/NlTreeDumper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/util/NlTreeDumper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toTree";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "dumpTree";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toTree";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "describe";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

