/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.scene.Display;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class SceneLayer
extends Layer {
    private final DesignSurface myDesignSurface;
    private final SceneView mySceneView;
    private final Dimension myScreenViewSize;
    private final Rectangle mySizeRectangle;
    private final Rectangle mySurfaceRectangle;
    private final Display myDisplay;
    private boolean myShowOnHover;
    private boolean myShowAlways;
    private boolean myAlwaysShowSelection;
    private boolean myTemporaryShow;

    public SceneLayer(@NotNull DesignSurface surface2, @NotNull SceneView view, boolean showAlways) {
        if (surface2 == null) {
            SceneLayer.$$$reportNull$$$0(0);
        }
        if (view == null) {
            SceneLayer.$$$reportNull$$$0(1);
        }
        this.myScreenViewSize = new Dimension();
        this.mySizeRectangle = new Rectangle();
        this.mySurfaceRectangle = new Rectangle();
        this.myDisplay = new Display();
        this.myShowOnHover = false;
        this.myShowAlways = true;
        this.myTemporaryShow = false;
        this.myDesignSurface = surface2;
        this.mySceneView = view;
        this.myShowAlways = showAlways;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(@NotNull Graphics2D g2) {
        NlDesignSurface designSurface;
        if (g2 == null) {
            SceneLayer.$$$reportNull$$$0(2);
        }
        SceneContext sceneContext = SceneContext.get(this.mySceneView);
        if (!(this.myTemporaryShow || this.myShowOnHover || this.myShowAlways || this.myAlwaysShowSelection)) {
            return;
        }
        if (!this.myShowAlways && this.getSceneView().getSurface() instanceof NlDesignSurface && (designSurface = (NlDesignSurface)this.getSceneView().getSurface()).isRenderingSynchronously() && !designSurface.isInAnimationScrubbing()) {
            return;
        }
        sceneContext.setShowOnlySelection(!this.myTemporaryShow && !this.myShowOnHover && this.myAlwaysShowSelection);
        Graphics2D g = (Graphics2D)g2.create();
        try {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.mySceneView.getScaledContentSize(this.myScreenViewSize);
            Rectangle clipBounds = g.getClipBounds();
            this.mySizeRectangle.setBounds(this.mySceneView.getX(), this.mySceneView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
            Rectangle2D.intersect(this.mySizeRectangle, clipBounds, this.mySizeRectangle);
            if (this.mySizeRectangle.isEmpty()) {
                return;
            }
            sceneContext.setRenderableBounds(clipBounds);
            if (this.myShowAlways) {
                this.paintBackground(g, sceneContext);
            }
            this.myDisplay.draw(sceneContext, g, this.mySceneView.getScene());
        }
        finally {
            g.dispose();
        }
    }

    private void paintBackground(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Color backgroundColor;
        if (g == null) {
            SceneLayer.$$$reportNull$$$0(3);
        }
        if (sceneContext == null) {
            SceneLayer.$$$reportNull$$$0(4);
        }
        if ((backgroundColor = sceneContext.getColorSet().getBackground()) == null) {
            return;
        }
        Shape shape = this.mySceneView.getScreenShape();
        if (shape == null) {
            g.setColor(backgroundColor);
            g.fillRect(this.mySizeRectangle.x, this.mySizeRectangle.y, this.mySizeRectangle.width, this.mySizeRectangle.height);
        } else {
            g.setColor(backgroundColor.darker());
            g.fillRect(this.mySizeRectangle.x, this.mySizeRectangle.y, this.mySizeRectangle.width, this.mySizeRectangle.height);
            Shape clip = g.getClip();
            g.setColor(backgroundColor);
            g.setClip(shape);
            g.fillRect(this.mySizeRectangle.x, this.mySizeRectangle.y, this.mySizeRectangle.width, this.mySizeRectangle.height);
            g.setClip(clip);
        }
    }

    public boolean isShowOnHover() {
        return this.myShowOnHover;
    }

    public void setShowOnHover(boolean value2) {
        this.myShowOnHover = value2;
    }

    public SceneView getSceneView() {
        return this.mySceneView;
    }

    @Override
    public void onHover(int x, int y) {
        boolean show = false;
        if (this.getSceneView() == this.myDesignSurface.getHoverSceneView(x, y)) {
            show = true;
        }
        if (this.isShowOnHover() != show) {
            this.setShowOnHover(show);
            this.myDesignSurface.repaint();
        }
    }

    public void setAlwaysShowSelection(boolean alwaysShowSelection) {
        this.myAlwaysShowSelection = alwaysShowSelection;
    }

    public void setTemporaryShow(boolean temporaryShow) {
        this.myTemporaryShow = temporaryShow;
        this.myDisplay.reLayout();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneContext";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/common/surface/SceneLayer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "paint";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "paintBackground";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

