/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.api.DragType;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.editor.ActionUtils;
import com.android.tools.idea.common.editor.DesignToolsSplitEditor;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceShortcut;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.InteractionHandlerKt;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.SceneViewHelper;
import com.android.tools.idea.common.surface.ScrollInteraction;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.surface.DragDropInteraction;
import com.android.tools.idea.uibuilder.surface.PanInteraction;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\rH\u0016J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0011H\u0016J$\u0010\u0014\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0011H\u0016J\"\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0011H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\"\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0011H\u0016J\u0010\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\"\u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0011H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/common/surface/InteractionHandlerBase;", "Lcom/android/tools/idea/common/surface/InteractionHandler;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "cursorWhenNoInteraction", "Ljava/awt/Cursor;", "createInteractionOnDragEnter", "Lcom/android/tools/idea/common/surface/Interaction;", "dragEvent", "Ljava/awt/dnd/DropTargetDragEvent;", "createInteractionOnMouseWheelMoved", "mouseWheelEvent", "Ljava/awt/event/MouseWheelEvent;", "doubleClick", "", "x", "", "y", "modifiersEx", "getCursorWhenNoInteraction", "mouseX", "mouseY", "hoverWhenNoInteraction", "keyPressedWithoutInteraction", "keyEvent", "Ljava/awt/event/KeyEvent;", "keyReleasedWithoutInteraction", "mouseReleaseWhenNoInteraction", "popupMenuTrigger", "mouseEvent", "Ljava/awt/event/MouseEvent;", "singleClick", "intellij.android.designer"})
public abstract class InteractionHandlerBase
implements InteractionHandler {
    private Cursor cursorWhenNoInteraction;
    private final DesignSurface surface;

    @Override
    @Nullable
    public Interaction createInteractionOnDragEnter(@NotNull DropTargetDragEvent dragEvent) {
        Intrinsics.checkNotNullParameter((Object)dragEvent, (String)"dragEvent");
        NlDropEvent event = new NlDropEvent(dragEvent);
        Point location = dragEvent.getLocation();
        int mouseX = location.x;
        int mouseY = location.y;
        SceneView sceneView = this.surface.getSceneView(mouseX, mouseY);
        if (sceneView == null) {
            event.reject();
            return null;
        }
        NlModel nlModel = sceneView.getModel();
        Intrinsics.checkNotNullExpressionValue((Object)nlModel, (String)"sceneView.model");
        NlModel model2 = nlModel;
        DnDTransferItem item = DnDTransferItem.getTransferItem(event.getTransferable(), true);
        if (item == null) {
            event.reject();
            return null;
        }
        DragType dragType = event.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
        InsertType insertType = model2.determineInsertType(dragType, item, true);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)insertType), (String)"model.determineInsertTyp\u2026item, true /* preview */)");
        InsertType insertType2 = insertType;
        List<NlComponent> dragged = null;
        Object object = StudioFlags.NELE_DRAG_PLACEHOLDER.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"StudioFlags.NELE_DRAG_PLACEHOLDER.get()");
        if (((Boolean)object).booleanValue() && !item.isFromPalette()) {
            dragged = new ArrayList(this.surface.getSelectionModel().getSelection());
        } else {
            if (item.isFromPalette()) {
                this.surface.getSelectionModel().clear();
            }
            List<NlComponent> list = model2.createComponents(item, insertType2, this.surface);
            Intrinsics.checkNotNullExpressionValue(list, (String)"model.createComponents(item, insertType, surface)");
            dragged = list;
        }
        if (dragged.isEmpty()) {
            event.reject();
            return null;
        }
        DragDropInteraction interaction = new DragDropInteraction(this.surface, dragged);
        interaction.setType(dragType);
        interaction.setTransferItem(item);
        event.accept(insertType2);
        return interaction;
    }

    @Override
    public void mouseReleaseWhenNoInteraction(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        block0: {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Intrinsics.checkNotNullExpressionValue((Object)toolkit, (String)"Toolkit.getDefaultToolkit()");
            boolean allowToggle = (modifiersEx & (1 | toolkit.getMenuShortcutKeyMask())) != 0;
            SceneView sceneView = this.surface.getSceneView(x, y);
            if (sceneView == null) break block0;
            SceneViewHelper.selectComponentAt(sceneView, x, y, modifiersEx, allowToggle, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void hoverWhenNoInteraction(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        void $this$forEach$iv;
        void $this$mapTo$iv$iv;
        SceneView sceneView = this.surface.getSceneView(mouseX, mouseY);
        if (sceneView != null) {
            SceneContext sceneContext = sceneView.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)sceneContext, (String)"sceneView.context");
            SceneContext context = sceneContext;
            context.setMouseLocation(mouseX, mouseY);
            sceneView.getScene().mouseHover(context, Coordinates.getAndroidXDip(sceneView, mouseX), Coordinates.getAndroidYDip(sceneView, mouseY), modifiersEx);
            Scene scene = sceneView.getScene();
            Intrinsics.checkNotNullExpressionValue((Object)scene, (String)"sceneView.scene");
            this.cursorWhenNoInteraction = scene.getMouseCursor();
        } else {
            this.cursorWhenNoInteraction = null;
        }
        ImmutableList<SceneManager> immutableList = this.surface.getSceneManagers();
        Intrinsics.checkNotNullExpressionValue(immutableList, (String)"surface.sceneManagers");
        Iterable $this$map$iv = (Iterable)immutableList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SceneManager sceneManager = (SceneManager)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            void v3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
            SceneView sceneView2 = v3.getSceneView();
            collection2.add(sceneView2);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SceneView it = (SceneView)element$iv;
            boolean bl = false;
            it.onHover(mouseX, mouseY);
        }
    }

    @Override
    public void popupMenuTrigger(@NotNull MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
        int x = mouseEvent.getX();
        int y = mouseEvent.getY();
        int modifiersEx = mouseEvent.getModifiersEx();
        SceneView sceneView = this.surface.getSceneView(x, y);
        if (sceneView != null) {
            NlComponent component = SceneViewHelper.selectComponentAt(sceneView, x, y, modifiersEx, false, true);
            DefaultActionGroup defaultActionGroup = this.surface.getActionManager().getPopupMenuActions(component);
            Intrinsics.checkNotNullExpressionValue((Object)defaultActionGroup, (String)"surface.actionManager.ge\u2026pupMenuActions(component)");
            DefaultActionGroup actions2 = defaultActionGroup;
            ActionUtils.showPopup(this.surface, mouseEvent, (ActionGroup)actions2, "LayoutEditor");
        }
    }

    @Override
    @Nullable
    public Interaction createInteractionOnMouseWheelMoved(@NotNull MouseWheelEvent mouseWheelEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseWheelEvent, (String)"mouseWheelEvent");
        int x = mouseWheelEvent.getX();
        int y = mouseWheelEvent.getY();
        SceneView sceneView = this.surface.getSceneView(x, y);
        if (sceneView == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sceneView, (String)"surface.getSceneView(x, y) ?: return null");
        SceneView sceneView2 = sceneView;
        NlComponent nlComponent = Coordinates.findComponent(sceneView2, x, y);
        if (nlComponent == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"Coordinates.findComponen\u2026iew, x, y) ?: return null");
        NlComponent component = nlComponent;
        return ScrollInteraction.createScrollInteraction(sceneView2, component);
    }

    @Override
    public void singleClick(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        DesignToolsSplitEditor splitEditor;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.surface.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorManager, (String)"FileEditorManager.getInstance(surface.project)");
        FileEditor selectedEditor = fileEditorManager.getSelectedEditor();
        if (selectedEditor instanceof DesignToolsSplitEditor && (splitEditor = (DesignToolsSplitEditor)selectedEditor).isSplitMode()) {
            SceneView sceneView = this.surface.getSceneView(x, y);
            if (sceneView == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)sceneView, (String)"surface.getSceneView(x, y) ?: return");
            SceneView sceneView2 = sceneView;
            NlComponent component = Coordinates.findComponent(sceneView2, x, y);
            if (component != null) {
                InteractionHandlerKt.navigateToComponent(component, false);
            }
        }
    }

    @Override
    public void doubleClick(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        SceneView sceneView = this.surface.getSceneView(x, y);
        if (sceneView == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)sceneView, (String)"surface.getSceneView(x, y) ?: return");
        SceneView sceneView2 = sceneView;
        NlComponent component = Coordinates.findComponent(sceneView2, x, y);
        if (component != null) {
            this.surface.notifyComponentActivate(component, Coordinates.getAndroidX(sceneView2, x), Coordinates.getAndroidY(sceneView2, y));
        }
    }

    @Override
    @Nullable
    public Cursor getCursorWhenNoInteraction(int mouseX, int mouseY, @JdkConstants.InputEventMask int modifiersEx) {
        return this.cursorWhenNoInteraction;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Interaction keyPressedWithoutInteraction(@NotNull KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
        int keyCode = keyEvent.getKeyCode();
        if (keyCode == DesignSurfaceShortcut.PAN.getKeyCode()) {
            return new PanInteraction(this.surface);
        }
        if (keyEvent.isAltDown() || keyEvent.isMetaDown() || keyEvent.isShiftDown() || keyEvent.isControlDown()) {
            return null;
        }
        if (!(keyCode != 127 && keyCode != 8 || ConstraintComponentUtilities.clearSelectedConstraint(this.surface))) {
            void $this$toTypedArray$iv;
            Object object;
            void $this$mapTo$iv$iv;
            Collection $this$map$iv;
            Object list$iv$iv;
            NlComponent it;
            void $this$groupByTo$iv$iv;
            List<NlComponent> selection = this.surface.getSelectionModel().getSelection();
            Iterable $this$groupBy$iv = selection;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                it = (NlComponent)element$iv$iv;
                boolean bl = false;
                NlModel key$iv$iv = it.getModel();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Map modelComponentsMap = destination$iv$iv;
            $this$groupBy$iv = modelComponentsMap.keySet();
            Runnable runnable2 = new Runnable(modelComponentsMap){
                final /* synthetic */ Map $modelComponentsMap;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    Map $this$forEach$iv = this.$modelComponentsMap;
                    boolean $i$f$forEach = false;
                    Map map2 = $this$forEach$iv;
                    boolean bl = false;
                    Iterator<Map.Entry<K, V>> iterator = map2.entrySet().iterator();
                    while (iterator.hasNext()) {
                        void model2;
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> $dstr$model$nlComponents = element$iv = iterator.next();
                        boolean bl2 = false;
                        Map.Entry<K, V> entry = $dstr$model$nlComponents;
                        boolean bl3 = false;
                        NlModel nlModel = (NlModel)entry.getKey();
                        entry = $dstr$model$nlComponents;
                        bl3 = false;
                        List nlComponents = (List)entry.getValue();
                        model2.delete(nlComponents);
                    }
                }
                {
                    this.$modelComponentsMap = map2;
                }
            };
            String string = null;
            String string2 = "Delete Components";
            Project project = this.surface.getProject();
            boolean $i$f$map = false;
            $this$groupByTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                list$iv$iv = (NlModel)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                NlComponent nlComponent = it;
                Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"it");
                XmlFile xmlFile = ((NlModel)((Object)nlComponent)).getFile();
                object.add(xmlFile);
            }
            object = (List)destination$iv$iv;
            $this$map$iv = (Collection)object;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            XmlFile[] xmlFileArray = thisCollection$iv.toArray(new XmlFile[0]);
            if (xmlFileArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            WriteCommandAction.runWriteCommandAction((Project)project, (String)string2, string, (Runnable)runnable2, (PsiFile[])((PsiFile[])xmlFileArray));
        }
        return null;
    }

    @Override
    public void keyReleasedWithoutInteraction(@NotNull KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
    }

    public InteractionHandlerBase(@NotNull DesignSurface surface2) {
        Intrinsics.checkNotNullParameter((Object)((Object)surface2), (String)"surface");
        this.surface = surface2;
    }
}

