/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.surface.DesignSurfaceHelper;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.MaterialDesignIcons;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.io.CharStreams;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.Icon;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r\u001a\u001e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\r\u001a0\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\"\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\rH\u0002\u001a\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001e"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logger$delegate", "Lkotlin/Lazy;", "copyLayoutToMainModuleSourceSet", "", "project", "Lcom/intellij/openapi/project/Project;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "layout", "", "xml", "copyVectorAssetToMainModuleSourceSet", "asset", "createResourceFile", "resourceDirectory", "resourceFileName", "resourceFileContent", "", "getResourceDirectoryChild", "Lcom/intellij/openapi/vfs/VirtualFile;", "child", "moduleContainsResource", "", "type", "Lcom/android/resources/ResourceType;", "name", "intellij.android.designer"})
@JvmName(name="DesignSurfaceHelper")
public final class DesignSurfaceHelper {
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);

    private static final Logger getLogger() {
        Lazy lazy = logger$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        boolean bl = false;
        return (Logger)lazy.getValue();
    }

    public static final boolean moduleContainsResource(@NotNull AndroidFacet facet2, @NotNull ResourceType type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ResourceRepositoryManager.getModuleResources(facet2).hasResources(ResourceNamespace.TODO(), type, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyVectorAssetToMainModuleSourceSet(@NotNull Project project, @NotNull AndroidFacet facet2, @NotNull String asset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        String path2 = MaterialDesignIcons.getPathForBasename(asset);
        try {
            Closeable closeable = new InputStreamReader(IconGenerator.class.getClassLoader().getResourceAsStream(path2), Charsets.UTF_8);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                InputStreamReader reader = (InputStreamReader)closeable;
                boolean bl3 = false;
                String string = asset + ".xml";
                String string2 = CharStreams.toString((Readable)reader);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CharStreams.toString(reader)");
                DesignSurfaceHelper.createResourceFile(project, facet2, "drawable", string, string2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException exception) {
            DesignSurfaceHelper.getLogger().warn((Throwable)exception);
        }
    }

    public static final void copyLayoutToMainModuleSourceSet(@NotNull Project project, @NotNull AndroidFacet facet2, @NotNull String layout2, @Language(value="XML") @NotNull String xml) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)facet2, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
        String message2 = "Do you want to copy layout " + layout2 + " to your main module source set?";
        if (Messages.showYesNoDialog((Project)project, (String)message2, (String)"Copy Layout", (Icon)Messages.getQuestionIcon()) == 1) {
            return;
        }
        DesignSurfaceHelper.createResourceFile(project, facet2, "layout", layout2 + ".xml", xml);
    }

    private static final void createResourceFile(Project project, AndroidFacet facet2, String resourceDirectory, String resourceFileName, CharSequence resourceFileContent) {
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(project, facet2, resourceDirectory, resourceFileName, resourceFileContent){
            final /* synthetic */ Project $project;
            final /* synthetic */ AndroidFacet $facet;
            final /* synthetic */ String $resourceDirectory;
            final /* synthetic */ String $resourceFileName;
            final /* synthetic */ CharSequence $resourceFileContent;

            public final void run() {
                try {
                    VirtualFile virtualFile = DesignSurfaceHelper.access$getResourceDirectoryChild(this.$project, this.$facet, this.$resourceDirectory);
                    if (virtualFile == null) {
                        return;
                    }
                    VirtualFile directory = virtualFile;
                    Document document = FileDocumentManager.getInstance().getDocument(directory.createChildData((Object)this.$project, this.$resourceFileName));
                    Intrinsics.checkNotNull((Object)document);
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026ect, resourceFileName))!!");
                    Document document2 = document;
                    document2.setText(this.$resourceFileContent);
                }
                catch (IOException exception) {
                    DesignSurfaceHelper.access$getLogger$p().warn((Throwable)exception);
                }
            }
            {
                this.$project = project;
                this.$facet = androidFacet;
                this.$resourceDirectory = string;
                this.$resourceFileName = string2;
                this.$resourceFileContent = charSequence;
            }
        });
    }

    private static final VirtualFile getResourceDirectoryChild(Project project, AndroidFacet facet2, String child) throws IOException {
        VirtualFile resourceDirectory = ResourceFolderManager.Companion.getInstance(facet2).getPrimaryFolder();
        if (resourceDirectory == null) {
            DesignSurfaceHelper.getLogger().warn("resourceDirectory is null");
            return null;
        }
        VirtualFile virtualFile = resourceDirectory.findChild(child);
        if (virtualFile == null) {
            return resourceDirectory.createChildDirectory((Object)project, child);
        }
        return virtualFile;
    }

    public static final /* synthetic */ VirtualFile access$getResourceDirectoryChild(Project project, AndroidFacet facet2, String child) {
        return DesignSurfaceHelper.getResourceDirectoryChild(project, facet2, child);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return DesignSurfaceHelper.getLogger();
    }
}

