/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.adtui.Pannable;
import com.android.tools.adtui.PannableKt;
import com.android.tools.adtui.Zoomable;
import com.android.tools.adtui.ZoomableKt;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.editor.PanZoomListener;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.analytics.DesignerAnalyticsManager;
import com.android.tools.idea.common.editor.ActionManager;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.error.IssuePanel;
import com.android.tools.idea.common.error.LintIssueProvider;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DefaultSelectionModel;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.ModelListener;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SecondarySelectionModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurfaceActionHandler;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.DesignSurfaceSettings;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.InteractionManager;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.MouseClickDisplayPanel;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.SceneViewPanel;
import com.android.tools.idea.common.surface.SurfaceState;
import com.android.tools.idea.common.surface.layout.MatchParentLayoutManager;
import com.android.tools.idea.common.type.DefaultDesignerFileType;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationListener;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.android.tools.idea.uibuilder.surface.layout.PositionableContent;
import com.android.tools.idea.uibuilder.surface.layout.PositionableContentLayoutManager;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.ZoomableViewport;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.plaf.ScrollBarUI;
import kotlin.jvm.functions.Function0;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class DesignSurface
extends EditorDesignSurface
implements Disposable,
DataProvider,
Zoomable,
Pannable,
ZoomableViewport {
    protected static final double SCALING_THRESHOLD = 0.005;
    private static final Predicate<NlModel> FILTER_DISPOSED_MODELS = input -> input != null && !input.getModule().isDisposed();
    private static final Predicate<SceneManager> FILTER_DISPOSED_SCENE_MANAGERS = input -> input != null && FILTER_DISPOSED_MODELS.apply((Object)input.getModel());
    private static final Integer LAYER_PROGRESS = JLayeredPane.POPUP_LAYER + 10;
    private static final Integer LAYER_MOUSE_CLICK = LAYER_PROGRESS + 10;
    private final Project myProject;
    private double myScale;
    @NotNull
    protected final JScrollPane myScrollPane;
    @NotNull
    private final JLayeredPane myLayeredPane;
    @NotNull
    private final SceneViewPanel mySceneViewPanel;
    @NotNull
    private final MouseClickDisplayPanel myMouseClickDisplayPanel;
    private final InteractionManager myInteractionManager;
    protected final List<DesignSurfaceListener> myListeners;
    private List<PanZoomListener> myZoomListeners;
    private final ActionManager myActionManager;
    @NotNull
    private WeakReference<FileEditor> myFileEditorDelegate;
    private final ReentrantReadWriteLock myModelToSceneManagersLock;
    private final LinkedHashMap<NlModel, SceneManager> myModelToSceneManagers;
    protected final JPanel myZoomControlsLayerPane;
    private final SelectionModel mySelectionModel;
    private final ModelListener myModelListener;
    @NotNull
    private final List<CompletableFuture<Void>> myRenderFutures;
    protected final IssueModel myIssueModel;
    private final IssuePanel myIssuePanel;
    private final Object myErrorQueueLock;
    private MergingUpdateQueue myErrorQueue;
    private boolean myIsActive;
    private LintIssueProvider myLintIssueProvider;
    private final boolean myIsEditable;
    private final ConfigurationListener myConfigurationListener;
    @NotNull
    private final DesignerAnalyticsManager myAnalyticsManager;
    private double myMaxFitIntoScale;
    private boolean myIsInitialZoomLevelDetermined;
    private final Timer myRepaintTimer;
    @NotNull
    private final Function<DesignSurface, DesignSurfaceActionHandler> myActionHandlerProvider;
    private final List<ProgressIndicator> myProgressIndicators;
    private final MyProgressPanel myProgressPanel;

    public DesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull Function<DesignSurface, ActionManager<? extends DesignSurface>> actionManagerProvider, @NotNull Function<DesignSurface, InteractionHandler> interactionProviderCreator, boolean isEditable, @NotNull Function<DesignSurface, PositionableContentLayoutManager> positionableLayoutManagerProvider, @NotNull Function<DesignSurface, DesignSurfaceActionHandler> designSurfaceActionHandlerProvider) {
        if (project == null) {
            DesignSurface.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            DesignSurface.$$$reportNull$$$0(1);
        }
        if (actionManagerProvider == null) {
            DesignSurface.$$$reportNull$$$0(2);
        }
        if (interactionProviderCreator == null) {
            DesignSurface.$$$reportNull$$$0(3);
        }
        if (positionableLayoutManagerProvider == null) {
            DesignSurface.$$$reportNull$$$0(4);
        }
        if (designSurfaceActionHandlerProvider == null) {
            DesignSurface.$$$reportNull$$$0(5);
        }
        this(project, parentDisposable, actionManagerProvider, interactionProviderCreator, isEditable, ZoomType.FIT_INTO, positionableLayoutManagerProvider, designSurfaceActionHandlerProvider, new DefaultSelectionModel());
    }

    public DesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull Function<DesignSurface, ActionManager<? extends DesignSurface>> actionManagerProvider, @NotNull Function<DesignSurface, InteractionHandler> interactionProviderCreator, boolean isEditable, @NotNull ZoomType onChangedZoom, @NotNull Function<DesignSurface, PositionableContentLayoutManager> positionableLayoutManagerProvider, @NotNull Function<DesignSurface, DesignSurfaceActionHandler> actionHandlerProvider, @NotNull SelectionModel selectionModel) {
        if (project == null) {
            DesignSurface.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            DesignSurface.$$$reportNull$$$0(7);
        }
        if (actionManagerProvider == null) {
            DesignSurface.$$$reportNull$$$0(8);
        }
        if (interactionProviderCreator == null) {
            DesignSurface.$$$reportNull$$$0(9);
        }
        if (onChangedZoom == null) {
            DesignSurface.$$$reportNull$$$0(10);
        }
        if (positionableLayoutManagerProvider == null) {
            DesignSurface.$$$reportNull$$$0(11);
        }
        if (actionHandlerProvider == null) {
            DesignSurface.$$$reportNull$$$0(12);
        }
        if (selectionModel == null) {
            DesignSurface.$$$reportNull$$$0(13);
        }
        super(new BorderLayout());
        this.myScale = 1.0;
        this.myListeners = new ArrayList<DesignSurfaceListener>();
        this.myFileEditorDelegate = new WeakReference<Object>(null);
        this.myModelToSceneManagersLock = new ReentrantReadWriteLock();
        this.myModelToSceneManagers = new LinkedHashMap();
        this.myModelListener = new ModelListener(){

            @Override
            public void modelChangedOnLayout(@NotNull NlModel model2, boolean animate) {
                if (model2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                DesignSurface.this.repaint();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/common/surface/DesignSurface$1", "modelChangedOnLayout"));
            }
        };
        this.myRenderFutures = new ArrayList<CompletableFuture<Void>>();
        this.myIssueModel = new IssueModel();
        this.myErrorQueueLock = new Object();
        this.myIsActive = false;
        this.myMaxFitIntoScale = Double.MAX_VALUE;
        this.myIsInitialZoomLevelDetermined = false;
        this.myRepaintTimer = new Timer(15, actionEvent -> this.repaint());
        this.myProgressIndicators = new ArrayList<ProgressIndicator>();
        this.myConfigurationListener = flags -> {
            if ((flags & 6) != 0 && !this.isLayoutDisabled()) {
                UIUtil.invokeLaterIfNeeded(() -> this.zoom(onChangedZoom, -1, -1));
            }
            return true;
        };
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.myProject = project;
        this.myIsEditable = isEditable;
        this.mySelectionModel = selectionModel;
        this.setOpaque(true);
        this.setFocusable(false);
        this.myAnalyticsManager = new DesignerAnalyticsManager(this);
        this.myActionHandlerProvider = actionHandlerProvider;
        SelectionListener selectionListener = (model2, selection) -> {
            if (this.getFocusedSceneView() != null) {
                this.notifySelectionListeners(selection);
            } else {
                this.notifySelectionListeners(Collections.emptyList());
            }
        };
        this.mySelectionModel.addListener(selectionListener);
        this.myInteractionManager = new InteractionManager(this, interactionProviderCreator.apply(this));
        this.myProgressPanel = new MyProgressPanel();
        this.myProgressPanel.setName("Layout Editor Progress Panel");
        this.myZoomControlsLayerPane = new JPanel();
        this.myZoomControlsLayerPane.setBorder(JBUI.Borders.empty((int)UIUtil.getScrollBarWidth()));
        this.myZoomControlsLayerPane.setOpaque(false);
        this.myZoomControlsLayerPane.setLayout(new BorderLayout());
        this.myZoomControlsLayerPane.setFocusable(false);
        this.mySceneViewPanel = new SceneViewPanel((Function0<? extends List<? extends Layer>>)((Function0)() -> this.getInteractionManager().getLayers()), positionableLayoutManagerProvider.apply(this));
        this.mySceneViewPanel.setBackground(this.getBackground());
        this.myScrollPane = new MyScrollPane();
        this.myScrollPane.setViewportView(this.mySceneViewPanel);
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myScrollPane.setVerticalScrollBarPolicy(22);
        this.myScrollPane.setHorizontalScrollBarPolicy(32);
        this.myScrollPane.getHorizontalScrollBar().addAdjustmentListener(this::notifyPanningChanged);
        this.myScrollPane.getVerticalScrollBar().addAdjustmentListener(this::notifyPanningChanged);
        this.myScrollPane.getViewport().setBackground(this.getBackground());
        this.myMouseClickDisplayPanel = new MouseClickDisplayPanel(this);
        this.myLayeredPane = new JLayeredPane();
        this.myLayeredPane.setLayout(new MatchParentLayoutManager());
        this.myLayeredPane.setFocusable(true);
        this.myLayeredPane.add((Component)this.myScrollPane, JLayeredPane.POPUP_LAYER);
        this.myLayeredPane.add((Component)this.myProgressPanel, LAYER_PROGRESS);
        this.myLayeredPane.add((Component)this.myMouseClickDisplayPanel, LAYER_MOUSE_CLICK);
        this.myLayeredPane.add((Component)this.myZoomControlsLayerPane, JLayeredPane.DRAG_LAYER);
        this.myIssuePanel = new IssuePanel(this, this.myIssueModel);
        Disposer.register((Disposable)this, (Disposable)this.myIssuePanel);
        this.add(this.myLayeredPane);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (componentEvent.getID() == 101) {
                    if (!DesignSurface.this.myIsInitialZoomLevelDetermined && DesignSurface.this.isShowing() && DesignSurface.this.getWidth() > 0 && DesignSurface.this.getHeight() > 0) {
                        NlModel model2 = (NlModel)Iterables.getFirst(DesignSurface.this.getModels(), null);
                        if (model2 == null) {
                            return;
                        }
                        if (!DesignSurface.this.restorePreviousScale(model2)) {
                            DesignSurface.this.zoomToFit();
                        }
                        DesignSurface.this.myIsInitialZoomLevelDetermined = true;
                    }
                    DesignSurface.this.getSceneManagers().forEach(manager -> {
                        Scene scene = manager.getScene();
                        scene.needsRebuildList();
                    });
                    DesignSurface.this.repaint();
                }
            }
        });
        this.myInteractionManager.startListening();
        this.myActionManager = actionManagerProvider.apply(this);
        this.myActionManager.registerActionsShortcuts(this.myLayeredPane);
        this.myZoomControlsLayerPane.add((Component)this.myActionManager.createDesignSurfaceToolbar(), "East");
    }

    public double getScreenScalingFactor() {
        return 1.0;
    }

    @NotNull
    protected abstract SceneManager createSceneManager(@NotNull NlModel var1);

    public JPanel getAccessoryPanel() {
        return null;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            DesignSurface.$$$reportNull$$$0(14);
        }
        return project;
    }

    @NotNull
    public DesignerEditorFileType getLayoutType() {
        NlModel model2 = this.getModel();
        DesignerEditorFileType designerEditorFileType = model2 == null ? DefaultDesignerFileType.INSTANCE : model2.getType();
        if (designerEditorFileType == null) {
            DesignSurface.$$$reportNull$$$0(15);
        }
        return designerEditorFileType;
    }

    @NotNull
    public ActionManager getActionManager() {
        ActionManager actionManager = this.myActionManager;
        if (actionManager == null) {
            DesignSurface.$$$reportNull$$$0(16);
        }
        return actionManager;
    }

    @NotNull
    public SelectionModel getSelectionModel() {
        SelectionModel selectionModel = this.mySelectionModel;
        if (selectionModel == null) {
            DesignSurface.$$$reportNull$$$0(17);
        }
        return selectionModel;
    }

    @NotNull
    public SecondarySelectionModel getSecondarySelectionModel() {
        SelectionModel selectionModel = this.mySelectionModel;
        if (selectionModel == null) {
            DesignSurface.$$$reportNull$$$0(18);
        }
        return selectionModel;
    }

    @NotNull
    public abstract ItemTransferable getSelectionAsTransferable();

    @Deprecated
    @Nullable
    public NlModel getModel() {
        return (NlModel)Iterables.getFirst(this.getModels(), null);
    }

    @NotNull
    public ImmutableList<NlModel> getModels() {
        this.myModelToSceneManagersLock.readLock().lock();
        ImmutableList immutableList = ImmutableList.copyOf((Collection)Sets.filter(this.myModelToSceneManagers.keySet(), FILTER_DISPOSED_MODELS));
        ImmutableList immutableList2 = immutableList;
        if (immutableList2 == null) {
            DesignSurface.$$$reportNull$$$0(19);
        }
        return immutableList2;
        finally {
            this.myModelToSceneManagersLock.readLock().unlock();
        }
    }

    @NotNull
    public ImmutableList<SceneManager> getSceneManagers() {
        this.myModelToSceneManagersLock.readLock().lock();
        ImmutableList immutableList = ImmutableList.copyOf((Collection)Collections2.filter(this.myModelToSceneManagers.values(), FILTER_DISPOSED_SCENE_MANAGERS));
        ImmutableList immutableList2 = immutableList;
        if (immutableList2 == null) {
            DesignSurface.$$$reportNull$$$0(20);
        }
        return immutableList2;
        finally {
            this.myModelToSceneManagersLock.readLock().unlock();
        }
    }

    public final void removeSceneView(@NotNull SceneView sceneView) {
        if (sceneView == null) {
            DesignSurface.$$$reportNull$$$0(21);
        }
        if (this.mySceneViewPanel != null) {
            UIUtil.invokeLaterIfNeeded(() -> this.mySceneViewPanel.removeSceneView(sceneView));
        }
    }

    public final void addSceneView(@NotNull SceneView sceneView) {
        if (sceneView == null) {
            DesignSurface.$$$reportNull$$$0(22);
        }
        if (this.mySceneViewPanel != null) {
            UIUtil.invokeLaterIfNeeded(() -> this.mySceneViewPanel.addSceneView(sceneView));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private SceneManager addModel(@NotNull NlModel model2) {
        SceneManager manager;
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(23);
        }
        if ((manager = this.getSceneManager(model2)) != null) {
            this.myModelToSceneManagersLock.writeLock().lock();
            try {
                SceneManager managerToMove = (SceneManager)this.myModelToSceneManagers.remove(model2);
                if (managerToMove != null) {
                    this.myModelToSceneManagers.put(model2, managerToMove);
                }
            }
            finally {
                this.myModelToSceneManagersLock.writeLock().unlock();
            }
            manager.getSceneViews().forEach(sceneView -> this.removeSceneView((SceneView)sceneView));
            manager.getSceneViews().forEach(sceneView -> this.addSceneView((SceneView)sceneView));
            SceneManager sceneManager = manager;
            if (sceneManager == null) {
                DesignSurface.$$$reportNull$$$0(24);
            }
            return sceneManager;
        }
        model2.addListener(this.myModelListener);
        model2.getConfiguration().addListener(this.myConfigurationListener);
        manager = this.createSceneManager(model2);
        manager.getSceneViews().forEach(sceneView -> this.addSceneView((SceneView)sceneView));
        this.myModelToSceneManagersLock.writeLock().lock();
        try {
            this.myModelToSceneManagers.put(model2, manager);
        }
        finally {
            this.myModelToSceneManagersLock.writeLock().unlock();
        }
        if (this.myIsActive) {
            manager.activate((Object)this);
        }
        SceneManager sceneManager = manager;
        if (sceneManager == null) {
            DesignSurface.$$$reportNull$$$0(25);
        }
        return sceneManager;
    }

    @NotNull
    public final CompletableFuture<Void> addAndRenderModel(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(26);
        }
        SceneManager modelSceneManager = this.addModel(model2);
        CompletionStage completionStage = modelSceneManager.requestRender().whenCompleteAsync((result2, ex) -> {
            this.reactivateInteractionManager();
            this.revalidateScrollArea();
            for (DesignSurfaceListener listener2 : ImmutableList.copyOf(this.myListeners)) {
                listener2.modelChanged(this, model2);
            }
        }, (Executor)EdtExecutorService.getInstance());
        if (completionStage == null) {
            DesignSurface.$$$reportNull$$$0(27);
        }
        return completionStage;
    }

    @NotNull
    public final SceneManager addModelWithoutRender(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(28);
        }
        SceneManager manager = this.addModel(model2);
        EdtExecutorService.getInstance().execute(() -> {
            for (DesignSurfaceListener listener2 : ImmutableList.copyOf(this.myListeners)) {
                listener2.modelChanged(this, model2);
            }
        });
        this.reactivateInteractionManager();
        SceneManager sceneManager = manager;
        if (sceneManager == null) {
            DesignSurface.$$$reportNull$$$0(29);
        }
        return sceneManager;
    }

    private boolean removeModelImpl(@NotNull NlModel model2) {
        SceneManager manager;
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(30);
        }
        this.myModelToSceneManagersLock.writeLock().lock();
        try {
            manager = (SceneManager)this.myModelToSceneManagers.remove(model2);
        }
        finally {
            this.myModelToSceneManagersLock.writeLock().unlock();
        }
        if (manager == null) {
            return false;
        }
        manager.getSceneViews().forEach(sceneView -> this.removeSceneView((SceneView)sceneView));
        model2.deactivate((Object)this);
        model2.getConfiguration().removeListener(this.myConfigurationListener);
        model2.removeListener(this.myModelListener);
        Disposer.dispose((Disposable)manager);
        UIUtil.invokeLaterIfNeeded(() -> this.revalidateScrollArea());
        return true;
    }

    public void removeModel(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(31);
        }
        if (!this.removeModelImpl(model2)) {
            return;
        }
        this.reactivateInteractionManager();
    }

    public CompletableFuture<Void> setModel(@Nullable NlModel model2) {
        NlModel oldModel = this.getModel();
        if (model2 == oldModel) {
            return CompletableFuture.completedFuture(null);
        }
        if (oldModel != null) {
            this.removeModelImpl(oldModel);
        }
        if (model2 == null) {
            return CompletableFuture.completedFuture(null);
        }
        this.addModel(model2);
        return this.requestRender().whenCompleteAsync((result2, ex) -> {
            this.reactivateInteractionManager();
            if (!this.restorePreviousScale(model2)) {
                this.zoomToFit();
            }
            this.revalidateScrollArea();
            for (DesignSurfaceListener listener2 : ImmutableList.copyOf(this.myListeners)) {
                listener2.modelChanged(this, model2);
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    private void reactivateInteractionManager() {
        if (this.isEditable()) {
            this.myInteractionManager.startListening();
        } else {
            this.myInteractionManager.stopListening();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.myInteractionManager.stopListening();
        List<CompletableFuture<Void>> list = this.myRenderFutures;
        synchronized (list) {
            for (CompletableFuture<Void> future2 : this.myRenderFutures) {
                try {
                    future2.cancel(true);
                }
                catch (CancellationException cancellationException) {}
            }
            this.myRenderFutures.clear();
        }
        if (this.myRepaintTimer.isRunning()) {
            this.myRepaintTimer.stop();
        }
        this.getModels().forEach(this::removeModelImpl);
    }

    @UiThread
    public void validateScrollArea() {
        this.mySceneViewPanel.invalidate();
        this.myScrollPane.invalidate();
        this.myScrollPane.validate();
        this.mySceneViewPanel.repaint();
    }

    @UiThread
    public void revalidateScrollArea() {
        this.mySceneViewPanel.invalidate();
        this.myScrollPane.revalidate();
        this.mySceneViewPanel.repaint();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.getInteractionPane();
    }

    public void needsRepaint() {
        if (!this.myRepaintTimer.isRunning()) {
            this.myRepaintTimer.setRepeats(false);
            this.myRepaintTimer.start();
        }
    }

    @Nullable
    public SceneView getFocusedSceneView() {
        NlComponent primary;
        SceneManager manager;
        ImmutableList<SceneManager> managers = this.getSceneManagers();
        if (managers.size() == 1) {
            SceneManager manager2 = this.getSceneManager();
            assert (manager2 != null);
            return (SceneView)Iterables.getFirst(manager2.getSceneViews(), null);
        }
        List<NlComponent> selection = this.mySelectionModel.getSelection();
        if (!selection.isEmpty() && (manager = this.getSceneManager((primary = selection.get(0)).getModel())) != null) {
            return (SceneView)Iterables.getFirst(manager.getSceneViews(), null);
        }
        return null;
    }

    @NotNull
    protected ImmutableCollection<SceneView> getSceneViews() {
        ImmutableCollection immutableCollection = (ImmutableCollection)this.getSceneManagers().stream().flatMap(sceneManager -> sceneManager.getSceneViews().stream()).collect(ImmutableList.toImmutableList());
        if (immutableCollection == null) {
            DesignSurface.$$$reportNull$$$0(32);
        }
        return immutableCollection;
    }

    public void startDragDropInteraction() {
        for (SceneView sceneView : this.getSceneViews()) {
            sceneView.onDragStart();
        }
        this.repaint();
    }

    public void stopDragDropInteraction() {
        for (SceneView sceneView : this.getSceneViews()) {
            sceneView.onDragEnd();
        }
        this.repaint();
    }

    public boolean zoom(@NotNull ZoomType type) {
        if (type == null) {
            DesignSurface.$$$reportNull$$$0(33);
        }
        this.myAnalyticsManager.trackZoom(type);
        return this.zoom(type, -1, -1);
    }

    @Nullable
    public Magnificator getMagnificator() {
        if (!this.getSupportPinchAndZoom()) {
            return null;
        }
        return (scale, at) -> null;
    }

    public void magnificationStarted(Point at) {
    }

    public void magnificationFinished(double magnification) {
    }

    public void magnify(double magnification) {
        if (Double.compare(magnification, 0.0) == 0) {
            return;
        }
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo != null) {
            Point mouse = pointerInfo.getLocation();
            SwingUtilities.convertPointFromScreen(mouse, this.myScrollPane.getViewport());
            double magnifiedScale = magnification < 0.0 ? 1.0 / (1.0 - magnification) : 1.0 + magnification;
            this.setScale(magnifiedScale * this.getScale(), mouse.x, mouse.y);
        }
    }

    public void setPanning(boolean isPanning) {
        this.myInteractionManager.setPanning(isPanning);
    }

    @UiThread
    public boolean zoom(@NotNull ZoomType type, int x, int y) {
        boolean scaled;
        SceneComponent component;
        Scene scene;
        if (type == null) {
            DesignSurface.$$$reportNull$$$0(34);
        }
        SceneView view = this.getFocusedSceneView();
        if (!(type != ZoomType.IN || x >= 0 && y >= 0 || view == null || this.getSelectionModel().isEmpty() || (scene = this.getScene()) == null || (component = scene.getSceneComponent(this.getSelectionModel().getPrimary())) == null)) {
            x = Coordinates.getSwingXDip(view, component.getCenterX());
            y = Coordinates.getSwingYDip(view, component.getCenterY());
        }
        switch (type) {
            case IN: {
                double currentScale = this.myScale * this.getScreenScalingFactor();
                int current = (int)Math.round(currentScale * 100.0);
                double scale = (double)ZoomType.zoomIn((int)current) / 100.0 / this.getScreenScalingFactor();
                scaled = this.setScale(scale, x, y);
                break;
            }
            case OUT: {
                double currentScale = this.myScale * this.getScreenScalingFactor();
                int current = (int)(currentScale * 100.0);
                double scale = (double)ZoomType.zoomOut((int)current) / 100.0 / this.getScreenScalingFactor();
                scaled = this.setScale(scale, x, y);
                break;
            }
            case ACTUAL: {
                scaled = this.setScale(1.0 / this.getScreenScalingFactor());
                break;
            }
            case FIT: 
            case FIT_INTO: {
                scaled = this.setScale(this.getFitScale(type == ZoomType.FIT_INTO));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not yet implemented: " + type);
            }
        }
        return scaled;
    }

    protected double getFitScale(boolean fitInto) {
        int availableWidth = this.getExtentSize().width;
        int availableHeight = this.getExtentSize().height;
        return this.getFitScale(this.getPreferredContentSize(availableWidth, availableHeight), fitInto);
    }

    public double getFitScale(Dimension size, boolean fitInto) {
        int availableWidth = this.getExtentSize().width;
        int availableHeight = this.getExtentSize().height;
        Dimension padding = this.getDefaultOffset();
        double scaleX = size.width == 0 ? 1.0 : (double)(availableWidth -= padding.width) / (double)size.width;
        double scaleY = size.height == 0 ? 1.0 : (double)(availableHeight -= padding.height) / (double)size.height;
        double scale = Math.min(scaleX, scaleY);
        if (fitInto) {
            double min = 1.0 / this.getScreenScalingFactor();
            scale = Math.min(min, scale);
        }
        scale = Math.min(scale, this.myMaxFitIntoScale);
        return scale;
    }

    protected abstract Dimension getDefaultOffset();

    @NotNull
    protected abstract Dimension getPreferredContentSize(int var1, int var2);

    @UiThread
    public boolean zoomToFit() {
        return this.zoom(ZoomType.FIT, -1, -1);
    }

    public double getScale() {
        return this.myScale;
    }

    public boolean isPanning() {
        return this.myInteractionManager.isPanning();
    }

    public boolean isPannable() {
        return true;
    }

    public boolean canZoomIn() {
        return this.getScale() < this.getMaxScale();
    }

    public boolean canZoomOut() {
        return this.getScale() > this.getMinScale();
    }

    public abstract boolean canZoomToFit();

    public boolean canZoomToActual() {
        double currentScale = this.getScale();
        return currentScale > 1.0 && this.canZoomOut() || currentScale < 1.0 && this.canZoomIn();
    }

    public abstract void scrollToCenter(@NotNull List<NlComponent> var1);

    public final void scrollToVisible(@NotNull SceneView sceneView) {
        Rectangle rectangle;
        if (sceneView == null) {
            DesignSurface.$$$reportNull$$$0(35);
        }
        if ((rectangle = this.mySceneViewPanel.findSceneViewRectangle(sceneView)) != null && !this.myScrollPane.getViewport().getViewRect().intersects(rectangle)) {
            Dimension defaultOffset = this.getDefaultOffset();
            this.setScrollPosition(rectangle.x - defaultOffset.width, rectangle.y - defaultOffset.height);
        }
    }

    public final void scrollToVisible(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(36);
        }
        this.getSceneViews().stream().filter(sceneView -> sceneView.getSceneManager().getModel() == model2).findFirst().ifPresent(this::scrollToVisible);
    }

    public void setScrollPosition(int x, int y) {
        this.setScrollPosition(new Point(x, y));
    }

    public void setScrollPosition(Point p) {
        p.setLocation(Math.max(0, p.x), Math.max(0, p.y));
        Dimension extent = this.getExtentSize();
        Dimension view = this.getViewSize();
        int minX = Math.min(p.x, view.width - extent.width);
        int minY = Math.min(p.y, view.height - extent.height);
        p.setLocation(minX, minY);
        this.myScrollPane.getViewport().setViewPosition(p);
    }

    public Point getScrollPosition() {
        return this.myScrollPane.getViewport().getViewPosition();
    }

    @NotNull
    public Dimension getExtentSize() {
        Dimension dimension2 = this.myScrollPane.getViewport().getExtentSize();
        if (dimension2 == null) {
            DesignSurface.$$$reportNull$$$0(37);
        }
        return dimension2;
    }

    @NotNull
    public Dimension getViewSize() {
        Dimension dimension2 = this.myScrollPane.getViewport().getViewSize();
        if (dimension2 == null) {
            DesignSurface.$$$reportNull$$$0(38);
        }
        return dimension2;
    }

    public boolean setScale(double scale) {
        return this.setScale(scale, -1, -1);
    }

    public boolean setScale(double scale, int x, int y) {
        double newScale = Math.min(Math.max(scale, this.getMinScale()), this.getMaxScale());
        if (Math.abs(newScale - this.myScale) < 0.005 / this.getScreenScalingFactor()) {
            return false;
        }
        Point oldViewPosition = this.getScrollPosition();
        if (x < 0 || y < 0) {
            x = oldViewPosition.x + this.myScrollPane.getWidth() / 2;
            y = oldViewPosition.y + this.myScrollPane.getHeight() / 2;
        }
        SceneView view = this.getFocusedSceneView();
        int androidX = 0;
        int androidY = 0;
        if (view != null) {
            androidX = Coordinates.getAndroidXDip(view, x);
            androidY = Coordinates.getAndroidYDip(view, y);
        }
        this.myScale = newScale;
        NlModel model2 = (NlModel)Iterables.getFirst(this.getModels(), null);
        if (model2 != null) {
            this.storeCurrentScale(model2);
        }
        if (view != null) {
            int shiftedX = Coordinates.getSwingXDip(view, androidX);
            int shiftedY = Coordinates.getSwingYDip(view, androidY);
            this.myScrollPane.getViewport().setViewPosition(new Point(oldViewPosition.x + shiftedX - x, oldViewPosition.y + shiftedY - y));
        }
        this.revalidateScrollArea();
        this.notifyScaleChanged();
        return true;
    }

    protected boolean isKeepingScaleWhenReopen() {
        return true;
    }

    private void storeCurrentScale(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(39);
        }
        if (!this.isKeepingScaleWhenReopen()) {
            return;
        }
        SurfaceState state = DesignSurfaceSettings.getInstance().getSurfaceState();
        state.saveFileScale((PsiFile)model2.getFile(), this.myScale);
    }

    private boolean restorePreviousScale(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(40);
        }
        if (!this.isKeepingScaleWhenReopen()) {
            return false;
        }
        SurfaceState state = DesignSurfaceSettings.getInstance().getSurfaceState();
        Double previousScale = state.loadFileScale((PsiFile)model2.getFile());
        if (previousScale != null) {
            this.setScale(previousScale);
            return true;
        }
        return false;
    }

    protected double getMinScale() {
        return 0.0;
    }

    protected double getMaxScale() {
        return 1.0;
    }

    private void notifyScaleChanged() {
        if (this.myZoomListeners != null) {
            for (PanZoomListener myZoomListener : this.myZoomListeners) {
                myZoomListener.zoomChanged();
            }
        }
    }

    private void notifyPanningChanged(AdjustmentEvent adjustmentEvent) {
        if (this.myZoomListeners != null) {
            for (PanZoomListener myZoomListener : this.myZoomListeners) {
                myZoomListener.panningChanged(adjustmentEvent);
            }
        }
    }

    @NotNull
    public JComponent getLayeredPane() {
        JLayeredPane jLayeredPane = this.myLayeredPane;
        if (jLayeredPane == null) {
            DesignSurface.$$$reportNull$$$0(41);
        }
        return jLayeredPane;
    }

    @NotNull
    public JComponent getInteractionPane() {
        SceneViewPanel sceneViewPanel = this.mySceneViewPanel;
        if (sceneViewPanel == null) {
            DesignSurface.$$$reportNull$$$0(42);
        }
        return sceneViewPanel;
    }

    @NotNull
    public DesignerAnalyticsManager getAnalyticsManager() {
        DesignerAnalyticsManager designerAnalyticsManager = this.myAnalyticsManager;
        if (designerAnalyticsManager == null) {
            DesignSurface.$$$reportNull$$$0(43);
        }
        return designerAnalyticsManager;
    }

    protected void notifySelectionListeners(@NotNull List<NlComponent> newSelection) {
        if (newSelection == null) {
            DesignSurface.$$$reportNull$$$0(44);
        }
        ArrayList listeners = Lists.newArrayList(this.myListeners);
        for (DesignSurfaceListener listener2 : listeners) {
            listener2.componentSelectionChanged(this, newSelection);
        }
    }

    public void notifyComponentActivate(@NotNull NlComponent component, int x, int y) {
        if (component == null) {
            DesignSurface.$$$reportNull$$$0(45);
        }
        this.notifyComponentActivate(component);
    }

    public void notifyComponentActivate(@NotNull NlComponent component) {
        if (component == null) {
            DesignSurface.$$$reportNull$$$0(46);
        }
        this.activatePreferredEditor(component);
    }

    @NotNull
    public abstract Consumer<NlComponent> getComponentRegistrar();

    protected void activatePreferredEditor(@NotNull NlComponent component) {
        if (component == null) {
            DesignSurface.$$$reportNull$$$0(47);
        }
        for (DesignSurfaceListener listener2 : new ArrayList<DesignSurfaceListener>(this.myListeners)) {
            if (listener2.activatePreferredEditor(this, component)) break;
        }
    }

    public void addListener(@NotNull DesignSurfaceListener listener2) {
        if (listener2 == null) {
            DesignSurface.$$$reportNull$$$0(48);
        }
        this.myListeners.remove(listener2);
        this.myListeners.add(listener2);
    }

    public void removeListener(@NotNull DesignSurfaceListener listener2) {
        if (listener2 == null) {
            DesignSurface.$$$reportNull$$$0(49);
        }
        this.myListeners.remove(listener2);
    }

    public void addPanZoomListener(PanZoomListener listener2) {
        if (this.myZoomListeners == null) {
            this.myZoomListeners = new ArrayList<PanZoomListener>();
        } else {
            this.myZoomListeners.remove(listener2);
        }
        this.myZoomListeners.add(listener2);
    }

    public void removePanZoomListener(PanZoomListener listener2) {
        if (this.myZoomListeners != null) {
            this.myZoomListeners.remove(listener2);
        }
    }

    public void activate() {
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        if (!this.myIsActive) {
            for (SceneManager manager : this.getSceneManagers()) {
                manager.activate((Object)this);
            }
        }
        this.myIsActive = true;
    }

    public void deactivate() {
        if (this.myIsActive) {
            for (SceneManager manager : this.getSceneManagers()) {
                manager.deactivate((Object)this);
            }
        }
        this.myIsActive = false;
        this.myInteractionManager.cancelInteraction();
    }

    public void setFileEditorDelegate(@Nullable FileEditor fileEditor) {
        this.myFileEditorDelegate = new WeakReference<FileEditor>(fileEditor);
    }

    @Nullable
    public SceneView getSceneView(int x, int y) {
        return this.getFocusedSceneView();
    }

    @Nullable
    public SceneView getHoverSceneView(int x, int y) {
        return this.getFocusedSceneView();
    }

    @Deprecated
    @Nullable
    public Scene getScene() {
        SceneManager sceneManager = this.getSceneManager();
        return sceneManager != null ? sceneManager.getScene() : null;
    }

    @Nullable
    public SceneManager getSceneManager() {
        NlModel model2 = this.getModel();
        return model2 != null ? this.getSceneManager(model2) : null;
    }

    @Nullable
    public SceneManager getSceneManager(@NotNull NlModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(50);
        }
        if (model2.getModule().isDisposed()) {
            return null;
        }
        this.myModelToSceneManagersLock.readLock().lock();
        try {
            SceneManager sceneManager = this.myModelToSceneManagers.get(model2);
            return sceneManager;
        }
        finally {
            this.myModelToSceneManagersLock.readLock().unlock();
        }
    }

    public CompletableFuture<?> goingToSetModel(NlModel model2) {
        return CompletableFuture.completedFuture(null);
    }

    @NotNull
    public InteractionManager getInteractionManager() {
        InteractionManager interactionManager = this.myInteractionManager;
        if (interactionManager == null) {
            DesignSurface.$$$reportNull$$$0(51);
        }
        return interactionManager;
    }

    protected boolean getSupportPinchAndZoom() {
        return true;
    }

    public boolean isEditable() {
        return this.getLayoutType().isEditable() && this.myIsEditable;
    }

    @NotNull
    protected Collection<PositionableContent> getPositionableContent() {
        Collection<PositionableContent> collection2 = this.mySceneViewPanel.getPositionableContent();
        if (collection2 == null) {
            DesignSurface.$$$reportNull$$$0(52);
        }
        return collection2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            DesignSurface.$$$reportNull$$$0(53);
        }
        if (this.myProject.isDisposed() || Disposer.isDisposed((Disposable)this)) {
            return;
        }
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.add(indicator);
            this.myProgressPanel.showProgressIcon();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterIndicator(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            DesignSurface.$$$reportNull$$$0(54);
        }
        List<ProgressIndicator> list = this.myProgressIndicators;
        synchronized (list) {
            this.myProgressIndicators.remove(indicator);
            if (this.myProgressIndicators.isEmpty()) {
                this.myProgressPanel.hideProgressIcon();
            }
        }
    }

    protected boolean useSmallProgressIcon() {
        return true;
    }

    @NotNull
    public CompletableFuture<Void> requestRender() {
        ImmutableList<SceneManager> managers = this.getSceneManagers();
        if (managers.isEmpty()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                DesignSurface.$$$reportNull$$$0(55);
            }
            return completableFuture;
        }
        CompletableFuture<Void> completableFuture = this.requestSequentialRender(manager -> manager.requestLayoutAndRender(false));
        if (completableFuture == null) {
            DesignSurface.$$$reportNull$$$0(56);
        }
        return completableFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected CompletableFuture<Void> requestSequentialRender(@NotNull Function<SceneManager, CompletableFuture<Void>> renderRequest) {
        if (renderRequest == null) {
            DesignSurface.$$$reportNull$$$0(57);
        }
        CompletableFuture<Void> callback2 = new CompletableFuture<Void>();
        List<CompletableFuture<Void>> list = this.myRenderFutures;
        synchronized (list) {
            if (!this.myRenderFutures.isEmpty()) {
                this.myRenderFutures.add(callback2);
                CompletableFuture<Void> completableFuture = callback2;
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var3_3
                if (completableFuture == null) {
                    DesignSurface.$$$reportNull$$$0(58);
                }
                return completableFuture;
            }
            this.myRenderFutures.add(callback2);
        }
        CompletionStage<Object> renderFuture = CompletableFuture.completedFuture(null);
        for (SceneManager manager : this.getSceneManagers()) {
            renderFuture = renderFuture.thenCompose(it -> {
                CompletableFuture future2 = (CompletableFuture)renderRequest.apply(manager);
                this.invalidate();
                return future2;
            });
        }
        renderFuture.thenRun(() -> {
            List<CompletableFuture<Void>> list = this.myRenderFutures;
            synchronized (list) {
                this.myRenderFutures.forEach(future2 -> future2.complete(null));
                this.myRenderFutures.clear();
            }
        });
        CompletableFuture<Void> completableFuture = callback2;
        if (completableFuture == null) {
            DesignSurface.$$$reportNull$$$0(59);
        }
        return completableFuture;
    }

    @TestOnly
    @NotNull
    public Point getCoordinatesOnViewport(@NotNull Point viewCoordinates) {
        if (viewCoordinates == null) {
            DesignSurface.$$$reportNull$$$0(60);
        }
        Point point = SwingUtilities.convertPoint(this.mySceneViewPanel, viewCoordinates.x, viewCoordinates.y, this.myScrollPane.getViewport());
        if (point == null) {
            DesignSurface.$$$reportNull$$$0(61);
        }
        return point;
    }

    @TestOnly
    public void setScrollViewSizeAndValidate(int width, int height) {
        this.myScrollPane.setSize(width, height);
        this.myScrollPane.doLayout();
        UIUtil.invokeAndWaitIfNeeded(() -> this.validateScrollArea());
    }

    public void setDesignToolTip(@Nullable String text2) {
        this.myLayeredPane.setToolTipText(text2);
    }

    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            DesignSurface.$$$reportNull$$$0(62);
        }
        if (DesignerDataKeys.DESIGN_SURFACE.is(dataId) || ZoomableKt.ZOOMABLE_KEY.is(dataId) || PannableKt.PANNABLE_KEY.is(dataId)) {
            return this;
        }
        if (PlatformDataKeys.FILE_EDITOR.is(dataId)) {
            return this.myFileEditorDelegate.get();
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId) || PlatformDataKeys.CUT_PROVIDER.is(dataId) || PlatformDataKeys.COPY_PROVIDER.is(dataId) || PlatformDataKeys.PASTE_PROVIDER.is(dataId)) {
            return this.myActionHandlerProvider.apply(this);
        }
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId)) {
            SceneView view = this.getFocusedSceneView();
            NlComponent selection = this.getSelectionModel().getPrimary();
            Scene scene = this.getScene();
            if (view == null || scene == null || selection == null) {
                return null;
            }
            SceneComponent sceneComponent = scene.getSceneComponent(selection);
            if (sceneComponent == null) {
                return null;
            }
            return new Point(Coordinates.getSwingXDip(view, sceneComponent.getCenterX()), Coordinates.getSwingYDip(view, sceneComponent.getCenterY()));
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            SelectionModel selectionModel;
            NlComponent primary;
            if (this.getFocusedSceneView() != null && (primary = (selectionModel = this.getFocusedSceneView().getSelectionModel()).getPrimary()) != null) {
                return primary.getTagDeprecated();
            }
        } else if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId)) {
            if (this.getFocusedSceneView() != null) {
                SelectionModel selectionModel = this.getFocusedSceneView().getSelectionModel();
                List<NlComponent> selection = selectionModel.getSelection();
                ArrayList list = Lists.newArrayListWithCapacity((int)selection.size());
                for (NlComponent component : selection) {
                    list.add(component.getTagDeprecated());
                }
                return list.toArray(XmlTag.EMPTY);
            }
        } else {
            NlModel model2 = this.getModel();
            if (LangDataKeys.MODULE.is(dataId) && model2 != null) {
                return model2.getModule();
            }
        }
        return null;
    }

    public abstract boolean isLayoutDisabled();

    @Override
    @NotNull
    public ImmutableCollection<Configuration> getConfigurations() {
        ImmutableCollection immutableCollection = (ImmutableCollection)this.getModels().stream().map(NlModel::getConfiguration).collect(ImmutableList.toImmutableList());
        if (immutableCollection == null) {
            DesignSurface.$$$reportNull$$$0(63);
        }
        return immutableCollection;
    }

    @NotNull
    public IssueModel getIssueModel() {
        IssueModel issueModel = this.myIssueModel;
        if (issueModel == null) {
            DesignSurface.$$$reportNull$$$0(64);
        }
        return issueModel;
    }

    public void setLintAnnotationsModel(@NotNull LintAnnotationsModel model2) {
        if (model2 == null) {
            DesignSurface.$$$reportNull$$$0(65);
        }
        if (this.myLintIssueProvider != null) {
            this.myLintIssueProvider.setLintAnnotationsModel(model2);
        } else {
            this.myLintIssueProvider = new LintIssueProvider(model2);
            this.getIssueModel().addIssueProvider(this.myLintIssueProvider);
        }
    }

    @NotNull
    public IssuePanel getIssuePanel() {
        IssuePanel issuePanel = this.myIssuePanel;
        if (issuePanel == null) {
            DesignSurface.$$$reportNull$$$0(66);
        }
        return issuePanel;
    }

    public void setShowIssuePanel(boolean show, boolean userInvoked) {
        UIUtil.invokeLaterIfNeeded(() -> {
            this.myIssuePanel.setMinimized(!show);
            if (userInvoked) {
                this.myIssuePanel.disableAutoSize();
            }
            this.revalidate();
            this.repaint();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    protected MergingUpdateQueue getErrorQueue() {
        Object object = this.myErrorQueueLock;
        // MONITORENTER : object
        if (this.myErrorQueue == null) {
            this.myErrorQueue = new MergingUpdateQueue("android.error.computation", 200, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        }
        MergingUpdateQueue mergingUpdateQueue = this.myErrorQueue;
        // MONITOREXIT : object
        if (mergingUpdateQueue != null) return mergingUpdateQueue;
        DesignSurface.$$$reportNull$$$0(67);
        return mergingUpdateQueue;
    }

    @NotNull
    public ConfigurationManager getConfigurationManager(@NotNull AndroidFacet facet2) {
        if (facet2 == null) {
            DesignSurface.$$$reportNull$$$0(68);
        }
        ConfigurationManager configurationManager = ConfigurationManager.getOrCreateInstance(facet2);
        if (configurationManager == null) {
            DesignSurface.$$$reportNull$$$0(69);
        }
        return configurationManager;
    }

    public void updateUI() {
        super.updateUI();
        if (this.myModelToSceneManagers != null) {
            for (SceneManager manager : this.getSceneManagers()) {
                manager.getSceneViews().forEach(SceneView::updateUI);
            }
        }
    }

    @NotNull
    public abstract List<NlComponent> getSelectableComponents();

    public void setMaxFitIntoZoomLevel(double maxFitIntoZoomLevel) {
        this.myMaxFitIntoScale = maxFitIntoZoomLevel / this.getScreenScalingFactor();
    }

    public void enableMouseClickDisplay() {
        this.myMouseClickDisplayPanel.setEnabled(true);
    }

    public void disableMouseClickDisplay() {
        this.myMouseClickDisplayPanel.setEnabled(false);
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.mySceneViewPanel != null) {
            this.mySceneViewPanel.setBackground(bg);
        }
    }

    @NotNull
    public final PositionableContentLayoutManager getSceneViewLayoutManager() {
        PositionableContentLayoutManager positionableContentLayoutManager = (PositionableContentLayoutManager)this.mySceneViewPanel.getLayout();
        if (positionableContentLayoutManager == null) {
            DesignSurface.$$$reportNull$$$0(70);
        }
        return positionableContentLayoutManager;
    }

    public final void setSceneViewAlignment(@NotNull SceneViewAlignment sceneViewAlignment) {
        if (sceneViewAlignment == null) {
            DesignSurface.$$$reportNull$$$0(71);
        }
        this.mySceneViewPanel.setSceneViewAlignment(sceneViewAlignment.mySwingAlignmentXValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 51: 
            case 52: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 51: 
            case 52: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionManagerProvider";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interactionProviderCreator";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "positionableLayoutManagerProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurfaceActionHandlerProvider";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onChangedZoom";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionHandlerProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionModel";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 51: 
            case 52: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/surface/DesignSurface";
                break;
            }
            case 21: 
            case 22: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 36: 
            case 39: 
            case 40: 
            case 50: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSelection";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 53: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderRequest";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewCoordinates";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneViewAlignment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/surface/DesignSurface";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionManager";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionModel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSecondarySelectionModel";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModels";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneManagers";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "addModel";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "addAndRenderModel";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "addModelWithoutRender";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneViews";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtentSize";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getViewSize";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayeredPane";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getInteractionPane";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnalyticsManager";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getInteractionManager";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getPositionableContent";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "requestRender";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "requestSequentialRender";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoordinatesOnViewport";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssueModel";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssuePanel";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorQueue";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationManager";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneViewLayoutManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 51: 
            case 52: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: {
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeSceneView";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "addSceneView";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addModel";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addAndRenderModel";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addModelWithoutRender";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "removeModelImpl";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeModel";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "zoom";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "scrollToVisible";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "storeCurrentScale";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "restorePreviousScale";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "notifySelectionListeners";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "notifyComponentActivate";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "activatePreferredEditor";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getSceneManager";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "registerIndicator";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "unregisterIndicator";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "requestSequentialRender";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getCoordinatesOnViewport";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "setLintAnnotationsModel";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationManager";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "setSceneViewAlignment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 24: 
            case 25: 
            case 27: 
            case 29: 
            case 32: 
            case 37: 
            case 38: 
            case 41: 
            case 42: 
            case 43: 
            case 51: 
            case 52: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 61: 
            case 63: 
            case 64: 
            case 66: 
            case 67: 
            case 69: 
            case 70: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyProgressPanel
    extends JPanel {
        private AsyncProcessIcon mySmallProgressIcon;
        private AsyncProcessIcon myLargeProgressIcon;
        private boolean mySmall;
        private boolean myProgressVisible;

        private MyProgressPanel() {
            super(new BorderLayout());
            this.setOpaque(false);
            this.setVisible(false);
        }

        private void setSmallIcon(boolean small) {
            if (small != this.mySmall) {
                if (this.myProgressVisible && this.getComponentCount() != 0) {
                    AsyncProcessIcon oldIcon = this.getProgressIcon();
                    oldIcon.suspend();
                }
                this.mySmall = true;
                this.removeAll();
                AsyncProcessIcon icon2 = this.getProgressIcon();
                this.add((Component)icon2, "Center");
                if (this.myProgressVisible) {
                    icon2.setVisible(true);
                    icon2.resume();
                }
            }
        }

        public void showProgressIcon() {
            if (!this.myProgressVisible) {
                this.setSmallIcon(DesignSurface.this.useSmallProgressIcon());
                this.myProgressVisible = true;
                this.setVisible(true);
                AsyncProcessIcon icon2 = this.getProgressIcon();
                if (this.getComponentCount() == 0) {
                    this.add((Component)this.getProgressIcon(), "Center");
                } else {
                    icon2.setVisible(true);
                }
                icon2.resume();
            }
        }

        public void hideProgressIcon() {
            if (this.myProgressVisible) {
                this.myProgressVisible = false;
                this.setVisible(false);
                AsyncProcessIcon icon2 = this.getProgressIcon();
                icon2.setVisible(false);
                icon2.suspend();
            }
        }

        @Override
        public void doLayout() {
            super.doLayout();
            this.setBackground((Color)JBColor.RED);
            if (!this.myProgressVisible) {
                return;
            }
            AsyncProcessIcon icon2 = this.getProgressIcon();
            Dimension size = icon2.getPreferredSize();
            if (this.mySmall) {
                icon2.setBounds(this.getWidth() - size.width - 1, 1, size.width, size.height);
            } else {
                icon2.setBounds(this.getWidth() / 2 - size.width / 2, this.getHeight() / 2 - size.height / 2, size.width, size.height);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.getProgressIcon().getPreferredSize();
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon() {
            return this.getProgressIcon(this.mySmall);
        }

        @NotNull
        private AsyncProcessIcon getProgressIcon(boolean small) {
            if (small) {
                if (this.mySmallProgressIcon == null) {
                    this.mySmallProgressIcon = new AsyncProcessIcon("Android layout rendering");
                    Disposer.register((Disposable)DesignSurface.this, (Disposable)this.mySmallProgressIcon);
                }
                AsyncProcessIcon asyncProcessIcon = this.mySmallProgressIcon;
                if (asyncProcessIcon == null) {
                    MyProgressPanel.$$$reportNull$$$0(0);
                }
                return asyncProcessIcon;
            }
            if (this.myLargeProgressIcon == null) {
                this.myLargeProgressIcon = new AsyncProcessIcon.Big("Android layout rendering");
                Disposer.register((Disposable)DesignSurface.this, (Disposable)this.myLargeProgressIcon);
            }
            AsyncProcessIcon asyncProcessIcon = this.myLargeProgressIcon;
            if (asyncProcessIcon == null) {
                MyProgressPanel.$$$reportNull$$$0(1);
            }
            return asyncProcessIcon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/common/surface/DesignSurface$MyProgressPanel", "getProgressIcon"));
        }
    }

    private static class MyScrollBar
    extends JBScrollBar
    implements IdeGlassPane.TopComponent {
        private ScrollBarUI myPersistentUI;

        private MyScrollBar(@JdkConstants.AdjustableOrientation int orientation) {
            super(orientation);
            this.setOpaque(false);
        }

        public boolean canBePreprocessed(@NotNull MouseEvent e) {
            if (e == null) {
                MyScrollBar.$$$reportNull$$$0(0);
            }
            return JBScrollPane.canBePreprocessed((MouseEvent)e, (JScrollBar)((Object)this));
        }

        public void setUI(ScrollBarUI ui) {
            if (this.myPersistentUI == null) {
                this.myPersistentUI = ui;
            }
            super.setUI(this.myPersistentUI);
            this.setOpaque(false);
        }

        public int getUnitIncrement(int direction) {
            return 5;
        }

        public int getBlockIncrement(int direction) {
            return 1;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/common/surface/DesignSurface$MyScrollBar", "canBePreprocessed"));
        }
    }

    private static class MyScrollPane
    extends JBScrollPane {
        private MyScrollPane() {
            super(0);
            this.setupCorners();
        }

        @NotNull
        public JScrollBar createVerticalScrollBar() {
            return new MyScrollBar(1);
        }

        @NotNull
        public JScrollBar createHorizontalScrollBar() {
            return new MyScrollBar(0);
        }
    }

    public static enum SceneViewAlignment {
        LEFT(0.0f),
        RIGHT(1.0f),
        CENTER(0.5f);

        private final float mySwingAlignmentXValue;

        private SceneViewAlignment(float swingValue) {
            this.mySwingAlignmentXValue = swingValue;
        }
    }
}

