/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import java.util.Arrays;
import java.util.function.Consumer;

public class ScenePicker {
    private static final int MAX_DATA_SIZE = 10;
    private static final int INITAL_OBJECT_STORE = 30;
    private static final double EPSILON = 1.0E-5;
    private double[] mObjectData = new double[100];
    private int mObjectDataUsed = 0;
    private int[] mObjectOffset = new int[30];
    private int[] mTypes = new int[30];
    private int[] mRect = new int[120];
    private Object[] mObjects = new Object[30];
    HitElementListener mHitElementListener;
    private int mObjectCount = 0;
    private static final int OBJECT_LINE = 0;
    private static final int OBJECT_CURVE = 1;
    private static final int OBJECT_RECTANGLE = 2;
    private static final int OBJECT_CIRCLE = 3;
    LineSelectionEngine mLine = new LineSelectionEngine();
    CurveToSelectionEngine mCurve = new CurveToSelectionEngine();
    RectangleSelectionEngine mRectangle = new RectangleSelectionEngine();
    CircleSelectionEngine mCircle = new CircleSelectionEngine();
    SelectionEngine[] myEngines = new SelectionEngine[4];

    public ScenePicker() {
        this.myEngines[0] = this.mLine;
        this.myEngines[1] = this.mCurve;
        this.myEngines[2] = this.mRectangle;
        this.myEngines[3] = this.mCircle;
    }

    public void foreachObject(Consumer<Object> consumer) {
        for (int i2 = 0; i2 < this.mObjectCount; ++i2) {
            consumer.accept(this.mObjects[i2]);
        }
    }

    public void find(int x, int y) {
        for (int i2 = 0; i2 < this.mObjectCount; ++i2) {
            SelectionEngine selector;
            int y2;
            int x2;
            int y1;
            int p = i2 * 4;
            int x1 = this.mRect[p++];
            if (!ScenePicker.inRect(x, y, x1, y1 = this.mRect[p++], x2 = this.mRect[p++], y2 = this.mRect[p]) || !(selector = this.myEngines[this.mTypes[i2]]).inRange(i2, x, y)) continue;
            this.mHitElementListener.over(this.mObjects[i2], selector.distance());
        }
    }

    public void setSelectListener(HitElementListener listener2) {
        this.mHitElementListener = listener2;
    }

    private static boolean inRect(int x, int y, int x1, int y1, int x2, int y2) {
        if (x < x1) {
            return false;
        }
        if (y < y1) {
            return false;
        }
        if (x > x2) {
            return false;
        }
        return y <= y2;
    }

    private static boolean inRect(double x, double y, double x1, double y1, double x2, double y2) {
        if (x < x1) {
            return false;
        }
        if (y < y1) {
            return false;
        }
        if (x > x2) {
            return false;
        }
        return !(y > y2);
    }

    public void reset() {
        this.mObjectCount = 0;
        this.mObjectDataUsed = 0;
        Arrays.fill(this.mObjects, null);
    }

    private void resizeTables() {
        if (this.mObjectDataUsed > this.mObjectData.length - 10) {
            this.mObjectData = Arrays.copyOf(this.mObjectData, this.mObjectData.length * 2);
        }
        if (this.mObjectCount < this.mTypes.length) {
            return;
        }
        this.mObjectOffset = Arrays.copyOf(this.mObjectOffset, this.mObjectOffset.length * 2);
        this.mTypes = Arrays.copyOf(this.mTypes, this.mTypes.length * 2);
        this.mObjects = Arrays.copyOf(this.mObjects, this.mObjects.length * 2);
        this.mRect = Arrays.copyOf(this.mRect, this.mRect.length * 2);
    }

    public void addLine(Object e, int range, int x1, int y1, int x2, int y2, int width) {
        this.mLine.add(e, range, x1, y1, x2, y2, width);
    }

    public void addRect(Object e, int range, int x1, int y1, int x2, int y2) {
        this.mRectangle.add(e, range, x1, y1, x2, y2);
    }

    public void addCircle(Object e, int range, int x1, int y1, int r) {
        this.mCircle.add(e, range, x1, y1, r);
    }

    public void addCurveTo(Object e, int range, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int width) {
        this.mCurve.add(e, range, x1, y1, x2, y2, x3, y3, x4, y4, width);
    }

    private static double lineDistanceSqr(double lineLengthSq, double x1, double y1, double x2, double y2, int mouseX, int mouseY) {
        if (lineLengthSq < 1.0E-5) {
            return Math.hypot(x1 - (double)mouseX, y1 - (double)mouseY);
        }
        double t = (((double)mouseX - x1) * (x2 - x1) + ((double)mouseY - y1) * (y2 - y1)) / lineLengthSq;
        t = Math.max(0.0, Math.min(1.0, t));
        double tx = x1 + t * (x2 - x1);
        double ty = y1 + t * (y2 - y1);
        return (tx - (double)mouseX) * (tx - (double)mouseX) + (ty - (double)mouseY) * (ty - (double)mouseY);
    }

    public class CurveToSelectionEngine
    extends SelectionEngine {
        double cx0;
        double cx1;
        double cx2;
        double cx3;
        double cy0;
        double cy1;
        double cy2;
        double cy3;
        double w;
        double mDistance;

        public void add(Object select2, int range, int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, int width) {
            ScenePicker.this.resizeTables();
            ScenePicker.this.mObjectOffset[ScenePicker.this.mObjectCount] = ScenePicker.this.mObjectDataUsed;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = range;
            this.cx0 = x1;
            this.cx1 = 3 * x2 - 3 * x1;
            this.cx2 = 3 * x3 - 6 * x2 + 3 * x1;
            this.cx3 = x4 - 3 * x3 + 3 * x2 - x1;
            this.cy0 = y1;
            this.cy1 = 3 * y2 - 3 * y1;
            this.cy2 = 3 * y3 - 6 * y2 + 3 * y1;
            this.cy3 = y4 - 3 * y3 + 3 * y2 - y1;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = this.cx0;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = this.cx1;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = this.cx2;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = this.cx3;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = this.cy0;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = this.cy1;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = this.cy2;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = this.cy3;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = width;
            ScenePicker.this.mObjects[ScenePicker.this.mObjectCount] = select2;
            ScenePicker.this.mTypes[ScenePicker.this.mObjectCount] = 1;
            this.bounds(range + width);
            ++ScenePicker.this.mObjectCount;
        }

        @Override
        protected boolean inRange() {
            double range = ScenePicker.this.mObjectData[this.mDataOffset];
            this.cx0 = ScenePicker.this.mObjectData[this.mDataOffset + 1];
            this.cx1 = ScenePicker.this.mObjectData[this.mDataOffset + 2];
            this.cx2 = ScenePicker.this.mObjectData[this.mDataOffset + 3];
            this.cx3 = ScenePicker.this.mObjectData[this.mDataOffset + 4];
            this.cy0 = ScenePicker.this.mObjectData[this.mDataOffset + 5];
            this.cy1 = ScenePicker.this.mObjectData[this.mDataOffset + 6];
            this.cy2 = ScenePicker.this.mObjectData[this.mDataOffset + 7];
            this.cy3 = ScenePicker.this.mObjectData[this.mDataOffset + 8];
            this.w = ScenePicker.this.mObjectData[this.mDataOffset + 9];
            double minDistanceSqr = 2.147483647E9;
            double widthSqr = this.w * this.w;
            double prevX = this.cx0;
            double prevY = this.cy0;
            for (double t = 0.03; t < 1.0; t += 0.03) {
                double t2 = t * t;
                double t3 = t * t2;
                double x = this.cx0 + this.cx1 * t + this.cx2 * t2 + this.cx3 * t3;
                double y = this.cy0 + this.cy1 * t + this.cy2 * t2 + this.cy3 * t3;
                double segmentSqr = (x - prevX) * (x - prevX) + (y - prevY) * (y - prevY);
                double distanceSqr = ScenePicker.lineDistanceSqr(segmentSqr, prevX, prevY, x, y, this.mMouseX, this.mMouseY);
                if (distanceSqr < widthSqr) {
                    this.mDistance = 0.0;
                    return true;
                }
                minDistanceSqr = Math.min(minDistanceSqr, distanceSqr);
                prevX = x;
                prevY = y;
            }
            if (minDistanceSqr > (range + this.w) * (range + this.w)) {
                return false;
            }
            this.mDistance = Math.sqrt(minDistanceSqr) - this.w;
            return true;
        }

        public final double evalX(double t) {
            double t2 = t * t;
            double t3 = t * t2;
            return this.cx0 + this.cx1 * t + this.cx2 * t2 + this.cx3 * t3;
        }

        public final double evalY(double t) {
            double t2 = t * t;
            double t3 = t * t2;
            return this.cy0 + this.cy1 * t + this.cy2 * t2 + this.cy3 * t3;
        }

        public final void bounds(int range) {
            double t2;
            double t1;
            double x0 = this.cx0;
            double y0 = this.cy0;
            double x1 = this.cx0 + this.cx1 + this.cx2 + this.cx3;
            double y1 = this.cy0 + this.cy1 + this.cy2 + this.cy3;
            double minx = Math.min(x0, x1);
            double miny = Math.min(y0, y1);
            double maxx = Math.max(x0, x1);
            double maxy = Math.max(y0, y1);
            if (this.cx3 != 0.0) {
                double x;
                t1 = -(Math.sqrt(this.cx2 * this.cx2 - 3.0 * this.cx1 * this.cx3) + this.cx2) / (3.0 * this.cx3);
                t2 = (Math.sqrt(this.cx2 * this.cx2 - 3.0 * this.cx1 * this.cx3) - this.cx2) / (3.0 * this.cx3);
                if (t1 > 0.0 && t1 < 1.0) {
                    x = this.evalX(t1);
                    minx = Math.min(x, minx);
                    maxx = Math.max(x, maxx);
                }
                if (t2 > 0.0 && t2 < 1.0) {
                    x = this.evalX(t2);
                    minx = Math.min(x, minx);
                    maxx = Math.max(x, maxx);
                }
            }
            if (this.cy3 != 0.0) {
                double y;
                t1 = -(Math.sqrt(this.cy2 * this.cy2 - 3.0 * this.cy1 * this.cy3) + this.cy2) / (3.0 * this.cy3);
                t2 = (Math.sqrt(this.cy2 * this.cy2 - 3.0 * this.cy1 * this.cy3) - this.cy2) / (3.0 * this.cy3);
                if (t1 > 0.0 && t1 < 1.0) {
                    y = this.evalY(t1);
                    miny = Math.min(y, miny);
                    maxy = Math.max(y, maxy);
                }
                if (t2 > 0.0 && t2 < 1.0) {
                    y = this.evalY(t2);
                    miny = Math.min(y, miny);
                    maxy = Math.max(y, maxy);
                }
            }
            this.addRect((int)minx - range, (int)miny - range, (int)(maxx + (double)range), (int)(maxy + (double)range));
        }

        @Override
        double distance() {
            return this.mDistance;
        }
    }

    class RectangleSelectionEngine
    extends SelectionEngine {
        double mDistance;

        RectangleSelectionEngine() {
        }

        public void add(Object select2, int range, int x1, int y1, int x2, int y2) {
            int t;
            ScenePicker.this.resizeTables();
            ScenePicker.this.mObjectOffset[ScenePicker.this.mObjectCount] = ScenePicker.this.mObjectDataUsed;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = range;
            if (x1 > x2) {
                t = x1;
                x1 = x2;
                x2 = t;
            }
            if (y1 > y2) {
                t = y1;
                y1 = y2;
                y2 = t;
            }
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = x1;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = y1;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = x2;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = y2;
            this.addRect(x1 - range, y1 - range, x2 + range, y2 + range);
            ScenePicker.this.mObjects[ScenePicker.this.mObjectCount] = select2;
            ScenePicker.this.mTypes[ScenePicker.this.mObjectCount] = 2;
            ++ScenePicker.this.mObjectCount;
        }

        @Override
        protected boolean inRange() {
            double range = ScenePicker.this.mObjectData[this.mDataOffset];
            double x1 = ScenePicker.this.mObjectData[this.mDataOffset + 1];
            double y1 = ScenePicker.this.mObjectData[this.mDataOffset + 2];
            double x2 = ScenePicker.this.mObjectData[this.mDataOffset + 3];
            double y2 = ScenePicker.this.mObjectData[this.mDataOffset + 4];
            if (ScenePicker.inRect((double)this.mMouseX, (double)this.mMouseY, x1, y1, x2, y2)) {
                this.mDistance = 0.0;
                return true;
            }
            if ((double)this.mMouseX >= x1 && (double)this.mMouseX <= x2) {
                if ((double)this.mMouseY < y1) {
                    this.mDistance = y1 - (double)this.mMouseY;
                    return this.mDistance < range;
                }
                if ((double)this.mMouseY > y2) {
                    this.mDistance = (double)this.mMouseY - y2;
                    return this.mDistance < range;
                }
            }
            if ((double)this.mMouseY >= y1 && (double)this.mMouseY <= y2) {
                if ((double)this.mMouseX < x1) {
                    this.mDistance = x1 - (double)this.mMouseX;
                    return this.mDistance < range;
                }
                if ((double)this.mMouseX > x2) {
                    this.mDistance = (double)this.mMouseX - x2;
                    return this.mDistance < range;
                }
            }
            if ((double)this.mMouseX < x1) {
                if ((double)this.mMouseY < y1) {
                    this.mDistance = Math.hypot((double)this.mMouseX - x1, (double)this.mMouseY - y1);
                    if (this.mDistance <= range) {
                        return true;
                    }
                } else {
                    this.mDistance = Math.hypot((double)this.mMouseX - x1, (double)this.mMouseY - y2);
                    if (this.mDistance <= range) {
                        return true;
                    }
                }
            } else if ((double)this.mMouseY <= y1) {
                this.mDistance = Math.hypot((double)this.mMouseX - x2, (double)this.mMouseY - y1);
                if (this.mDistance <= range) {
                    return true;
                }
            } else {
                this.mDistance = Math.hypot((double)this.mMouseX - x2, (double)this.mMouseY - y2);
                if (this.mDistance <= range) {
                    return true;
                }
            }
            return false;
        }

        @Override
        double distance() {
            return this.mDistance;
        }
    }

    class LineSelectionEngine
    extends SelectionEngine {
        double mDistance;

        LineSelectionEngine() {
        }

        public void add(Object select2, int range, int x1, int y1, int x2, int y2, int width) {
            int t;
            ScenePicker.this.resizeTables();
            ScenePicker.this.mObjectOffset[ScenePicker.this.mObjectCount] = ScenePicker.this.mObjectDataUsed;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = range;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = x1;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = y1;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = x2;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = y2;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = width;
            if (x1 > x2) {
                t = x1;
                x1 = x2;
                x2 = t;
            }
            if (y1 > y2) {
                t = y1;
                y1 = y2;
                y2 = t;
            }
            int r = range + width;
            this.addRect(x1 - r, y1 - r, x2 + r, y2 + r);
            ScenePicker.this.mObjects[ScenePicker.this.mObjectCount] = select2;
            ScenePicker.this.mTypes[ScenePicker.this.mObjectCount] = 0;
            ++ScenePicker.this.mObjectCount;
        }

        @Override
        protected boolean inRange() {
            double range = ScenePicker.this.mObjectData[this.mDataOffset];
            double lineLengthSq = ScenePicker.this.mObjectData[this.mDataOffset + 1];
            double x1 = ScenePicker.this.mObjectData[this.mDataOffset + 2];
            double y1 = ScenePicker.this.mObjectData[this.mDataOffset + 3];
            double x2 = ScenePicker.this.mObjectData[this.mDataOffset + 4];
            double y2 = ScenePicker.this.mObjectData[this.mDataOffset + 5];
            double w = ScenePicker.this.mObjectData[this.mDataOffset + 6];
            this.mDistance = Math.max(Math.sqrt(ScenePicker.lineDistanceSqr(lineLengthSq, x1, y1, x2, y2, this.mMouseX, this.mMouseY)) - w, 0.0);
            return this.mDistance <= range;
        }

        @Override
        double distance() {
            return this.mDistance;
        }
    }

    class CircleSelectionEngine
    extends SelectionEngine {
        double mDistance;

        CircleSelectionEngine() {
        }

        public void add(Object select2, int range, int x1, int y1, int r) {
            ScenePicker.this.resizeTables();
            ScenePicker.this.mTypes[ScenePicker.this.mObjectCount] = 3;
            ScenePicker.this.mObjectOffset[ScenePicker.this.mObjectCount] = ScenePicker.this.mObjectDataUsed;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = range;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = x1;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = y1;
            ScenePicker.this.mObjectData[ScenePicker.this.mObjectDataUsed++] = r;
            ScenePicker.this.mObjects[ScenePicker.this.mObjectCount] = select2;
            this.addRect(x1 - range - r, y1 - range - r, x1 + range + r, y1 + range + r);
            ++ScenePicker.this.mObjectCount;
        }

        @Override
        protected boolean inRange() {
            double range = ScenePicker.this.mObjectData[this.mDataOffset];
            double x = ScenePicker.this.mObjectData[this.mDataOffset + 1];
            double y = ScenePicker.this.mObjectData[this.mDataOffset + 2];
            double r = ScenePicker.this.mObjectData[this.mDataOffset + 3];
            double d = Math.hypot(x - (double)this.mMouseX, y - (double)this.mMouseY);
            if (d < r) {
                this.mDistance = 0.0;
                return true;
            }
            this.mDistance = d - r;
            return this.mDistance <= range;
        }

        @Override
        double distance() {
            return this.mDistance;
        }
    }

    private abstract class SelectionEngine {
        protected int mObject;
        protected int mMouseX;
        protected int mMouseY;
        protected int mDataOffset;

        private SelectionEngine() {
        }

        protected void addRect(int x1, int y1, int x2, int y2) {
            int off = ScenePicker.this.mObjectCount * 4;
            ScenePicker.this.mRect[off++] = x1;
            ScenePicker.this.mRect[off++] = y1;
            ScenePicker.this.mRect[off++] = x2;
            ScenePicker.this.mRect[off] = y2;
        }

        boolean inRange(int object, int x, int y) {
            this.mObject = object;
            this.mDataOffset = ScenePicker.this.mObjectOffset[this.mObject];
            this.mMouseX = x;
            this.mMouseY = y;
            return this.inRange();
        }

        protected abstract boolean inRange();

        abstract double distance();
    }

    public static interface HitElementListener {
        public void over(Object var1, double var2);
    }
}

