/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.DefaultHitProvider;
import com.android.tools.idea.common.scene.DefaultSceneManagerHierarchyProvider;
import com.android.tools.idea.common.scene.HitProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecoratorFactory;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SceneManager
implements Disposable {
    public static final boolean SUPPORTS_LOCKING = false;
    @NotNull
    private final NlModel myModel;
    @NotNull
    private final DesignSurface myDesignSurface;
    @NotNull
    private final Scene myScene;
    @Nullable
    private SceneView mySceneView;
    @NotNull
    private final HitProvider myHitProvider;
    @NotNull
    private final SceneComponentHierarchyProvider mySceneComponentProvider;
    @NotNull
    private final SceneUpdateListener mySceneUpdateListener;

    public SceneManager(@NotNull NlModel model2, @NotNull DesignSurface surface2, boolean useLiveRendering, @Nullable SceneComponentHierarchyProvider sceneComponentProvider, @Nullable SceneUpdateListener sceneUpdateListener) {
        if (model2 == null) {
            SceneManager.$$$reportNull$$$0(0);
        }
        if (surface2 == null) {
            SceneManager.$$$reportNull$$$0(1);
        }
        this.myHitProvider = new DefaultHitProvider();
        this.myModel = model2;
        this.myDesignSurface = surface2;
        Disposer.register((Disposable)model2, (Disposable)this);
        this.mySceneComponentProvider = sceneComponentProvider == null ? new DefaultSceneManagerHierarchyProvider() : sceneComponentProvider;
        this.mySceneUpdateListener = sceneUpdateListener == null ? new DefaultSceneUpdateListener() : sceneUpdateListener;
        this.myScene = new Scene(this, this.myDesignSurface, useLiveRendering);
    }

    protected void createSceneView() {
        if (this.mySceneView != null) {
            Disposer.dispose((Disposable)this.mySceneView);
        }
        this.mySceneView = this.doCreateSceneView();
        Disposer.register((Disposable)this, (Disposable)this.mySceneView);
    }

    @NotNull
    protected abstract SceneView doCreateSceneView();

    public final void updateSceneView() {
        for (SceneView sceneView : this.getSceneViews()) {
            this.myDesignSurface.removeSceneView(sceneView);
        }
        this.createSceneView();
        for (SceneView sceneView : this.getSceneViews()) {
            this.myDesignSurface.addSceneView(sceneView);
        }
    }

    @Deprecated
    @NotNull
    public SceneView getSceneView() {
        assert (this.mySceneView != null) : "createSceneView was not called";
        SceneView sceneView = this.mySceneView;
        if (sceneView == null) {
            SceneManager.$$$reportNull$$$0(2);
        }
        return sceneView;
    }

    @NotNull
    public List<SceneView> getSceneViews() {
        ImmutableList immutableList = ImmutableList.of((Object)this.getSceneView());
        if (immutableList == null) {
            SceneManager.$$$reportNull$$$0(3);
        }
        return immutableList;
    }

    public abstract float getSceneScalingFactor();

    public void dispose() {
        for (SceneView sceneView : this.getSceneViews()) {
            this.myDesignSurface.removeSceneView(sceneView);
        }
    }

    public void update() {
        ImmutableList<NlComponent> components = this.getModel().getComponents();
        Scene scene = this.getScene();
        if (components.isEmpty()) {
            scene.removeAllComponents();
            scene.setRoot(null);
            return;
        }
        HashSet<SceneComponent> usedComponents = new HashSet<SceneComponent>();
        HashSet<SceneComponent> oldComponents = new HashSet<SceneComponent>(scene.getSceneComponents());
        NlComponent rootComponent2 = this.getRoot();
        if (this.myScene.getRoot() != null && rootComponent2 != this.myScene.getRoot().getNlComponent()) {
            scene.removeAllComponents();
            scene.setRoot(null);
        }
        this.mySceneUpdateListener.onUpdate(rootComponent2, this.myDesignSurface);
        List<SceneComponent> hierarchy = this.mySceneComponentProvider.createHierarchy(this, rootComponent2);
        SceneComponent root2 = hierarchy.isEmpty() ? null : hierarchy.get(0);
        scene.setRoot(root2);
        if (root2 != null) {
            this.updateFromComponent(root2, usedComponents);
        }
        oldComponents.removeAll(usedComponents);
        oldComponents.removeIf(component -> component instanceof TemporarySceneComponent);
        oldComponents.forEach(scene::removeComponent);
        scene.needsRebuildList();
    }

    @NotNull
    protected NlComponent getRoot() {
        NlComponent nlComponent = ((NlComponent)this.getModel().getComponents().get(0)).getRoot();
        if (nlComponent == null) {
            SceneManager.$$$reportNull$$$0(4);
        }
        return nlComponent;
    }

    public static boolean isComponentLocked(@NotNull NlComponent component) {
        if (component == null) {
            SceneManager.$$$reportNull$$$0(5);
        }
        return false;
    }

    protected final void updateFromComponent(@NotNull SceneComponent component, @NotNull Set<SceneComponent> seenComponents) {
        if (component == null) {
            SceneManager.$$$reportNull$$$0(6);
        }
        if (seenComponents == null) {
            SceneManager.$$$reportNull$$$0(7);
        }
        seenComponents.add(component);
        this.syncFromNlComponent(component);
        for (SceneComponent child : component.getChildren()) {
            this.updateFromComponent(child, seenComponents);
        }
    }

    @NotNull
    public abstract TemporarySceneComponent createTemporaryComponent(@NotNull NlComponent var1);

    protected final void syncFromNlComponent(SceneComponent sceneComponent) {
        this.mySceneComponentProvider.syncFromNlComponent(sceneComponent);
    }

    @NotNull
    protected DesignSurface getDesignSurface() {
        DesignSurface designSurface = this.myDesignSurface;
        if (designSurface == null) {
            SceneManager.$$$reportNull$$$0(8);
        }
        return designSurface;
    }

    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myModel;
        if (nlModel == null) {
            SceneManager.$$$reportNull$$$0(9);
        }
        return nlModel;
    }

    @NotNull
    public Scene getScene() {
        Scene scene = this.myScene;
        if (scene == null) {
            SceneManager.$$$reportNull$$$0(10);
        }
        return scene;
    }

    @NotNull
    public abstract CompletableFuture<Void> requestRender();

    @NotNull
    public CompletableFuture<Void> requestLayoutAndRender(boolean animate) {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            SceneManager.$$$reportNull$$$0(11);
        }
        return completableFuture;
    }

    @NotNull
    public abstract CompletableFuture<Void> requestLayout(boolean var1);

    public abstract void layout(boolean var1);

    @NotNull
    public abstract SceneDecoratorFactory getSceneDecoratorFactory();

    public abstract Map<Object, Map<ResourceReference, ResourceValue>> getDefaultProperties();

    public abstract Map<Object, ResourceReference> getDefaultStyles();

    @NotNull
    protected HitProvider getHitProvider(@NotNull NlComponent component) {
        if (component == null) {
            SceneManager.$$$reportNull$$$0(12);
        }
        HitProvider hitProvider = this.myHitProvider;
        if (hitProvider == null) {
            SceneManager.$$$reportNull$$$0(13);
        }
        return hitProvider;
    }

    public boolean activate(@NotNull Object source) {
        if (source == null) {
            SceneManager.$$$reportNull$$$0(14);
        }
        return this.getModel().activate(source);
    }

    public boolean deactivate(@NotNull Object source) {
        if (source == null) {
            SceneManager.$$$reportNull$$$0(15);
        }
        return this.getModel().deactivate(source);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/SceneManager";
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "seenComponents";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/SceneManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneViews";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignSurface";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getScene";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "requestLayoutAndRender";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getHitProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isComponentLocked";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateFromComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getHitProvider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "activate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "deactivate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DefaultSceneUpdateListener
    implements SceneUpdateListener {
        @Override
        public void onUpdate(@NotNull NlComponent component, @NotNull DesignSurface designSurface) {
            if (component == null) {
                DefaultSceneUpdateListener.$$$reportNull$$$0(0);
            }
            if (designSurface == null) {
                DefaultSceneUpdateListener.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "designSurface";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/idea/common/scene/SceneManager$DefaultSceneUpdateListener";
            objectArray[2] = "onUpdate";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface SceneUpdateListener {
        public void onUpdate(@NotNull NlComponent var1, @NotNull DesignSurface var2);
    }

    public static interface SceneComponentHierarchyProvider {
        @NotNull
        public List<SceneComponent> createHierarchy(@NotNull SceneManager var1, @NotNull NlComponent var2);

        public void syncFromNlComponent(@NotNull SceneComponent var1);
    }
}

