/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionEvent;
import com.android.tools.idea.common.surface.KeyPressedEvent;
import com.android.tools.idea.common.surface.KeyReleasedEvent;
import com.android.tools.idea.common.surface.MouseDraggedEvent;
import com.android.tools.idea.common.surface.MousePressedEvent;
import com.android.tools.idea.common.surface.MouseReleasedEvent;
import com.android.tools.idea.common.surface.SceneView;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SceneInteraction
extends Interaction {
    protected SceneView mySceneView;

    public SceneInteraction(@NotNull SceneView sceneView) {
        if (sceneView == null) {
            SceneInteraction.$$$reportNull$$$0(0);
        }
        this.mySceneView = sceneView;
    }

    @Override
    public void begin(@NotNull InteractionEvent event) {
        if (event == null) {
            SceneInteraction.$$$reportNull$$$0(1);
        }
        if (event instanceof MousePressedEvent) {
            MouseEvent mouseEvent = (MouseEvent)((MousePressedEvent)event).getEventObject();
            this.begin(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiersEx());
        } else {
            Logger.getInstance(SceneInteraction.class).warn("The Scene Interaction shouldn't be started by event " + event);
        }
    }

    @Override
    public void begin(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        super.begin(x, y, modifiersEx);
        int androidX = Coordinates.getAndroidX(this.mySceneView, this.myStartX);
        int androidY = Coordinates.getAndroidY(this.mySceneView, this.myStartY);
        int dpX = Coordinates.pxToDp(this.mySceneView, androidX);
        int dpY = Coordinates.pxToDp(this.mySceneView, androidY);
        Scene scene = this.mySceneView.getScene();
        scene.mouseDown(SceneContext.get(this.mySceneView), dpX, dpY, modifiersEx);
    }

    @Override
    public void update(@NotNull InteractionEvent event) {
        if (event == null) {
            SceneInteraction.$$$reportNull$$$0(2);
        }
        if (event instanceof MouseDraggedEvent) {
            MouseEvent mouseEvent = (MouseEvent)((MouseDraggedEvent)event).getEventObject();
            int mouseX = mouseEvent.getX();
            int mouseY = mouseEvent.getY();
            this.mySceneView.getContext().setMouseLocation(mouseX, mouseY);
            this.update(mouseX, mouseY, mouseEvent.getModifiersEx());
        } else if (event instanceof KeyPressedEvent || event instanceof KeyReleasedEvent) {
            Scene scene = this.mySceneView.getScene();
            scene.needsRebuildList();
            scene.repaint();
        }
    }

    @Override
    public void update(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        super.update(x, y, modifiersEx);
        int androidX = Coordinates.getAndroidX(this.mySceneView, x);
        int androidY = Coordinates.getAndroidY(this.mySceneView, y);
        int dpX = Coordinates.pxToDp(this.mySceneView, androidX);
        int dpY = Coordinates.pxToDp(this.mySceneView, androidY);
        Scene scene = this.mySceneView.getScene();
        scene.mouseDrag(SceneContext.get(this.mySceneView), dpX, dpY, modifiersEx);
        this.mySceneView.getSurface().repaint();
    }

    @Override
    public void commit(@NotNull InteractionEvent event) {
        if (event == null) {
            SceneInteraction.$$$reportNull$$$0(3);
        }
        assert (event instanceof MouseReleasedEvent) : "The instance of event should be MouseReleasedEvent but it is " + event.getClass() + "; The SceneView is " + this.mySceneView + ", start (x, y) = " + this.myStartX + ", " + this.myStartY + ", start mask is " + this.myStartMask;
        MouseEvent mouseEvent = (MouseEvent)((MouseReleasedEvent)event).getEventObject();
        this.end(mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getModifiersEx());
    }

    @Override
    public void end(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        int androidX = Coordinates.getAndroidX(this.mySceneView, x);
        int androidY = Coordinates.getAndroidY(this.mySceneView, y);
        int dpX = Coordinates.pxToDp(this.mySceneView, androidX);
        int dpY = Coordinates.pxToDp(this.mySceneView, androidY);
        Scene scene = this.mySceneView.getScene();
        scene.mouseRelease(SceneContext.get(this.mySceneView), dpX, dpY, modifiersEx);
        this.mySceneView.getSurface().repaint();
    }

    @Override
    public void cancel(@NotNull InteractionEvent event) {
        if (event == null) {
            SceneInteraction.$$$reportNull$$$0(4);
        }
        this.cancel(event.getInfo().getX(), event.getInfo().getY(), event.getInfo().getModifiersEx());
    }

    @Override
    public void cancel(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        Scene scene = this.mySceneView.getScene();
        scene.mouseCancel();
        this.mySceneView.getSurface().repaint();
    }

    @Override
    @Nullable
    public Cursor getCursor() {
        return this.mySceneView.getScene().getMouseCursor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/common/scene/SceneInteraction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "begin";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "commit";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "cancel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

