/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.ComponentProvider;
import com.android.tools.idea.common.scene.HitProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.TargetProvider;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.CommonDragTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SceneComponent {
    @VisibleForTesting
    public static final int ANIMATION_DURATION = 350;
    public HashMap<String, Object> myCache;
    public SceneDecorator myDecorator;
    private TargetProvider myTargetProvider;
    private ComponentProvider myComponentProvider;
    private HitProvider myHitProvider;
    private final Scene myScene;
    private final NlComponent myNlComponent;
    private CopyOnWriteArrayList<SceneComponent> myChildren;
    private SceneComponent myParent;
    private boolean myIsToolLocked;
    private boolean myIsSelected;
    private boolean myIsHighlighted;
    protected boolean myDragging;
    private AnimatedValue myAnimatedDrawX;
    private AnimatedValue myAnimatedDrawY;
    private AnimatedValue myAnimatedDrawWidth;
    private AnimatedValue myAnimatedDrawHeight;
    private DrawState myDrawState;
    private final ArrayList<Target> myTargets;
    @Nullable
    private ImmutableList<Target> myCachedTargetList;
    private int myCurrentLeft;
    private int myCurrentTop;
    private int myCurrentRight;
    private int myCurrentBottom;
    private boolean myShowBaseline;
    @Nullable
    private Notch.Provider myNotchProvider;
    @Nullable
    private CommonDragTarget myDragTarget;

    public int getCenterX() {
        return this.myCurrentLeft + (this.myCurrentRight - this.myCurrentLeft) / 2;
    }

    public int getCenterY() {
        return this.myCurrentTop + (this.myCurrentBottom - this.myCurrentTop) / 2;
    }

    public SceneComponent(@NotNull Scene scene, @NotNull NlComponent component, @NotNull HitProvider hitProvider) {
        if (scene == null) {
            SceneComponent.$$$reportNull$$$0(0);
        }
        if (component == null) {
            SceneComponent.$$$reportNull$$$0(1);
        }
        if (hitProvider == null) {
            SceneComponent.$$$reportNull$$$0(2);
        }
        this.myCache = new HashMap();
        this.myChildren = new CopyOnWriteArrayList();
        this.myParent = null;
        this.myIsToolLocked = false;
        this.myIsSelected = false;
        this.myIsHighlighted = false;
        this.myDragging = false;
        this.myAnimatedDrawX = new AnimatedValue();
        this.myAnimatedDrawY = new AnimatedValue();
        this.myAnimatedDrawWidth = new AnimatedValue();
        this.myAnimatedDrawHeight = new AnimatedValue();
        this.myDrawState = DrawState.NORMAL;
        this.myTargets = new ArrayList();
        this.myCurrentLeft = 0;
        this.myCurrentTop = 0;
        this.myCurrentRight = 0;
        this.myCurrentBottom = 0;
        this.myShowBaseline = false;
        this.myNotchProvider = null;
        this.myScene = scene;
        this.myNlComponent = component;
        this.myScene.addComponent(this);
        SceneManager manager = scene.getSceneManager();
        this.myDecorator = manager.getSceneDecoratorFactory().get(component);
        this.myHitProvider = hitProvider;
        this.setSelected(this.myScene.getDesignSurface().getSelectionModel().isSelected(component));
    }

    public String toString() {
        return this.getNlComponent().toString() + " [ " + this.myCurrentLeft + ", " + this.myCurrentTop + " - " + this.myCurrentRight + ", " + this.myCurrentBottom + "]";
    }

    @Nullable
    public SceneComponent getParent() {
        return this.myParent;
    }

    private void setParent(@NotNull SceneComponent parent) {
        if (parent == null) {
            SceneComponent.$$$reportNull$$$0(3);
        }
        this.myParent = parent;
    }

    public int getDepth() {
        int depth = 0;
        SceneComponent current = this.myParent;
        while (current != null) {
            current = current.myParent;
            ++depth;
        }
        return depth;
    }

    private TargetProvider getTargetProvider() {
        return this.myTargetProvider;
    }

    public boolean useRtlAttributes() {
        return this.myScene.supportsRTL();
    }

    public int findTarget(Class aClass) {
        ImmutableList<Target> targets = this.getTargets();
        int count = targets.size();
        for (int i2 = 0; i2 < count; ++i2) {
            if (!aClass.isInstance(targets.get(i2))) continue;
            return i2;
        }
        return -1;
    }

    boolean hasAncestor(SceneComponent candidate) {
        for (SceneComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != candidate) continue;
            return true;
        }
        return false;
    }

    public boolean isSelected() {
        return this.myIsSelected;
    }

    public boolean isHighlighted() {
        return this.myIsHighlighted;
    }

    public boolean canShowBaseline() {
        return this.myShowBaseline;
    }

    public void setShowBaseline(boolean value2) {
        this.myShowBaseline = value2;
    }

    public boolean hasNoDimension() {
        return this.myAnimatedDrawWidth.value == 0 && this.myAnimatedDrawHeight.value == 0 && this.myAnimatedDrawX.value == this.myAnimatedDrawX.target && this.myAnimatedDrawY.value == this.myAnimatedDrawY.target;
    }

    public int getDrawX() {
        return this.myAnimatedDrawX.getValue(0L);
    }

    public int getDrawY() {
        return this.myAnimatedDrawY.getValue(0L);
    }

    public int getDrawWidth() {
        return this.myAnimatedDrawWidth.getValue(0L);
    }

    public int getDrawHeight() {
        return this.myAnimatedDrawHeight.getValue(0L);
    }

    public int getDrawX(long time2) {
        return this.myAnimatedDrawX.getValue(time2);
    }

    public int getDrawY(long time2) {
        return this.myAnimatedDrawY.getValue(time2);
    }

    public int getDrawWidth(long time2) {
        return this.myAnimatedDrawWidth.getValue(time2);
    }

    public int getDrawHeight(long time2) {
        return this.myAnimatedDrawHeight.getValue(time2);
    }

    public void setPosition(int dx, int dy) {
        this.myAnimatedDrawX.setValue(dx);
        this.myAnimatedDrawY.setValue(dy);
        if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
            NlComponentHelperKt.setX(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)dx));
            NlComponentHelperKt.setY(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)dy));
        }
        this.myScene.needsRebuildList();
    }

    public void setPositionTarget(int dx, int dy, long time2) {
        this.myAnimatedDrawX.setTarget(dx, time2);
        this.myAnimatedDrawY.setTarget(dy, time2);
        if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
            NlComponentHelperKt.setX(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)dx));
            NlComponentHelperKt.setY(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)dy));
        } else {
            this.myScene.needsRebuildList();
        }
    }

    public void setSize(int width, int height) {
        this.myAnimatedDrawWidth.setValue(width);
        this.myAnimatedDrawHeight.setValue(height);
        if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
            NlComponentHelperKt.setW(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)width));
            NlComponentHelperKt.setH(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)height));
        }
        this.myScene.needsRebuildList();
    }

    public void setSizeTarget(int width, int height, long time2) {
        this.myAnimatedDrawWidth.setTarget(width, time2);
        this.myAnimatedDrawHeight.setTarget(height, time2);
        if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
            NlComponentHelperKt.setW(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)width));
            NlComponentHelperKt.setH(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)height));
        }
    }

    @NotNull
    public NlComponent getAuthoritativeNlComponent() {
        ComponentProvider provider2 = this.myComponentProvider;
        if (provider2 != null) {
            NlComponent nlComponent = provider2.getComponent(this);
            if (nlComponent == null) {
                SceneComponent.$$$reportNull$$$0(4);
            }
            return nlComponent;
        }
        NlComponent nlComponent = this.myNlComponent;
        if (nlComponent == null) {
            SceneComponent.$$$reportNull$$$0(5);
        }
        return nlComponent;
    }

    @NotNull
    public NlComponent getNlComponent() {
        NlComponent nlComponent = this.myNlComponent;
        if (nlComponent == null) {
            SceneComponent.$$$reportNull$$$0(6);
        }
        return nlComponent;
    }

    @NotNull
    public Scene getScene() {
        Scene scene = this.myScene;
        if (scene == null) {
            SceneComponent.$$$reportNull$$$0(7);
        }
        return scene;
    }

    public List<SceneComponent> getChildren() {
        return this.myChildren;
    }

    public int getChildCount() {
        return this.myChildren.size();
    }

    public SceneComponent getChild(int i2) {
        return this.myChildren.get(i2);
    }

    public void setToolLocked(boolean locked) {
        this.myIsToolLocked = locked;
    }

    public boolean isToolLocked() {
        return this.myIsToolLocked;
    }

    public void setDrawState(@NotNull DrawState drawState) {
        if (drawState == null) {
            SceneComponent.$$$reportNull$$$0(8);
        }
        DrawState oldState = this.myDrawState;
        this.myDrawState = drawState;
        if (this.myIsSelected) {
            this.myDrawState = DrawState.SELECTED;
        }
        if (oldState != this.myDrawState) {
            DecoratorUtilities.setTimeChange(this.myNlComponent, "view", DecoratorUtilities.mapState(drawState));
        }
    }

    public int getBaseline() {
        return Coordinates.pxToDp(this.getScene().getSceneManager(), NlComponentHelperKt.getBaseline(this.myNlComponent));
    }

    public void setHighlighted(boolean highlighted) {
        this.myIsHighlighted = highlighted;
        this.setDrawState(DrawState.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(boolean selected) {
        if (!selected || !this.myIsSelected) {
            this.myShowBaseline = false;
        }
        this.myIsSelected = selected;
        if (this.myIsSelected) {
            this.setDrawState(DrawState.SELECTED);
        } else {
            this.setDrawState(DrawState.NORMAL);
        }
        ArrayList<Target> arrayList = this.myTargets;
        synchronized (arrayList) {
            this.myTargets.forEach(it -> it.componentSelectionChanged(selected));
        }
    }

    public void setDragging(boolean dragging) {
        if (!this.getNlComponent().isRoot()) {
            this.myDragging = dragging;
        }
    }

    public boolean isDragging() {
        return this.myDragging;
    }

    public DrawState getDrawState() {
        return this.myDrawState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<Target> getTargets() {
        assert (ApplicationManager.getApplication().isDispatchThread());
        ArrayList<Target> arrayList = this.myTargets;
        synchronized (arrayList) {
            if (this.myCachedTargetList == null) {
                this.myCachedTargetList = ImmutableList.copyOf(this.myTargets);
            }
            return this.myCachedTargetList;
        }
    }

    public SceneDecorator getDecorator() {
        return this.myDecorator;
    }

    @Nullable
    public Notch.Provider getNotchProvider() {
        return this.myNotchProvider;
    }

    public void setNotchProvider(@Nullable Notch.Provider notchProvider) {
        this.myNotchProvider = notchProvider;
    }

    @VisibleForTesting
    ResizeBaseTarget getResizeTarget(ResizeBaseTarget.Type type) {
        ImmutableList<Target> targets = this.getTargets();
        int count = targets.size();
        for (int i2 = 0; i2 < count; ++i2) {
            ResizeBaseTarget target;
            if (!(targets.get(i2) instanceof ResizeBaseTarget) || (target = (ResizeBaseTarget)targets.get(i2)).getType() != type) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull String componentId) {
        if (componentId == null) {
            SceneComponent.$$$reportNull$$$0(9);
        }
        if (componentId.equalsIgnoreCase(this.myNlComponent.getId())) {
            return this;
        }
        for (SceneComponent child : this.myChildren) {
            SceneComponent found = child.getSceneComponent(componentId);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull NlComponent nlComponent) {
        if (nlComponent == null) {
            SceneComponent.$$$reportNull$$$0(10);
        }
        if (nlComponent == this.myNlComponent) {
            return this;
        }
        for (SceneComponent child : this.getChildren()) {
            SceneComponent found = child.getSceneComponent(nlComponent);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public boolean intersects(@NotNull SceneContext sceneTransform, Rectangle rectangle) {
        if (sceneTransform == null) {
            SceneComponent.$$$reportNull$$$0(11);
        }
        return this.myHitProvider.intersects(this, sceneTransform, rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTarget(@NotNull Target target) {
        if (target == null) {
            SceneComponent.$$$reportNull$$$0(12);
        }
        target.setComponent(this);
        ArrayList<Target> arrayList = this.myTargets;
        synchronized (arrayList) {
            this.myCachedTargetList = null;
            this.myTargets.add(target);
        }
    }

    public void addChild(@NotNull SceneComponent child) {
        if (child == null) {
            SceneComponent.$$$reportNull$$$0(13);
        }
        child.removeFromParent();
        child.setParent(this);
        this.myChildren.add(child);
    }

    public void removeFromParent() {
        SceneComponent parent = this.myParent;
        if (parent != null) {
            parent.remove(this);
        }
    }

    private void remove(@NotNull SceneComponent component) {
        if (component == null) {
            SceneComponent.$$$reportNull$$$0(14);
        }
        if (this.myChildren.remove(component)) {
            component.myParent = null;
        }
    }

    public boolean layout(@NotNull SceneContext sceneTransform, long time2) {
        if (sceneTransform == null) {
            SceneComponent.$$$reportNull$$$0(15);
        }
        boolean needsRebuildDisplayList = false;
        int left2 = this.myAnimatedDrawX.getValue(time2);
        int top = this.myAnimatedDrawY.getValue(time2);
        int right2 = left2 + this.myAnimatedDrawWidth.getValue(time2);
        int bottom2 = top + this.myAnimatedDrawHeight.getValue(time2);
        needsRebuildDisplayList |= this.myCurrentLeft != left2;
        needsRebuildDisplayList |= this.myCurrentTop != top;
        needsRebuildDisplayList |= this.myCurrentRight != right2;
        needsRebuildDisplayList |= this.myCurrentBottom != bottom2;
        this.myCurrentLeft = left2;
        this.myCurrentTop = top;
        this.myCurrentRight = right2;
        this.myCurrentBottom = bottom2;
        needsRebuildDisplayList |= this.isAnimating();
        ImmutableList<Target> targets = this.getTargets();
        int num = targets.size();
        for (int i2 = 0; i2 < num; ++i2) {
            Target target = (Target)targets.get(i2);
            needsRebuildDisplayList |= target.layout(sceneTransform, this.myCurrentLeft, this.myCurrentTop, this.myCurrentRight, this.myCurrentBottom);
        }
        for (SceneComponent child : this.myChildren) {
            needsRebuildDisplayList |= child.layout(sceneTransform, time2);
        }
        return needsRebuildDisplayList;
    }

    @VisibleForTesting
    public boolean isAnimating() {
        return this.myAnimatedDrawX.isAnimating() || this.myAnimatedDrawY.isAnimating() || this.myAnimatedDrawWidth.isAnimating() || this.myAnimatedDrawHeight.isAnimating();
    }

    public Rectangle fillRect(@Nullable Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.x = this.myCurrentLeft;
        rectangle.y = this.myCurrentTop;
        rectangle.width = this.myCurrentRight - this.myCurrentLeft;
        rectangle.height = this.myCurrentBottom - this.myCurrentTop;
        return rectangle;
    }

    public void addHit(@NotNull SceneContext sceneTransform, @NotNull ScenePicker picker, @JdkConstants.InputEventMask int modifiersEx) {
        if (sceneTransform == null) {
            SceneComponent.$$$reportNull$$$0(16);
        }
        if (picker == null) {
            SceneComponent.$$$reportNull$$$0(17);
        }
        if (this.myIsToolLocked) {
            return;
        }
        this.myHitProvider.addHit(this, sceneTransform, picker);
        ImmutableList<Target> targets = this.getTargets();
        int num = targets.size();
        for (int i2 = 0; i2 < num; ++i2) {
            Target target = (Target)targets.get(i2);
            target.addHit(sceneTransform, picker, modifiersEx);
        }
        for (SceneComponent child : this.myChildren) {
            if (child instanceof TemporarySceneComponent) continue;
            child.addHit(sceneTransform, picker, modifiersEx);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void buildDisplayList(long time2, @NotNull DisplayList list, SceneContext sceneContext) {
        void sceneContext2;
        if (list == null) {
            SceneComponent.$$$reportNull$$$0(18);
        }
        this.myDecorator.buildList(list, time2, (SceneContext)sceneContext2, this);
    }

    @NotNull
    public Rectangle fillDrawRect(long time2, @Nullable Rectangle rec) {
        if (rec == null) {
            rec = new Rectangle();
        }
        rec.x = this.getDrawX(time2);
        rec.y = this.getDrawY(time2);
        rec.width = this.getDrawWidth(time2);
        rec.height = this.getDrawHeight(time2);
        Rectangle rectangle = rec;
        if (rectangle == null) {
            SceneComponent.$$$reportNull$$$0(19);
        }
        return rectangle;
    }

    @NotNull
    public Rectangle2D.Float fillDrawRect2D(long time2, @Nullable Rectangle2D.Float rec) {
        if (rec == null) {
            rec = new Rectangle2D.Float();
        }
        rec.x = this.getDrawX(time2);
        rec.y = this.getDrawY(time2);
        rec.width = this.getDrawWidth(time2);
        rec.height = this.getDrawHeight(time2);
        Rectangle2D.Float float_ = rec;
        if (float_ == null) {
            SceneComponent.$$$reportNull$$$0(20);
        }
        return float_;
    }

    @Nullable
    public String getId() {
        return this.myNlComponent.getId();
    }

    public boolean containsX(int xDp) {
        return this.getDrawX() <= xDp && xDp <= this.getDrawX() + this.getDrawWidth();
    }

    public boolean containsY(int yDp) {
        return this.getDrawY() <= yDp && yDp <= this.getDrawY() + this.getDrawHeight();
    }

    public void setTargetProvider(@Nullable TargetProvider targetProvider) {
        if (this.myTargetProvider == targetProvider) {
            return;
        }
        this.myTargetProvider = targetProvider;
    }

    public void setComponentProvider(@NotNull ComponentProvider provider2) {
        if (provider2 == null) {
            SceneComponent.$$$reportNull$$$0(21);
        }
        this.myComponentProvider = provider2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTargets() {
        TargetProvider provider2;
        ArrayList<Target> arrayList = this.myTargets;
        synchronized (arrayList) {
            this.myCachedTargetList = null;
            this.myTargets.clear();
        }
        SceneComponent parent = this.myParent;
        if (parent != null && (provider2 = parent.getTargetProvider()) != null) {
            provider2.createChildTargets(parent, this).forEach(this::addTarget);
        }
        if ((provider2 = this.myTargetProvider) != null) {
            provider2.createTargets(this).forEach(this::addTarget);
        }
        for (SceneComponent child : this.getChildren()) {
            child.updateTargets();
        }
        if (((Boolean)StudioFlags.NELE_DRAG_PLACEHOLDER.get()).booleanValue()) {
            boolean hasDragTarget;
            ArrayList<Target> arrayList2 = this.myTargets;
            synchronized (arrayList2) {
                hasDragTarget = this.myTargets.removeIf(CommonDragTarget::isSupported);
            }
            if (hasDragTarget && this.myScene.getRoot() != this) {
                if (this.myDragTarget == null) {
                    this.myDragTarget = new CommonDragTarget(this);
                }
                this.addTarget(this.myDragTarget);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scene";
                break;
            }
            case 1: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hitProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/SceneComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "drawState";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentId";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nlComponent";
                break;
            }
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneTransform";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picker";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/SceneComponent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAuthoritativeNlComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNlComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getScene";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "fillDrawRect";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "fillDrawRect2D";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setParent";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDrawState";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSceneComponent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addTarget";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addChild";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "layout";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addHit";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "buildDisplayList";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setComponentProvider";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class AnimatedValue {
        int value;
        int target;
        long startTime;
        int duration = 350;

        AnimatedValue() {
        }

        public void setValue(int v) {
            this.value = v;
            this.target = v;
            this.startTime = 0L;
        }

        public void setTarget(int v, long time2) {
            if (this.target == v) {
                return;
            }
            this.startTime = time2;
            this.target = v;
        }

        public int getValue(long time2) {
            if (this.startTime == 0L) {
                this.target = this.value;
                return this.value;
            }
            float progress = (float)(time2 - this.startTime) / (float)this.duration;
            if (progress >= 1.0f) {
                this.value = this.target;
                return this.value;
            }
            if (progress <= 0.0f) {
                return this.value;
            }
            return (int)(0.5 + this.EaseInOutInterpolator(progress, this.value, this.target));
        }

        public boolean isAnimating() {
            return this.value != this.target;
        }

        double EaseInOutInterpolator(double progress, double begin, double end) {
            double change = (end - begin) / 2.0;
            if ((progress *= 2.0) < 1.0) {
                return change * progress * progress + begin;
            }
            return -change * ((progress -= 1.0) * (progress - 2.0) - 1.0) + begin;
        }
    }

    public static enum DrawState {
        SUBDUED,
        NORMAL,
        HOVER,
        SELECTED,
        DRAG;

    }
}

