/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.ide.common.resources.configuration.LayoutDirectionQualifier;
import com.android.resources.LayoutDirection;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.devices.Device;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionListener;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneHitListener;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.common.scene.target.LassoTarget;
import com.android.tools.idea.common.scene.target.MultiComponentTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.SecondarySelector;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ui.JBUI;
import java.awt.Cursor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class Scene
implements SelectionListener,
Disposable {
    private static final int DRAG_THRESHOLD = JBUI.scale((int)10);
    private static final String PREFERENCE_KEY_PREFIX = "ScenePreference";
    private static final String SHOW_TOOLTIP_KEY = "ScenePreferenceShowToolTip";
    private static Boolean SHOW_TOOLTIP_VALUE = null;
    private final DesignSurface myDesignSurface;
    private final SceneManager mySceneManager;
    private static final boolean DEBUG = false;
    private final HashMap<NlComponent, SceneComponent> mySceneComponents;
    private SceneComponent myRoot;
    private boolean myIsAnimated;
    public static final int NO_LAYOUT = 0;
    public static final int IMMEDIATE_LAYOUT = 1;
    public static final int ANIMATED_LAYOUT = 2;
    private long myDisplayListVersion;
    private Target myOverTarget;
    private Target mySnapTarget;
    private SceneComponent myCurrentComponent;
    NlComponent myLastHoverConstraintComponent;
    private int mNeedsLayout;
    protected int myPressedMouseX;
    protected int myPressedMouseY;
    private int myLastMouseX;
    private int myLastMouseY;
    @NotNull
    private final SceneHitListener myHoverListener;
    @NotNull
    private final SceneHitListener myHitListener;
    @NotNull
    private final SceneHitListener myFindListener;
    @NotNull
    private final SceneHitListener mySnapListener;
    @Nullable
    private Target myHitTarget;
    private Cursor myMouseCursor;
    private SceneComponent myHitComponent;
    List<SceneComponent> myNewSelectedComponentsOnRelease;
    List<SceneComponent> myNewSelectedComponentsOnDown;
    Set<SceneComponent> myHoveredComponents;
    private boolean myIsLiveRenderingEnabled;
    @NotNull
    private FilterType myFilterType;

    public Scene(@NotNull SceneManager sceneManager, @NotNull DesignSurface surface2, @NotNull boolean useLiveRendering) {
        if (sceneManager == null) {
            Scene.$$$reportNull$$$0(0);
        }
        if (surface2 == null) {
            Scene.$$$reportNull$$$0(1);
        }
        this.mySceneComponents = new HashMap();
        this.myIsAnimated = true;
        this.myDisplayListVersion = 1L;
        this.myLastHoverConstraintComponent = null;
        this.mNeedsLayout = 0;
        this.myHitTarget = null;
        this.myNewSelectedComponentsOnRelease = new ArrayList<SceneComponent>();
        this.myNewSelectedComponentsOnDown = new ArrayList<SceneComponent>();
        this.myHoveredComponents = new HashSet<SceneComponent>();
        this.myFilterType = FilterType.NONE;
        this.myDesignSurface = surface2;
        this.mySceneManager = sceneManager;
        SelectionModel selectionModel = this.myDesignSurface.getSelectionModel();
        this.myHoverListener = new SceneHitListener(selectionModel);
        this.myHitListener = new SceneHitListener(selectionModel);
        this.myFindListener = new SceneHitListener(selectionModel);
        this.mySnapListener = new SceneHitListener(selectionModel);
        selectionModel.addListener(this);
        this.myHoverListener.setTargetFilter(target -> {
            if (target instanceof AnchorTarget) {
                AnchorTarget anchorTarget = (AnchorTarget)target;
                if (this.myHitTarget == null) {
                    return !anchorTarget.isEdge();
                }
                if (this.myHitTarget instanceof AnchorTarget) {
                    return ((AnchorTarget)this.myHitTarget).isConnectible(anchorTarget);
                }
            }
            return true;
        });
        this.myIsLiveRenderingEnabled = useLiveRendering;
        Disposer.register((Disposable)sceneManager, (Disposable)this);
    }

    public static void setTooltipVisibility(boolean visible) {
        SHOW_TOOLTIP_VALUE = visible;
        PropertiesComponent.getInstance().setValue(SHOW_TOOLTIP_KEY, visible);
    }

    public static boolean getTooltipVisibility() {
        if (SHOW_TOOLTIP_VALUE != null) {
            return SHOW_TOOLTIP_VALUE;
        }
        SHOW_TOOLTIP_VALUE = PropertiesComponent.getInstance().getBoolean(SHOW_TOOLTIP_KEY, false);
        return SHOW_TOOLTIP_VALUE;
    }

    public void dispose() {
        this.myDesignSurface.getSelectionModel().removeListener(this);
    }

    @NotNull
    public SceneManager getSceneManager() {
        SceneManager sceneManager = this.mySceneManager;
        if (sceneManager == null) {
            Scene.$$$reportNull$$$0(2);
        }
        return sceneManager;
    }

    public boolean supportsRTL() {
        return true;
    }

    public boolean isResizeAvailable() {
        Configuration configuration = this.mySceneManager.getModel().getConfiguration();
        Device device = configuration.getCachedDevice();
        return device != null;
    }

    public boolean isInRTL() {
        Configuration configuration = this.mySceneManager.getModel().getConfiguration();
        LayoutDirectionQualifier qualifier = configuration.getFullConfig().getLayoutDirectionQualifier();
        if (qualifier == null) {
            return false;
        }
        return qualifier.getValue() == LayoutDirection.RTL;
    }

    public int getRenderedApiLevel() {
        Configuration configuration = this.mySceneManager.getModel().getConfiguration();
        IAndroidTarget target = configuration.getTarget();
        if (target != null) {
            return target.getVersion().getApiLevel();
        }
        return 1;
    }

    public boolean isAnimated() {
        return this.myIsAnimated;
    }

    public void setAnimated(boolean animated) {
        this.myIsAnimated = animated;
    }

    @Nullable
    public SceneComponent getSceneComponent(@Nullable NlComponent component) {
        if (component == null) {
            return null;
        }
        return this.mySceneComponents.get(component);
    }

    @NotNull
    public DesignSurface getDesignSurface() {
        DesignSurface designSurface = this.myDesignSurface;
        if (designSurface == null) {
            Scene.$$$reportNull$$$0(3);
        }
        return designSurface;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull String componentId) {
        if (componentId == null) {
            Scene.$$$reportNull$$$0(4);
        }
        if (this.myRoot == null) {
            return null;
        }
        return this.myRoot.getSceneComponent(componentId);
    }

    public List<NlComponent> getSelection() {
        return this.myDesignSurface.getSelectionModel().getSelection();
    }

    @Nullable
    public Object getSecondarySelection() {
        return this.myDesignSurface.getSelectionModel().getSecondarySelection();
    }

    @Nullable
    public SceneComponent getRoot() {
        return this.myRoot;
    }

    public Cursor getMouseCursor() {
        return this.myMouseCursor;
    }

    public boolean isCtrlMetaDown() {
        int ctrlMetaDownMask;
        int modifiersEx = this.getModifiersEx();
        return (modifiersEx & (ctrlMetaDownMask = AdtUiUtils.getActionMask())) != 0;
    }

    public boolean isShiftDown() {
        int modifiersEx = this.getModifiersEx();
        return (modifiersEx & 0x40) != 0;
    }

    public boolean isAltDown() {
        int modifiersEx = this.getModifiersEx();
        return (modifiersEx & 0x200) != 0;
    }

    @JdkConstants.InputEventMask
    private int getModifiersEx() {
        return this.myDesignSurface.getInteractionManager().getLastModifiersEx();
    }

    public void addComponent(@NotNull SceneComponent component) {
        if (component == null) {
            Scene.$$$reportNull$$$0(5);
        }
        this.mySceneComponents.put(component.getNlComponent(), component);
        this.needsRebuildList();
    }

    public void removeComponent(@NotNull SceneComponent component) {
        if (component == null) {
            Scene.$$$reportNull$$$0(6);
        }
        component.removeFromParent();
        this.mySceneComponents.remove(component.getNlComponent(), component);
        this.needsRebuildList();
    }

    void removeAllComponents() {
        Iterator<Map.Entry<NlComponent, SceneComponent>> it = this.mySceneComponents.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<NlComponent, SceneComponent> entry = it.next();
            entry.getValue().removeFromParent();
            it.remove();
        }
    }

    @Override
    public void selectionChanged(@NotNull SelectionModel model2, @NotNull List<NlComponent> selection) {
        if (model2 == null) {
            Scene.$$$reportNull$$$0(7);
        }
        if (selection == null) {
            Scene.$$$reportNull$$$0(8);
        }
        if (this.myRoot != null) {
            Scene.markSelection(this.myRoot, model2);
        }
    }

    private static void markSelection(SceneComponent component, SelectionModel model2) {
        component.setSelected(model2.isSelected(component.getNlComponent()));
        component.setHighlighted(model2.isHighlighted(component.getNlComponent()));
        for (SceneComponent child : component.getChildren()) {
            Scene.markSelection(child, model2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void buildDisplayList(@NotNull DisplayList displayList, long time2, SceneView sceneView) {
        void sceneView2;
        if (displayList == null) {
            Scene.$$$reportNull$$$0(9);
        }
        this.buildDisplayList(displayList, time2, SceneContext.get((SceneView)sceneView2));
    }

    public void buildDisplayList(@NotNull DisplayList displayList, long time2) {
        if (displayList == null) {
            Scene.$$$reportNull$$$0(10);
        }
        this.layout(time2, SceneContext.get());
        this.buildDisplayList(displayList, time2, SceneContext.get());
    }

    public void repaint() {
        this.myDesignSurface.repaint();
    }

    /*
     * WARNING - void declaration
     */
    public void buildDisplayList(@NotNull DisplayList displayList, long time2, SceneContext sceneContext) {
        if (displayList == null) {
            Scene.$$$reportNull$$$0(11);
        }
        if (this.myRoot != null) {
            void sceneContext2;
            sceneContext2.getScenePicker().foreachObject(o -> {
                if (o instanceof SecondarySelector) {
                    ((SecondarySelector)o).release();
                }
            });
            sceneContext2.getScenePicker().reset();
            this.myRoot.buildDisplayList(time2, displayList, (SceneContext)sceneContext2);
        }
    }

    public boolean layout(long time2, SceneContext sceneContext) {
        boolean needsToRebuildDisplayList = false;
        if (this.myRoot != null && (needsToRebuildDisplayList = this.myRoot.layout(sceneContext, time2))) {
            this.needsRebuildList();
        }
        return needsToRebuildDisplayList;
    }

    public void select(List<SceneComponent> components) {
        if (this.myDesignSurface != null) {
            ArrayList<NlComponent> nlComponents = new ArrayList<NlComponent>();
            if (this.isShiftDown() || this.isCtrlMetaDown()) {
                List<NlComponent> selection = this.myDesignSurface.getSelectionModel().getSelection();
                nlComponents.addAll(selection);
            }
            for (SceneComponent sceneComponent : components) {
                NlComponent nlComponent = sceneComponent.getNlComponent();
                if ((this.isShiftDown() || this.isCtrlMetaDown()) && nlComponents.contains(nlComponent)) {
                    nlComponents.remove(nlComponent);
                    continue;
                }
                nlComponents.add(nlComponent);
            }
            this.myDesignSurface.getSelectionModel().setSelection(nlComponents);
        }
    }

    public void mouseHover(@NotNull SceneContext transform, int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        SecondarySelector ss;
        if (transform == null) {
            Scene.$$$reportNull$$$0(12);
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myLastHoverConstraintComponent != null) {
            this.myLastHoverConstraintComponent.putClientProperty("CONSTRAINT_HOVER", null);
            this.myLastHoverConstraintComponent = null;
            this.needsRebuildList();
        }
        if (this.myRoot != null) {
            this.myHoverListener.find(transform, this.myRoot, x, y, modifiersEx);
            this.mySnapListener.find(transform, this.myRoot, x, y, modifiersEx);
        }
        this.repaint();
        Target closestTarget = this.myHoverListener.getClosestTarget(modifiersEx);
        String tooltip = null;
        if (this.myOverTarget != closestTarget) {
            if (this.myOverTarget != null) {
                this.myOverTarget.setMouseHovered(false);
                this.myOverTarget = null;
                this.needsRebuildList();
            }
            if (closestTarget != null) {
                closestTarget.setMouseHovered(true);
                this.myOverTarget = closestTarget;
                this.needsRebuildList();
            }
        }
        if (closestTarget != null) {
            tooltip = closestTarget.getToolTipText();
            Target snapTarget = this.myHoverListener.getFilteredTarget(closestTarget);
            if (snapTarget != this.mySnapTarget) {
                if (this.mySnapTarget != null) {
                    this.mySnapTarget.setMouseHovered(false);
                    this.mySnapTarget = null;
                    this.needsRebuildList();
                }
                if (snapTarget != null) {
                    snapTarget.setMouseHovered(true);
                    this.mySnapTarget = closestTarget;
                    this.needsRebuildList();
                }
            }
        }
        this.updateHoveredComponentsDrawState();
        SceneComponent closestComponent = this.myHoverListener.getClosestComponent();
        if (closestComponent != null && tooltip == null) {
            tooltip = closestComponent.getNlComponent().getTooltipText();
        }
        if (this.myCurrentComponent != closestComponent) {
            if (this.myCurrentComponent != null) {
                this.myCurrentComponent.setDrawState(SceneComponent.DrawState.NORMAL);
                this.myCurrentComponent = null;
            }
            if (closestComponent != null) {
                closestComponent.setDrawState(SceneComponent.DrawState.HOVER);
                this.myCurrentComponent = closestComponent;
            }
            this.needsRebuildList();
        }
        if ((closestComponent == null || closestComponent.getNlComponent().isRoot() && this.myHitTarget == null) && (ss = Scene.getSecondarySelector(transform, x, y)) != null) {
            NlComponent component = ss.getComponent();
            this.myLastHoverConstraintComponent = ss.getComponent();
            tooltip = this.getConstraintToolTip(ss);
            component.putClientProperty("CONSTRAINT_HOVER", (Object)ss.getConstraint());
            this.needsRebuildList();
        }
        if (Scene.getTooltipVisibility()) {
            this.getDesignSurface().setDesignToolTip(tooltip);
        }
        this.setCursor(transform, x, y, modifiersEx);
    }

    @NotNull
    private String getConstraintToolTip(@NotNull SecondarySelector ss) {
        Object tooltip;
        if (ss == null) {
            Scene.$$$reportNull$$$0(13);
        }
        NlComponent component = ss.getComponent();
        String connect2 = "";
        String target = "";
        SecondarySelector.Constraint connection = ss.getConstraint();
        if (this.isInRTL()) {
            if (connection == SecondarySelector.Constraint.LEFT) {
                connection = SecondarySelector.Constraint.RIGHT;
            } else if (connection == SecondarySelector.Constraint.RIGHT) {
                connection = SecondarySelector.Constraint.LEFT;
            }
        }
        switch (connection) {
            case LEFT: {
                connect2 = "layout_constraintStart_toStartOf";
                target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect2);
                if (target != null || (target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect2 = "layout_constraintStart_toEndOf")) == null) break;
                break;
            }
            case RIGHT: {
                connect2 = "layout_constraintEnd_toStartOf";
                target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect2);
                if (target != null || (target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect2 = "layout_constraintEnd_toEndOf")) == null) break;
                break;
            }
            case TOP: {
                connect2 = "layout_constraintTop_toTopOf";
                target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect2);
                if (target != null || (target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect2 = "layout_constraintTop_toBottomOf")) == null) break;
                break;
            }
            case BOTTOM: {
                connect2 = "layout_constraintBottom_toTopOf";
                target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect2);
                if (target != null || (target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect2 = "layout_constraintBottom_toBottomOf")) == null) break;
                break;
            }
            case BASELINE: {
                connect2 = "layout_constraintBaseline_toBaselineOf";
                target = component.getAttribute("http://schemas.android.com/apk/res-auto", connect2);
            }
        }
        try {
            connect2 = connect2.substring("layout_constraint".length(), connect2.length() - 2).replace("_to", " to ").toLowerCase();
            target = target.substring(target.indexOf("/") + 1);
            tooltip = component.getTooltipText() + " " + connect2 + " of " + target;
        }
        catch (Exception ex) {
            tooltip = "";
        }
        String string = tooltip;
        if (string == null) {
            Scene.$$$reportNull$$$0(14);
        }
        return string;
    }

    private void updateHoveredComponentsDrawState() {
        ArrayList<SceneComponent> hitComponents = this.myHoverListener.getHitComponents();
        for (SceneComponent component : hitComponents) {
            if (component != this.myCurrentComponent) {
                NlComponent nlComponent = component.getAuthoritativeNlComponent();
                if (DecoratorUtilities.getTryingToConnectState(nlComponent) != null) {
                    component.setDrawState(SceneComponent.DrawState.HOVER);
                } else {
                    component.setDrawState(SceneComponent.DrawState.NORMAL);
                }
            }
            this.myHoveredComponents.remove(component);
        }
        Iterator<SceneComponent> iterator = this.myHoveredComponents.iterator();
        while (iterator.hasNext()) {
            SceneComponent component;
            component = iterator.next();
            component.setDrawState(SceneComponent.DrawState.NORMAL);
            iterator.remove();
        }
        this.myHoveredComponents.addAll(hitComponents);
    }

    private void setCursor(@NotNull SceneContext transform, int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        if (transform == null) {
            Scene.$$$reportNull$$$0(15);
        }
        this.myMouseCursor = Cursor.getDefaultCursor();
        if (this.myCurrentComponent != null && this.myCurrentComponent.isDragging()) {
            this.myMouseCursor = Cursor.getPredefinedCursor(13);
            return;
        }
        if (this.myOverTarget != null) {
            this.myMouseCursor = this.myOverTarget.getMouseCursor(modifiersEx);
            return;
        }
        SceneComponent component = this.findComponent(transform, x, y);
        if (component != null && component.getParent() != null) {
            this.myMouseCursor = Cursor.getPredefinedCursor(12);
        }
    }

    private void delegateMouseDownToSelection(int x, int y, SceneComponent currentComponent) {
        List<NlComponent> selection = this.getSelection();
        if (selection.size() > 1) {
            for (NlComponent nlComponent : selection) {
                SceneComponent c;
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null || c == currentComponent) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    target.mouseDown(x, y);
                }
            }
        }
    }

    private void delegateMouseDragToSelection(int x, int y, @Nullable Target closestTarget, @NotNull SceneComponent currentComponent, @NotNull SceneContext context) {
        List<NlComponent> selection;
        if (currentComponent == null) {
            Scene.$$$reportNull$$$0(16);
        }
        if (context == null) {
            Scene.$$$reportNull$$$0(17);
        }
        if ((selection = this.getSelection()).size() > 1) {
            for (NlComponent nlComponent : selection) {
                SceneComponent c;
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null || c == currentComponent) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    ArrayList<Target> list = new ArrayList<Target>();
                    list.add(closestTarget);
                    target.mouseDrag(x, y, list, context);
                }
            }
        }
    }

    private void delegateMouseReleaseToSelection(int x, int y, @Nullable Target closestTarget, @NotNull SceneComponent currentComponent) {
        List<NlComponent> selection;
        if (currentComponent == null) {
            Scene.$$$reportNull$$$0(18);
        }
        if ((selection = this.getSelection()).size() > 1) {
            int count = selection.size();
            for (int i2 = 0; i2 < count; ++i2) {
                SceneComponent c;
                NlComponent nlComponent = selection.get(i2);
                if (nlComponent == currentComponent.getNlComponent() || (c = currentComponent.getScene().getSceneComponent(nlComponent)) == null) continue;
                for (Target target : c.getTargets()) {
                    if (!(target instanceof MultiComponentTarget)) continue;
                    target.mouseRelease(x, y, Collections.singletonList(closestTarget));
                }
            }
        }
    }

    private void delegateMouseCancelToSelection(@NotNull SceneComponent currentComponent) {
        if (currentComponent == null) {
            Scene.$$$reportNull$$$0(19);
        }
        NlComponent currentNlComponent = currentComponent.getNlComponent();
        Scene scene = currentComponent.getScene();
        List otherComponents = this.getSelection().stream().filter(it -> it != currentNlComponent).map(it -> scene.getSceneComponent((NlComponent)it)).filter(it -> it != null).collect(Collectors.toList());
        for (SceneComponent c : otherComponents) {
            ImmutableList<Target> targets = c.getTargets();
            for (Target t : targets) {
                if (!(t instanceof MultiComponentTarget)) continue;
                t.mouseCancel();
            }
        }
    }

    public void mouseDown(@NotNull SceneContext transform, int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        if (transform == null) {
            Scene.$$$reportNull$$$0(20);
        }
        this.myPressedMouseX = x;
        this.myPressedMouseY = y;
        this.mNeedsLayout = 0;
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        this.myFilterType = FilterType.NONE;
        if (this.myRoot == null) {
            return;
        }
        this.myNewSelectedComponentsOnDown.clear();
        this.myHitListener.setTargetFilter(it -> {
            if (it instanceof AnchorTarget) {
                return !((AnchorTarget)it).isEdge();
            }
            return true;
        });
        SecondarySelector secondarySelector = Scene.getSecondarySelector(transform, x, y);
        this.myHitListener.find(transform, this.myRoot, x, y, modifiersEx);
        this.myHitTarget = this.myHitListener.getClosestTarget(modifiersEx);
        this.myHitComponent = this.myHitListener.getClosestComponent();
        if (this.myHitTarget != null) {
            this.myHitTarget.mouseDown(x, y);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseDownToSelection(x, y, this.myHitTarget.getComponent());
            }
        } else if (this.myHitComponent != null && !this.inCurrentSelection(this.myHitComponent)) {
            this.myNewSelectedComponentsOnDown.add(this.myHitComponent);
            this.select(this.myNewSelectedComponentsOnDown);
        } else if (this.findSelectionOfCurve(secondarySelector)) {
            return;
        }
        this.myHitListener.setTargetFilter(null);
    }

    @Nullable
    public static SecondarySelector getSecondarySelector(@NotNull SceneContext transform, int x, int y) {
        Object obj;
        if (transform == null) {
            Scene.$$$reportNull$$$0(21);
        }
        if ((obj = transform.findClickedGraphics(transform.getSwingXDip(x), transform.getSwingYDip(y))) != null && obj instanceof SecondarySelector) {
            return (SecondarySelector)obj;
        }
        return null;
    }

    public void mouseDrag(@NotNull SceneContext transform, int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        if (transform == null) {
            Scene.$$$reportNull$$$0(22);
        }
        if (this.myLastMouseX == x && this.myLastMouseY == y) {
            return;
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        if (this.myHitTarget != null) {
            if (!this.myHitTarget.getComponent().isDragging() && !this.myDesignSurface.getSelectionModel().isSelected(this.myHitTarget.getComponent().getNlComponent()) && Scene.isWithinThreshold(this.myPressedMouseX, x, transform) && Scene.isWithinThreshold(this.myPressedMouseY, y, transform)) {
                return;
            }
            LassoTarget lassoTarget = null;
            if (this.myHitTarget instanceof LassoTarget && (lassoTarget = (LassoTarget)this.myHitTarget).getSelectWhileDragging() && lassoTarget.getHasChanged()) {
                this.myNewSelectedComponentsOnRelease.clear();
                this.myNewSelectedComponentsOnRelease.addAll(lassoTarget.getIntersectingComponents());
                this.select(this.myNewSelectedComponentsOnRelease);
                lassoTarget.clearHasChanged();
            }
            this.myHitListener.setTargetFilter(target -> this.myHitTarget != target);
            this.myHitListener.find(transform, this.myRoot, x, y, modifiersEx);
            SceneComponent targetComponent = this.myHitTarget.getComponent();
            if (lassoTarget == null && targetComponent != null && !this.inCurrentSelection(targetComponent)) {
                this.myNewSelectedComponentsOnRelease.clear();
                this.myNewSelectedComponentsOnRelease.add(targetComponent);
                this.select(this.myNewSelectedComponentsOnRelease);
            }
            this.myHitTarget.mouseDrag(x, y, this.myHitListener.myHitTargets, transform);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseDragToSelection(x, y, this.myHitListener.getClosestTarget(modifiersEx), this.myHitTarget.getComponent(), transform);
            }
            this.myHitListener.setTargetFilter(null);
        }
        this.mouseHover(transform, x, y, modifiersEx);
        this.requestLayoutIfNeeded();
    }

    private static boolean isWithinThreshold(int pos1, int pos2, SceneContext transform) {
        int pos4;
        int pos3 = transform.getSwingDimensionDip(pos1);
        return Math.abs(pos3 - (pos4 = transform.getSwingDimensionDip(pos2))) < DRAG_THRESHOLD;
    }

    public void requestLayoutIfNeeded() {
        if (this.mNeedsLayout != 0) {
            SceneManager manager = this.myDesignSurface.getSceneManager();
            if (manager == null) {
                return;
            }
            if (this.myIsLiveRenderingEnabled) {
                manager.requestLayoutAndRender(this.mNeedsLayout == 2);
            } else {
                manager.requestLayout(this.mNeedsLayout == 2);
            }
        }
    }

    private boolean findSelectionOfCurve(SecondarySelector ss) {
        if (ss == null) {
            return false;
        }
        NlComponent comp = ss.getComponent();
        SecondarySelector.Constraint sub = ss.getConstraint();
        this.myDesignSurface.getSelectionModel().setSecondarySelection(comp, (Object)sub);
        return true;
    }

    public void mouseRelease(@NotNull SceneContext transform, int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        List<SceneComponent> changed;
        if (transform == null) {
            Scene.$$$reportNull$$$0(23);
        }
        this.myLastMouseX = x;
        this.myLastMouseY = y;
        SceneComponent closestComponent = this.myHitListener.getClosestComponent();
        if (this.myHitTarget != null) {
            this.myHitListener.find(transform, this.myRoot, x, y, modifiersEx);
            this.myHitTarget.mouseRelease(x, y, (List<Target>)this.myHitListener.getHitTargets());
            this.myHitTarget.getComponent().setDragging(false);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseReleaseToSelection(x, y, this.myHitListener.getClosestTarget(modifiersEx), this.myHitTarget.getComponent());
            }
        }
        this.myFilterType = FilterType.NONE;
        this.myNewSelectedComponentsOnRelease.clear();
        if (this.myHitComponent != null && closestComponent == this.myHitComponent) {
            this.myNewSelectedComponentsOnRelease.add(this.myHitComponent);
        }
        if (this.myHitTarget != null && (changed = this.myHitTarget.newSelection()) != null) {
            this.myNewSelectedComponentsOnRelease.clear();
            this.myNewSelectedComponentsOnRelease.addAll(changed);
        }
        SecondarySelector secondarySelector = Scene.getSecondarySelector(transform, x, y);
        boolean same = this.sameSelection();
        if (same && this.myHitListener.getTopHitComponent() != closestComponent && Scene.isWithinThreshold(this.myPressedMouseX, x, transform) && Scene.isWithinThreshold(this.myPressedMouseY, y, transform)) {
            this.myNewSelectedComponentsOnRelease.clear();
            this.myNewSelectedComponentsOnRelease.add(this.myHitListener.getTopHitComponent());
            this.myHitTarget = null;
            same = this.sameSelection();
        }
        if (secondarySelector == null && !same && (this.myHitTarget == null || this.myHitTarget.canChangeSelection())) {
            this.select(this.myNewSelectedComponentsOnRelease);
        } else {
            this.myDesignSurface.getSelectionModel().clearSecondary();
            this.findSelectionOfCurve(secondarySelector);
        }
        this.myHitTarget = null;
        this.requestLayoutIfNeeded();
    }

    public void mouseCancel() {
        if (this.myHitTarget != null) {
            this.myHitTarget.mouseCancel();
            this.myHitTarget.getComponent().setDragging(false);
            if (this.myHitTarget instanceof MultiComponentTarget) {
                this.delegateMouseCancelToSelection(this.myHitTarget.getComponent());
            }
        }
        this.myFilterType = FilterType.NONE;
        this.myNewSelectedComponentsOnRelease.clear();
        this.myHitTarget = null;
        this.requestLayoutIfNeeded();
    }

    private boolean inCurrentSelection(@NotNull SceneComponent component) {
        if (component == null) {
            Scene.$$$reportNull$$$0(24);
        }
        List<NlComponent> currentSelection = this.myDesignSurface.getSelectionModel().getSelection();
        return currentSelection.contains(component.getNlComponent());
    }

    private boolean sameSelection() {
        if (!this.myNewSelectedComponentsOnRelease.isEmpty() && this.myNewSelectedComponentsOnRelease.size() == this.myNewSelectedComponentsOnDown.size() && this.myNewSelectedComponentsOnRelease.containsAll(this.myNewSelectedComponentsOnDown)) {
            return true;
        }
        List<NlComponent> currentSelection = this.myDesignSurface.getSelectionModel().getSelection();
        if (this.myNewSelectedComponentsOnRelease.size() == currentSelection.size()) {
            int count = currentSelection.size();
            for (int i2 = 0; i2 < count; ++i2) {
                NlComponent component = currentSelection.get(i2);
                SceneComponent sceneComponent = this.getSceneComponent(component);
                if (this.myNewSelectedComponentsOnRelease.contains(sceneComponent)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void markNeedsLayout(int type) {
        this.mNeedsLayout = type;
    }

    public long getDisplayListVersion() {
        return this.myDisplayListVersion;
    }

    public void needsRebuildList() {
        ++this.myDisplayListVersion;
    }

    public List<SceneComponent> findWithin(int x, int y, int width, int height) {
        ArrayList<SceneComponent> within = new ArrayList<SceneComponent>();
        if (this.getRoot() != null) {
            Scene.addWithin(within, this.getRoot(), x, y, width, height);
        }
        return within;
    }

    private static boolean addWithin(@NotNull List<SceneComponent> result2, @NotNull SceneComponent component, int x, int y, int width, int height) {
        if (result2 == null) {
            Scene.$$$reportNull$$$0(25);
        }
        if (component == null) {
            Scene.$$$reportNull$$$0(26);
        }
        if (component.getDrawX() + component.getDrawWidth() <= x || x + width <= component.getDrawX() || component.getDrawY() + component.getDrawHeight() <= y || y + height <= component.getDrawY()) {
            return false;
        }
        boolean found = false;
        for (SceneComponent child : component.getChildren()) {
            found |= Scene.addWithin(result2, child, x, y, width, height);
        }
        if (!found) {
            result2.add(component);
        }
        return true;
    }

    @Nullable
    public SceneComponent findComponent(@NotNull SceneContext transform, int x, int y) {
        if (transform == null) {
            Scene.$$$reportNull$$$0(27);
        }
        if (this.myRoot == null) {
            return null;
        }
        this.myFindListener.find(transform, this.myRoot, x, y, 0);
        return this.myFindListener.getClosestComponent();
    }

    @Nullable
    public Target findTarget(@NotNull SceneContext transform, int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        if (transform == null) {
            Scene.$$$reportNull$$$0(28);
        }
        if (this.myRoot == null) {
            return null;
        }
        this.myFindListener.find(transform, this.myRoot, x, y, modifiersEx);
        return this.myFindListener.getClosestTarget(modifiersEx);
    }

    public Collection<SceneComponent> getSceneComponents() {
        return this.mySceneComponents.values();
    }

    public void setRoot(SceneComponent root2) {
        this.myRoot = root2;
    }

    @NotNull
    public FilterType getFilterType() {
        FilterType filterType = this.myFilterType;
        if (filterType == null) {
            Scene.$$$reportNull$$$0(29);
        }
        return filterType;
    }

    public void setFilterType(@NotNull FilterType filterType) {
        if (filterType == null) {
            Scene.$$$reportNull$$$0(30);
        }
        this.myFilterType = filterType;
    }

    @Nullable
    public Target getInteractingTarget() {
        return this.myHitTarget;
    }

    @NotNull
    public CompletableFuture<Dimension> measureWrapSize(@NotNull SceneComponent component) {
        if (component == null) {
            Scene.$$$reportNull$$$0(31);
        }
        return this.measure(component, (n, namespace, localName) -> {
            if ("layout_width".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                return "wrap_content";
            }
            if ("layout_height".equals(localName) && "http://schemas.android.com/apk/res/android".equals(namespace)) {
                return "wrap_content";
            }
            return null;
        });
    }

    @NotNull
    private CompletableFuture<Dimension> measure(@NotNull SceneComponent component, @Nullable RenderTask.AttributeFilter filter2) {
        NlComponent neleComponent;
        if (component == null) {
            Scene.$$$reportNull$$$0(32);
        }
        if (!(neleComponent = component.getNlComponent()).getBackend().isValid()) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            if (completableFuture == null) {
                Scene.$$$reportNull$$$0(33);
            }
            return completableFuture;
        }
        NlModel model2 = neleComponent.getModel();
        XmlFile xmlFile = model2.getFile();
        Module module2 = model2.getModule();
        RenderService renderService = RenderService.getInstance(module2.getProject());
        AndroidFacet facet2 = model2.getFacet();
        RenderLogger logger2 = renderService.createLogger(facet2);
        CompletionStage completionStage = ((CompletableFuture)renderService.taskBuilder(facet2, model2.getConfiguration()).withLogger(logger2).withPsiFile((PsiFile)xmlFile).build().thenCompose(task2 -> {
            if (task2 == null) {
                return CompletableFuture.completedFuture(null);
            }
            XmlTag tag = neleComponent.getTagDeprecated();
            return task2.measureChild(tag, filter2).whenCompleteAsync((map2, ex) -> task2.dispose(), (Executor)PooledThreadExecutor.INSTANCE);
        })).thenApply(viewInfo -> {
            if (viewInfo == null) {
                return null;
            }
            viewInfo = RenderService.getSafeBounds(viewInfo);
            return new Dimension(Coordinates.pxToDp(this.getSceneManager(), viewInfo.getRight() - viewInfo.getLeft()), Coordinates.pxToDp(this.getSceneManager(), viewInfo.getBottom() - viewInfo.getTop()));
        });
        if (completionStage == null) {
            Scene.$$$reportNull$$$0(34);
        }
        return completionStage;
    }

    public List<Placeholder> getPlaceholders(@Nullable SceneComponent requester) {
        ImmutableList.Builder builder2 = new ImmutableList.Builder();
        Scene.doGetPlaceholders((ImmutableList.Builder<Placeholder>)builder2, this.myRoot, requester);
        return builder2.build();
    }

    public boolean isLiveRenderingEnabled() {
        return this.myIsLiveRenderingEnabled;
    }

    public void setLiveRenderingEnabled(boolean enabled) {
        this.myIsLiveRenderingEnabled = enabled;
    }

    private static void doGetPlaceholders(@NotNull ImmutableList.Builder<Placeholder> builder2, @NotNull SceneComponent component, @Nullable SceneComponent requester) {
        if (builder2 == null) {
            Scene.$$$reportNull$$$0(35);
        }
        if (component == null) {
            Scene.$$$reportNull$$$0(36);
        }
        if (component == requester) {
            return;
        }
        NlComponent nlComponent = component.getNlComponent();
        ViewHandler handler2 = NlComponentHelperKt.getViewHandler(nlComponent);
        if (handler2 != null) {
            builder2.addAll(handler2.getPlaceholders(component));
        }
        for (SceneComponent child : component.getChildren()) {
            Scene.doGetPlaceholders(builder2, child, requester);
        }
    }

    public void setHitTarget(@Nullable Target hitTarget) {
        this.myHitTarget = hitTarget;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 29: 
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 29: 
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 29: 
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/scene/Scene";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentId";
                break;
            }
            case 5: 
            case 6: 
            case 24: 
            case 26: 
            case 31: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayList";
                break;
            }
            case 12: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transform";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ss";
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentComponent";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterType";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/scene/Scene";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDesignSurface";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstraintToolTip";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "measure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 29: 
            case 33: 
            case 34: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSceneComponent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeComponent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "selectionChanged";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "buildDisplayList";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "mouseHover";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getConstraintToolTip";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setCursor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "delegateMouseDragToSelection";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "delegateMouseReleaseToSelection";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "delegateMouseCancelToSelection";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "mouseDown";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSecondarySelector";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "mouseDrag";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "mouseRelease";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "inCurrentSelection";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addWithin";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findComponent";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "findTarget";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "setFilterType";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "measureWrapSize";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "measure";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "doGetPlaceholders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 29: 
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum FilterType {
        ALL,
        ANCHOR,
        VERTICAL_ANCHOR,
        HORIZONTAL_ANCHOR,
        BASELINE_ANCHOR,
        NONE,
        RESIZE;

    }
}

